/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.money;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public class ReceivingBillEditPlugin
extends MdrBillPlugin
implements BeforeF7SelectListener {
    private static final String CONTACTS_CUSTOMER = "contactscustomer";

    public void afterCreateNewData(EventObject e) {
        this.setOwnerF7Value(UserUtil.getDefaultOwnerID());
        this.SetOwnerFromCache(null);
        String ordertype = (String)this.getView().getFormShowParameter().getCustomParam("ordertype");
        Object orderid = this.getView().getFormShowParameter().getCustomParam("orderid");
        if (null != orderid) {
            this.initFromOrder(orderid, ordertype);
        } else {
            this.initReceivingtypeEnum();
        }
    }

    private void initReceivingtypeEnum() {
        ComboEdit ce = (ComboEdit)this.getControl("receivingtype");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        ComboItem co1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9884\u6536\u6b3e", (String)"ReceivingBillEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0])), "0");
        ComboItem co2 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9000\u9884\u6536\u6b3e", (String)"ReceivingBillEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0])), "1");
        list.add(co1);
        list.add(co2);
        ce.setComboItems(list);
        ce.selectedStore((ComboItem)list.get(0));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Boolean iscopy = (Boolean)((FormView)e.getSource()).getFormShowParameter().getCustomParam("iscopy");
        if (iscopy != null && iscopy.booleanValue()) {
            this.initReceivingtypeEnum();
            this.getModel().setValue("sourcebillno", null);
            this.getModel().setValue("ordertype", null);
            this.getModel().setValue("orderid", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isAddNew()) {
            this.setUnEnable(new String[]{"btnaudit"});
        }
    }

    public void registerListener(EventObject e) {
        this.addF7Listener(this, new String[]{"owner", CONTACTS_CUSTOMER});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFitler());
                break;
            }
            case "contactscustomer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFitler());
            }
        }
    }

    private QFilter getOwnerFitler() {
        return UserUtil.getAuthorizedCommonUserOwnersFilter();
    }

    private QFilter getCustomerFitler() {
        Object ownerID = this.getOwnerF7PKValue();
        if (ownerID == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6240\u5c5e\u6e20\u9053\uff01", (String)"ReceivingBillEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        Set ids = CustomerUtil.getAuthSubsIds((Object)ownerID);
        return new QFilter("id", "in", (Object)ids);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.setValue(CONTACTS_CUSTOMER, null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.isEmpty()) {
            return;
        }
        String status = this.getModel().getValue("status").toString();
        switch (key) {
            case "audit": {
                if (!"0".equals(status)) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\uff01", (String)"ReceivingBillEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            case "unaudit": {
                boolean isAddNew = (Boolean)this.getModel().getValue("isaddnew");
                if (isAddNew) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u624b\u52a8\u65b0\u589e\u5355\u636e\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01", (String)"ReceivingBillEditPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            }
            case "save": {
                break;
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Object orderId = this.getModel().getValue("orderid");
        if (StringUtils.isEmpty((Object)orderId)) {
            String receivingtype = (String)this.getValue("receivingtype");
            ComboEdit ce = (ComboEdit)this.getControl("receivingtype");
            ArrayList<ComboItem> list = new ArrayList<ComboItem>();
            ComboItem co1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9884\u6536\u6b3e", (String)"ReceivingBillEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0])), "0");
            ComboItem co2 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9000\u9884\u6536\u6b3e", (String)"ReceivingBillEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0])), "1");
            list.add(co1);
            list.add(co2);
            ce.setComboItems(list);
            for (ComboItem item : list) {
                if (!item.getValue().equals(receivingtype)) continue;
                ce.selectedStore(item);
                break;
            }
        } else {
            this.setUnEnable(new String[]{"receivingtype"});
        }
    }

    private void initFromOrder(Object orderId, String orderType) {
        DynamicObject order = this.loadOrderData(orderId, orderType, "billno,owner,customer,amounttobepaid");
        IDataModel model = this.getModel();
        ComboEdit ce = (ComboEdit)this.getControl("receivingtype");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        ComboItem co1 = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u9500\u552e\u56de\u6b3e", (String)"ReceivingBillEditPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0])), "2");
        list.add(co1);
        ce.setComboItems(list);
        ce.selectedStore((ComboItem)list.get(0));
        this.setUnEnable(new String[]{"owner", CONTACTS_CUSTOMER});
        model.setValue("orderid", (Object)order.get("id").toString());
        if ("saleorder".equals(orderType)) {
            model.setValue("ordertype", (Object)"saleorder");
        }
        model.setValue("sourcebillno", order.get("billno"));
        model.setValue("receivingtype", (Object)"2");
        model.setValue("owner", order.get("owner"));
        model.setValue(CONTACTS_CUSTOMER, order.get("customer"));
        model.setValue("amount", (Object)order.getBigDecimal("amounttobepaid"));
        model.setValue("isaddnew", (Object)1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String orderid = String.valueOf(this.getModel().getDataEntity().getPkValue());
        String operateKey = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (operateKey) {
                case "save": {
                    if (this.getValue("status").toString().compareTo("B") != 0) {
                        this.getModel().setValue("status", (Object)"B");
                        this.getView().invokeOperation("save");
                    }
                    this.setEnable(new String[]{"btnaudit"});
                    break;
                }
                case "audit": {
                    if (StringUtils.isNotEmpty((String)orderid)) {
                        this.getView().getParentView().invokeOperation("refresh");
                        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5ba1\u6838\u6210\u529f\uff01", (String)"ReceivingBillEditPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                        this.getView().close();
                        break;
                    }
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getModel().setValue("status", (Object)"C");
                    this.getModel().setDataChanged(false);
                    break;
                }
                case "unaudit": {
                    if (StringUtils.isNotEmpty((String)orderid)) {
                        this.getView().getParentView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u53cd\u5ba1\u6838\u6210\u529f\uff01", (String)"ReceivingBillEditPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                        this.getView().close();
                        break;
                    }
                    this.getView().setStatus(OperationStatus.VIEW);
                    this.getModel().setValue("status", (Object)"B");
                    this.getModel().setDataChanged(false);
                    break;
                }
            }
        } else {
            this.getView().showErrorNotification(e.getOperationResult().getMessage());
        }
    }

    private DynamicObject loadOrderData(Object orderId, String orderType, String selectFields) {
        DynamicObject saleorder = null;
        if ("saleorder".equals(orderType)) {
            saleorder = BusinessDataServiceHelper.loadSingle((Object)orderId, (String)"bbc_saleorder", (String)selectFields);
        }
        if (saleorder == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5173\u8054\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u8bd5", (String)"ReceivingBillEditPlugin_8", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        return saleorder;
    }
}

