/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.returnorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.drp.dpa.common.algorithm.SaleOrderAlgorithm;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.constants.BigDecimalConstants;
import kd.drp.mdr.common.enums.Status;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.handler.OrderOperateLogHandler;
import kd.drp.mdr.common.item.ConversionDirection;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.BigDecimalUtil;
import kd.drp.mdr.common.util.BillTypeParameterHelper;
import kd.drp.mdr.common.util.BizValidateUtils;
import kd.drp.mdr.common.util.ConsigneeAddressUtil;
import kd.drp.mdr.common.util.CustomerSalerUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.PriceUtil;
import kd.drp.mdr.common.util.SysParamsUtil;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.common.util.WebUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;
import kd.drp.mdr.formplugin.formhandler.UnitFormHandler;

public class ReturnOrderReqEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String HAS_ATTR = "hasattr";
    private static final String INVALID = "invalid";
    protected static final String TO_VALID = "valid";
    protected static final String TO_ADD_ROW = "advconbaritemap";
    protected static final String TO_DEL_ROW = "advconbaritemap1";
    protected static final String DELETEENTRY = "deleteentry";
    protected static final String MODIFY = "modify";
    protected static final String UNAUDIT = "unaudit";
    private SaleOrderAlgorithm algo = null;

    protected SaleOrderAlgorithm getAlgorithm() {
        if (this.algo == null) {
            this.algo = new SaleOrderAlgorithm(this.getModel().getDataEntity(true), this.getView(), this.getPageCache());
        }
        return this.algo;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"customer", "saler", "owner", "item", "assistattr", "unit", "consigneeaddress", "enquirychannel", "paychannel", "billtype"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setBillParameter();
        this.initDefaultVals();
    }

    private void setViewLockProperties() {
        this.setDisVisible(new String[]{TO_ADD_ROW});
        this.setUnEnable(new String[]{"customer", "owner", "ordernumber"});
        DynamicObjectCollection itementry = this.getModel().getEntryEntity("itementry");
        int rowIndex = 0;
        for (DynamicObject row : itementry) {
            DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
            ArrayList<String> keys = new ArrayList<String>(properties.size());
            for (IDataEntityProperty property : properties) {
                keys.add(property.getName());
            }
            this.setUnEnable(rowIndex, keys.toArray(new String[0]));
            this.setEnable(rowIndex, new String[]{"qty"});
            this.setEnable(rowIndex, new String[]{"unit"});
            if (!this.isPresentItem(rowIndex)) {
                boolean hasTax = this.isHasTax();
                if (hasTax) {
                    this.setEnable(rowIndex, new String[]{"taxprice"});
                } else {
                    this.setEnable(rowIndex, new String[]{"itemprice"});
                }
            }
            ++rowIndex;
        }
    }

    public void afterBindData(EventObject e) {
        if (this.isGenerateOrder()) {
            DynamicObject assistBillType = (DynamicObject)this.getModel().getValue("assistbilltype");
            if (null == assistBillType) {
                this.setBillParameter();
            }
            this.lockAllField();
        } else {
            this.initBillPropertiesLockByBillStatus();
        }
        String area = this.getStringValue("area");
        if (StringUtils.isEmpty((String)area)) {
            this.setValue("area", 0);
        }
    }

    protected void lockAllField() {
        DataEntityPropertyCollection billProperties = this.getModel().getDataEntityType().getProperties();
        List<String> billPropertiesName = billProperties.stream().map(IMetadata::getName).collect(Collectors.toList());
        this.setUnEnable(billPropertiesName.toArray(new String[0]));
        DynamicObjectCollection itementry = this.getModel().getEntryEntity("itementry");
        int i = 0;
        for (DynamicObject row : itementry) {
            DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
            Set<String> propertiesName = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
            this.setUnEnable(i++, propertiesName.toArray(new String[0]));
        }
        this.setDisVisible(new String[]{TO_ADD_ROW});
        this.setDisVisible(new String[]{TO_DEL_ROW});
    }

    protected void initBillPropertiesLockByBillStatus() {
        if (Status.SAVED.toString().equalsIgnoreCase(this.getStringValue("billstatus"))) {
            this.setVisible(new String[]{"bar_modify"});
            if (this.isGenerateOrder()) {
                this.setViewLockProperties();
            } else {
                this.setCurrencyByCustomer();
            }
            this.setAllItemAssistantAttrLock();
            this.setAllMaterialAuxptyVisibilityAndLock();
        } else if ("D".equalsIgnoreCase(this.getStringValue("billstatus"))) {
            this.lockAllField();
        }
    }

    public boolean isGenerateOrder() {
        boolean isGenerate = false;
        Object ordernumber = this.getView().getModel().getValue("ordernumber");
        if (null != ordernumber && StringUtils.isNotEmpty((Object)ordernumber)) {
            isGenerate = true;
        }
        return isGenerate;
    }

    public boolean isHasTax() {
        boolean isHasTax = false;
        Object hastax = this.getView().getModel().getValue("hastax");
        if (Boolean.TRUE.equals(hastax)) {
            isHasTax = true;
        }
        return isHasTax;
    }

    protected void initDefaultVals() {
        List ownerIDs = UserUtil.getOwnerIDs();
        if (ownerIDs != null && ownerIDs.size() > 0) {
            boolean isBuyer = false;
            DynamicObject customer = BusinessDataServiceHelper.loadSingle(ownerIDs.get(0), (String)"mdr_customer");
            for (DynamicObject customerfunction : customer.getDynamicObjectCollection("customerfunctions")) {
                if (!"001".equalsIgnoreCase(customerfunction.getDynamicObject("fbasedataid").getString("number"))) continue;
                isBuyer = true;
            }
            if (isBuyer) {
                this.setValue("customer", ownerIDs.get(0));
                List authOwnerIDs = CustomerUtil.getAuthOwnerIDs(ownerIDs.get(0));
                if (authOwnerIDs != null && authOwnerIDs.size() > 0) {
                    this.setValue("owner", authOwnerIDs.get(0));
                    this.setSaler();
                }
                if (ownerIDs.size() == 1) {
                    this.setUnEnable(new String[]{"customer"});
                }
                this.setSaleOrg();
            }
        }
    }

    protected void setSaleOrg() {
        DynamicObject owner = this.getOwnerF7Value();
        if (null != owner) {
            long bizGroup = owner.getLong("bizgroup.id");
            this.setValue("saleorg", bizGroup);
            this.setSettleOrg(this.getF7Value("saleorg"));
        }
    }

    protected void setSettleOrg(DynamicObject saleOrg) {
        if (null == saleOrg) {
            this.setValue("balanceorg", null);
        } else {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)saleOrg.getLong("id"), (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (!CollectionUtils.isEmpty((Map)map)) {
                this.setValue("balanceorg", map.get("id"));
            } else {
                this.setValue("balanceorg", saleOrg);
            }
            this.setUnEnable(new String[]{"balanceorg"});
        }
        this.setExRateTable();
    }

    private void setExRateTable() {
        DynamicObject[] accountingsys;
        Object settleOrg = this.getValue("balanceorg");
        if (null == settleOrg) {
            this.setValue("exratetable", null);
            this.setValue("exchangerate", 1, false);
            this.setValue("localcurrency", null, false);
        } else if (settleOrg instanceof DynamicObject && (accountingsys = BusinessDataServiceHelper.load((String)"bd_accountingsys_base", (String)"id,exratetable,basecurrrency", (QFilter[])new QFilter[]{new QFilter("baseacctorg", "=", ((DynamicObject)settleOrg).getPkValue())})).length > 0) {
            Object exratetable = accountingsys[0].get("exratetable");
            if (null == exratetable) {
                return;
            }
            this.setValue("exratetable", exratetable);
            Object currency = this.getValue("currency");
            if (null == currency) {
                return;
            }
            Long srcCurId = (Long)((DynamicObject)currency).getPkValue();
            Object orderDate = this.getValue("billdate");
            if (null == orderDate) {
                return;
            }
            Object basecurrrency = accountingsys[0].get("basecurrrency");
            if (null == basecurrrency) {
                return;
            }
            this.setValue("localcurrency", basecurrrency, false);
            this.setExchangeRate(srcCurId, (Long)((DynamicObject)basecurrrency).getPkValue(), (Long)((DynamicObject)exratetable).getPkValue(), (Date)orderDate);
        }
    }

    private void setExchangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = this.calcExChangeRate(srcCurId, targetCurId, exRateTableId, date);
        this.setValue("exchangerate", exchangeRate);
    }

    private BigDecimal calcExChangeRate(Long srcCurId, Long targetCurId, Long exRateTableId, Date date) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId.equals(targetCurId)) {
            exchangeRate = BigDecimal.valueOf(1L);
        } else {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)srcCurId, (Long)targetCurId, (Date)date);
            if (null == exchangeRate || BigDecimal.ZERO.compareTo(exchangeRate) >= 0) {
                exchangeRate = BigDecimal.ONE;
            }
        }
        return exchangeRate;
    }

    public void setOwnerFilter() {
        this.setF7Filter("owner", this.getOwnerFilter());
    }

    public QFilter getOwnerFilter() {
        Object customerId = this.getF7PKValue("customer");
        if (customerId != null) {
            List authOwnerIDs = CustomerUtil.getAuthOwnerIDs((Object)customerId);
            return new QFilter("id", "in", (Object)authOwnerIDs);
        }
        return new QFilter("1", "=", (Object)"0");
    }

    public void setCustomerFilter() {
        this.setF7Filter("customer", this.getCustomerFilter());
    }

    public QFilter getCustomerFilter() {
        QFilter customerFilter = WebUtil.getIdQFilter((Collection)UserUtil.getAuthorizedOwnerIDs());
        customerFilter.and(new QFilter("customerfunctions.fbasedataid.number", "=", (Object)"001"));
        return customerFilter;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        DynamicObject item = null;
        int index = e.getRow();
        switch (key) {
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                break;
            }
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                break;
            }
            case "saler": {
                Object ownerId = this.getF7PKValue("owner");
                if (ownerId == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053\u4e0d\u5f97\u4e3a\u7a7a", (String)"ReturnOrderReqEditPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                List salers = CustomerSalerUtil.queryCustomerSalerPK((Object)this.getF7PKValue("customer"), (Object)ownerId);
                ArrayList<QFilter> salerList = new ArrayList<QFilter>();
                this.setNoTreeF7(e);
                QFilter qFilter = new QFilter("id", "in", (Object)salers);
                salerList.add(qFilter);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, salerList);
                break;
            }
            case "item": {
                Object ownerId = this.getF7PKValue("owner");
                if (ownerId == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u5f97\u4e3a\u7a7a", (String)"ReturnOrderReqEditPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Object customerId = this.getF7PKValue("customer");
                if (customerId == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8981\u8d27\u6e20\u9053\u4e0d\u5f97\u4e3a\u7a7a", (String)"ReturnOrderReqEditPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                ArrayList<QFilter> fs = new ArrayList<QFilter>();
                fs.add(ItemSaleControlUtil.getItemFilterUsePageCache((Object)this.getOwnerF7PKValue(), (Object)this.getCustomerF7PKValue(), (IPageCache)this.getPageCache()));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fs);
                break;
            }
            case "assistattr": {
                item = (DynamicObject)this.getValue("item", index);
                Object itemId = this.getEntryF7PKValue("itementry", "item", index);
                if (item == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ReturnOrderReqEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter assistFilter = new QFilter("item", "=", itemId);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)assistFilter);
                break;
            }
            case "unit": {
                item = this.getEntryF7Value("itementry", "item", index);
                if (item == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"ReturnOrderReqEditPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                List unitIdList = this.getUnitFormHandler().getUnitIdList(item.get("id"));
                ArrayList<QFilter> unitList = new ArrayList<QFilter>();
                unitList.add(new QFilter("id", "in", (Object)unitIdList));
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, unitList);
                break;
            }
            case "consigneeaddress": {
                QFilter addressFilter = ConsigneeAddressUtil.getConsigneeAddressQFilter((Object)this.getCustomerF7PKValue());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)addressFilter);
                break;
            }
            case "enquirychannel": {
                if (null == this.getF7Value("customer")) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u9000\u8d27\u6e20\u9053");
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntryRequiryChannelFilter());
                break;
            }
            case "paychannel": {
                if (null == this.getF7Value("customer")) {
                    e.setCancel(true);
                    this.getView().showMessage("\u8bf7\u5148\u9009\u62e9\u9000\u8d27\u6e20\u9053");
                    break;
                }
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getEntrySettleChannelFilter());
                break;
            }
            case "billtype": {
                QFilter qFilter1 = new QFilter("number", "!=", (Object)"mdr_returnorder_sys005");
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter1);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            this.triggerChangeEvent = true;
            return;
        }
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        switch (key) {
            case "customer": {
                this.clearCustomer();
                this.setCurrencyByCustomer();
                this.setAllEntryRowDefaultValue();
                this.setSaleChannel();
                break;
            }
            case "owner": {
                this.clearOwner();
                this.setSaleOrg();
                this.setSaler();
                break;
            }
            case "item": {
                this.setEntryDefaultValue(index);
                this.itemChange(index);
                this.qtyChangedHandler(index);
                this.setMaterialAuxptyVisibilityAndLock(index);
                break;
            }
            case "unit": {
                this.unitChange(index);
                break;
            }
            case "qty": {
                this.qtyChange(index);
                this.qtyChangedHandler(index);
                break;
            }
            case "assistattr": {
                this.assistAttrChange(index);
                break;
            }
            case "itemprice": {
                this.priceChangedHandler(index);
                break;
            }
            case "taxprice": {
                this.setItemPriceByTaxPrice(index);
                this.priceChangedHandler(index);
                break;
            }
            case "assistqty": {
                this.assistQtyChange(index);
                break;
            }
            case "currency": {
                this.setExRateTable();
                break;
            }
            case "consigneeaddress": {
                this.fillConsigneeInfo();
                break;
            }
            case "ispresent": {
                this.isPresentHandler(index);
                break;
            }
            case "billtype": {
                this.setBillParameter();
                break;
            }
            case "discounttype": {
                this.discountTypeChangedHandler(index);
                break;
            }
            case "discount": {
                this.discountChangedHandler(index);
                break;
            }
            case "balanceorg": {
                this.setExRateTable();
                break;
            }
            case "taxrate": {
                this.taxRateChangeHandler(index);
                break;
            }
        }
    }

    private void taxRateChangeHandler(int index) {
        this.includeTaxCalcPrices(index);
        this.priceChangedHandler(index);
    }

    private void includeTaxCalcPrices(int index) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
        if (BigDecimal.ZERO.compareTo(taxPrice) >= 0) {
            this.getView().showTipNotification(String.format("\u7b2c%s\u884c\u5206\u5f55\uff0c\u542b\u7a0e\u5355\u4ef7\uff0c\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5", index + 1));
            return;
        }
        BigDecimal itemPrice = taxPrice.divide(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L))), this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        this.setValue("itemprice", itemPrice, index);
        this.priceChangedHandler(index);
    }

    protected boolean isAllChannelCloudVersion() {
        return "A".equals(SysParamsUtil.getChannelVersion());
    }

    protected boolean isEnableAssistAttribute(int index) {
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        DynamicObject item = row.getDynamicObject("item");
        if (null != item) {
            return item.getBoolean(HAS_ATTR);
        }
        return false;
    }

    protected void setAllMaterialAuxptyVisibilityAndLock() {
        int rowCount = this.getModel().getEntryEntity("itementry").getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.setMaterialAuxptyVisibilityAndLock(i);
        }
    }

    protected void setMaterialAuxptyVisibilityAndLock(int index) {
        if (this.isAllChannelCloudVersion()) {
            this.setVisible(new String[]{"auxptyid"});
            this.setUnEnable(index, new String[]{"auxptyid"});
            Object material = this.getValue("material", index);
            if (material instanceof DynamicObject && ((DynamicObject)material).getBoolean("isuseauxpty")) {
                this.setEnable(index, new String[]{"auxptyid"});
            }
        } else {
            this.setDisVisible(new String[]{"auxptyid"});
        }
    }

    protected void setAllItemAssistantAttrLock() {
        int rowCount = this.getModel().getEntryEntity("itementry").getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.setItemAssistantAttrLock(i);
        }
    }

    protected void setItemAssistantAttrLock(int index) {
        Object item = this.getValue("item", index);
        if (item instanceof DynamicObject) {
            boolean hasAttr = ((DynamicObject)item).getBoolean(HAS_ATTR);
            if (hasAttr) {
                if (!this.isGenerateOrder()) {
                    this.setEnable(index, new String[]{"assistattr"});
                }
            } else {
                this.setUnEnable(index, new String[]{"assistattr"});
            }
        }
    }

    private void setSaleChannel() {
        Object customer = this.getCustomerF7PKValue();
        if (null != customer) {
            QFilter fs = new QFilter("customer", "=", customer).and("enable", "=", (Object)"1");
            DynamicObjectCollection owners = QueryServiceHelper.query((String)"mdr_customer_authorize", (String)String.join((CharSequence)",", "authowner", "isdefault"), (QFilter[])fs.toArray(), (String)"isdefault desc");
            if (!CollectionUtils.isEmpty((Collection)owners)) {
                if (1 == owners.size()) {
                    this.setValue("owner", ((DynamicObject)owners.get(0)).get("authowner"), true);
                } else if (((DynamicObject)owners.get(0)).getBoolean("isdefault")) {
                    this.setValue("owner", ((DynamicObject)owners.get(0)).get("authowner"), true);
                }
            }
        }
    }

    private void discountChangedHandler(int index) {
        BigDecimal discount = (BigDecimal)this.getValue("discount", index);
        String discountType = (String)this.getValue("discounttype", index);
        if ("A".equalsIgnoreCase(discountType)) {
            if (BigDecimal.ZERO.compareTo(discount) > 0 || BigDecimal.valueOf(100L).compareTo(discount) <= 0) {
                this.getView().showErrorNotification("\u6298\u6263\u7387\uff0c\u5fc5\u987b\u57280-100\u4e4b\u95f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                this.setValue("discount", BigDecimal.ZERO, index, true);
            }
        } else if ("B".equalsIgnoreCase(discountType)) {
            BigDecimal taxPrice = (BigDecimal)this.getValue("taxprice", index);
            if (BigDecimal.ZERO.compareTo(discount) >= 0 || taxPrice.compareTo(discount) < 0) {
                this.getView().showErrorNotification("\u5355\u4f4d\u6298\u6263\u989d\uff0c\u5fc5\u987b\u57280-\u542b\u7a0e\u5355\u4ef7\u4e4b\u95f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                this.setValue("discount", BigDecimal.ZERO, index, true);
            }
        }
        this.qtyChangedHandler(index);
    }

    private void discountTypeChangedHandler(int index) {
        this.getView().showMessage("\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u6298\u6263\u7387/\u5355\u4f4d\u6298\u6263\u989d");
        this.setValue("discount", BigDecimal.ZERO, index, true);
    }

    protected void isPresentHandler(int index) {
        if (this.isPresentItem(index)) {
            this.setValue("taxprice", BigDecimal.ZERO, true);
            this.lockColumnIfPresentItem(index);
        } else {
            this.resetPrice(index);
            this.priceChangedHandler(index);
            this.unLockColumnIfNotPresentItem(index);
        }
    }

    protected void unLockColumnIfNotPresentItem(int index) {
        this.setEnable(index, new String[]{"item", "qty", "unit", "discounttype", "discounttype", "discount", "taxprice", "taxrate", "stockid", "enquirychannel", "paychannel", "remark"});
        this.setMaterialAuxptyVisibilityAndLock(index);
        this.lockAssistAttrByItem(index);
    }

    private void lockColumnIfPresentItem(int index) {
        DynamicObject row = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
        ArrayList<String> keys = new ArrayList<String>(properties.size());
        for (IDataEntityProperty property : properties) {
            keys.add(property.getName());
        }
        this.setUnEnable(index, keys.toArray(new String[0]));
        this.setEnable(index, new String[]{"ispresent"});
        this.setEnable(index, new String[]{"qty", "unit"});
    }

    protected boolean isPresentItem(int index) {
        Object value = this.getValue("ispresent", index);
        return Boolean.parseBoolean(value.toString());
    }

    private void fillConsigneeInfo() {
        DynamicObject consigneeAddress = this.getF7Value("consigneeaddress");
        if (null != consigneeAddress) {
            this.setValue("consigneename", consigneeAddress.getString("contactname"));
            this.setValue("consigneephone", consigneeAddress.getString("telephone"));
            this.setValue("consigneefixedtel", consigneeAddress.getString("fixedtel"));
            String address = consigneeAddress.getString("address");
            if (StringUtils.isEmpty((String)address)) {
                this.setValue("area", 0);
            } else {
                this.setValue("area", Integer.valueOf(address));
            }
            this.setValue("detailaddress", consigneeAddress.getString("address2"));
        } else {
            this.setValue("consigneename", null);
            this.setValue("consigneephone", null);
            this.setValue("consigneefixedtel", null);
            this.setValue("area", 0);
            this.setValue("detailaddress", null);
        }
    }

    protected void setCurrencyByCustomer() {
        DynamicObject customer = this.getModel().getDataEntity().getDynamicObject("customer");
        if (null != customer) {
            Object localCurrency = this.getValue("currency");
            if (null == localCurrency) {
                this.setValue("currency", customer.getLong("currency.id"), true);
            }
        } else {
            this.setValue("currency", null, true);
        }
    }

    private void qtyChangedHandler(int rowIndex) {
        this.setDiscountAmount(rowIndex);
        this.setTaxAndPriceAmount(rowIndex);
        this.setTaxAmount(rowIndex);
        this.setAmount(rowIndex);
        this.calcSumAmounts();
    }

    private void setTaxAndPriceAmount(int rowIndex) {
        BigDecimal taxAndPriceAmount = this.calcTaxAndPriceAmount(rowIndex);
        this.setValue("amountandtax", taxAndPriceAmount, rowIndex);
    }

    private BigDecimal calcTaxAndPriceAmount(int rowIndex) {
        BigDecimal taxAndPriceAmount = BigDecimal.ZERO;
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty");
        if (this.isHasTax()) {
            BigDecimal taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
            taxAndPriceAmount = qty.multiply(taxPrice).subtract(this.calcDiscountAmount(rowIndex)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        } else {
            taxAndPriceAmount = this.calcAmount(rowIndex).add(this.calcTaxAmount(rowIndex));
        }
        return taxAndPriceAmount;
    }

    private BigDecimal calcAmount(int rowIndex) {
        BigDecimal amount = BigDecimal.ZERO;
        if (this.isHasTax()) {
            amount = this.calcTaxAndPriceAmount(rowIndex).subtract(this.calcTaxAmount(rowIndex));
        } else {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
            BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty");
            BigDecimal itemPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemprice");
            BigDecimal discount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty");
            amount = this.isDiscountRate(rowIndex) ? qty.multiply(itemPrice).multiply(BigDecimal.ONE.subtract(discount.divide(BigDecimal.valueOf(100L)))).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP) : qty.multiply(itemPrice.subtract(discount)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        }
        return amount;
    }

    private void priceChangedHandler(int rowIndex) {
        this.setTaxPriceByItemPrice(rowIndex);
        this.setDiscountAmount(rowIndex);
        this.setAmount(rowIndex);
        this.setTaxAmount(rowIndex);
        this.setTaxAndPriceAmount(rowIndex);
        this.calcSumAmounts();
    }

    private void setTaxPriceByItemPrice(int rowIndex) {
        if (!this.isHasTax()) {
            DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
            BigDecimal itemPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemprice");
            this.setItemPriceAndTaxPriceByItemPriceAccordingHasTax(rowIndex, itemPrice);
        }
    }

    private void setItemPriceByTaxPrice(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
        this.setItemPriceAndTaxPriceByTaxPriceAccordingHasTax(rowIndex, taxPrice);
    }

    private void setItemPriceAndTaxPriceByTaxPriceAccordingHasTax(int index, BigDecimal taxPrice) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        taxRate = taxRate.divide(BigDecimal.valueOf(100L)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        this.setValue("taxprice", taxPrice, index);
        if (this.isHasTax()) {
            BigDecimal itemPrice = taxPrice.divide(BigDecimal.ONE.add(taxRate), this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
            this.setValue("itemprice", itemPrice, index);
        }
    }

    private void calcPrice(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
            price = taxPrice.divide(one.add(taxRate), this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        }
        this.triggerChangeEvent = false;
        this.setValue("itemprice", price, rowIndex);
    }

    private void calcTaxPrice(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal price = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"itemprice");
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        BigDecimal taxPrice = null;
        if (price != null) {
            taxRate = taxRate == null ? BigDecimalConstants.ZERO : taxRate;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate.divide(oneHundred, this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
            taxPrice = price.multiply(BigDecimalConstants.ONE.add(taxRate));
            taxPrice = taxPrice.setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        }
        this.triggerChangeEvent = false;
        this.setValue("taxprice", taxPrice, rowIndex);
    }

    private void setDiscountAmount(int rowIndex) {
        BigDecimal discountAmount = this.calcDiscountAmount(rowIndex);
        this.setValue("discountamount", discountAmount, rowIndex);
    }

    private boolean isDiscountRate(int rowIndex) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        String discountType = entry.getString("discounttype");
        return "A".equalsIgnoreCase(discountType);
    }

    private BigDecimal calcDiscountAmount(int rowIndex) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal qty = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"qty");
        BigDecimal taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
        BigDecimal discount = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"discount");
        if (this.isDiscountRate(rowIndex)) {
            discountAmount = taxPrice.multiply(qty).multiply(discount.divide(BigDecimal.valueOf(100L))).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        } else if (this.isHasTax()) {
            discountAmount = qty.multiply(discount).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        } else {
            BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
            taxRate = taxRate.divide(BigDecimal.valueOf(100L)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
            discountAmount = qty.multiply(discount).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        }
        return discountAmount;
    }

    private void setAmount(int rowIndex) {
        BigDecimal amount = this.calcAmount(rowIndex);
        this.setValue("amount", amount, rowIndex);
    }

    private void setTaxAmount(int rowIndex) {
        BigDecimal taxAmount = this.calcTaxAmount(rowIndex);
        this.setValue("taxamount", taxAmount, rowIndex);
    }

    private BigDecimal calcTaxAmount(int rowIndex) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(rowIndex);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        taxRate = taxRate.divide(BigDecimal.valueOf(100L)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        taxAmount = this.isHasTax() ? this.calcTaxAndPriceAmount(rowIndex).divide(BigDecimal.ONE.add(taxRate), this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP).multiply(taxRate) : this.calcAmount(rowIndex).multiply(taxRate).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        return taxAmount;
    }

    private void calcSumAmounts() {
        BigDecimal taxAndPriceSum = BigDecimal.ZERO;
        BigDecimal amountSum = BigDecimal.ZERO;
        BigDecimal taxamountSum = BigDecimal.ZERO;
        DynamicObjectCollection itementry = this.getModel().getEntryEntity("itementry");
        for (DynamicObject row : itementry) {
            if (row.getBoolean("ispresent")) continue;
            BigDecimal taxAndPrice = row.getBigDecimal("amountandtax");
            BigDecimal amount = row.getBigDecimal("amount");
            BigDecimal taxamount = row.getBigDecimal("taxamount");
            taxAndPriceSum = taxAndPriceSum.add(taxAndPrice);
            amountSum = amountSum.add(amount);
            taxamountSum = taxamountSum.add(taxamount);
        }
        this.setValue("totalamountandtax", taxAndPriceSum);
        this.setValue("totaltaxamount", taxamountSum);
        this.setValue("totalamount", amountSum);
    }

    private void assistQtyChange(int index) {
        this.calcuNumByAssistQty(index);
        this.assistQtyResetPrice(index);
    }

    private void assistAttrChange(int index) {
        Object assistAttrValue = this.getValue("assistattr", index);
        if (assistAttrValue == null) {
            DynamicObject item = (DynamicObject)this.getValue("item", index);
            DynamicObject defaultAttr = ItemAttrUtil.getDefaultAttr((Object)item.get("id"));
            this.setValue("assistattr", defaultAttr.get("id"), index);
        }
        this.setValue("taxprice", BigDecimal.ZERO, index, false);
        this.setValue("taxrate", BigDecimal.ZERO, index);
        this.resetPrice(index);
    }

    private void qtyChange(int index) {
        this.resetByQtyUnit(index);
        this.priceChangedHandler(index);
    }

    private void unitChange(int index) {
        this.setValue("taxprice", BigDecimal.ZERO, index, false);
        this.resetByQtyUnit(index);
        this.resetPrice(index);
        this.priceChangedHandler(index);
    }

    private void calcuNumByAssistQty(int index) {
        DynamicObject item = (DynamicObject)this.getValue("item", index);
        Object itemId = item.get("id");
        DynamicObject assistUnit = (DynamicObject)this.getValue("assistunit", index);
        if (assistUnit == null) {
            this.setValue("assistqty", BigDecimal.ZERO, index);
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5546\u54c1\u7684\u8f85\u52a9\u8ba1\u91cf\u5355\u4f4d\uff01", (String)"ReturnOrderReqEditPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject unit = (DynamicObject)this.getValue("unit", index);
        BigDecimal assistQty = (BigDecimal)this.getValue("assistqty", index);
        String conversionfor = item.getString("conversionfor");
        UnitFormHandler unitFormHandler = this.getUnitFormHandler();
        if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_MWASUREUNIT.getConversionFor().equals(conversionfor)) {
            BigDecimal qty = unitFormHandler.getQtyFromAssistUnit(itemId, assistUnit.get("id"), assistQty, unit.get("id"));
            this.setValue("qty", qty, index);
            BigDecimal baseQty = unitFormHandler.getBaseQty(itemId, qty, unit.get("id"));
            this.setValue("baseqty", baseQty, index);
        }
    }

    private void resetByQtyUnit(int index) {
        DynamicObject itemValue = (DynamicObject)this.getValue("item", index);
        if (itemValue == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5165\u5546\u54c1", (String)"ReturnOrderReqEditPlugin_5", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
            this.setValue("qty", null, index);
            return;
        }
        Object itemId = itemValue.get("id");
        DynamicObject unit = this.getEntryF7Value("itementry", "unit", index);
        if (unit == null) {
            this.setValue("qty", BigDecimal.ZERO, index);
            this.setValue("baseqty", BigDecimal.ZERO, index);
            this.setValue("assistqty", BigDecimal.ZERO, index);
            return;
        }
        UnitFormHandler unitFormHandler = this.getUnitFormHandler();
        BigDecimal qty = (BigDecimal)this.getValue("qty", index);
        DynamicObject assistunit = (DynamicObject)this.getValue("assistunit");
        BigDecimal baseQty = unitFormHandler.getBaseQty(itemId, qty, unit.get("id"));
        this.setValue("baseqty", baseQty, index);
        if (StringUtils.isNotEmpty((Object)assistunit)) {
            String conversionfor = itemValue.getString("conversionfor");
            if (ConversionDirection.FOR_EACH.getConversionFor().equals(conversionfor) || ConversionDirection.FOR_ASSISTUNIT.getConversionFor().equals(conversionfor)) {
                BigDecimal assistQty = unitFormHandler.getUnitQty(itemId, assistunit.get("id"), baseQty);
                this.setValue("assistqty", assistQty, index);
            }
        }
    }

    private void calcuPrice(int index) {
        BigDecimal qty = (BigDecimal)this.getValue("qty");
        BigDecimal mount = (BigDecimal)this.getValue("amount");
        if (qty != null && mount != null && mount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal price = mount.divide(qty, this.getSettlePrecisionWithDefault(4), 4);
            this.setValue("itemprice", price, index);
        }
    }

    private void itemChange(int index) {
        this.clearColumnWhenItemChanged(index);
        DynamicObject itemValue = (DynamicObject)this.getValue("item", index);
        this.lockAssistAttrByItem(itemValue, index);
        if (itemValue == null) {
            this.setValue("assistattr", null, index);
            this.setValue("unit", null, index);
            this.setValue("baseunit", null, index);
            this.setValue("assistunit", null, index);
            this.setValue("assistqty", null, index);
            this.setValue("qty", null, index);
            this.setValue("baseqty", null, index);
            this.setValue("material", null, index);
            return;
        }
        Object itemId = itemValue.get("id");
        boolean hasattr = itemValue.getBoolean(HAS_ATTR);
        ArrayList<Object> list = new ArrayList<Object>();
        if (hasattr) {
            this.setEnable(index, new String[]{"assistattr"});
            DynamicObject[] assistAttrCollection = BusinessDataServiceHelper.load((String)"mdr_item_attrvalue", (String)"id", (QFilter[])new QFilter("item", "=", itemId).toArray());
            if (assistAttrCollection.length > 0) {
                for (DynamicObject assistAttr : assistAttrCollection) {
                    list.add(assistAttr.get("id"));
                }
                DynamicObject defaultValue = BusinessDataServiceHelper.loadSingle(list.get(0), (DynamicObjectType)assistAttrCollection[0].getDynamicObjectType());
                this.getModel().setValue("assistattr", (Object)defaultValue, index);
            }
        } else {
            this.setUnEnable(index, new String[]{"assistattr"});
        }
        UnitFormHandler unitFormHandler = this.getUnitFormHandler();
        Object baseUnitId = unitFormHandler.getBaseUnitId(itemId);
        Object saleUnitId = unitFormHandler.getSaleUnitId(itemId);
        this.getModel().setValue("unit", saleUnitId, index);
        this.getModel().setValue("baseunit", baseUnitId, index);
        Object assistId = unitFormHandler.getAssistUnitId(itemId);
        if (assistId != null) {
            this.setEnable(index, new String[]{"assistqty"});
            this.getModel().setValue("assistunit", assistId, index);
        } else {
            this.setUnEnable(index, new String[]{"assistqty"});
        }
        this.getModel().setValue("material", itemValue.get("material.id"), index);
        this.resetPrice(index);
    }

    private void clearColumnWhenItemChanged(int index) {
        this.setValue("taxamount", BigDecimal.ZERO, index, false);
        this.setValue("assistattr", null, index, false);
        this.setValue("amountandtax", BigDecimal.ZERO, index, false);
        this.setValue("taxprice", BigDecimal.ZERO, index, false);
        this.setValue("taxrate", BigDecimal.ZERO, index);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        int rowIndex = e.getRowDataEntities()[0].getRowIndex();
        switch (entryName) {
            case "itementry": {
                this.setEntryDefaultValue(rowIndex);
            }
        }
    }

    protected void setBillParameter() {
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        String formid = this.getView().getFormShowParameter().getFormId();
        if (null != billType) {
            DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameterByConstants((String)formid, (long)billType.getLong("id"));
            DynamicObject assistbilltype = billTypeParam.getDynamicObject("assistbilltype");
            this.setValue("assistbilltype", assistbilltype);
            String billTypeNumber = billType.getString("number");
            if ("mdr_returnorder_sys005".equalsIgnoreCase(billTypeNumber) || "mdr_returnorder_req_sys005".equalsIgnoreCase(billTypeNumber)) {
                this.setValue("saler", null, false);
                this.setUnEnable(new String[]{"saler"});
            } else {
                this.setSaler();
                this.setEnable(new String[]{"saler"});
            }
        }
    }

    private void setEntryDefaultValue(int rowIndex) {
        DynamicObject customer = this.getF7Value("customer");
        if (null != customer) {
            this.setValue("enquirychannel", customer, rowIndex);
            Object paycustomer = customer.get("paycustomer");
            if (null != paycustomer) {
                this.setValue("paychannel", paycustomer, rowIndex);
            }
        }
    }

    private int getEntryRowCount() {
        return this.getModel().getEntryEntity("itementry").getRowCount();
    }

    private void setAllEntryRowDefaultValue() {
        int entryRowCount = this.getEntryRowCount();
        for (int i = 0; i < entryRowCount; ++i) {
            this.setEntryDefaultValue(i);
        }
    }

    private QFilter getEntrySettleChannelFilter() {
        return this.getEntryChannelCommonFilter().and(new QFilter("customerfunctions.fbasedataid.number", "=", (Object)"006"));
    }

    private QFilter getEntryRequiryChannelFilter() {
        return this.getEntryChannelCommonFilter().and(new QFilter("customerfunctions.fbasedataid.number", "=", (Object)"003"));
    }

    private QFilter getEntryChannelCommonFilter() {
        DynamicObject customer = this.getF7Value("customer");
        if (null != customer) {
            long legalCustomerId = customer.getLong("legalcustomer.id");
            return new QFilter("parentcustomer", "=", customer.getPkValue()).or("legalcustomer", "=", (Object)legalCustomerId);
        }
        return new QFilter("1", "=", (Object)"2");
    }

    protected final int getSettlePrecisionWithDefault(int defaultPrecision) {
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("currency");
        if (null != settleCurrency) {
            int amtPrecision = settleCurrency.getInt("amtprecision");
            defaultPrecision = amtPrecision > defaultPrecision ? amtPrecision : defaultPrecision;
        }
        return defaultPrecision;
    }

    private BigDecimal getRealTimePrice(int index) {
        Object customerPk = this.getCustomerF7PKValue();
        Object ownerPk = this.getOwnerF7PKValue();
        Object itemPK = this.getEntryF7PKValue("itementry", "item", index);
        Object unitPK = this.getEntryF7PKValue("itementry", "unit", index);
        BigDecimal qty = this.getRowInfo("itementry", index).getBigDecimal("qty");
        Date date = new Date();
        DynamicObject assistAttr = this.getEntryF7Value("itementry", "assistattr", index);
        BigDecimal itemPrice = BigDecimal.ZERO;
        Object assistAttrId = 0L;
        if (assistAttr != null) {
            assistAttrId = assistAttr.get("id");
        }
        if (itemPK != null && unitPK != null && BizValidateUtils.itemAttrNullValidate((Object)itemPK, (DynamicObject)assistAttr)) {
            itemPrice = PriceUtil.getItemPrice((Object)ownerPk, (Object)customerPk, (Object)itemPK, (Object)unitPK, (Object)assistAttrId, (BigDecimal)qty, (Date)date);
        }
        return itemPrice;
    }

    private void resetPrice(int index) {
        BigDecimal itemPrice = this.getRealTimePrice(index);
        this.setItemPriceAndTaxPriceByItemPriceAccordingHasTax(index, itemPrice);
        this.priceChangedHandler(index);
    }

    private void assistQtyResetPrice(int index) {
        BigDecimal taxPrice;
        BigDecimal itemPrice = this.getRealTimePrice(index);
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        BigDecimal tempTaxPrice = itemPrice.multiply(BigDecimal.ONE.add(taxRate = taxRate.divide(BigDecimal.valueOf(100L)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP)));
        if (tempTaxPrice.compareTo(taxPrice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice")) == 0) {
            this.setValue("itemprice", itemPrice, index);
            if (!this.isHasTax()) {
                BigDecimal taxAndPrice = itemPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
                this.setValue("taxprice", taxAndPrice, index);
            } else {
                BigDecimal taxprice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
                if (BigDecimal.ZERO.compareTo(taxprice) == 0) {
                    this.setValue("taxprice", itemPrice, index);
                }
            }
            this.priceChangedHandler(index);
        }
    }

    private void setItemPriceAndTaxPriceByItemPriceAccordingHasTax(int index, BigDecimal itemPrice) {
        DynamicObject entry = (DynamicObject)this.getModel().getEntryEntity("itementry").get(index);
        BigDecimal taxRate = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxrate");
        taxRate = taxRate.divide(BigDecimal.valueOf(100L)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
        this.setValue("itemprice", itemPrice, index);
        if (!this.isHasTax()) {
            BigDecimal taxAndPrice = itemPrice.multiply(BigDecimal.ONE.add(taxRate)).setScale(this.getSettlePrecisionWithDefault(4), RoundingMode.HALF_UP);
            this.setValue("taxprice", taxAndPrice, index);
        } else {
            BigDecimal taxprice = BigDecimalUtil.getNullToZero((DynamicObject)entry, (String)"taxprice");
            if (BigDecimal.ZERO.compareTo(taxprice) == 0) {
                this.setValue("taxprice", itemPrice, index);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if (key.equals(INVALID)) {
            FormOperate operate = (FormOperate)e.getSource();
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                String opMessage = OrderOperateLogHandler.getOpMessage((String)key);
                HashMap<String, String> param = new HashMap<String, String>();
                if (key.equals(TO_VALID) && Status.SAVED.toString().equals(this.getModel().getDataEntity().getString("billstatus"))) {
                    opMessage = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u4f5c\u5e9f\u8be5\u7533\u8bf7\u5355\uff1f", (String)"ReturnOrderReqEditPlugin_6", (String)"drp-dpa-formplugin", (Object[])new Object[0]);
                }
                param.put("message", opMessage);
                param.put("remark", ResManager.loadKDString((String)"\u4f5c\u5e9f\u539f\u56e0", (String)"ReturnOrderReqEditPlugin_7", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                param.put("ismustinput", "true");
                this.showForm("mdr_operate_confirm", param, new CloseCallBack((IFormPlugin)this, INVALID), ShowType.Modal);
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (this.getOperationResult(e)) {
            switch (key) {
                case "valid": {
                    this.reLoadPage();
                    this.initBillPropertiesLockByBillStatus();
                    break;
                }
                case "invalid": {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4f5c\u5e9f\u6210\u529f", (String)"ReturnOrderReqEditPlugin_9", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
                    this.initBillPropertiesLockByBillStatus();
                    break;
                }
                case "deleteentry": {
                    this.calcSumAmounts();
                    break;
                }
                case "modify": {
                    this.checkAllEntryRowAssistAttrByItem();
                    break;
                }
                case "unaudit": {
                    this.initBillPropertiesLockByBillStatus();
                    this.reLoadPage();
                }
            }
        }
    }

    protected void setSaler() {
        DynamicObject saler = this.getF7Value("saler");
        Object customerId = this.getCustomerF7PKValue();
        Object ownerId = this.getOwnerF7PKValue();
        DynamicObject[] salers = BusinessDataServiceHelper.load((String)"mdr_cust_saler_relation", (String)"id,user", (QFilter[])new QFilter[]{new QFilter("owner", "=", ownerId).and("enable", "=", (Object)"1").and("customer", "=", customerId)}, (String)"isdefault desc", (int)1);
        if (null != salers && salers.length > 0) {
            this.setValue("saler", salers[0].getDynamicObject("user"));
        }
    }

    protected void checkAllEntryRowAssistAttrByItem() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("itementry");
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject item = ((DynamicObject)entries.get(i)).getDynamicObject("item");
            this.lockAssistAttrByItem(item, i);
        }
    }

    protected void lockAssistAttrByItem(DynamicObject itemValue, int index) {
        if (null != itemValue && Boolean.TRUE.equals(itemValue.get(HAS_ATTR))) {
            this.setEnable(index, new String[]{"assistattr"});
        } else {
            this.setUnEnable(index, new String[]{"assistattr"});
        }
    }

    protected void lockAssistAttrByItem(int index) {
        Object item = this.getValue("item");
        if (item instanceof DynamicObject) {
            DynamicObject itemValue = (DynamicObject)item;
            if (null != itemValue && Boolean.TRUE.equals(itemValue.get(HAS_ATTR))) {
                this.setEnable(index, new String[]{"assistattr"});
            } else {
                this.setUnEnable(index, new String[]{"assistattr"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Map param = (Map)e.getReturnData();
        if (param == null || param.get("isconfirm") == null || !"true".equals(param.get("isconfirm"))) {
            return;
        }
        String remark = (String)param.get("remark");
        this.setValue("invalidreason", remark);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("afterconfirm", "true");
        this.getView().invokeOperation(INVALID, operateOption);
    }

    public void clearOwner() {
        this.setValue("saler", null, true);
        this.clearTB(new String[]{"itementry"});
    }

    public void clearCustomer() {
        this.setValue("owner", null);
        this.clearOwner();
    }
}

