/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.widget;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.matetype.Dto;
import kd.drp.mdr.common.matetype.impl.BaseDto;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class AlterOrderedQtyChartWidgetPlugin
extends MdrFormPlugin {
    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void customEvent(CustomEventArgs e) {
        if (e.getKey().equals("refreshFromGridContainer")) {
            this.initData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void initData() {
        CustomChart chart = (CustomChart)this.getControl("chart");
        chart.setName(new LocaleString(ResManager.loadKDString((String)"\u8fd1\u671f\u8ba2\u8d27\u60c5\u51b5", (String)"AlterOrderedQtyChartWidgetPlugin_0", (String)"drp-dpa-formplugin", (Object[])new Object[0])));
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTitle(false);
        Axis x = chart.createXAxis("", AxisType.category);
        Axis yamount = chart.createYAxis(ResManager.loadKDString((String)"\u4e07\u5143", (String)"AlterOrderedQtyChartWidgetPlugin_1", (String)"drp-dpa-formplugin", (Object[])new Object[0]), AxisType.value);
        Axis yqty = chart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf", (String)"AlterOrderedQtyChartWidgetPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]), AxisType.value);
        Map<String, Object> datas = this.bindData();
        x.setCategorys((String[])datas.get("dates"));
        LineSeries line = chart.createLineSeries(ResManager.loadKDString((String)"\u6570\u91cf", (String)"AlterOrderedQtyChartWidgetPlugin_2", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        line.setLineColor("#F8CC57");
        line.setItemColor("#F8CC57");
        line.setData((Number[])datas.get("qtys"));
        line.setYAxisIndex(1);
        BarSeries bar = chart.createBarSeries(ResManager.loadKDString((String)"\u91d1\u989d", (String)"AlterOrderedQtyChartWidgetPlugin_3", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        bar.setData((Number[])datas.get("amounts"));
        bar.setColor("#88BFFF");
        chart.setShowTooltip(true);
        chart.bindData((BindingContext)null);
    }

    public Map<String, Object> bindData() {
        int num = 7;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        cal.add(5, 1);
        String enddate = sdf.format(cal.getTime());
        cal.add(5, 0 - num);
        String begindate = sdf.format(cal.getTime());
        List ownerid = UserUtil.getOwnerIDs();
        HashMap<String, Object> data = new HashMap<String, Object>();
        QFilter[] filterList = this.getQFilterList(begindate, enddate, ownerid);
        ORM orm = ORM.create();
        try (DataSet set = orm.queryDataSet(((Object)((Object)this)).getClass().getName(), this.getForm(), "id,CONCAT(CONCAT(YEAR(createtime),'-'),CONCAT(CONCAT(MONTH(createtime),'-'),DAYOFMONTH(createtime))) as x_index,totalorderamount", filterList).orderBy(new String[]{"x_index"}).groupBy(new String[]{"x_index"}).count("ordercount").sum("totalorderamount", "orderamount").finish().select("x_index,ordercount,orderamount,TO_DATE(x_index,'yyyy-MM-dd') as x_date").orderBy(new String[]{"x_date"});){
            BaseDto d;
            String[] dates = new String[num];
            Number[] qtys = new Number[num];
            Number[] amounts = new Number[num];
            HashMap<String, BaseDto> dataMap = new HashMap<String, BaseDto>();
            for (Row row : set) {
                d = new BaseDto();
                d.put((Object)"ordercount", (Object)row.getBigDecimal("ordercount"));
                d.put((Object)"orderamount", (Object)row.getBigDecimal("orderamount"));
                dataMap.put(row.getString("x_index").substring(5), d);
            }
            sdf = new SimpleDateFormat("M-d");
            cal.add(5, -1);
            for (int i = 0; i < num; ++i) {
                String date;
                cal.add(5, 1);
                dates[i] = date = sdf.format(cal.getTime());
                if (dataMap.get(date) != null) {
                    d = (Dto)dataMap.get(date);
                    qtys[i] = d.getAsBigDecimal("ordercount");
                    amounts[i] = d.getAsBigDecimal("orderamount").divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
                    continue;
                }
                qtys[i] = 0;
                amounts[i] = 0;
            }
            data.put("dates", dates);
            data.put("qtys", qtys);
            data.put("amounts", amounts);
        }
        return data;
    }

    protected String getForm() {
        return "dpa_purorder";
    }

    protected QFilter[] getQFilterList(String begindate, String enddate, List<Object> ownerid) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = simpleDateFormat.parse(begindate);
            endTime = simpleDateFormat.parse(enddate);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (String)"AlterOrderedQtyChartWidgetPlugin_4", (String)"drp-dpa-formplugin", (Object[])new Object[0]));
        }
        QFilter qcreatetime = new QFilter("createtime", ">", (Object)startTime);
        QFilter qendtime = new QFilter("createtime", "<", (Object)endTime);
        QFilter qownerid = new QFilter("customer.id", "in", ownerid);
        return new QFilter[]{qcreatetime, qendtime, qownerid};
    }
}

