/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.widget;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EventObject;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class BalanceWidgetPlugin
extends MdrFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container flex = (Container)this.getView().getControl("flexall");
        flex.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("mdr_mybalance");
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        DynamicObject customer = (DynamicObject)this.getView().getParentView().getModel().getValue("customer");
        QFilter filterCustomer = new QFilter("customer", "in", customer.getPkValue());
        DataSet datas = QueryServiceHelper.queryDataSet((String)"QueryServiceHelper.mdr_mybalance", (String)"mdr_mybalance", (String)"balance,usable,occupied", (QFilter[])filterCustomer.toArray(), null);
        Iterator data = datas.iterator();
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal usable = BigDecimal.ZERO;
        BigDecimal occupied = BigDecimal.ZERO;
        while (data.hasNext()) {
            Row row = (Row)data.next();
            balance = balance.add(row.getBigDecimal("balance"));
            usable = usable.add(row.getBigDecimal("usable"));
            occupied = occupied.add(row.getBigDecimal("occupied"));
        }
        DecimalFormat df2 = new DecimalFormat("0.00");
        Label balanceLable = (Label)this.getView().getControl("balance");
        balanceLable.setText(df2.format(balance));
        Label usableLable = (Label)this.getView().getControl("usable");
        usableLable.setText(df2.format(usable));
        Label occupiedLable = (Label)this.getView().getControl("occupied");
        occupiedLable.setText(df2.format(occupied));
    }
}

