/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpa.formplugin.widget;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.itemclass.ItemClassUtil;
import kd.drp.mdr.common.util.DateUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class OrderVolumeTrend
extends MdrFormPlugin {
    private static Set<Long> parentItemIdSet = new HashSet<Long>();
    private static String[] strColor = new String[]{"#F8CC57", "#F2ED57", "#F4FA57"};

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void customEvent(CustomEventArgs e) {
        if (e.getKey().equals("refreshFromGridContainer")) {
            this.initData();
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void initData() {
        CustomChart chart = (CustomChart)this.getControl("chart");
        chart.setName(new LocaleString(ResManager.loadKDString((String)"\u8fd16\u6708\u8ba2\u8d27\u989d\u8d8b\u52bf", (String)"OrderVolumeTrend_0", (String)"drp-dpa-formplugin", (Object[])new Object[0])));
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.right, YAlign.top);
        chart.setShowTitle(false);
        DynamicObject customer = (DynamicObject)this.getView().getParentView().getModel().getValue("customer");
        int nums = 6;
        TreeMap<String, Map<Long, BigDecimal>> datas = this.bindData(customer.getPkValue(), nums);
        Axis x = chart.createXAxis("", AxisType.category);
        Axis yamount = chart.createYAxis("(\u5143)", AxisType.value);
        String[] strings = datas.keySet().toArray(new String[datas.keySet().size()]);
        int colorNum = 0;
        for (Long parentId : parentItemIdSet) {
            QFilter filter = new QFilter("id", "=", (Object)parentId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)"name,id", (QFilter[])filter.toArray());
            BarSeries bar = chart.createBarSeries((String)dynamicObject.get("name"));
            bar.setItemColor(strColor[colorNum]);
            Number[] numbersData = new Number[strings.length];
            int index = 0;
            for (Map<Long, BigDecimal> amout : datas.values()) {
                BigDecimal value = amout.get(parentId);
                if (value != null) {
                    numbersData[index] = value;
                    bar.setData(numbersData);
                }
                ++index;
            }
            ++colorNum;
        }
        x.setCategorys(strings);
        chart.setShowTooltip(true);
    }

    public TreeMap<String, Map<Long, BigDecimal>> bindData(Object ownerId, int nums) {
        TreeMap<String, Map<Long, BigDecimal>> map = new TreeMap<String, Map<Long, BigDecimal>>();
        HashMap<Long, BigDecimal> mapItemData = new HashMap<Long, BigDecimal>();
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < nums; ++i) {
            Date begin = DateUtil.getFirstDayOfMonth((Date)DateUtil.getDayFirst((Date)DateUtil.getBeforeMonth((int)i)));
            Date end = DateUtil.getLastDayOfMonth((Date)DateUtil.getDayFirst((Date)DateUtil.getBeforeMonth((int)i)));
            cal.setTime(begin);
            int month = cal.get(2) + 1;
            DateUtil.getNowMonth();
            QFilter filters = new QFilter("customer", "=", ownerId);
            filters.and(QFilter.isNotNull((String)"itementry.item"));
            filters.and("createTime", ">=", (Object)begin);
            filters.and("createTime", "<=", (Object)end);
            DataSet datas = QueryServiceHelper.queryDataSet((String)"QueryServiceHelper.dpa_purorder", (String)"dpa_purorder", (String)"itementry.item,itementry.item.id,itementry.qty,itementry.price,itementry.item.itemclass.name", (QFilter[])filters.toArray(), null);
            Iterator dataIterator = datas.iterator();
            HashMap<Long, BigDecimal> parentItemData = new HashMap<Long, BigDecimal>();
            while (dataIterator.hasNext()) {
                Row row = (Row)dataIterator.next();
                long itemId = (Long)row.get("itementry.item.id");
                BigDecimal itemIdQty = (BigDecimal)row.get("itementry.qty");
                BigDecimal itemidPrice = (BigDecimal)row.get("itementry.price");
                List list = ItemClassUtil.queryClassList((Object)itemId);
                long parentId = (Long)list.get(list.size() - 1);
                mapItemData.put(itemId, itemIdQty.multiply(itemidPrice));
                if (parentItemData.get(parentId) != null) {
                    parentItemData.put(parentId, ((BigDecimal)parentItemData.get(parentId)).add((BigDecimal)mapItemData.get(itemId)));
                } else {
                    parentItemData.put(parentId, (BigDecimal)mapItemData.get(itemId));
                }
                parentItemIdSet.add(parentId);
                if (parentItemIdSet.size() != 0) continue;
                parentItemIdSet.clear();
            }
            map.put("" + month, parentItemData);
        }
        return map;
    }
}

