/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.mservice;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.model.condition.PricePolicyCondition;
import kd.drp.dpm.common.model.result.PricePolicyResult;
import kd.drp.dpm.common.model.result.ResultMessage;
import kd.drp.dpm.common.retailpriceenum.PriceTypeCheckboxEnum;
import kd.drp.dpm.common.retailpriceenum.RetailPriceTypeEnum;
import kd.drp.dpm.common.util.CommonUtil;
import kd.drp.dpm.mservice.api.PricePolicyService;

public class PricePolicyServiceImpl
implements PricePolicyService {
    private Log logger = LogFactory.getLog(PricePolicyServiceImpl.class);
    private static final String PRICE_QUERY_FIELD = "id,billno,channel,billstatus,billtype,enable,pricedetailentity.item,pricedetailentity.item.name,pricedetailentity.barcode,pricedetailentity.priceunit,pricedetailentity.pricenum,pricedetailentity.stocktype,pricedetailentity.priceeffectdate,pricedetailentity.priceinvaliddate,pricedetailentity.retailprice,pricedetailentity.uniqueprice,pricedetailentity.factoryprice,pricedetailentity.memberprice,pricedetailentity.specialprice,userangeentity.hasdistributed";
    private static final String PRICE_TYPE_QUERY_FIELD = "number,name,iscontrolprice,isallowadjust,pricefield,level,enable,status,disabletime";

    public ResultMessage<PricePolicyResult> matchPricePolicy(PricePolicyCondition condition) {
        this.logger.info("\u4ef7\u683c\u653f\u7b56\u8c03\u7528:" + JSON.toJSONString((Object)condition));
        ResultMessage<PricePolicyResult> result = new ResultMessage<PricePolicyResult>();
        this.checkServiceParam(result, condition);
        if (StringUtils.isNotEmpty((String)result.getMessage())) {
            return result;
        }
        QFilter filter = new QFilter("pricedetailentity.item", "=", (Object)condition.getItemId());
        filter.and(new QFilter("billstatus", "=", (Object)"C"));
        filter.and(new QFilter("enable", "=", (Object)"A"));
        filter.and(new QFilter("pricedetailentity.priceisinvalid", "=", (Object)"0"));
        filter.and(new QFilter("userangeentity.pricebranch", "=", (Object)condition.getChannel()));
        String useTerminal = condition.getUseTerminal();
        if (StringUtils.isNotEmpty((String)useTerminal)) {
            String[] useterminals = useTerminal.split(",");
            filter.and(new QFilter("useterminal", "in", (Object)useterminals));
        }
        filter.and(new QFilter("pricedetailentity.priceunit", "=", (Object)condition.getPriceUnit()));
        filter.and(new QFilter("pricedetailentity.barcode", "=", (Object)condition.getBarcode()));
        filter.and(new QFilter("pricedetailentity.priceeffectdate", "<=", (Object)CommonUtil.stringToDateformat((String)condition.getBizDate())));
        filter.and(new QFilter("pricedetailentity.priceinvaliddate", ">=", (Object)CommonUtil.stringToDateformat((String)condition.getBizDate())));
        DynamicObjectCollection pricePolicyList = QueryServiceHelper.query((String)"dpm_retailpricelist", (String)PRICE_QUERY_FIELD, (QFilter[])new QFilter[]{filter}, (String)"billtype desc,auditdate desc");
        String billType = null;
        Boolean distributed = null;
        for (DynamicObject dynamicObject : pricePolicyList) {
            billType = dynamicObject.getString("billType");
            distributed = dynamicObject.getBoolean("userangeentity.hasdistributed");
            if ("920289759207803904".equals(billType)) {
                result = this.judgePriceTypeLevel(dynamicObject);
                break;
            }
            if (!"920045548189278208".equals(billType) || !distributed.booleanValue()) continue;
            result = this.judgePriceTypeLevel(dynamicObject);
            break;
        }
        this.logger.info("\u4ef7\u683c\u653f\u7b56\u8fd4\u56de:" + JSON.toJSONString((Object)result));
        return result;
    }

    private ResultMessage<PricePolicyResult> judgePriceTypeLevel(DynamicObject pricePolicy) {
        ResultMessage result = new ResultMessage();
        try {
            List<String> priceFields = this.getPriceField(pricePolicy);
            if (priceFields.size() > 0) {
                PricePolicyResult pricePolicyResult = new PricePolicyResult();
                QFilter filter = new QFilter("pricefield", "in", priceFields);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"dpm_retailpricetype", (String)PRICE_TYPE_QUERY_FIELD, (QFilter[])new QFilter[]{filter}, (String)"level asc", (int)1);
                if (dynamicObjects.length > 0) {
                    DynamicObject priceType = dynamicObjects[0];
                    pricePolicyResult.setBillNo(pricePolicy.getString("billno"));
                    pricePolicyResult.setBarcode(pricePolicy.getString("pricedetailentity.barcode"));
                    pricePolicyResult.setChannel(pricePolicy.getString("channel"));
                    pricePolicyResult.setControllerPrice(priceType.getBoolean("iscontrolprice"));
                    pricePolicyResult.setItemId(Long.valueOf(pricePolicy.getLong("pricedetailentity.item")));
                    pricePolicyResult.setItemName(pricePolicy.getString("pricedetailentity.item.name"));
                    pricePolicyResult.setMatchStatus("1");
                    this.matchTopLevelPrice(pricePolicyResult, pricePolicy, priceType);
                    pricePolicyResult.setPriceNum(pricePolicy.getBigDecimal("pricedetailentity.pricenum"));
                    pricePolicyResult.setPriceUnit(pricePolicy.getString("pricedetailentity.priceunit"));
                    pricePolicyResult.setStockType(pricePolicy.getString("pricedetailentity.stocktype"));
                    result.success((Object)pricePolicyResult);
                }
            }
        }
        catch (Exception e) {
            result.fail("\u53d6\u4ef7\u9519\u8bef:" + e.getMessage());
            this.logger.error((Throwable)e);
        }
        return result;
    }

    private List<String> getPriceField(DynamicObject pricePolicy) {
        ArrayList<String> priceFields = new ArrayList<String>(5);
        if (pricePolicy.getLong("pricedetailentity.retailprice") > 0L) {
            priceFields.add(PriceTypeCheckboxEnum.RPCHECKBOX.getPriceType());
        }
        if (pricePolicy.getLong("pricedetailentity.uniqueprice") > 0L) {
            priceFields.add(PriceTypeCheckboxEnum.UPCHECKBOX.getPriceType());
        }
        if (pricePolicy.getLong("pricedetailentity.factoryprice") > 0L) {
            priceFields.add(PriceTypeCheckboxEnum.FPCHECKBOX.getPriceType());
        }
        if (pricePolicy.getLong("pricedetailentity.memberprice") > 0L) {
            priceFields.add(PriceTypeCheckboxEnum.MPCHECKBOX.getPriceType());
        }
        if (pricePolicy.getLong("pricedetailentity.specialprice") > 0L) {
            priceFields.add(PriceTypeCheckboxEnum.SPCHECKBOX.getPriceType());
        }
        return priceFields;
    }

    private void matchTopLevelPrice(PricePolicyResult pricePolicyResult, DynamicObject pricePolicy, DynamicObject priceType) {
        BigDecimal pricenum = pricePolicy.getBigDecimal("pricedetailentity.pricenum");
        if (pricenum.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        switch (priceType.getString("pricefield")) {
            case "A": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.retailprice").divide(pricenum));
                pricePolicyResult.setPriceType(RetailPriceTypeEnum.RPCHECKBOX.getName());
                break;
            }
            case "B": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.factoryprice").divide(pricenum));
                pricePolicyResult.setPriceType(RetailPriceTypeEnum.FPCHECKBOX.getName());
                break;
            }
            case "C": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.uniqueprice").divide(pricenum));
                pricePolicyResult.setPriceType(RetailPriceTypeEnum.UPCHECKBOX.getName());
                break;
            }
            case "D": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.memberprice").divide(pricenum));
                pricePolicyResult.setPriceType(RetailPriceTypeEnum.MPCHECKBOX.getName());
                break;
            }
            case "E": {
                pricePolicyResult.setPrice(pricePolicy.getBigDecimal("pricedetailentity.specialprice").divide(pricenum));
                pricePolicyResult.setPriceType(RetailPriceTypeEnum.SPCHECKBOX.getName());
                break;
            }
        }
    }

    private void checkServiceParam(ResultMessage<PricePolicyResult> result, PricePolicyCondition condition) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((String)condition.getItemId())) {
            sb.append("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a ");
        }
        if (StringUtils.isEmpty((String)condition.getBarcode())) {
            sb.append("\u5546\u54c1\u6761\u5f62\u7801\u4e0d\u80fd\u4e3a\u7a7a ");
        }
        if (StringUtils.isEmpty((String)condition.getChannel())) {
            sb.append("\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a ");
        }
        if (StringUtils.isEmpty((String)condition.getPriceUnit())) {
            sb.append("\u8ba1\u4ef7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a ");
        }
        if (StringUtils.isEmpty((String)condition.getBizDate())) {
            sb.append("\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a ");
        }
        result.fail(sb.toString());
    }
}

