/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.mservice;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.execute.PromotionUsableContext;
import kd.drp.dpm.common.limit.PromotionLimitUtil;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.dpm.mservice.api.PromotionService;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.PromotionApiResult;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;

public class PromotionServiceImpl
implements PromotionService {
    public PromotionApiResult matchAndExecute(String cachekey, PromotionOrder order) {
        PromotionExecuteContext context = PromotionUtil.matchAndExecute((String)cachekey, (PromotionOrder)order);
        return this.generateApiResult(context);
    }

    public PromotionApiResult match(String cachekey, PromotionOrder order) {
        PromotionExecuteContext context = PromotionUtil.match((String)cachekey, (PromotionOrder)order);
        return this.generateApiResult(context);
    }

    public PromotionApiResult execute(String cachekey, PromotionOrder order) {
        PromotionExecuteContext context = PromotionUtil.execute((String)cachekey, (PromotionOrder)order);
        return this.generateApiResult(context);
    }

    public PromotionApiResult switchExecutions(String cachekey, PromotionOrder order, Object promotionid, char groupnumber) {
        PromotionExecuteContext context = PromotionUtil.switchExecutions((String)cachekey, (PromotionOrder)order, (Object)promotionid, (char)groupnumber);
        return this.generateApiResult(context);
    }

    public PromotionApiResult getPromotionResult4Runtime(String cachekey) {
        PromotionExecuteContext context = PromotionUtil.loadPromotionContextFromCache((String)cachekey);
        return this.generateApiResult(context);
    }

    public PromotionApiResult getPromotionResult4Order(Long orderid) {
        PromotionExecuteContext context = PromotionUtil.loadPromotionContextFromDB((Object)orderid);
        return this.generateApiResult(context);
    }

    public Set<Object> getPromotionResult4Orders(Set<Object> orderids) {
        return PromotionUtil.getPromotionResultFromOrders(orderids);
    }

    public void savePromotionExecution(String cachekey, Object orderid) {
        PromotionUtil.savePromotionContext((String)cachekey, (Object)orderid);
    }

    public void deletePromotionExecution(Set<Object> orderids) {
        PromotionUtil.deletePromotionContext(orderids);
    }

    public void removeContextFromPolicy(String cachekey, Set<Object> policyids) {
        PromotionUtil.removeContextFromPolicy((String)cachekey, policyids);
    }

    public void deletePromotionContext(Object orderid, Set<Object> promotionpolicyids) {
        PromotionUtil.deletePromotionExecution((Object)orderid, promotionpolicyids);
    }

    public void removePromotionCache(String cachekey) {
        PromotionUtil.removePromotionCache((String)cachekey);
    }

    public Set<UsablePromotionResult> matchByOrder(PromotionOrder order) {
        PromotionUsableContext context = PromotionUtil.matchPolicys((PromotionOrder)order);
        return PromotionServiceImpl.getPromotionAvailableResult(context);
    }

    public Set<UsablePromotionResult> matchAndExecutePromotion(String cachekey, Object ownerid, Object customerid, boolean islimit, String ... sourceformkey) {
        return PromotionUtil.matchAndExecutePromotion((String)cachekey, (Object)ownerid, (Object)customerid, (boolean)islimit, (String[])sourceformkey);
    }

    public Set<UsablePromotionResult> matchPromotion(String cachekey, Object ownerid, Object customerid, boolean islimit, String ... sourceformkey) {
        return PromotionUtil.matchPromotion((String)cachekey, (Object)ownerid, (Object)customerid, (boolean)islimit, (String[])sourceformkey);
    }

    public Set<UsablePromotionResult> getUsablePromotionResult(String cachekey) {
        return PromotionUtil.loadPromotionAvailableContextFromCache((String)cachekey);
    }

    public void removePromotionContextFromCache(String cachekey) {
        PromotionUtil.removePromotionContextFromCache((String)cachekey);
    }

    public Set<OperateErrorInfo> CreateLimitBill(Object ... promotionids) {
        return PromotionUtil.CreateLimitBill((Object[])promotionids);
    }

    public Set<Object> getPromotionByLimit(Object ... promotionids) {
        return PromotionUtil.getPromotionByLimit((Object[])promotionids);
    }

    private PromotionApiResult generateApiResult(PromotionExecuteContext ctx) {
        PromotionApiResult result = new PromotionApiResult();
        result.setCachekey(ctx.getCachekey());
        result.setOrder(ctx.getOrder());
        Map promotionmap = result.getPromotions();
        for (Promotion promotion : ctx.getPromotions()) {
            promotionmap.put(promotion.getNumber(), promotion.getName());
        }
        List executionlist = result.getExecutions();
        for (ReplaceablePromotionExecution rpe : ctx.getExecutions()) {
            executionlist.addAll(rpe.createExecution());
        }
        result.setExecutions(executionlist);
        return result;
    }

    private static Set<UsablePromotionResult> getPromotionAvailableResult(PromotionUsableContext context) {
        HashSet<UsablePromotionResult> promotionInfos = null;
        if (context == null) {
            return promotionInfos;
        }
        Set promotions = context.getPromotions();
        if (promotions != null && promotions.size() > 0) {
            promotionInfos = new HashSet<UsablePromotionResult>(promotions.size());
            UsablePromotionResult usablePromotionResult = null;
            for (Promotion promotion : promotions) {
                usablePromotionResult = new UsablePromotionResult();
                usablePromotionResult.setId(promotion.getId());
                usablePromotionResult.setNumber(promotion.getNumber());
                usablePromotionResult.setName(promotion.getName());
                usablePromotionResult.setPriority(promotion.getPriority());
                usablePromotionResult.setStarttime(promotion.getstarttime());
                usablePromotionResult.setEndtime(promotion.getendtime());
                usablePromotionResult.setIslimit(promotion.getislimit());
                usablePromotionResult.setLeftLimitqty(promotion.getLeftLimitqty());
                promotionInfos.add(usablePromotionResult);
            }
        }
        return promotionInfos;
    }

    public LimitResult executeLimitRule(Object orderId, PromotionOrder porder, String cachekey, boolean putOnOrder) {
        return PromotionLimitUtil.executeLimitRule((Object)orderId, (PromotionOrder)porder, (String)cachekey, (boolean)putOnOrder);
    }

    public LimitResult validateLimitRule(String cachekey, PromotionOrder porder, boolean putOnOrder) {
        return PromotionLimitUtil.validateLimitRule((String)cachekey, (PromotionOrder)porder, (boolean)putOnOrder);
    }

    public LimitResult executeLimitRule(Object orderId, PromotionOrder porder, boolean putOnOrder) {
        return PromotionLimitUtil.executeLimitRule((Object)orderId, (PromotionOrder)porder, (boolean)putOnOrder);
    }

    public LimitResult validateLimitRule(PromotionOrder porder, boolean putOnOrder) {
        return PromotionLimitUtil.validateLimitRule((PromotionOrder)porder, (boolean)putOnOrder);
    }

    public boolean rollbackLimit(Object orderId, boolean isexpected) {
        if (isexpected) {
            return PromotionLimitUtil.rollBackExpectedQty((Object)orderId);
        }
        return PromotionLimitUtil.rollback((Object)orderId);
    }
}

