/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;

public class ItemRangeUtil {
    private static final DBRoute MDR_DBROUTE = new DBRoute("mdr");

    public static boolean isItemRangeEfective(DynamicObject itemrange) {
        DynamicObjectCollection entrys = itemrange.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if (entry.get("itemclass") == null && entry.get("itembrand") == null && entry.get("item") == null) continue;
            return true;
        }
        return false;
    }

    public static Set parseItemRange(Object rangeid) {
        DynamicObject itemrange = BusinessDataServiceHelper.loadSingle((Object)rangeid, (String)"dpm_itemrange", (String)"entryentity.itembrand,entryentity.itemclass,entryentity.item,entryentity.unit,entryentity.attr,entryentity.isremoved");
        return ItemRangeUtil.parseItemRange(itemrange);
    }

    public static Set<DetailItemInfo> parseItemRange(DynamicObject itemrange) {
        DynamicObjectCollection rangeentrys = itemrange.getDynamicObjectCollection("entryentity");
        HashSet<DetailItemInfo> addDetail = new HashSet<DetailItemInfo>();
        HashSet<DetailItemInfo> removeDetail = new HashSet<DetailItemInfo>();
        for (DynamicObject entry : rangeentrys) {
            boolean isremoved = entry.getBoolean("isremoved");
            if (entry.get("item") == null) continue;
            DetailItemInfo info = new DetailItemInfo();
            info.setItemid(entry.getDynamicObject("item").getPkValue());
            if (entry.get("unit") != null) {
                info.setUnitid(entry.getDynamicObject("unit").getPkValue());
            } else {
                info.setUnitid((Object)0L);
            }
            if (entry.get("attr") != null) {
                info.setAttrid(entry.getDynamicObject("attr").getPkValue());
            } else {
                info.setAttrid((Object)0L);
            }
            if (isremoved) {
                removeDetail.add(info);
                continue;
            }
            addDetail.add(info);
        }
        Set<DetailItemInfo> set = ItemRangeUtil.genFromClassAndBrand(rangeentrys);
        set.addAll(addDetail);
        set.removeAll(removeDetail);
        return set;
    }

    public static DynamicObject copyAndCreateNewItemRange(DynamicObject fromrange) {
        DynamicObject torange = BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemrange");
        DynamicObjectCollection fromcol = fromrange.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection tocol = torange.getDynamicObjectCollection("entryentity");
        for (DynamicObject fromentry : fromcol) {
            DynamicObject entry = tocol.addNew();
            entry.set("itemclass", fromentry.get("itemclass"));
            entry.set("itembrand", fromentry.get("itembrand"));
            entry.set("item", fromentry.get("item"));
            entry.set("unit", fromentry.get("unit"));
            entry.set("attr", fromentry.get("attr"));
            entry.set("isremoved", fromentry.get("isremoved"));
        }
        return torange;
    }

    public static boolean isItemInRange(DetailItemInfo item, Object rangeid) {
        Set itemset = ItemRangeUtil.parseItemRange(rangeid);
        return itemset.contains(item);
    }

    private static Set<DetailItemInfo> genFromClassAndBrand(DynamicObjectCollection rangeentrys) {
        HashSet<Object> initemidset = new HashSet<Object>();
        HashSet<Object> removeitemidset = new HashSet<Object>();
        HashSet<Object> inmaterialidset = new HashSet<Object>();
        HashSet<Object> removematerialidset = new HashSet<Object>();
        for (DynamicObject entry : rangeentrys) {
            boolean isremoved = entry.getBoolean("isremoved");
            DynamicObjectCollection entryresult = null;
            if (entry.getDynamicObject("itemclass") != null) {
                DynamicObject itemclass = entry.getDynamicObject("itemclass");
                String longnumber = QueryServiceHelper.queryOne((String)"mdr_item_class", (String)"longnumber", (QFilter[])new QFilter("id", "=", itemclass.getPkValue()).toArray()).getString("longnumber");
                entryresult = QueryServiceHelper.query((String)"mdr_item_info", (String)"id,material.id", (QFilter[])new QFilter("itemclassentity.goodsclasssid.longnumber", "like", (Object)(longnumber + "%")).toArray());
            } else {
                if (entry.getDynamicObject("itembrand") == null) continue;
                entryresult = QueryServiceHelper.query((String)"mdr_item_info", (String)"id,material.id", (QFilter[])new QFilter("itembrands.fbasedataid", "=", entry.getDynamicObject("itembrand").getPkValue()).toArray());
            }
            for (DynamicObject o : entryresult) {
                if (isremoved) {
                    removeitemidset.add(o.get("id"));
                    removematerialidset.add(o.get("material.id"));
                    continue;
                }
                initemidset.add(o.get("id"));
                inmaterialidset.add(o.get("material.id"));
            }
        }
        initemidset.removeAll(removeitemidset);
        inmaterialidset.removeAll(removematerialidset);
        ORM orm = ORM.create();
        HashSet<DetailItemInfo> set = new HashSet<DetailItemInfo>();
        try (DataSet itemset = orm.queryDataSet("kd.drp.dpm.common.ItemRangeUtil", "mdr_item_info", "id as itemid,material.id as material", new QFilter("id", "in", initemidset).toArray());
             DataSet mutilunitset = orm.queryDataSet("kd.drp.dpm.common.ItemRangeUtil", "bd_multimeasureunit", "materialid.id as material,measureunitid.id as unitid", new QFilter("materialid.id", "in", inmaterialidset).toArray());
             DataSet baseunitset = orm.queryDataSet("kd.drp.dpm.common.ItemRangeUtil", "bd_material", "id as material,baseunit.id as unitid", new QFilter("id", "in", inmaterialidset).toArray());
             DataSet unitset = mutilunitset.union(baseunitset);
             DataSet attrset = orm.queryDataSet("kd.drp.dpm.common.ItemRangeUtil", "mdr_item_attrvalue", "item.id as itemid,id as attrid", new QFilter[]{new QFilter("item.id", "in", initemidset)});
             DataSet iuset = itemset.join(unitset, JoinType.LEFT).on("material", "material").select(new String[]{"itemid"}, new String[]{"unitid"}).finish();
             DataSet finalset = iuset.join(attrset, JoinType.LEFT).on("itemid", "itemid").select(new String[]{"itemid", "unitid"}, new String[]{"attrid"}).finish();){
            while (finalset.hasNext()) {
                Row row = finalset.next();
                Object attr = row.get("attrid");
                set.add(new DetailItemInfo(row.get("itemid"), row.get("unitid"), attr == null ? Long.valueOf(0L) : attr));
            }
        }
        return set;
    }
}

