/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class PromotionDataServiceHelper {
    public static DynamicObject[] getConditionObjsFromDB(String conditionexp) {
        Object[] conditionids = conditionexp.split("AND|OR");
        return BusinessDataServiceHelper.load((Object[])conditionids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dpm_condition"));
    }

    public static DynamicObject[] getResultObjsFromDB(String resultexp) {
        String[] ids = resultexp.split("AND|OR");
        DynamicObject[] relations = BusinessDataServiceHelper.load((Object[])Arrays.stream(ids).map(i -> Long.parseLong(i)).collect(Collectors.toList()).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dpm_result_relation"));
        DynamicObject[] results = new DynamicObject[relations.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = BusinessDataServiceHelper.loadSingle((Object)relations[i2].getPkValue(), (String)relations[i2].getString("resulttype.metadata.number"));
        }
        return results;
    }

    public static DynamicObject getResultFromDB(Object resultid) {
        return BusinessDataServiceHelper.loadSingle((Object)resultid, (String)PromotionDataServiceHelper.getResultRelation(resultid));
    }

    public static String getResultRelation(Object resultid) {
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)resultid, (String)"dpm_result_relation");
        return relation.getDynamicObject("resulttype.metadata").getString("number");
    }

    public static ILocaleString getResultTypeName(Object resultid) {
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)resultid, (String)"dpm_result_relation");
        return relation.getDynamicObject("resulttype").getLocaleString("name");
    }

    public static DynamicObject getConditionFromDB(Object conditionid) {
        return BusinessDataServiceHelper.loadSingle((Object)conditionid, (String)"dpm_condition");
    }

    public static void deleteCondition(Object conditionid) {
        DynamicObject condition = BusinessDataServiceHelper.loadSingle((Object)conditionid, (String)"dpm_condition");
        PromotionDataServiceHelper.deleteCondition(condition);
    }

    public static void deleteConditions(Object[] conditionids) {
        DynamicObject[] conditions = BusinessDataServiceHelper.load((Object[])conditionids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dpm_condition"));
        LinkedList<Object> rangeids = new LinkedList<Object>();
        for (DynamicObject condition : conditions) {
            DynamicObject itemrange = condition.getDynamicObject("itemrange");
            if (itemrange == null) continue;
            rangeids.add(itemrange.getPkValue());
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_itemrange"), (Object[])rangeids.toArray());
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_condition"), (Object[])conditionids);
    }

    public static void deleteResults(Object[] resultids) {
        for (Object resultid : resultids) {
            PromotionDataServiceHelper.deleteResult(resultid);
        }
    }

    public static void deleteCondition(DynamicObject condition) {
        DynamicObject itemrange = condition.getDynamicObject("itemrange");
        if (itemrange != null) {
            DeleteServiceHelper.delete((IDataEntityType)itemrange.getDataEntityType(), (Object[])new DynamicObject[]{itemrange});
        }
        DeleteServiceHelper.delete((IDataEntityType)condition.getDataEntityType(), (Object[])new DynamicObject[]{condition});
    }

    public static void batchDeleteConditions(DynamicObject[] conditions) {
        ArrayList<DynamicObject> itemrangelist = new ArrayList<DynamicObject>();
        for (DynamicObject condition : conditions) {
            if (condition.get("itemrange") == null) continue;
            itemrangelist.add(condition.getDynamicObject("itemrange"));
        }
        Object[] ranges = new DynamicObject[itemrangelist.size()];
        itemrangelist.toArray(ranges);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_itemrange"), (Object[])ranges);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_condition"), (Object[])conditions);
    }

    public static void deleteResult(DynamicObject result) {
        DynamicObject itemrange = result.getDynamicObject("itemrange");
        if (itemrange != null) {
            DeleteServiceHelper.delete((IDataEntityType)itemrange.getDataEntityType(), (Object[])new Object[]{itemrange});
        }
        DeleteServiceHelper.delete((String)"dpm_result_relation", (QFilter[])new QFilter[]{new QFilter("id", "=", result.getPkValue())});
        DeleteServiceHelper.delete((IDataEntityType)result.getDataEntityType(), (Object[])new Object[]{result});
    }

    public static void deleteResult(Object resultid) {
        DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)resultid, (String)"dpm_result_relation");
        if (relation == null) {
            return;
        }
        DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)resultid, (String)relation.getDynamicObject("resulttype.metadata").getString("number"));
        PromotionDataServiceHelper.deleteResult(result);
    }

    public static void batchDeleteResults(DynamicObject[] results) {
        String resulttype;
        HashMap map = new HashMap();
        HashSet<Object> idset = new HashSet<Object>(results.length);
        ArrayList<DynamicObject> itemrangelist = new ArrayList<DynamicObject>();
        for (DynamicObject result : results) {
            List<DynamicObject> list;
            if (result.get("itemrange") != null) {
                itemrangelist.add(result.getDynamicObject("itemrange"));
            }
            idset.add(result.getPkValue());
            resulttype = result.getDataEntityType().getName();
            if (map.get(resulttype) == null) {
                list = new ArrayList<DynamicObject>();
                list.add(result);
                map.put(resulttype, list);
                continue;
            }
            list = (List)map.get(resulttype);
            list.add(result);
        }
        Object[] ranges = new DynamicObject[itemrangelist.size()];
        itemrangelist.toArray(ranges);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_itemrange"), (Object[])ranges);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"dpm_result_relation"), (Object[])idset.toArray());
        for (Map.Entry entry : map.entrySet()) {
            List resultlist = (List)entry.getValue();
            resulttype = (String)entry.getKey();
            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)resulttype), (Object[])resultlist.toArray());
        }
    }

    public static void deleteUnit(Object unitid) {
    }

    public static void deleteUnitContent(String conditionexp, String resultexp) {
        if (conditionexp != null && !conditionexp.trim().isEmpty()) {
            DynamicObject[] conditions = PromotionDataServiceHelper.getConditionObjsFromDB(conditionexp);
            PromotionDataServiceHelper.batchDeleteConditions(conditions);
        }
        if (resultexp != null && !resultexp.trim().isEmpty()) {
            DynamicObject[] results = PromotionDataServiceHelper.getResultObjsFromDB(resultexp);
            PromotionDataServiceHelper.batchDeleteResults(results);
        }
    }

    public static String getResultName(Object conditionid) {
        return PromotionDataServiceHelper.getResultFromDB(conditionid).getString("name");
    }
}

