/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common;

import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.itemcontrol.ItemSaleControlUtil;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemUtil;

public class PromotionUiUtil {
    public static void addItemFilter(BeforeF7SelectEvent e, Object ownerid) {
        if (ownerid == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f9b\u8d27\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionUiUtil_0", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)PromotionUiUtil.getItemF7Filter(ownerid));
    }

    private static QFilter getItemF7Filter(Object ownerid) {
        Set itemids = ItemSaleControlUtil.getAllCanSaleItemIdsByDefaultFilter((Object)ownerid);
        return new QFilter("id", "in", (Object)itemids);
    }

    public static void itemChanged(IFormView view, String itemfield, String unitfield, String attrfield) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield);
        if (item == null) {
            return;
        }
        if (item.getBoolean("iscombination")) {
            model.setValue(unitfield, null);
            model.setValue(attrfield, null);
            view.setEnable(Boolean.FALSE, new String[]{unitfield, attrfield});
        } else {
            QFilter fs = new QFilter("id", "=", item.getPkValue());
            boolean hasattr = false;
            DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
            if (iteminfo != null) {
                Object unit = iteminfo.get("saleunit");
                if (unit != null) {
                    model.setValue(unitfield, unit);
                }
                hasattr = iteminfo.getBoolean("hasattr");
            }
            view.setEnable(Boolean.TRUE, new String[]{unitfield});
            if (hasattr) {
                model.setValue(attrfield, ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()));
                view.setEnable(Boolean.TRUE, new String[]{attrfield});
            } else {
                model.setValue(attrfield, null);
                view.setEnable(Boolean.FALSE, new String[]{attrfield});
            }
        }
    }

    public static void itemChanged(IFormView view, String itemfield, String unitfield, String attrfield, int index) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield, index);
        if (item == null) {
            return;
        }
        if (item.getBoolean("iscombination")) {
            model.setValue(unitfield, null, index);
            model.setValue(attrfield, null, index);
            view.setEnable(Boolean.FALSE, index, new String[]{unitfield, attrfield});
        } else {
            QFilter fs = new QFilter("id", "=", item.getPkValue());
            boolean hasattr = false;
            DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
            if (iteminfo != null) {
                Object unit = iteminfo.get("saleunit");
                if (unit != null) {
                    model.setValue(unitfield, unit, index);
                }
                hasattr = iteminfo.getBoolean("hasattr");
            }
            view.setEnable(Boolean.TRUE, index, new String[]{unitfield});
            if (hasattr) {
                model.setValue(attrfield, ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()), index);
                view.setEnable(Boolean.TRUE, index, new String[]{attrfield});
            } else {
                model.setValue(attrfield, null);
                view.setEnable(Boolean.FALSE, index, new String[]{attrfield});
            }
        }
    }

    public static void itemChanged(IFormView view, String itemfield, String baseunitfield, String unitfield, String attrfield, int index) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield, index);
        if (item == null) {
            return;
        }
        if (item.getBoolean("iscombination")) {
            model.setValue(baseunitfield, null, index);
            model.setValue(unitfield, null, index);
            model.setValue(attrfield, null, index);
            view.setEnable(Boolean.FALSE, index, new String[]{unitfield, attrfield});
        } else {
            QFilter fs = new QFilter("id", "=", item.getPkValue());
            boolean hasattr = false;
            DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"baseunit,saleunit,hasattr");
            if (iteminfo != null) {
                Object unit = iteminfo.get("baseunit");
                if (unit != null) {
                    model.setValue(baseunitfield, unit, index);
                }
                if ((unit = iteminfo.get("saleunit")) != null) {
                    model.setValue(unitfield, unit, index);
                }
                hasattr = iteminfo.getBoolean("hasattr");
            }
            view.setEnable(Boolean.TRUE, index, new String[]{unitfield});
            if (hasattr) {
                model.setValue(attrfield, ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()), index);
                view.setEnable(Boolean.TRUE, index, new String[]{attrfield});
            } else {
                model.setValue(attrfield, null);
                view.setEnable(Boolean.FALSE, index, new String[]{attrfield});
            }
        }
    }

    public static boolean hasAssistAttr(Object itemId) {
        boolean hasattr = false;
        QFilter fs = new QFilter("id", "=", itemId);
        DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
        if (iteminfo != null) {
            hasattr = iteminfo.getBoolean("hasattr");
        }
        return hasattr;
    }

    public static void addUnitFilter(BeforeF7SelectEvent e, IFormView view, String itemfield) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield);
        if (item == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PromotionUiUtil_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        Set unitids = ItemUtil.queryAllUnit((Object)item.getPkValue());
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)unitids));
    }

    public static void addUnitFilter(BeforeF7SelectEvent e, IFormView view, String itemfield, int index) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield, index);
        if (item == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PromotionUiUtil_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        Set unitids = ItemUtil.queryAllUnit((Object)item.getPkValue());
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)unitids));
    }

    public static void standardChanged(IFormView view, String unitfield, String currencyfield, String standardfield, String decimalfield) {
        IDataModel model = view.getModel();
        String standard = model.getValue(standardfield).toString();
        if (standard.equals("qty")) {
            PromotionUiUtil.unitChanged(view, unitfield, decimalfield);
        }
        if (standard.equals("amount")) {
            PromotionUiUtil.currencyChanged(view, currencyfield, decimalfield);
        }
    }

    public static void unitChanged(IFormView view, String unitfield, String decimalfield) {
        IDataModel model = view.getModel();
        DynamicObject unit = (DynamicObject)model.getValue(unitfield);
        HashMap<String, Integer> sc = new HashMap<String, Integer>(1);
        HashMap<String, HashMap<String, Integer>> item = new HashMap<String, HashMap<String, Integer>>();
        if (unit == null) {
            sc.put("sc", 0);
        } else {
            sc.put("sc", unit.getInt("precision"));
        }
        item.put("item", sc);
        view.updateControlMetadata(decimalfield, item);
    }

    public static void unitChangedWithStandard(IFormView view, String unitfield, String decimalfield, String standardfield) {
        String standard = view.getModel().getValue(standardfield).toString();
        if (standard.equals("amount")) {
            return;
        }
        PromotionUiUtil.unitChanged(view, unitfield, decimalfield);
    }

    public static void currencyChanged(IFormView view, String currencyfield, String decimalfield) {
        IDataModel model = view.getModel();
        HashMap<String, Integer> sc = new HashMap<String, Integer>(1);
        HashMap<String, HashMap<String, Integer>> item = new HashMap<String, HashMap<String, Integer>>();
        sc.put("sc", 2);
        item.put("item", sc);
        view.updateControlMetadata(decimalfield, item);
    }

    public static void unitChanged(IFormView view, String unitfield, String decimalfield, int index) {
    }

    public static void addAttrFilter(BeforeF7SelectEvent e, IFormView view, String itemfield) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield);
        if (item == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PromotionUiUtil_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        if (ItemAttrUtil.hasAssistAttr((Object)item.getPkValue())) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)item.getPkValue()));
        } else {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("1", "=", (Object)2));
        }
    }

    public static void addAttrFilter(BeforeF7SelectEvent e, IFormView view, String itemfield, int index) {
        IDataModel model = view.getModel();
        DynamicObject item = (DynamicObject)model.getValue(itemfield, index);
        if (item == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5546\u54c1", (String)"PromotionUiUtil_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)item.getPkValue()));
    }
}

