/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.common.cache.DPMAppCache;
import kd.drp.dpm.common.chain.PromotionOpEnum;
import kd.drp.dpm.common.chain.processor.MatchUsablePromotionProcessor;
import kd.drp.dpm.common.execute.PromotionAvailableContext;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.execute.PromotionExecutor;
import kd.drp.dpm.common.execute.PromotionUsableContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.execution.ExecutionInCache;
import kd.drp.dpm.common.model.execution.PromotionExecutionFactory;
import kd.drp.dpm.common.model.execution.PromotionExecutionUnit;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.dpm.common.model.execution.impl.AddPresentExecution;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;
import kd.drp.mdr.common.util.UserUtil;

public class PromotionUtil {
    protected static Log log = LogFactory.getLog(PromotionUtil.class);

    public static PromotionExecuteContext matchAndExecute(String cachekey, PromotionOrder order) {
        String key = cachekey == null ? PromotionUtil.generateCacheKey() : cachekey;
        PromotionExecuteContext context = new PromotionExecuteContext();
        context.setOp(PromotionOpEnum.MATCH_AND_EXECUTE);
        context.setOrder(order);
        context.setCachekey(key);
        new PromotionExecutor().execute(context);
        DPMAppCache.putContextIntoCache(context);
        return context;
    }

    public static PromotionExecuteContext match(String cachekey, PromotionOrder order) {
        String key = cachekey == null ? PromotionUtil.generateCacheKey() : cachekey;
        PromotionExecuteContext context = new PromotionExecuteContext();
        context.setOp(PromotionOpEnum.MATCH);
        context.setOrder(order);
        context.setCachekey(key);
        new PromotionExecutor().execute(context);
        DPMAppCache.putContextIntoCache(context);
        return context;
    }

    public static PromotionUsableContext matchPolicys(PromotionOrder order) {
        PromotionUsableContext context = new PromotionUsableContext();
        context.setOrder(order);
        new MatchUsablePromotionProcessor().usablePromotionProcessor(context);
        return context;
    }

    public static Set<UsablePromotionResult> matchAndExecutePromotion(String cachekey, Object ownerid, Object customerid, boolean islimit, String ... sourceformkey) {
        PromotionAvailableContext context = new PromotionAvailableContext();
        context.setOwnerid(ownerid);
        context.setCustomerid(customerid);
        context.setOp(PromotionOpEnum.MATCH_AND_EXECUTE);
        context.setIslimit(islimit);
        if (sourceformkey.length == 0) {
            context.setSourceFromKey("");
        } else {
            context.setSourceFromKey(sourceformkey[0]);
        }
        new PromotionExecutor().execute(context);
        Set<UsablePromotionResult> retults = PromotionUtil.getPromotionAvailableResult(context);
        DPMAppCache.putPromotionContextIntoCache(cachekey, retults);
        return retults;
    }

    public static Set<UsablePromotionResult> matchPromotion(String cachekey, Object ownerid, Object customerid, boolean islimit, String ... sourceformkey) {
        PromotionAvailableContext context = new PromotionAvailableContext();
        context.setOwnerid(ownerid);
        context.setCustomerid(customerid);
        context.setOp(PromotionOpEnum.MATCH);
        context.setIslimit(islimit);
        if (sourceformkey.length == 0) {
            context.setSourceFromKey("");
        } else {
            context.setSourceFromKey(sourceformkey[0]);
        }
        new PromotionExecutor().execute(context);
        Set<UsablePromotionResult> retults = PromotionUtil.getPromotionAvailableResult(context);
        DPMAppCache.putPromotionContextIntoCache(cachekey, retults);
        return retults;
    }

    public static Set<UsablePromotionResult> loadPromotionAvailableContextFromCache(String cachekey) {
        return DPMAppCache.getPromotionContextIntoCache(cachekey);
    }

    public static void removePromotionContextFromCache(String cachekey) {
        DPMAppCache.removePromotionContextFromCache(cachekey);
    }

    public static PromotionExecuteContext execute(String cachekey, PromotionOrder order) {
        log.info("\u6e20\u9053\u4e91\uff1acachekey\uff1a" + cachekey + "\norder:" + order);
        Objects.requireNonNull(cachekey);
        PromotionExecuteContext context = DPMAppCache.getContextFromCache(cachekey);
        context = new PromotionExecuteContext();
        context.setOp(PromotionOpEnum.MATCH_AND_EXECUTE);
        context.setOrder(order);
        context.setCachekey(cachekey);
        new PromotionExecutor().execute(context);
        DPMAppCache.putContextIntoCache(context);
        return context;
    }

    public static void putContextIntoCache(String cachekey, Set<AddPresentExecution> executions) {
        Objects.requireNonNull(cachekey);
        PromotionExecuteContext context = DPMAppCache.getContextFromCache(cachekey);
        if (context == null) {
            return;
        }
        HashMap<Object, ArrayList<AddPresentExecution>> lists = new HashMap<Object, ArrayList<AddPresentExecution>>();
        for (AddPresentExecution addPresentExecution : executions) {
            Object policyid = addPresentExecution.getPolicyid();
            ArrayList<AddPresentExecution> aExecutions = (ArrayList<AddPresentExecution>)lists.get(policyid);
            if (aExecutions == null) {
                aExecutions = new ArrayList<AddPresentExecution>();
                lists.put(policyid, aExecutions);
            }
            aExecutions.add(addPresentExecution);
        }
        Collection<ReplaceablePromotionExecution> rpes = context.getExecutions();
        for (Map.Entry entry : lists.entrySet()) {
            for (ReplaceablePromotionExecution replaceablePromotionExecution : rpes) {
                if (!replaceablePromotionExecution.getPromotionid().equals(entry.getKey())) continue;
                PromotionExecutionUnit u = new PromotionExecutionUnit();
                u.setIsused(true);
                u.setGroupnumber(Character.valueOf('A'));
                u.add((List)entry.getValue());
                replaceablePromotionExecution.add(u);
            }
        }
        DPMAppCache.putContextIntoCache(context);
    }

    public static PromotionExecuteContext switchExecutions(String cachekey, PromotionOrder order, Object promotionid, char groupnumber) {
        Objects.requireNonNull(cachekey);
        PromotionExecuteContext context = DPMAppCache.getContextFromCache(cachekey);
        Promotion promotion = Promotion.getPromotion(promotionid);
        context.setOp(PromotionOpEnum.SWITCH_EXECUTION);
        context.setOrder(order);
        context.setExecutelevel(promotion.getPriority() + 1);
        context.changeUnitUsed(promotion, groupnumber);
        new PromotionExecutor().execute(context);
        DPMAppCache.putContextIntoCache(context);
        return context;
    }

    public static Set<Object> getPromotionResultFromOrders(Set<Object> orderids) {
        HashSet<Object> ids = new HashSet<Object>();
        QFilter qFilter = new QFilter("order", "in", orderids);
        qFilter.and(new QFilter("entryentity.type", "=", (Object)"addpresentbag"));
        try (DataSet set = ORM.create().queryDataSet(PromotionUtil.class.getName(), "dpm_execution", "order.id id", qFilter.toArray());){
            for (Row row : set) {
                ids.add(row.get("id"));
            }
        }
        return ids;
    }

    public static PromotionExecuteContext loadPromotionContextFromDB(Object orderid) {
        String cachekey = PromotionUtil.generateCacheKey();
        PromotionExecuteContext context = new PromotionExecuteContext();
        context.setCachekey(cachekey);
        DynamicObjectCollection policycol = QueryServiceHelper.query((String)"dpm_order_relation", (String)"policy.id,policy.priority", (QFilter[])new QFilter[]{new QFilter("order", "=", orderid)}, (String)"policy.priority,policy.isexclusive desc");
        DynamicObject[] executionunits = BusinessDataServiceHelper.load((String)"dpm_execution", (String)"policy.id,policy.priority,order,isused,groupnumber,entryentity.resultid,entryentity.type,entryentity.entryid,entryentity.item,entryentity.resultname,entryentity.combination,entryentity.unit,entryentity.attr,entryentity.qty,entryentity.pricediff,entryentity.amountdiff,entryentity.sourceentryids,entryentity.multiple", (QFilter[])new QFilter[]{new QFilter("order", "=", orderid)});
        for (DynamicObject policy : policycol) {
            Object policyid = policy.get("policy.id");
            Promotion promotion = Promotion.getPromotion(policy.get("policy.id"));
            ReplaceablePromotionExecution rpe = null;
            for (DynamicObject executionunit : executionunits) {
                if (rpe == null) {
                    rpe = new ReplaceablePromotionExecution(policyid);
                }
                if (!policyid.equals(executionunit.get("policy.id"))) continue;
                PromotionExecutionUnit unit = PromotionExecutionFactory.loadUnit(executionunit);
                rpe.add(unit);
            }
            context.put(promotion, rpe);
        }
        DPMAppCache.putContextIntoCache(context);
        return context;
    }

    public static void savePromotionContext(String cachekey, Object orderid) {
        PromotionExecuteContext ctx = PromotionUtil.loadPromotionContextFromCache(cachekey);
        PromotionUtil.deletePromotionContext(orderid);
        PromotionUtil.savePolicys(orderid, ctx.getPromotions());
        PromotionUtil.saveExecutions(orderid, ctx.getExecutions());
    }

    public static Set<OperateErrorInfo> CreateLimitBill(Object ... promotionids) {
        Object dynamicObject;
        HashSet<OperateErrorInfo> operateErrorInfos = null;
        if (promotionids == null || promotionids.length == 0) {
            return operateErrorInfos;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)promotionids);
        qFilter.and(new QFilter("limitcontent.id", ">", (Object)0L));
        String strFields = "id,name,owner,starttime,endtime,customerrange,limitcontent";
        DynamicObject[] promotions = BusinessDataServiceHelper.load((String)"dpm_policy", (String)strFields, (QFilter[])qFilter.toArray());
        int size = promotions.length;
        DynamicObject[] limits = new DynamicObject[size];
        operateErrorInfos = new HashSet<OperateErrorInfo>(size);
        DynamicObject limit = null;
        int length = promotions.length;
        HashMap<Object, Long> limitids = new HashMap<Object, Long>(length);
        long[] limitPkIds = DBServiceHelper.genLongIds((String)"T_DPM_LIMITCONTENT", (int)length);
        Long limitid = null;
        for (int i = 0; i < length; ++i) {
            dynamicObject = promotions[i];
            limit = BusinessDataServiceHelper.newDynamicObject((String)"dpm_limit");
            String number = CodeRuleServiceHelper.getNumber((String)"dpm_limit", (DynamicObject)limit, null);
            limitid = limitPkIds[i];
            limitids.put(dynamicObject.getDynamicObject("limitcontent").getPkValue(), limitid);
            limit.set("id", (Object)limitid);
            limit.set("number", (Object)number);
            PromotionUtil.setLimitInfo(limit, (DynamicObject)dynamicObject);
            limits[i] = limit;
        }
        TXHandle h = TX.requiresNew();
        dynamicObject = null;
        try {
            try {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>(limitids.size());
                String updatesql = "UPDATE T_DPM_LIMITCONTENT SET FLIMITID = ?  WHERE FID = ? ";
                for (Map.Entry entryinfo : limitids.entrySet()) {
                    ArrayList<Object> dataValueList = new ArrayList<Object>(2);
                    dataValueList.add(entryinfo.getValue());
                    dataValueList.add(entryinfo.getKey());
                    paramsList.add(dataValueList.toArray());
                }
                DB.executeBatch((DBRoute)new DBRoute("mdr"), (String)updatesql, paramsList);
            }
            catch (Throwable e) {
                h.markRollback();
                log.info("drp_CreateLimitBill\uff1a" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            dynamicObject = throwable;
            throw throwable;
        }
        finally {
            if (h != null) {
                if (dynamicObject != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)dynamicObject).addSuppressed(throwable);
                    }
                } else {
                    h.close();
                }
            }
        }
        OperationResult operation = OperationServiceHelper.executeOperate((String)"save", (String)"dpm_limit", (DynamicObject[])limits, (OperateOption)OperateOption.create());
        List listSuccessids = operation.getSuccessPkIds();
        if (!operation.isSuccess()) {
            PromotionUtil.setOperateErrorInfos(operation, operateErrorInfos, "save");
        }
        if (listSuccessids.size() == 0) {
            return operateErrorInfos;
        }
        operation = OperationServiceHelper.executeOperate((String)"submit", (String)"dpm_limit", (Object[])listSuccessids.toArray(), (OperateOption)OperateOption.create());
        listSuccessids = operation.getSuccessPkIds();
        if (!operation.isSuccess()) {
            PromotionUtil.setOperateErrorInfos(operation, operateErrorInfos, "submit");
        }
        if (listSuccessids.size() == 0) {
            return operateErrorInfos;
        }
        operation = OperationServiceHelper.executeOperate((String)"audit", (String)"dpm_limit", (Object[])listSuccessids.toArray(), (OperateOption)OperateOption.create());
        listSuccessids = operation.getSuccessPkIds();
        if (!operation.isSuccess()) {
            PromotionUtil.setOperateErrorInfos(operation, operateErrorInfos, "audit");
        }
        return operateErrorInfos;
    }

    public static Set<Object> getPromotionByLimit(Object ... promotionids) {
        HashSet<Object> limitpolicyids = null;
        if (promotionids == null || promotionids.length == 0) {
            return limitpolicyids;
        }
        limitpolicyids = new HashSet<Object>(promotionids.length);
        QFilter qFilter = new QFilter("policy.promotionpolicy.id", "in", (Object)promotionids);
        try (DataSet set = ORM.create().queryDataSet("", "dpm_limit", "policy.promotionpolicy.id promotionid", qFilter.toArray());){
            for (Row row : set) {
                limitpolicyids.add(row.get("promotionid"));
            }
        }
        return limitpolicyids;
    }

    private static void savePolicys(Object orderid, Set<Promotion> policyset) {
        if (policyset.isEmpty()) {
            return;
        }
        LinkedList<DynamicObject> objlist = new LinkedList<DynamicObject>();
        for (Promotion promotion : policyset) {
            DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"dpm_order_relation");
            relation.set("order", orderid);
            relation.set("policy", promotion.getId());
            objlist.add(relation);
        }
        SaveServiceHelper.save((DynamicObject[])objlist.toArray(new DynamicObject[objlist.size()]));
    }

    private static void saveExecutions(Object orderid, Collection<ReplaceablePromotionExecution> executionset) {
        if (executionset.isEmpty()) {
            return;
        }
        LinkedList<DynamicObject> objlist = new LinkedList<DynamicObject>();
        for (ReplaceablePromotionExecution rpe : executionset) {
            List<DynamicObject> executions = rpe.createExecution();
            executions.forEach(k -> k.set("order", orderid));
            objlist.addAll(executions);
        }
        SaveServiceHelper.save((DynamicObject[])objlist.toArray(new DynamicObject[objlist.size()]));
    }

    public static void deletePromotionContext(Set<Object> orderids) {
        if (orderids.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"dpm_order_relation", (QFilter[])new QFilter[]{new QFilter("order", "in", orderids)});
        DeleteServiceHelper.delete((String)"dpm_execution", (QFilter[])new QFilter[]{new QFilter("order", "in", orderids)});
    }

    public static void deletePromotionExecution(Object orderid, Set<Object> promotionpolicyids) {
        if (promotionpolicyids.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("order", "=", orderid);
        qFilter.and(new QFilter("policy", "in", promotionpolicyids));
        DeleteServiceHelper.delete((String)"dpm_order_relation", (QFilter[])qFilter.toArray());
        DeleteServiceHelper.delete((String)"dpm_execution", (QFilter[])qFilter.toArray());
    }

    public static void deletePromotionContext(Object orderid) {
        DeleteServiceHelper.delete((String)"dpm_order_relation", (QFilter[])new QFilter[]{new QFilter("order", "=", orderid)});
        DeleteServiceHelper.delete((String)"dpm_execution", (QFilter[])new QFilter[]{new QFilter("order", "=", orderid)});
    }

    public static void removePromotionCache(String cachekey) {
        DPMAppCache.removeContextFromCache(cachekey);
    }

    public static void removeContextFromPolicy(String cachekey, Set<Object> policyids) {
        DPMAppCache.removeContextFromPolicy(cachekey, policyids);
    }

    public static PromotionExecuteContext loadPromotionContextFromCache(String cachekey) {
        return DPMAppCache.getContextFromCache(cachekey);
    }

    public static ExecutionInCache getExecutionInCache(String pageid, Object executionid) {
        return DPMAppCache.getExecutionFromCache(pageid, executionid);
    }

    private static String generateCacheKey() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static Set<UsablePromotionResult> getPromotionAvailableResult(PromotionAvailableContext context) {
        HashSet<UsablePromotionResult> promotionInfos = null;
        if (context != null) {
            Set<Promotion> promotions = context.getPromotions();
            promotionInfos = new HashSet<UsablePromotionResult>(promotions.size());
            UsablePromotionResult usablePromotionResult = null;
            for (Promotion promotion : promotions) {
                usablePromotionResult = new UsablePromotionResult();
                usablePromotionResult.setId(promotion.getId());
                usablePromotionResult.setNumber(promotion.getNumber());
                usablePromotionResult.setName(promotion.getName());
                usablePromotionResult.setPriority(promotion.getPriority());
                usablePromotionResult.setStarttime(promotion.getstarttime());
                usablePromotionResult.setEndtime(promotion.getendtime());
                usablePromotionResult.setLeftLimitqty(promotion.getLeftLimitqty());
                usablePromotionResult.setItemRanges(context.get(promotion));
                promotionInfos.add(usablePromotionResult);
            }
        }
        return promotionInfos;
    }

    private static void setLimitInfo(DynamicObject limit, DynamicObject policy) {
        limit.set("createtime", (Object)TimeServiceHelper.now());
        limit.set("creator", UserUtil.getUserID());
        limit.set("enable", (Object)"1");
        limit.set("limittype", (Object)"qty");
        limit.set("modifier", UserUtil.getUserID());
        limit.set("modifytime", (Object)TimeServiceHelper.now());
        limit.set("name", (Object)String.format("%s\u9650\u91cf", policy.getString("name")));
        limit.set("owner", policy.get("owner"));
        limit.set("starttime", (Object)policy.getDate("starttime"));
        limit.set("endtime", (Object)policy.getDate("endtime"));
        limit.set("status", (Object)"A");
        limit.set("isactonpolicy", (Object)Boolean.TRUE);
        limit.set("customerrangeid", policy.getDynamicObject("customerrange").getPkValue());
        DynamicObjectCollection policys = limit.getDynamicObjectCollection("policy");
        policys.beginInit();
        policys.addNew();
        ((DynamicObject)policys.get(0)).set("Seq", (Object)1);
        ((DynamicObject)policys.get(0)).set("promotionpolicy", policy.getPkValue());
        policys.endInit();
        DynamicObjectCollection qtylimititems = limit.getDynamicObjectCollection("qtylimititems");
        DynamicObject limitcontent = policy.getDynamicObject("limitcontent");
        DynamicObjectCollection itemEntrys = limitcontent.getDynamicObjectCollection("entryentity");
        qtylimititems.beginInit();
        UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
        for (int j = 0; j < itemEntrys.size(); ++j) {
            DynamicObject dynamicObject = (DynamicObject)itemEntrys.get(j);
            qtylimititems.addNew();
            DynamicObject item = dynamicObject.getDynamicObject("item");
            DynamicObject baseunit = dynamicObject.getDynamicObject("baseunit");
            ((DynamicObject)qtylimititems.get(j)).set("Seq", (Object)(j + 1));
            ((DynamicObject)qtylimititems.get(j)).set("item", item.getPkValue());
            DynamicObject unit = dynamicObject.getDynamicObject("unit");
            ((DynamicObject)qtylimititems.get(j)).set("baseunit", (Object)baseunit);
            ((DynamicObject)qtylimititems.get(j)).set("unit", (Object)unit);
            ((DynamicObject)qtylimititems.get(j)).set("attr", dynamicObject.get("attr"));
            BigDecimal limitqty = dynamicObject.getBigDecimal("limitqty");
            ((DynamicObject)qtylimititems.get(j)).set("limitqty", (Object)limitqty);
            ((DynamicObject)qtylimititems.get(j)).set("leftlimitqty", (Object)limitqty);
            BigDecimal limitBaseQty = BigDecimal.ZERO;
            limitBaseQty = unit == null || baseunit.getPkValue().equals(unit.getPkValue()) ? limitqty : unitBatchHandler.getBaseQty(item.get("id"), limitqty, unit.getPkValue());
            ((DynamicObject)qtylimititems.get(j)).set("limitbaseqty", (Object)limitBaseQty);
            ((DynamicObject)qtylimititems.get(j)).set("leftlimitbaseqty", (Object)limitBaseQty);
        }
        qtylimititems.endInit();
    }

    private static void setOperateErrorInfos(OperationResult operation, Set<OperateErrorInfo> operateErrorInfos, String operationKey) {
        String str = "";
        switch (operationKey) {
            case "save": {
                str = "\u4fdd\u5b58\u4fc3\u9500\u9650\u91cf";
                break;
            }
            case "submit": {
                str = "\u63d0\u4ea4\u4fc3\u9500\u9650\u91cf";
                break;
            }
            case "audit": {
                str = "\u5ba1\u6838\u4fc3\u9500\u9650\u91cf";
                break;
            }
        }
        List validateresults = operation.getValidateResult().getValidateErrors();
        if (validateresults.size() > 0) {
            for (ValidateResult validateresult : validateresults) {
                for (OperateErrorInfo operateErrorInfo : validateresult.getAllErrorInfo()) {
                    operateErrorInfos.add((OperateErrorInfo)new ValidationErrorInfo("", (Object)0, 0, 0, "500", "", String.format("%s\uff1a%s", str, operateErrorInfo.getMessage()), ErrorLevel.Error));
                }
            }
        } else {
            operateErrorInfos.add((OperateErrorInfo)new ValidationErrorInfo("", (Object)0, 0, 0, "500", "", String.format("%s\uff1a%s", str, operation.getMessage()), ErrorLevel.Error));
        }
    }
}

