/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.util.StringUtils;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.execution.AbstractExecution;
import kd.drp.dpm.common.model.execution.ExecutionInCache;
import kd.drp.dpm.common.model.execution.PromotionExecutionFactory;
import kd.drp.dpm.common.model.execution.PromotionExecutionUnit;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.UsablePromotionResult;

public class DPMAppCache {
    private static IAppCache proCache = AppCache.get((String)"dpm");
    private static final String POLICY4CONTEXT = "policy4context";
    private static final String EXECUTION4CONTEXT = "execution4context";
    private static final String PROMOTION4CONTEXT = "promotion4context";

    public static void putIntoCache(String key, Object obj) {
        proCache.put(key, obj);
    }

    public static <T> T getFromCache(String key, Class<T> c) {
        return (T)proCache.get(key, c);
    }

    public static void removeFromCache(String key) {
        proCache.remove(key);
    }

    public static void putContextIntoCache(PromotionExecuteContext context) {
        Set<Promotion> promotions = context.getPromotions();
        String cacheKey = context.getCachekey();
        if (promotions.isEmpty()) {
            proCache.remove(POLICY4CONTEXT + cacheKey);
            return;
        }
        HashSet<Object> policyids = new HashSet<Object>(promotions.size());
        for (Promotion promotion : promotions) {
            policyids.add(promotion.getId());
        }
        proCache.put(POLICY4CONTEXT + cacheKey, policyids);
        Collection<ReplaceablePromotionExecution> rpes = context.getExecutions();
        if (rpes.isEmpty()) {
            proCache.remove(EXECUTION4CONTEXT + cacheKey);
            return;
        }
        ArrayList<ExecutionInCache> cacheobjlist = new ArrayList<ExecutionInCache>(16);
        for (ReplaceablePromotionExecution rpe : rpes) {
            if (rpe == null) continue;
            Map<Character, PromotionExecutionUnit> unitmap = rpe.getUnitmap();
            for (Map.Entry<Character, PromotionExecutionUnit> entry : unitmap.entrySet()) {
                PromotionExecutionUnit unit = entry.getValue();
                for (AbstractExecution execution : unit.getExecutionlist()) {
                    ExecutionInCache cacheobj = new ExecutionInCache();
                    cacheobj.setId(unit.getId());
                    cacheobj.setPolicyid(rpe.getPromotionid());
                    cacheobj.setIsused(unit.isUsed());
                    cacheobj.setGroupnumber(unit.getGroupnumber().charValue());
                    execution.handleCache(cacheobj);
                    cacheobjlist.add(cacheobj);
                }
            }
        }
        proCache.put(EXECUTION4CONTEXT + cacheKey, (Object)SerializationUtils.toJsonString(cacheobjlist));
    }

    public static PromotionExecuteContext getContextFromCache(String cacheKey) {
        PromotionExecuteContext context = new PromotionExecuteContext();
        context.setCachekey(cacheKey);
        List policyidlist = (List)proCache.get(POLICY4CONTEXT + cacheKey, List.class);
        if (policyidlist == null) {
            return context;
        }
        String jsonarraystr = (String)proCache.get(EXECUTION4CONTEXT + cacheKey, String.class);
        List list = new ArrayList();
        if (jsonarraystr != null) {
            list = SerializationUtils.fromJsonStringToList((String)jsonarraystr, ExecutionInCache.class);
        }
        for (Object id : policyidlist) {
            Promotion promotion = Promotion.getPromotion(id);
            ReplaceablePromotionExecution rpe = null;
            for (ExecutionInCache executionunit : list) {
                PromotionExecutionUnit unit;
                if (!id.equals(executionunit.getPolicyid())) continue;
                AbstractExecution execution = PromotionExecutionFactory.loadPromotionExecutionFromCache(executionunit);
                Character groupnumber = Character.valueOf(executionunit.getGroupnumber());
                if (rpe == null) {
                    rpe = new ReplaceablePromotionExecution(id);
                }
                if ((unit = rpe.get(groupnumber)) == null) {
                    unit = new PromotionExecutionUnit();
                    unit.setId(executionunit.getId());
                    unit.setGroupnumber(groupnumber);
                    unit.setIsused(executionunit.isIsused());
                }
                unit.add(execution);
                rpe.add(unit);
            }
            context.put(promotion, rpe);
        }
        return context;
    }

    public static List<ExecutionInCache> getExecutionsFromCache(String cacheKey) {
        String jsonarraystr = (String)proCache.get(EXECUTION4CONTEXT + cacheKey, String.class);
        if (jsonarraystr == null) {
            return null;
        }
        return SerializationUtils.fromJsonStringToList((String)jsonarraystr, ExecutionInCache.class);
    }

    public static ExecutionInCache getExecutionFromCache(String cacheKey, Object executionid) {
        List<ExecutionInCache> list = DPMAppCache.getExecutionsFromCache(cacheKey);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ExecutionInCache execution : list) {
            if (!executionid.equals(execution.getId())) continue;
            return execution;
        }
        return null;
    }

    public static void removeContextFromCache(String cacheKey) {
        proCache.remove(EXECUTION4CONTEXT + cacheKey);
        proCache.remove(POLICY4CONTEXT + cacheKey);
    }

    public static void removeContextFromPolicy(String cacheKey, Set<Object> policyids) {
        if (cacheKey.isEmpty() || policyids == null || policyids.isEmpty()) {
            return;
        }
        String key = String.format("%s%s", POLICY4CONTEXT, cacheKey);
        List policyidlist = (List)proCache.get(key, List.class);
        if (policyidlist == null) {
            return;
        }
        policyidlist.removeAll(policyids);
        proCache.remove(key);
        if (policyidlist.size() > 0) {
            proCache.put(key, (Object)policyidlist);
        }
        key = String.format("%s%s", EXECUTION4CONTEXT, cacheKey);
        String jsonarraystr = (String)proCache.get(key, String.class);
        List list = new ArrayList();
        if (jsonarraystr != null) {
            list = SerializationUtils.fromJsonStringToList((String)jsonarraystr, ExecutionInCache.class);
        }
        ArrayList<ExecutionInCache> deleList = new ArrayList<ExecutionInCache>();
        for (Object id : policyids) {
            for (ExecutionInCache executionunit : list) {
                if (!id.equals(executionunit.getPolicyid())) continue;
                deleList.add(executionunit);
            }
        }
        if (deleList.size() > 0) {
            list.removeAll(deleList);
        }
        proCache.remove(key);
        if (list.size() > 0) {
            proCache.put(key, (Object)SerializationUtils.toJsonString(list));
        }
    }

    public static void putPromotionContextIntoCache(String cachekey, Set<UsablePromotionResult> retults) {
        if (StringUtils.isEmpty((String)cachekey)) {
            return;
        }
        String key = String.format("%s_%s", PROMOTION4CONTEXT, cachekey);
        if (retults.isEmpty()) {
            proCache.remove(key);
            return;
        }
        proCache.put(key, (Object)SerializationUtils.toJsonString(retults));
    }

    public static Set<UsablePromotionResult> getPromotionContextIntoCache(String cachekey) {
        HashSet<UsablePromotionResult> retults = new HashSet<UsablePromotionResult>();
        if (StringUtils.isEmpty((String)cachekey)) {
            return retults;
        }
        String key = String.format("%s_%s", PROMOTION4CONTEXT, cachekey);
        String jsonarraystr = (String)proCache.get(key, String.class);
        if (jsonarraystr != null) {
            List aList = SerializationUtils.fromJsonStringToList((String)jsonarraystr, UsablePromotionResult.class);
            UsablePromotionResult usablePromotionResult = null;
            UsablePromotionResult usablePromotion = null;
            HashSet<DetailItemInfo> detailItemInfos = null;
            for (Object object : aList) {
                usablePromotionResult = new UsablePromotionResult();
                usablePromotion = (UsablePromotionResult)object;
                detailItemInfos = new HashSet<DetailItemInfo>();
                usablePromotionResult.setId(usablePromotion.getId());
                usablePromotionResult.setNumber(usablePromotion.getNumber());
                usablePromotionResult.setName(usablePromotion.getName());
                usablePromotionResult.setPriority(usablePromotion.getPriority());
                usablePromotionResult.setStarttime(usablePromotion.getstarttime());
                usablePromotionResult.setEndtime(usablePromotion.getendtime());
                usablePromotionResult.setLeftLimitqty(usablePromotion.getLeftLimitqty());
                if (usablePromotion.getItemRanges() != null) {
                    for (DetailItemInfo detailItemInfo : usablePromotion.getItemRanges()) {
                        DetailItemInfo detailItemInfo1 = new DetailItemInfo(detailItemInfo.getItemid(), detailItemInfo.getUnitid(), (Object)Long.valueOf(String.valueOf(detailItemInfo.getAttrid())));
                        detailItemInfos.add(detailItemInfo1);
                    }
                }
                usablePromotionResult.setItemRanges(detailItemInfos);
                retults.add(usablePromotionResult);
            }
        }
        return retults;
    }

    public static void removePromotionContextFromCache(String cacheKey) {
        if (!StringUtils.isEmpty((String)cacheKey)) {
            proCache.remove(PROMOTION4CONTEXT + cacheKey);
        }
    }
}

