/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDBizException;
import kd.drp.dpm.common.chain.PromotionOpEnum;
import kd.drp.dpm.common.chain.processor.IProcessor;
import kd.drp.dpm.common.chain.processor.IPromotionProcessor;

public class PromotionChainBuilder {
    public static List<IProcessor> getChains(PromotionOpEnum op) {
        String matchType = "";
        if (op == PromotionOpEnum.MATCH) {
            matchType = "MATCH_CHAIN";
        } else if (op == PromotionOpEnum.MATCH_AND_EXECUTE) {
            matchType = "MATCH_AND_EXECUTE_CHAIN";
        } else if (op == PromotionOpEnum.SWITCH_EXECUTION) {
            matchType = "EXECUTE_CHAIN";
        } else if (op == PromotionOpEnum.EXECUTE) {
            matchType = "EXECUTE_CHAIN";
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728key\u503c\u4e3a", (String)"PromotionChainBuilder_0", (String)"drp-dpm-common", (Object[])new Object[0]) + (Object)((Object)op) + ResManager.loadKDString((String)"\u7684\u4fc3\u9500\u6267\u884c\u94fe", (String)"PromotionChainBuilder_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        String sql = "SELECT FID,FMATCHTYPE,FMATCHCHAIN,FENABLE,FSEQ FROM T_DPM_PROMOTIONCHAIN WHERE FMATCHTYPE=? ORDER BY FSEQ";
        Object[] params = new SqlParameter[]{new SqlParameter(":matchType", -9, (Object)matchType)};
        List processorclass = (List)DB.query((DBRoute)new DBRoute("mdr"), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> processorclass = new ArrayList<String>(16);
                while (rs.next()) {
                    processorclass.add(rs.getString("FMATCHCHAIN"));
                }
                return processorclass;
            }
        });
        ArrayList<IProcessor> processors = new ArrayList<IProcessor>(processorclass.size());
        for (String classname : processorclass) {
            IProcessor processor = null;
            try {
                processor = (IProcessor)Class.forName(classname).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fc3\u9500\u5904\u7406\u5668", (String)"PromotionChainBuilder_2", (String)"drp-dpm-common", (Object[])new Object[0]) + classname + ResManager.loadKDString((String)"\u5931\u8d25", (String)"PromotionChainBuilder_3", (String)"drp-dpm-common", (Object[])new Object[0]));
            }
            processors.add(processor);
        }
        return processors;
    }

    public static List<IPromotionProcessor> getPromotionChains(PromotionOpEnum op) {
        ArrayList<String> processorclass = null;
        if (op == PromotionOpEnum.MATCH) {
            processorclass = new ArrayList<String>(1);
            processorclass.add("kd.drp.dpm.common.chain.processor.MatchAvailablePromotionProcessor");
        } else if (op == PromotionOpEnum.MATCH_AND_EXECUTE) {
            processorclass = new ArrayList(2);
            processorclass.add("kd.drp.dpm.common.chain.processor.MatchAvailablePromotionProcessor");
            processorclass.add("kd.drp.dpm.common.chain.processor.ExecuteAvailablePromotionProcessor");
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728key\u503c\u4e3a", (String)"PromotionChainBuilder_0", (String)"drp-dpm-common", (Object[])new Object[0]) + (Object)((Object)op) + ResManager.loadKDString((String)"\u7684\u4fc3\u9500\u6267\u884c\u94fe", (String)"PromotionChainBuilder_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        ArrayList<IPromotionProcessor> processors = new ArrayList<IPromotionProcessor>(processorclass.size());
        for (String classname : processorclass) {
            IPromotionProcessor processor = null;
            try {
                processor = (IPromotionProcessor)Class.forName(classname).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4fc3\u9500\u5904\u7406\u5668", (String)"PromotionChainBuilder_2", (String)"drp-dpm-common", (Object[])new Object[0]) + classname + ResManager.loadKDString((String)"\u5931\u8d25", (String)"PromotionChainBuilder_3", (String)"drp-dpm-common", (Object[])new Object[0]));
            }
            processors.add(processor);
        }
        return processors;
    }
}

