/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain.processor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.drp.dpm.common.chain.processor.IPromotionProcessor;
import kd.drp.dpm.common.execute.PromotionAvailableContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.condition.IPromotionCondition;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;

public class ExecuteAvailablePromotionProcessor
implements IPromotionProcessor {
    @Override
    public void process(PromotionAvailableContext ctx) {
        Set<Promotion> promotionset = ctx.getPromotions();
        if (promotionset.isEmpty()) {
            return;
        }
        Set<DetailItemInfo> rangedetails = null;
        for (Promotion promotion : promotionset) {
            rangedetails = this.getPromotionItemRange(promotion);
            if (rangedetails == null) continue;
            ctx.put(promotion, rangedetails);
        }
    }

    private Set<DetailItemInfo> getPromotionItemRange(Promotion promotion) {
        Set<DetailItemInfo> rangedetails = null;
        if (promotion.unitsize() == 0) {
            return rangedetails;
        }
        String conditionexp = promotion.getConditionExp(0);
        if (conditionexp == null || conditionexp.trim().isEmpty()) {
            return rangedetails;
        }
        if (!conditionexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) {
            return rangedetails;
        }
        char[] chars = conditionexp.toCharArray();
        int i = 0;
        int startindex = 0;
        String beforeConnector = null;
        int length = chars.length;
        IPromotionCondition condition = null;
        String[] ids = conditionexp.split("AND|OR");
        HashSet conditionids = new HashSet(ids.length);
        Collections.addAll(conditionids, ids);
        String conditionid = "";
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isDigit(c) && ++i < length) continue;
            if (i == length) {
                ++i;
            }
            if (conditionids.contains(conditionid = conditionexp.substring(startindex, i - 1))) {
                condition = Promotion.getCondition(conditionid);
                if (rangedetails == null) {
                    rangedetails = condition.getPromotionItemRange();
                } else {
                    if ("AND".equals(beforeConnector)) {
                        // empty if block
                    }
                    if ("OR".equals(beforeConnector)) {
                        // empty if block
                    }
                }
            }
            if (c == 'A') {
                beforeConnector = "AND";
                startindex = i += 2;
            }
            if (c != 'O') continue;
            beforeConnector = "OR";
            startindex = ++i;
        }
        return rangedetails;
    }
}

