/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain.processor;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.drp.dpm.common.PromotionOrderDivideUtil;
import kd.drp.dpm.common.chain.processor.IProcessor;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.condition.IPromotionCondition;
import kd.drp.dpm.common.model.execution.AbstractExecution;
import kd.drp.dpm.common.model.execution.PromotionExecutionUnit;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.dpm.common.model.result.IPromotionResult;
import kd.drp.dpm.common.model.result.impl.RebatePromotionResult;
import kd.drp.dpm.common.model.result.impl.ReductionsPromotionResult;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class ExecutePromotionProcessor
implements IProcessor {
    @Override
    public void process(PromotionExecuteContext ctx) {
        int executelevel = ctx.getExecutelevel();
        Set<Promotion> promotionset = ctx.getPromotions();
        if (promotionset.isEmpty()) {
            return;
        }
        PromotionOrder order = ctx.getOrder();
        int size = order.getEntries().size();
        int currentlevel = ctx.getFirstPority();
        ArrayList<String> entryids = new ArrayList<String>();
        for (Promotion promotion : promotionset) {
            int priority = promotion.getPriority();
            if (priority != currentlevel) {
                this.divideWholeOrderAmountDiff(order);
            }
            if (priority < executelevel) {
                this.putOnOrder(order, ctx.get(promotion));
            } else {
                this.executeAndPutOnOrder(order, promotion, ctx, entryids);
                if (size == entryids.size()) break;
            }
            currentlevel = priority;
        }
        this.divideWholeOrderAmountDiff(order);
        ctx.setOrder(order);
    }

    private void putOnOrder(PromotionOrder order, ReplaceablePromotionExecution rpe) {
        if (rpe != null) {
            rpe.putOnOrder(order);
        }
    }

    private void executeAndPutOnOrder(PromotionOrder order, Promotion promotion, PromotionExecuteContext ctx, List<String> entryids) {
        ReplaceablePromotionExecution rpe = this.executePromotion(order, promotion);
        if (rpe != null) {
            ArrayList<String> copylist = new ArrayList<String>();
            copylist.addAll(entryids);
            ArrayList<String> list = new ArrayList<String>();
            String id = "";
            for (Map.Entry<Character, PromotionExecutionUnit> entry : rpe.getUnitmap().entrySet()) {
                List<AbstractExecution> executionlist = entry.getValue().getExecutionlist();
                for (AbstractExecution abstractExecution : executionlist) {
                    if (abstractExecution.getSourceentryids() == null || abstractExecution.getSourceentryids().isEmpty()) {
                        id = abstractExecution.getEntryid().toString();
                        if (id.isEmpty() || id.compareTo("0") == 0 || list.contains(id)) continue;
                        list.add(id);
                        continue;
                    }
                    for (String entryid : abstractExecution.getSourceentryids().split(",")) {
                        if (list.contains(entryid)) continue;
                        list.add(entryid);
                    }
                }
            }
            copylist.retainAll(list);
            if (copylist.size() == 0) {
                entryids.addAll(list);
                this.putOnOrder(order, rpe);
                ctx.put(promotion, rpe);
            }
        }
    }

    private ReplaceablePromotionExecution executePromotion(PromotionOrder order, Promotion promotion) {
        PromotionOrder copyorder = order.clone();
        this.enablePromotionOrderEntry(copyorder, promotion.isIscombinationsplit());
        for (int i = 0; i < promotion.unitsize(); ++i) {
            if (!this.isMatchPromotion(copyorder, promotion, i)) continue;
            ReplaceablePromotionExecution rpe = this.executeMatchedPromotion(copyorder, promotion, i);
            return rpe;
        }
        return null;
    }

    private void enablePromotionOrderEntry(PromotionOrder order, boolean iscombinationsplit) {
        List entrys = order.getEntries();
        Iterator i = entrys.iterator();
        while (i.hasNext()) {
            PromotionOrderEntry entry = (PromotionOrderEntry)i.next();
            if (entry.isIspresent()) {
                i.remove();
                continue;
            }
            SaleOrderEntryType type = entry.getType();
            if (type.equals((Object)SaleOrderEntryType.COMMON) || type.equals((Object)SaleOrderEntryType.COMBINATION) && !iscombinationsplit || type.equals((Object)SaleOrderEntryType.COMBINATION_SON) && iscombinationsplit) continue;
            i.remove();
        }
    }

    private boolean isMatchPromotion(PromotionOrder order, Promotion promotion, int index) {
        boolean issucess = false;
        String conditionexp = promotion.getConditionExp(index);
        if (conditionexp == null || conditionexp.trim().isEmpty()) {
            issucess = true;
        } else {
            if (!conditionexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u7b26\u5408\u516c\u5f0f\u89c4\u5219", (String)"ExecutePromotionProcessor_0", (String)"drp-dpm-common", (Object[])new Object[0]));
            }
            IPromotionCondition condition = null;
            boolean isMatchCondition = false;
            StringBuilder isMatchStr = new StringBuilder();
            String conditionresut = conditionexp;
            for (String conditionid : conditionexp.split("AND|OR")) {
                condition = Promotion.getCondition(Long.valueOf(conditionid));
                isMatchCondition = condition.isMatch(order);
                isMatchStr = new StringBuilder();
                isMatchStr.append(' ');
                isMatchStr.append(isMatchCondition);
                isMatchStr.append(' ');
                conditionresut = conditionresut.replaceAll(conditionid, isMatchStr.toString());
            }
            issucess = (Boolean)FormulaEngine.execExcelFormula((String)conditionresut);
        }
        return issucess;
    }

    private ReplaceablePromotionExecution executeMatchedPromotion(PromotionOrder order, Promotion promotion, int index) {
        String resultexp = promotion.getResultExp(index);
        if (!resultexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u679c\u8868\u8fbe\u5f0f\u4e0d\u7b26\u5408\u516c\u5f0f\u89c4\u5219", (String)"ExecutePromotionProcessor_1", (String)"drp-dpm-common", (Object[])new Object[0]));
        }
        char[] chars = resultexp.toCharArray();
        int i = 0;
        int startindex = 0;
        String beforeConnector = null;
        ReplaceablePromotionExecution currentRL = new ReplaceablePromotionExecution(promotion.getId());
        PromotionExecutionUnit currentU = null;
        int length = chars.length;
        String conditionexp = promotion.getConditionExp(index);
        String[] conditionids = conditionexp.split("AND|OR");
        List<AbstractExecution> list = null;
        while (i < chars.length) {
            char c = chars[i];
            if (Character.isDigit(c) && ++i < length) continue;
            if (i == length) {
                ++i;
            }
            String resultid = resultexp.substring(startindex, i - 1);
            IPromotionResult result = Promotion.getResult(Long.valueOf(resultid));
            list = conditionids.length > 0 && (result.getClass().equals(RebatePromotionResult.class) || result.getClass().equals(ReductionsPromotionResult.class)) ? result.returnExecution(order, conditionids[0]) : result.returnExecution(order, new Object[0]);
            if (list != null && !list.isEmpty()) {
                PromotionExecutionUnit u;
                if (currentU == null) {
                    u = new PromotionExecutionUnit();
                    u.setIsused(true);
                    u.add(list);
                    currentRL.add(u);
                    currentU = u;
                } else {
                    if ("AND".equals(beforeConnector)) {
                        u = new PromotionExecutionUnit();
                        u.setIsused(true);
                        u.add(list);
                        currentRL.add(u);
                        currentU = u;
                    }
                    if ("OR".equals(beforeConnector)) {
                        u = new PromotionExecutionUnit();
                        u.setIsused(false);
                        u.add(list);
                        currentRL.add(u);
                        currentU = u;
                    }
                }
            }
            if (c == 'A') {
                beforeConnector = "AND";
                startindex = i += 2;
            }
            if (c != 'O') continue;
            beforeConnector = "OR";
            startindex = ++i;
        }
        return currentRL;
    }

    private void clearExecutions(PromotionExecuteContext ctx, int priority) {
        for (Promotion promotion : ctx.getPromotions()) {
            if (promotion.getPriority() < priority) continue;
            ctx.put(promotion, null);
        }
    }

    private void divideWholeOrderAmountDiff(PromotionOrder order) {
        List entrys = order.getEntries();
        ArrayList<PromotionOrderEntry> needdiviededentrys = new ArrayList<PromotionOrderEntry>(entrys.size());
        HashMap<Object, List<PromotionOrderEntry>> nincmap = new HashMap<Object, List<PromotionOrderEntry>>();
        ArrayList<PromotionOrderEntry> presententrys = new ArrayList<PromotionOrderEntry>();
        BigDecimal entrytotalamount = BigDecimal.ZERO;
        for (PromotionOrderEntry entry : entrys) {
            if (entry.isIspresent()) {
                presententrys.add(entry);
                continue;
            }
            if (SaleOrderEntryType.COMBINATION_SON.equals((Object)entry.getType())) {
                Object sourcebillid = entry.getSourceentryid();
                ArrayList<PromotionOrderEntry> nincentrys = (ArrayList<PromotionOrderEntry>)nincmap.get(sourcebillid);
                if (nincentrys == null) {
                    nincentrys = new ArrayList<PromotionOrderEntry>(16);
                    nincentrys.add(entry);
                    nincmap.put(sourcebillid, nincentrys);
                    continue;
                }
                nincentrys.add(entry);
                continue;
            }
            entrytotalamount = entrytotalamount.add(entry.getAmount());
            needdiviededentrys.add(entry);
        }
        BigDecimal orderdiff = order.getTotalamount().subtract(entrytotalamount);
        if (orderdiff.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.divideEntrys(needdiviededentrys, nincmap, entrytotalamount, orderdiff);
        for (Map.Entry entry : nincmap.entrySet()) {
            needdiviededentrys.addAll((Collection)entry.getValue());
        }
        needdiviededentrys.addAll(presententrys);
        order.setEntries(needdiviededentrys);
    }

    private void divideEntrys(List<PromotionOrderEntry> entrys, Map<Object, List<PromotionOrderEntry>> nincmap, BigDecimal oldamount, BigDecimal substractamount) {
        PromotionOrderDivideUtil.sortByAmount(entrys);
        BigDecimal alreadydiff = BigDecimal.ZERO;
        for (int i = 0; i < entrys.size(); ++i) {
            PromotionOrderEntry entry = entrys.get(i);
            BigDecimal entrydiff = null;
            if (i == entrys.size() - 1) {
                entrydiff = substractamount.subtract(alreadydiff);
            } else {
                entrydiff = oldamount.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : substractamount.multiply(entry.getAmount()).divide(oldamount, 2, RoundingMode.HALF_UP);
                alreadydiff = alreadydiff.add(entrydiff);
            }
            if (SaleOrderEntryType.COMBINATION.equals((Object)entry.getType())) {
                Object key = entry.getEntryid();
                List<PromotionOrderEntry> nincentrys = nincmap.get(key);
                PromotionOrderDivideUtil.divideEntrys(nincentrys, entry.getAmount(), entrydiff);
            }
            entry.setAmount(entry.getAmount().add(entrydiff));
        }
    }
}

