/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.drp.dpm.common.CustomerRangeUtil;
import kd.drp.dpm.common.cache.DPMAppCache;
import kd.drp.dpm.common.chain.processor.IPromotionProcessor;
import kd.drp.dpm.common.execute.PromotionAvailableContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.mdr.common.util.SysParamsUtil;

public class MatchAvailablePromotionProcessor
implements IPromotionProcessor {
    private static String QUERY_FIELDS = "id,priority,applicability,isexclusive,customerrange.id,scheduletype,schedulevalues,modifytime";
    protected static Log log = LogFactory.getLog(DPMAppCache.class);

    @Override
    public void process(PromotionAvailableContext ctx) {
        this.matchPolicys(ctx);
    }

    private void matchPolicys(PromotionAvailableContext context) {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        log.info(String.format("\u6e20\u9053\u4e91\uff1aMatchAvailablePromotionProcessor,%s,%s", context.getOwnerid(), context.getCustomerid()));
        ORM orm = ORM.create();
        Date createtime = TimeServiceHelper.now();
        HashSet<Object> promotionids = new HashSet<Object>();
        HashSet<Object> rangeids = new HashSet<Object>();
        HashMap<Object, Object> rangePromotions = new HashMap<Object, Object>();
        ArrayList<Object> sortids = new ArrayList<Object>();
        Object policyid = null;
        String sourceformkey = context.getsetSourceFromKey();
        try (DataSet dataset = orm.queryDataSet(this.getClass().getName(), "dpm_policy", QUERY_FIELDS, this.buildQFilters(context.getOwnerid(), createtime)).orderBy(new String[]{"isexclusive desc", "priority", "modifytime desc"});){
            while (dataset.hasNext()) {
                Object rangeid;
                Row row = dataset.next();
                String applicability = row.getString("applicability");
                if (!sourceformkey.isEmpty() && !applicability.contains(sourceformkey) || (rangeid = row.getLong("customerrange.id")) == null || ((Long)rangeid).equals(0L) || !this.isPolicyInSchedule(row.getString("scheduletype"), row.getString("schedulevalues"), createtime)) continue;
                rangeids.add(rangeid);
                policyid = row.get("id");
                rangePromotions.put(rangeid, policyid);
                sortids.add(policyid);
            }
            Set<Object> ids = CustomerRangeUtil.isCustomerInTheRange(context.getCustomerid(), rangeids);
            HashSet<Object> policyids = new HashSet<Object>();
            if (ids != null && ids.size() > 0) {
                for (Object e : ids) {
                    policyids.add(rangePromotions.get(e));
                }
            } else {
                return;
            }
            Set<Promotion> promotions = Promotion.getPromotions(policyids);
            HashMap<Object, Promotion> hashMap = new HashMap<Object, Promotion>(promotions.size());
            for (Promotion promotion : promotions) {
                hashMap.put(promotion.getId(), promotion);
            }
            for (Promotion promotion : sortids) {
                Promotion promotion2 = (Promotion)hashMap.get(promotion);
                if (promotion2 == null) continue;
                promotionids.add(promotion2.getId());
                context.put(promotion2, null);
            }
        }
        if (context.getIslimit()) {
            Map<Object, BigDecimal> leftlimitqtys = this.queryRegionDataSet(promotionids, createtime);
            BigDecimal leftlimitqty = BigDecimal.ZERO;
            for (Promotion promotion : context.getPromotions()) {
                leftlimitqty = leftlimitqtys.get(promotion.getId());
                if (leftlimitqty == null) continue;
                promotion.setLeftLimitqty(leftlimitqty);
            }
        }
        log.info("\u6e20\u9053\u4e91\uff1aMatchAvailablePromotionProcessor" + context.getPromotions());
    }

    private boolean isPolicyInSchedule(String type, String schedulevalues, Date promotiontime) {
        if (type == null || type.trim().isEmpty() || "day".equals(type)) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(promotiontime);
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        if ("week".equals(type)) {
            return this.isInValues(schedulevalues, dayofweek);
        }
        if ("month".equals(type)) {
            return this.isInValues(schedulevalues, dayofmonth);
        }
        return false;
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private QFilter[] buildQFilters(Object ownerid, Date createtime) {
        QFilter filter = new QFilter("owner", "=", ownerid);
        filter.and(new QFilter("starttime", "<=", (Object)createtime));
        filter.and(new QFilter("endtime", ">=", (Object)createtime));
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        return filter.toArray();
    }

    private Map<Object, BigDecimal> queryRegionDataSet(Set<Object> ids, Date createtime) {
        HashMap<Object, BigDecimal> sumqtyInfo = new HashMap<Object, BigDecimal>();
        ORM orm = ORM.create();
        String str = this.getString(ids);
        Object[] ob = this.getObjectValue(ids, createtime);
        StringBuilder returnsql = new StringBuilder();
        returnsql.append("select policy.promotionpolicy.id as promotionid, sum(qtylimititems.leftlimitqty) as sumqty ");
        returnsql.append("from dpm_limit where status ='C' and enable='1' and policy.promotionpolicy.policystatus ='D' ");
        returnsql.append("and policy.promotionpolicy.id in ");
        returnsql.append(str);
        returnsql.append(" and starttime < ? and endtime > ?  ");
        returnsql.append("group by policy.promotionpolicy.id ");
        try (DataSet set = orm.queryDataSet(this.getClass().getName(), returnsql.toString(), ob);){
            for (Row row : set) {
                sumqtyInfo.put(row.get("promotionid"), row.getBigDecimal("sumqty"));
            }
        }
        return sumqtyInfo;
    }

    private String getString(Set<Object> ids) {
        if (ids.isEmpty()) {
            return "(0)";
        }
        StringBuilder str = new StringBuilder("(");
        for (int i = 0; i < ids.size(); ++i) {
            str.append("?,");
        }
        return str.substring(0, str.length() - 1) + ")";
    }

    private Object[] getObjectValue(Set<Object> ids, Object nowdate) {
        if (ids != null) {
            ArrayList<Object> newList = new ArrayList<Object>(ids);
            newList.add(nowdate);
            newList.add(nowdate);
            return newList.toArray();
        }
        return new Object[0];
    }
}

