/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain.processor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.dpm.common.CustomerRangeUtil;
import kd.drp.dpm.common.cache.DPMAppCache;
import kd.drp.dpm.common.chain.processor.IProcessor;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.mdr.common.model.dpm.PromotionOrder;

public class MatchPromotionProcessor
implements IProcessor {
    private static String QUERY_FIELDS = "id,priority,applicability,isexclusive,customerrange.id,scheduletype,schedulevalues,modifytime";
    protected static Log log = LogFactory.getLog(DPMAppCache.class);

    @Override
    public void process(PromotionExecuteContext ctx) {
        this.matchPolicys(ctx);
    }

    private void matchPolicys(PromotionExecuteContext context) {
        log.info("\u6e20\u9053\u4e91\uff1amatchPolicys" + context.getOrder());
        PromotionOrder order = context.getOrder();
        ORM orm = ORM.create();
        HashSet<Object> rangeids = new HashSet<Object>();
        HashMap<Object, Object> rangePromotions = new HashMap<Object, Object>();
        ArrayList<Object> sortids = new ArrayList<Object>();
        Object policyid = null;
        String sourceformkey = order.getsetSourceFromKey();
        try (DataSet dataset = orm.queryDataSet(this.getClass().getName(), "dpm_policy", QUERY_FIELDS, this.buildQFilters(order)).orderBy(new String[]{"isexclusive desc", "priority", "modifytime desc"});){
            while (dataset.hasNext()) {
                Object rangeid;
                Row row = dataset.next();
                String applicability = row.getString("applicability");
                if (sourceformkey != null && (applicability == null || applicability.length() == 0 || !applicability.contains(sourceformkey)) || (rangeid = row.getLong("customerrange.id")) == null || ((Long)rangeid).equals(0L) || !this.isPolicyInSchedule(row.getString("scheduletype"), row.getString("schedulevalues"), order.getCreatetime())) continue;
                rangeids.add(rangeid);
                policyid = row.get("id");
                rangePromotions.put(rangeid, policyid);
                sortids.add(policyid);
            }
            Set<Object> ids = CustomerRangeUtil.isCustomerInTheRange(order.getCustomerid(), rangeids);
            HashSet<Object> policyids = new HashSet<Object>();
            if (ids != null && ids.size() > 0) {
                for (Object e : ids) {
                    policyids.add(rangePromotions.get(e));
                }
            } else {
                return;
            }
            Set<Promotion> promotions = Promotion.getPromotions(policyids);
            HashMap<Object, Promotion> hashMap = new HashMap<Object, Promotion>(promotions.size());
            for (Promotion promotion : promotions) {
                hashMap.put(promotion.getId(), promotion);
            }
            for (Promotion promotion : sortids) {
                Promotion promotion2 = (Promotion)hashMap.get(promotion);
                if (promotion2 == null) continue;
                context.put(promotion2, null);
            }
        }
        log.info("\u6e20\u9053\u4e91\uff1amatchPolicys" + context.getPromotions());
    }

    private boolean isPolicyInSchedule(String type, String schedulevalues, Date promotiontime) {
        if (type == null || type.trim().isEmpty() || "day".equals(type)) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(promotiontime);
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        if ("week".equals(type)) {
            return this.isInValues(schedulevalues, dayofweek);
        }
        if ("month".equals(type)) {
            return this.isInValues(schedulevalues, dayofmonth);
        }
        return false;
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private QFilter[] buildQFilters(PromotionOrder order) {
        QFilter filter = new QFilter("owner", "=", order.getOwnerid());
        filter.and(new QFilter("starttime", "<=", (Object)order.getCreatetime()));
        filter.and(new QFilter("endtime", ">=", (Object)order.getCreatetime()));
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        return filter.toArray();
    }
}

