/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.chain.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.drp.dpm.common.CustomerRangeUtil;
import kd.drp.dpm.common.cache.DPMAppCache;
import kd.drp.dpm.common.execute.PromotionUsableContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.util.SysParamsUtil;

public class MatchUsablePromotionProcessor {
    private static String QUERY_FIELDS = "id,priority,applicability,isexclusive,customerrange.id,scheduletype,schedulevalues,modifytime,starttime,endtime,name,number";
    protected static Log log = LogFactory.getLog(DPMAppCache.class);

    public void usablePromotionProcessor(PromotionUsableContext context) {
        this.matchUsablePolicys(context);
    }

    private void matchUsablePolicys(PromotionUsableContext context) {
        if (!SysParamsUtil.isUsePromotion()) {
            return;
        }
        PromotionOrder order = context.getOrder();
        ORM orm = ORM.create();
        HashSet<Object> rangeids = new HashSet<Object>();
        HashSet<Object> promotionids = new HashSet<Object>();
        HashMap<Iterator<Object>, Object> rangePromotions = new HashMap<Iterator<Object>, Object>();
        String sourceformkey = order.getsetSourceFromKey();
        try (DataSet dataset = orm.queryDataSet(this.getClass().getName(), "dpm_policy", QUERY_FIELDS, this.buildQFilters(order)).orderBy(new String[]{"isexclusive desc", "priority", "modifytime desc"});){
            while (dataset.hasNext()) {
                Iterator<Object> rangeid;
                Row row = dataset.next();
                String applicability = row.getString("applicability");
                if (!sourceformkey.isEmpty() && !applicability.contains(sourceformkey) || (rangeid = row.get("customerrange.id")) == null || rangeid.equals(0L) || !this.isPolicyInSchedule(row.getString("scheduletype"), row.getString("schedulevalues"), order.getCreatetime())) continue;
                rangeids.add(rangeid);
                rangePromotions.put(rangeid, row.get("id"));
            }
            Set<Object> ids = CustomerRangeUtil.isCustomerInTheRange(order.getCustomerid(), rangeids);
            HashSet<Object> policyids = new HashSet<Object>();
            if (ids != null && ids.size() > 0) {
                for (Object id : ids) {
                    policyids.add(rangePromotions.get(id));
                }
            } else {
                return;
            }
            Set<Promotion> promotions = Promotion.getPromotions(policyids);
            context.setPromotions(promotions);
            for (Promotion promotion : promotions) {
                promotionids.add(promotion.getId());
            }
        }
        if (promotionids.size() > 0) {
            Map<Object, BigDecimal> leftlimitqtys = this.queryRegionDataSet(promotionids, order.getCreatetime());
            BigDecimal leftlimitqty = BigDecimal.ZERO;
            for (Promotion promotion : context.getPromotions()) {
                leftlimitqty = leftlimitqtys.get(promotion.getId());
                if (leftlimitqty == null) continue;
                promotion.setislimit(true);
                promotion.setLeftLimitqty(leftlimitqty);
            }
        }
    }

    private boolean isPolicyInSchedule(String type, String schedulevalues, Date promotiontime) {
        if (type == null || type.trim().isEmpty() || "day".equals(type)) {
            return true;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(promotiontime);
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        if ("week".equals(type)) {
            return this.isInValues(schedulevalues, dayofweek);
        }
        if ("month".equals(type)) {
            return this.isInValues(schedulevalues, dayofmonth);
        }
        return false;
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private QFilter[] buildQFilters(PromotionOrder order) {
        QFilter filter = new QFilter("owner", "=", order.getOwnerid());
        filter.and(new QFilter("starttime", "<=", (Object)order.getCreatetime()));
        filter.and(new QFilter("endtime", ">=", (Object)order.getCreatetime()));
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        return filter.toArray();
    }

    private Map<Object, BigDecimal> queryRegionDataSet(Set<Object> ids, Date createtime) {
        HashMap<Object, BigDecimal> sumqtyInfo = new HashMap<Object, BigDecimal>();
        ORM orm = ORM.create();
        String str = this.getString(ids);
        Object[] ob = this.getObjectValue(ids, createtime);
        StringBuilder returnsql = new StringBuilder();
        returnsql.append("select policy.promotionpolicy.id as promotionid, sum(qtylimititems.leftlimitqty) as sumqty ");
        returnsql.append("from dpm_limit where status ='C' and enable='1' and policy.promotionpolicy.policystatus ='D' ");
        returnsql.append("and policy.promotionpolicy.id in ");
        returnsql.append(str);
        returnsql.append(" and starttime < ? and endtime > ?  ");
        returnsql.append("group by policy.promotionpolicy.id ");
        try (DataSet set = orm.queryDataSet(this.getClass().getName(), returnsql.toString(), ob);){
            for (Row row : set) {
                sumqtyInfo.put(row.get("promotionid"), row.getBigDecimal("sumqty"));
            }
        }
        return sumqtyInfo;
    }

    private String getString(Set<Object> ids) {
        if (ids.isEmpty()) {
            return "(0)";
        }
        StringBuilder str = new StringBuilder("(");
        for (int i = 0; i < ids.size(); ++i) {
            str.append("?,");
        }
        return str.substring(0, str.length() - 1) + ")";
    }

    private Object[] getObjectValue(Set<Object> ids, Object nowdate) {
        if (ids != null) {
            ArrayList<Object> newList = new ArrayList<Object>(ids);
            newList.add(nowdate);
            newList.add(nowdate);
            return newList.toArray();
        }
        return new Object[0];
    }
}

