/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.limit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.limit.LimitContext;
import kd.drp.dpm.common.limit.LimitRollBacker;
import kd.drp.dpm.common.limit.executor.LimitExecutor;
import kd.drp.dpm.common.limit.executor.impl.LimitQtyExecutor;
import kd.drp.dpm.common.limit.executor.impl.LimitQtyValidateExecutor;
import kd.drp.dpm.common.limit.handler.LimitHandler;
import kd.drp.dpm.common.limit.handler.impl.AbstractQtyHandler;
import kd.drp.dpm.common.limit.handler.impl.LimitPresentQtyHandler;
import kd.drp.dpm.common.limit.handler.impl.LimitPromotionPresentQtyHandler;
import kd.drp.dpm.common.limit.handler.impl.LimitPromotionQtyHandler;
import kd.drp.dpm.common.limit.handler.impl.LimitQtyHandler;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class PromotionLimitUtil {
    public static LimitResult executeLimitRule(Object orderId, PromotionOrder porder, String cachekey, boolean putOnOrder) {
        PromotionExecuteContext peContext = PromotionUtil.loadPromotionContextFromCache(cachekey);
        if (peContext == null) {
            return new LimitResult(true);
        }
        peContext.setOrder(porder);
        return PromotionLimitUtil.executeLimitRule(peContext.getOrder().getCreatetime(), peContext.getOrder(), peContext, "2", false, putOnOrder, orderId);
    }

    public static LimitResult validateLimitRule(String cachekey, PromotionOrder porder, boolean putOnOrder) {
        PromotionExecuteContext peContext = PromotionUtil.loadPromotionContextFromCache(cachekey);
        if (peContext == null) {
            return new LimitResult(true);
        }
        peContext.setOrder(porder);
        return PromotionLimitUtil.executeLimitRule(peContext.getOrder().getCreatetime(), peContext.getOrder(), peContext, "2", true, putOnOrder, null);
    }

    private static LimitResult executeLimitRule(Date executeDate, PromotionOrder order, PromotionExecuteContext peContext, String mode, boolean isValidate, boolean putOnOrder, Object orderId) {
        LimitContext limitContext = new LimitContext();
        ArrayList<AbstractQtyHandler> handlers = new ArrayList<AbstractQtyHandler>(4);
        String[] modes = mode.split(",");
        String[] stringArray = modes;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String m;
            switch (m = stringArray[i]) {
                case "1": {
                    handlers.add(new LimitQtyHandler(executeDate, order, peContext));
                    continue block12;
                }
                case "2": {
                    handlers.add(new LimitPresentQtyHandler(executeDate, order, peContext));
                    continue block12;
                }
                case "3": {
                    handlers.add(new LimitPromotionQtyHandler(executeDate, order, peContext));
                    continue block12;
                }
                case "4": {
                    handlers.add(new LimitPromotionPresentQtyHandler(executeDate, order, peContext));
                    continue block12;
                }
            }
        }
        for (LimitHandler limitHandler : handlers) {
            limitContext.combine(limitHandler.handle());
        }
        LimitExecutor executor = null;
        executor = isValidate ? new LimitQtyValidateExecutor() : new LimitQtyExecutor(orderId);
        LimitResult limitResult = executor.executeLimit(limitContext);
        if (!isValidate && !limitResult.isLimitResult()) {
            PromotionLimitUtil.rollBackExpectedQty(orderId);
        }
        if (putOnOrder) {
            PromotionLimitUtil.putOnOrder(limitResult, order);
        }
        return limitResult;
    }

    public static LimitResult executeLimitRule(Object orderId, PromotionOrder porder, boolean putOnOrder) {
        List policyenterys = porder.getPolicyEntries();
        PromotionExecuteContext peContext = null;
        String mode = "1";
        if (policyenterys != null) {
            peContext = PromotionUtil.loadPromotionContextFromCache(porder.getPromotioncachekey());
            int size = policyenterys.size();
            if (size == porder.getEntries().size()) {
                mode = "3";
            } else if (size > 0) {
                mode = "1,3";
            }
        }
        return PromotionLimitUtil.executeLimitRule(porder.getCreatetime(), porder, peContext, mode, false, putOnOrder, orderId);
    }

    public static LimitResult validateLimitRule(PromotionOrder porder, boolean putOnOrder) {
        List policyenterys = porder.getPolicyEntries();
        PromotionExecuteContext peContext = null;
        String mode = "1";
        if (policyenterys != null) {
            peContext = PromotionUtil.loadPromotionContextFromCache(porder.getPromotioncachekey());
            int size = policyenterys.size();
            if (size == porder.getEntries().size()) {
                mode = "3";
            } else if (size > 0) {
                mode = "1,3";
            }
        }
        return PromotionLimitUtil.executeLimitRule(porder.getCreatetime(), porder, peContext, mode, true, putOnOrder, null);
    }

    public static boolean rollback(Object orderId) {
        return new LimitRollBacker(orderId).rollback();
    }

    public static boolean rollBackExpectedQty(Object orderId) {
        return new LimitRollBacker(orderId).rollBackExpectedQty();
    }

    private static PromotionOrder putOnOrder(LimitResult result, PromotionOrder order) {
        Map entries;
        if (!result.isSuccessExecuteLimit() && (entries = result.getLimitResultEntries()) != null && entries.size() != 0) {
            HashMap<DetailItemInfo, LimitResultEntry> leastmap = new HashMap<DetailItemInfo, LimitResultEntry>();
            for (LimitResultEntry lrEntry : entries.values()) {
                String type;
                if (lrEntry.getExecuteResult()) continue;
                switch (type = lrEntry.getType()) {
                    case "2": {
                        DetailItemInfo detailIntemInfo = new DetailItemInfo(lrEntry.getItemId(), lrEntry.getUnitId(), lrEntry.getAttrId());
                        PromotionLimitUtil.putIntoMap(leastmap, detailIntemInfo, lrEntry);
                    }
                }
            }
            for (LimitResultEntry entry : leastmap.values()) {
                PromotionLimitUtil.putOnOrderByLimitPresentQty(entry, order);
            }
        }
        return order;
    }

    private static void putIntoMap(Map<DetailItemInfo, LimitResultEntry> leastmap, DetailItemInfo detailIntemInfo, LimitResultEntry limitResultEntry) {
        LimitResultEntry cuResultEntry = leastmap.get(detailIntemInfo);
        if (cuResultEntry == null || cuResultEntry.getLeftLimitQty().compareTo(limitResultEntry.getLeftLimitQty()) > 0) {
            leastmap.put(detailIntemInfo, limitResultEntry);
        }
    }

    private static void putOnOrderByLimitPresentQty(LimitResultEntry lrEntry, PromotionOrder order) {
        BigDecimal totalLeftSubstactQty;
        HashSet<PromotionOrderEntry> needSubstractEntries = new HashSet<PromotionOrderEntry>();
        PromotionOrderEntry maxQtyEntry = null;
        BigDecimal totalQty = BigDecimal.ZERO;
        for (PromotionOrderEntry entry : order.getEntries()) {
            if (!entry.getItemid().equals(lrEntry.getItemId()) || !entry.getUnitid().equals(lrEntry.getUnitId()) || !entry.getAttrid().equals(lrEntry.getAttrId()) || !entry.isIspresent()) continue;
            needSubstractEntries.add(entry);
            totalQty = totalQty.add(entry.getQty());
            if (maxQtyEntry != null && entry.getQty().compareTo(maxQtyEntry.getQty()) <= 0) continue;
            maxQtyEntry = entry;
        }
        if (needSubstractEntries.size() == 0) {
            return;
        }
        if (lrEntry.getLeftLimitQty().compareTo(BigDecimal.ZERO) <= 0) {
            order.getEntries().removeAll(needSubstractEntries);
            return;
        }
        DynamicObject unit = QueryServiceHelper.queryOne((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter("id", "=", lrEntry.getUnitId()).toArray());
        Integer precision = unit.getInt("precision");
        BigDecimal totalSubstactQty = totalLeftSubstactQty = lrEntry.getMinusQty().subtract(lrEntry.getLeftLimitQty());
        for (PromotionOrderEntry needSubstractEntry : needSubstractEntries) {
            BigDecimal substractQty = needSubstractEntry.getQty().divide(totalQty, 10, 1).multiply(totalSubstactQty);
            substractQty = substractQty.setScale((int)precision, 1);
            BigDecimal entryLeftQty = needSubstractEntry.getQty().subtract(substractQty);
            if (entryLeftQty.compareTo(BigDecimal.ZERO) == 0) {
                // empty if block
            }
            needSubstractEntry.setQty(entryLeftQty);
            totalLeftSubstactQty = totalLeftSubstactQty.subtract(substractQty);
        }
        if (maxQtyEntry != null) {
            maxQtyEntry.setQty(maxQtyEntry.getQty().subtract(totalLeftSubstactQty));
        }
    }
}

