/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.limit.executor.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.limit.LimitContext;
import kd.drp.dpm.common.limit.LimitContextEntry;
import kd.drp.dpm.common.limit.executor.LimitExecutor;
import kd.drp.mdr.common.handler.UnitBatchHandler;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;

public class LimitQtyExecutor
implements LimitExecutor {
    private static final DBRoute MDR_DBROUTE = new DBRoute("mdr");
    protected Object orderId;

    public LimitQtyExecutor(Object orderId) {
        this.orderId = orderId;
    }

    @Override
    public LimitResult executeLimit(LimitContext context) {
        LimitResult limitResult = new LimitResult(true);
        HashMap<Object, LimitResultEntry> limitResultEntries = new HashMap<Object, LimitResultEntry>();
        limitResult.setType("execute");
        try (TXHandle h = TX.requiresNew();){
            try {
                Set<Object> idset = context.getEntryIds();
                if (idset.size() != 0) {
                    DynamicObject limitRule;
                    QFilter filter = new QFilter("qtylimititems.id", "in", idset);
                    DynamicObject[] limitRules = BusinessDataServiceHelper.load((String)"dpm_limit", (String)"qtylimititems.id,qtylimititems.item,qtylimititems.unit,qtylimititems.baseunit", (QFilter[])filter.toArray());
                    String updatesql = "update t_dpm_limit_qtyitems set fleftlimitqty = fleftlimitqty + ? ,fusedqty =fusedqty + ? ,fleftlimitbaseqty = fleftlimitbaseqty + ? ,fusedbaseqty =fusedbaseqty + ?    where FEntryId = ?";
                    BigDecimal qty = BigDecimal.ZERO;
                    BigDecimal baseqty = BigDecimal.ZERO;
                    DynamicObject unit = null;
                    DynamicObject item = null;
                    Object limitqtyid = null;
                    DynamicObjectCollection qtylimititems = null;
                    Map<Object, LimitContextEntry> entries = context.getEntries();
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>(entries.size());
                    UnitBatchHandler unitBatchHandler = new UnitBatchHandler();
                    DynamicObject[] dynamicObjectArray = limitRules;
                    int n = dynamicObjectArray.length;
                    for (int i = 0; i < n && (qtylimititems = (limitRule = dynamicObjectArray[i]).getDynamicObjectCollection("qtylimititems")) != null && !qtylimititems.isEmpty(); ++i) {
                        for (DynamicObject qtylimititem : qtylimititems) {
                            limitqtyid = qtylimititem.getPkValue();
                            if (!idset.contains(limitqtyid)) continue;
                            baseqty = entries.get(limitqtyid).getbaseQty();
                            item = qtylimititem.getDynamicObject("item");
                            if (item.getBoolean("iscombination")) {
                                qty = baseqty;
                            } else {
                                unit = qtylimititem.getDynamicObject("unit");
                                qty = unitBatchHandler.getUnitQty(item.getPkValue(), unit.getPkValue(), baseqty);
                            }
                            ArrayList<Object> dataValueList = new ArrayList<Object>(5);
                            dataValueList.add(qty.negate());
                            dataValueList.add(qty);
                            dataValueList.add(baseqty.negate());
                            dataValueList.add(baseqty);
                            dataValueList.add(limitqtyid);
                            paramsList.add(dataValueList.toArray());
                        }
                    }
                    DB.executeBatch((DBRoute)MDR_DBROUTE, (String)updatesql, paramsList);
                    DynamicObjectCollection results = QueryServiceHelper.query((String)"dpm_limit", (String)"id,qtylimititems.item,qtylimititems.item.number,qtylimititems.item.name,qtylimititems.id,qtylimititems.unit,qtylimititems.attr,qtylimititems.leftlimitqty,qtylimititems.leftlimitbaseqty", (QFilter[])new QFilter("qtylimititems.id", "in", idset).toArray());
                    boolean issuccess = true;
                    for (DynamicObject limitItems : results) {
                        Object qtylimititemsid = limitItems.get("qtylimititems.id");
                        LimitContextEntry limitContextEntry = context.getLimitContextEntry(qtylimititemsid);
                        BigDecimal substractLimitQty = limitContextEntry.getbaseQty();
                        Object itemId = limitItems.get("qtylimititems.item");
                        Object unitId = limitItems.get("qtylimititems.unit");
                        Object attrId = limitItems.get("qtylimititems.attr");
                        BigDecimal leftLimitQty = limitItems.getBigDecimal("qtylimititems.leftlimitbaseqty");
                        LimitResultEntry resultEntry = new LimitResultEntry();
                        resultEntry.setRuleId((Object)limitItems.getLong("id"));
                        resultEntry.setItemId(itemId);
                        resultEntry.setItemName(String.format("%s.%s", limitItems.getString("qtylimititems.item.number"), limitItems.getString("qtylimititems.item.name")));
                        resultEntry.setUnitId(unitId);
                        resultEntry.setAttrId(attrId);
                        resultEntry.setLeftLimitQty(leftLimitQty.add(qty));
                        resultEntry.setMinusQty(substractLimitQty);
                        resultEntry.setType(limitContextEntry.getType());
                        if (BigDecimal.ZERO.compareTo(leftLimitQty) > 0) {
                            issuccess = false;
                            resultEntry.setExecuteResult(false);
                            limitResultEntries.put(qtylimititemsid, resultEntry);
                            continue;
                        }
                        resultEntry.setExecuteResult(true);
                        limitResultEntries.put(qtylimititemsid, resultEntry);
                    }
                    if (!issuccess) {
                        h.markRollback();
                    }
                    limitResult.setLimitResult(issuccess);
                    limitResult.setLimitResultEntries(limitResultEntries);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        return limitResult;
    }
}

