/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.limit.executor.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.limit.LimitContext;
import kd.drp.dpm.common.limit.LimitContextEntry;
import kd.drp.dpm.common.limit.executor.LimitExecutor;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;

public class LimitQtyValidateExecutor
implements LimitExecutor {
    private static final DBRoute MDR_DBROUTE = new DBRoute("mdr");

    @Override
    public LimitResult executeLimit(LimitContext context) {
        LimitResult limitResult = new LimitResult(true);
        HashMap<Object, LimitResultEntry> limitResultEntries = new HashMap<Object, LimitResultEntry>();
        limitResult.setType("validate");
        Set<Object> idset = context.getEntryIds();
        if (idset.size() != 0) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            DynamicObjectCollection results = QueryServiceHelper.query((String)"dpm_limit", (String)"id,isactonpolicy,qtylimititems.item,qtylimititems.item.number,qtylimititems.item.name,qtylimititems.id,qtylimititems.unit,qtylimititems.attr,qtylimititems.limitbaseqty,qtylimititems.expectedbaseqty", (QFilter[])new QFilter("qtylimititems.id", "in", idset).toArray());
            String updatesql = "update t_dpm_limit_qtyitems set fexpectedbaseqty = fexpectedbaseqty + ? where FEntryId = ?";
            boolean issuccess = true;
            for (DynamicObject limitItems : results) {
                Object qtylimititemsid = limitItems.get("qtylimititems.id");
                LimitContextEntry limitContextEntry = context.getLimitContextEntry(qtylimititemsid);
                if (limitContextEntry == null) continue;
                BigDecimal leftLimitQty = limitItems.getBigDecimal("qtylimititems.limitbaseqty").subtract(limitItems.getBigDecimal("qtylimititems.expectedbaseqty"));
                BigDecimal substractLimitQty = limitContextEntry.getbaseQty();
                Object itemId = limitItems.get("qtylimititems.item");
                Object unitId = limitItems.get("qtylimititems.unit");
                Object attrId = limitItems.get("qtylimititems.attr");
                LimitResultEntry resultEntry = new LimitResultEntry();
                resultEntry.setRuleId((Object)limitItems.getLong("id"));
                resultEntry.setisactonpolicy(limitItems.getBoolean("isactonpolicy"));
                resultEntry.setItemId(itemId);
                resultEntry.setItemName(String.format("%s.%s", limitItems.getString("qtylimititems.item.number"), limitItems.getString("qtylimititems.item.name")));
                resultEntry.setUnitId(unitId);
                resultEntry.setAttrId(attrId);
                resultEntry.setLeftLimitQty(leftLimitQty);
                resultEntry.setMinusQty(substractLimitQty);
                resultEntry.setType(limitContextEntry.getType());
                if (substractLimitQty.compareTo(leftLimitQty) > 0) {
                    issuccess = false;
                    resultEntry.setExecuteResult(false);
                    limitResultEntries.put(qtylimititemsid, resultEntry);
                    continue;
                }
                resultEntry.setExecuteResult(true);
                limitResultEntries.put(qtylimititemsid, resultEntry);
                ArrayList<Object> dataValueList = new ArrayList<Object>(5);
                dataValueList.add(substractLimitQty);
                dataValueList.add(qtylimititemsid);
                paramsList.add(dataValueList.toArray());
            }
            if (issuccess && paramsList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        DB.executeBatch((DBRoute)MDR_DBROUTE, (String)updatesql, paramsList);
                        Map<Object, List<Object>> orderentryids = context.getOrderEntryIds();
                        if (orderentryids != null && !orderentryids.isEmpty()) {
                            List<Object> limitinfo = null;
                            updatesql = "update t_bbc_saleorderentry_x  set flimitid = ? ,fqtylimitid =?  where fentryid = ?";
                            paramsList = new ArrayList(orderentryids.size());
                            for (Map.Entry<Object, List<Object>> orderentryid : orderentryids.entrySet()) {
                                limitinfo = orderentryid.getValue();
                                if (limitinfo == null || limitinfo.size() != 2) continue;
                                ArrayList<Object> dataValueList = new ArrayList<Object>(3);
                                dataValueList.add(limitinfo.get(0));
                                dataValueList.add(limitinfo.get(1));
                                dataValueList.add(orderentryid.getKey());
                                paramsList.add(dataValueList.toArray());
                            }
                            DB.executeBatch((DBRoute)MDR_DBROUTE, (String)updatesql, paramsList);
                        }
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        throw e;
                    }
                }
            }
            limitResult.setLimitResult(issuccess);
            limitResult.setLimitResultEntries(limitResultEntries);
        }
        return limitResult;
    }
}

