/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.model.condition.IPromotionCondition;
import kd.drp.dpm.common.model.result.IPromotionResult;
import kd.drp.dpm.common.parse.PromotionConditionParser;
import kd.drp.dpm.common.parse.PromotionResultParser;

public class Promotion {
    private Object id;
    private String number;
    private String name;
    private int priority;
    private boolean isexclusive;
    private Date starttime;
    private Date endtime;
    private boolean islimit;
    private BigDecimal leftlimitqty;
    private boolean iscombinationsplit;
    private Date modifytime;
    private List<PromotionEntry> entrylist = new ArrayList<PromotionEntry>();
    private static LocalCache<Object, Promotion> promotioncache = new LocalCache(50);
    private static LocalCache<Object, IPromotionCondition> conditioncache = new LocalCache(100);
    private static LocalCache<Object, IPromotionResult> resultcache = new LocalCache(100);
    private static final String QUERY_FIELD = "id,number,name,priority,isexclusive,starttime,endtime,modifytime,iscombinationsplit,entryentity.seq,entryentity.conditionexp,entryentity.resultexp";

    private Promotion() {
    }

    private static Set<Promotion> SetPromotion(Set<Object> policyids) {
        QFilter fs = new QFilter("id", "in", policyids);
        HashSet<Promotion> promotions = new HashSet<Promotion>(policyids.size());
        Map policys = BusinessDataServiceHelper.loadFromCache((String)"dpm_policy", (String)QUERY_FIELD, (QFilter[])fs.toArray());
        for (DynamicObject policy : policys.values()) {
            Promotion promotion = new Promotion();
            promotion.id = policy.getPkValue();
            promotion.number = policy.getString("number");
            promotion.name = policy.getLocaleString("name").getLocaleValue();
            promotion.priority = policy.getInt("priority");
            promotion.isexclusive = policy.getBoolean("isexclusive");
            promotion.starttime = policy.getDate("starttime");
            promotion.endtime = policy.getDate("endtime");
            promotion.iscombinationsplit = policy.getBoolean("iscombinationsplit");
            promotion.modifytime = policy.getDate("modifytime");
            DynamicObjectCollection entrys = policy.getDynamicObjectCollection("entryentity");
            String conditionexp = "";
            String resultexp = "";
            block1: for (int i = entrys.size(); i >= 1; --i) {
                for (DynamicObject entry : entrys) {
                    int seq = entry.getInt("seq");
                    if (i != seq) continue;
                    conditionexp = entry.getString("conditionexp");
                    resultexp = entry.getString("resultexp");
                    promotion.entrylist.add(new PromotionEntry(conditionexp, resultexp));
                    if (conditionexp != null && !conditionexp.trim().isEmpty() && conditionexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) {
                        for (String condition : conditionexp.split("AND|OR")) {
                            conditioncache.remove(condition);
                        }
                    }
                    if (resultexp == null || resultexp.trim().isEmpty() || !resultexp.matches("^\\d{1,}((AND|OR)\\d{1,})*$")) continue block1;
                    for (String result : resultexp.split("AND|OR")) {
                        resultcache.remove(result);
                    }
                }
            }
            promotions.add(promotion);
        }
        return promotions;
    }

    public static Promotion getPromotion(Object policyid) {
        Promotion promotion = (Promotion)promotioncache.get(policyid);
        if (promotion != null) {
            DynamicObject tempPolicy = BusinessDataServiceHelper.loadSingleFromCache((Object)policyid, (String)"dpm_policy", (String)"id,modifytime");
            Date modifydate = tempPolicy.getDate("modifytime");
            Date cacheProDate = promotion.getModifytime();
            if (cacheProDate.compareTo(modifydate) < 0) {
                promotion = null;
            }
        }
        if (promotion == null) {
            HashSet<Object> policyids = new HashSet<Object>(1);
            policyids.add(policyid);
            Set<Promotion> promotions = Promotion.SetPromotion(policyids);
            Iterator<Promotion> iterator = promotions.iterator();
            while (iterator.hasNext()) {
                Promotion promotion1;
                promotion = promotion1 = iterator.next();
                promotioncache.put(policyid, promotion);
            }
        }
        return promotion;
    }

    public static Set<Promotion> getPromotions(Set<Object> policyids) {
        Promotion promotion;
        int size = policyids.size();
        HashSet<Promotion> promotions = new HashSet<Promotion>(size);
        HashSet<Object> ids = new HashSet<Object>(size);
        HashMap<Object, Promotion> mapPromotions = new HashMap<Object, Promotion>(size);
        for (Object policyid : policyids) {
            promotion = (Promotion)promotioncache.get(policyid);
            if (promotion != null) {
                mapPromotions.put(policyid, promotion);
                continue;
            }
            ids.add(policyid);
        }
        if (mapPromotions.size() > 0) {
            QFilter fs = new QFilter("id", "in", mapPromotions.keySet());
            Map tempPolicys = BusinessDataServiceHelper.loadFromCache((String)"dpm_policy", (String)"id,modifytime", (QFilter[])fs.toArray());
            promotion = null;
            Object id = null;
            for (Map.Entry tempPolicy : tempPolicys.entrySet()) {
                Date modifydate = ((DynamicObject)tempPolicy.getValue()).getDate("modifytime");
                id = tempPolicy.getKey();
                promotion = (Promotion)mapPromotions.get(id);
                Date cacheProDate = promotion.getModifytime();
                if (cacheProDate.compareTo(modifydate) < 0) {
                    ids.add(tempPolicy.getKey());
                    continue;
                }
                promotions.add(promotion);
            }
        }
        if (ids.size() > 0) {
            for (Promotion promotion1 : Promotion.SetPromotion(ids)) {
                promotions.add(promotion1);
                promotioncache.put(promotion1.getId(), promotion1);
            }
        }
        return promotions;
    }

    public Object getId() {
        return this.id;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isIsexclusive() {
        return this.isexclusive;
    }

    public Date getstarttime() {
        return this.starttime;
    }

    public Date getendtime() {
        return this.endtime;
    }

    public void setislimit(boolean islimit) {
        this.islimit = islimit;
    }

    public boolean getislimit() {
        return this.islimit;
    }

    public void setLeftLimitqty(BigDecimal leftlimitqty) {
        this.leftlimitqty = leftlimitqty;
    }

    public BigDecimal getLeftLimitqty() {
        return this.leftlimitqty;
    }

    public boolean isIscombinationsplit() {
        return this.iscombinationsplit;
    }

    public int unitsize() {
        return this.entrylist.size();
    }

    public Date getModifytime() {
        return this.modifytime;
    }

    public String getConditionExp(int index) {
        return this.entrylist.get(index).getConditionexp();
    }

    public String getResultExp(int index) {
        return this.entrylist.get(index).getResultexp();
    }

    public static IPromotionCondition getCondition(Object conditionid) {
        IPromotionCondition condition = (IPromotionCondition)conditioncache.get(conditionid);
        if (condition == null) {
            condition = PromotionConditionParser.parseCondition(conditionid);
            conditioncache.put(conditionid, condition);
        }
        return condition;
    }

    public static IPromotionResult getResult(Object resultid) {
        IPromotionResult result = (IPromotionResult)resultcache.get(resultid);
        if (result == null) {
            result = PromotionResultParser.parseResult(resultid);
            resultcache.put(resultid, result);
        }
        return result;
    }

    private static class PromotionEntry {
        private String conditionexp;
        private String resultexp;

        private PromotionEntry(String conditionexp, String resultexp) {
            this.conditionexp = conditionexp;
            this.resultexp = resultexp;
        }

        public String getConditionexp() {
            return this.conditionexp;
        }

        public String getResultexp() {
            return this.resultexp;
        }
    }

    private static class LocalCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int cachesize = 100;

        private LocalCache(int cachesize) {
            this.cachesize = cachesize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cachesize;
        }

        @Override
        public synchronized V put(K key, V value) {
            return super.put(key, value);
        }
    }
}

