/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.model.condition.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.CompareORCalculateUtil;
import kd.drp.dpm.common.model.condition.IPromotionCondition;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public abstract class AbstractCondition
implements IPromotionCondition {
    private DynamicObject model;

    public AbstractCondition(Object conditionid) {
        this.model = BusinessDataServiceHelper.loadSingle((Object)conditionid, (String)"dpm_condition");
    }

    @Override
    public boolean isMatch(PromotionOrder order) {
        boolean ismatch = false;
        ismatch = this.isRangeTypeCondition() && this.getIsRangeSplit() ? this.isRangeSplitMatch(order) : this.compareWithJudgeValue(this.calculateComparisonValue(order), this.getJudgeValue());
        return ismatch;
    }

    private boolean isRangeSplitMatch(PromotionOrder order) {
        Map<DetailItemInfo, BigDecimal> rangetotal = this.getRangePerTotalInfo(order);
        if (rangetotal == null) {
            return false;
        }
        for (Map.Entry<DetailItemInfo, BigDecimal> entry : rangetotal.entrySet()) {
            BigDecimal value = entry.getValue();
            if (!this.compareWithJudgeValue(value, this.getJudgeValue())) continue;
            return true;
        }
        return false;
    }

    public final boolean compareWithJudgeValue(BigDecimal value, BigDecimal judgevalue) {
        int comparator = this.model.getInt("comparison");
        return CompareORCalculateUtil.compareWithJudgeValue(value, judgevalue, comparator);
    }

    public BigDecimal calculateComparisonValue(PromotionOrder order) {
        BigDecimal totalvalue = BigDecimal.ZERO;
        List<PromotionOrderEntry> entrys = this.getEntrysInCondition(order);
        for (PromotionOrderEntry entry : entrys) {
            totalvalue = totalvalue.add(this.getEntryQtyOrAmount(entry));
        }
        return totalvalue;
    }

    public abstract List<PromotionOrderEntry> getEntrysInCondition(PromotionOrder var1);

    public Map<DetailItemInfo, BigDecimal> getRangePerTotalInfo(PromotionOrder order) {
        List<PromotionOrderEntry> entrysincondition = this.getEntrysInCondition(order);
        Map<DetailItemInfo, BigDecimal> map = this.sumOrderByDetailItem(entrysincondition);
        return map;
    }

    public DynamicObject getConditionModel() {
        return this.model;
    }

    public BigDecimal getEntryQtyOrAmount(PromotionOrderEntry entry) {
        return CompareORCalculateUtil.getEntryQtyOrAmount(entry, this.getJudgeStandard());
    }

    protected BigDecimal getOrderQtyOrAmount(PromotionOrder order) {
        return CompareORCalculateUtil.getOrderQtyOrAmount(order, this.getJudgeStandard());
    }

    public List genEntrySetInRange(PromotionOrder order) {
        DynamicObject itemrange = this.model.getDynamicObject("itemrange");
        return CompareORCalculateUtil.genEntrysInRange(order.getEntries(), itemrange);
    }

    public List getEntryEqualsItem(PromotionOrder order) {
        Long itemid = this.model.getLong("item.id");
        Long unitid = this.model.getLong("unit.id");
        Long attrid = this.model.getLong("attr.id");
        return CompareORCalculateUtil.getEntrysEqualsItem(order.getEntries(), itemid, unitid, attrid);
    }

    protected Map<DetailItemInfo, BigDecimal> sumOrderByDetailItem(List<PromotionOrderEntry> entrys) {
        return CompareORCalculateUtil.sumOrderByDetailItem(entrys, this.getJudgeStandard());
    }

    protected final BigDecimal getJudgeValue() {
        return this.model.getBigDecimal("judgevalue");
    }

    protected final boolean getIsRangeSplit() {
        return this.model.getBoolean("israngesplit");
    }

    protected final boolean isRangeTypeCondition() {
        return this.model.getDynamicObject("conditiontype").getBoolean("isrange");
    }

    protected final String getJudgeStandard() {
        return this.model.getString("judgestandard");
    }

    public int hashCode() {
        return this.model.getPkValue().hashCode();
    }

    public boolean equals(Object paramObject) {
        if (!(paramObject instanceof AbstractCondition)) {
            return false;
        }
        AbstractCondition target = (AbstractCondition)paramObject;
        return this.model.getPkValue().equals(target.getConditionModel().getPkValue());
    }
}

