/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.model.execution;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.drp.dpm.common.model.execution.PromotionExecutionUnit;
import kd.drp.mdr.common.model.dpm.PromotionOrder;

public class ReplaceablePromotionExecution {
    private Map<Character, PromotionExecutionUnit> unitmap = new HashMap<Character, PromotionExecutionUnit>();
    private GroupNoGenerator generator = new GroupNoGenerator();
    private Object promotionid;

    public ReplaceablePromotionExecution(Object promotionid) {
        this.promotionid = promotionid;
    }

    public Map<Character, PromotionExecutionUnit> getUnitmap() {
        return this.unitmap;
    }

    public void add(PromotionExecutionUnit unit) {
        Character groupnumber = unit.getGroupnumber();
        if (groupnumber == null) {
            groupnumber = Character.valueOf(this.generator.generateGroupNo());
            unit.setGroupnumber(groupnumber);
        }
        this.unitmap.put(groupnumber, unit);
    }

    public PromotionExecutionUnit get(Character groupnumber) {
        return this.unitmap.get(groupnumber);
    }

    public boolean isReplaceable() {
        return this.unitmap.size() > 1;
    }

    public boolean isEmpty() {
        return this.unitmap.isEmpty();
    }

    public void putOnOrder(PromotionOrder order) {
        for (PromotionExecutionUnit unit : this.unitmap.values()) {
            if (!unit.isUsed()) continue;
            unit.putOnOrder(order);
        }
    }

    public void changeUnitUsed(PromotionOrder order, char groupnumber) {
        Iterator<Map.Entry<Character, PromotionExecutionUnit>> iterator = this.unitmap.entrySet().iterator();
        while (iterator.hasNext()) {
            Character c;
            Map.Entry<Character, PromotionExecutionUnit> entry;
            entry.getValue().setIsused((c = (entry = iterator.next()).getKey()).charValue() == groupnumber);
        }
    }

    public Object getPromotionid() {
        return this.promotionid;
    }

    public List<DynamicObject> createExecution() {
        LinkedList<DynamicObject> list = new LinkedList<DynamicObject>();
        for (Map.Entry<Character, PromotionExecutionUnit> entry : this.unitmap.entrySet()) {
            PromotionExecutionUnit unit = entry.getValue();
            list.add(unit.createExecution(this.promotionid));
        }
        return list;
    }

    private static class GroupNoGenerator {
        private final char[] charset = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
        private int index = 0;

        private GroupNoGenerator() {
        }

        public char generateGroupNo() {
            if (this.index > 9) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u522b\u4e0d\u80fd\u8d85\u8fc7\u5341\u7ec4", (String)"ReplaceablePromotionExecution_0", (String)"drp-dpm-common", (Object[])new Object[0]));
            }
            return this.charset[this.index++];
        }
    }
}

