/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.model.result.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.drp.dpm.common.CompareORCalculateUtil;
import kd.drp.dpm.common.model.condition.impl.AbstractCondition;
import kd.drp.dpm.common.model.execution.AbstractExecution;
import kd.drp.dpm.common.model.execution.impl.EntryAmountDiffExecution;
import kd.drp.dpm.common.model.result.AbstractResult;
import kd.drp.mdr.common.model.dpm.DetailItemInfo;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class FullFreePromotionResult
extends AbstractResult {
    private int comparison = 1;
    private String judgestand = "";
    private BigDecimal conditionQty = null;
    private int amtprecision = 2;

    public FullFreePromotionResult(Object resultid, String resulttype) {
        super(resultid, resulttype);
    }

    @Override
    public List<AbstractExecution> calExecution(PromotionOrder order, AbstractCondition condition) {
        String typenumber;
        ArrayList<AbstractExecution> list = new ArrayList<AbstractExecution>();
        ArrayList<PromotionOrderEntry> orderItems = new ArrayList<PromotionOrderEntry>();
        this.conditionQty = this.getResultModel().getBigDecimal("batchqty");
        this.judgestand = this.getResultModel().getString("batchstandard");
        orderItems.addAll(order.getEntries());
        switch (typenumber = this.getResultModel().getDynamicObject("batchtype").getString("number")) {
            case "singleitem": {
                DynamicObject conditionItem = this.getResultModel().getDynamicObject("batchitem");
                Object conditionItemId = conditionItem.getPkValue();
                DynamicObject conditionUnit = this.getResultModel().getDynamicObject("batchunit");
                Object conditionUnitID = conditionUnit != null ? conditionUnit.getPkValue() : Long.valueOf(0L);
                DynamicObject conditionAtrr = this.getResultModel().getDynamicObject("batchattr");
                Object conditionAtrrId = conditionAtrr != null ? conditionAtrr.getPkValue() : Long.valueOf(0L);
                list.addAll(this.executePromotionOnSingleItem(orderItems, conditionItemId, conditionUnitID, conditionAtrrId));
                break;
            }
            case "itemrange": {
                DynamicObject itemRange = this.getResultModel().getDynamicObject("itemrange");
                List<PromotionOrderEntry> matchItems = CompareORCalculateUtil.genEntrysInRange(orderItems, itemRange);
                if (this.getResultModel().getBoolean("israngesplit")) {
                    for (PromotionOrderEntry detailItemInfo : matchItems) {
                        list.addAll(this.executePromotionOnSingleItem(orderItems, detailItemInfo.getItemid(), detailItemInfo.getUnitid(), detailItemInfo.getAttrid()));
                    }
                    break;
                }
                list.addAll(this.executePromotionOnItemRangeWithoutSplit(matchItems));
                break;
            }
            case "wholeorder": {
                if (this.getResultModel().getBoolean("israngesplit")) {
                    HashSet<DetailItemInfo> itemdetails = new HashSet<DetailItemInfo>(orderItems.size());
                    for (PromotionOrderEntry detailItemInfo : orderItems) {
                        if (itemdetails.contains(detailItemInfo.getItemdetail())) continue;
                        itemdetails.add(detailItemInfo.getItemdetail());
                    }
                    for (DetailItemInfo itemdetail : itemdetails) {
                        list.addAll(this.executePromotionOnSingleItem(orderItems, itemdetail.getItemid(), itemdetail.getUnitid(), itemdetail.getAttrid()));
                    }
                    break;
                }
                list.addAll(this.executePromotionOnItemRangeWithoutSplit(orderItems));
            }
        }
        return list;
    }

    private List<EntryAmountDiffExecution> executePromotionOnSingleItem(List<PromotionOrderEntry> orderItems, Object promotionBatchItemId, Object promotionBatchUnitID, Object promotionAtrrId) {
        DynamicObject resultInfo = this.getResultModel();
        List<PromotionOrderEntry> matchPromotionItems = this.getMatchItemsList(orderItems, promotionBatchItemId, promotionBatchUnitID, promotionAtrrId);
        if (matchPromotionItems.size() == 0) {
            return new ArrayList<EntryAmountDiffExecution>();
        }
        if (resultInfo.getBoolean("isactonsingleentry")) {
            return this.executePromotionOnSingleItemByActOnSingEntry(orderItems, matchPromotionItems);
        }
        return this.executePromotionOnSingleItemByActOnWholeEntry(orderItems, matchPromotionItems);
    }

    private List<PromotionOrderEntry> getMatchItemsList(List<PromotionOrderEntry> orderItems, Object promotionBatchItemId, Object promotionBatchUnitID, Object promotionAtrrId) {
        ArrayList<PromotionOrderEntry> matchPromotionItems = new ArrayList<PromotionOrderEntry>();
        PromotionOrderEntry temp = null;
        Object attrId = null;
        for (int i = 0; i < orderItems.size(); ++i) {
            temp = orderItems.get(i);
            attrId = temp.getAttrid();
            if (!promotionBatchItemId.equals(temp.getItemid()) || !promotionBatchUnitID.equals(temp.getUnitid()) || (promotionAtrrId != null || attrId != null) && (promotionAtrrId == null || attrId == null || !promotionAtrrId.equals(attrId)) || temp.isIspresent()) continue;
            matchPromotionItems.add(temp);
        }
        return matchPromotionItems;
    }

    private List<EntryAmountDiffExecution> executePromotionOnSingleItemByActOnSingEntry(List<PromotionOrderEntry> orderItems, List<PromotionOrderEntry> matchPromotionItems) {
        ArrayList<EntryAmountDiffExecution> list = new ArrayList<EntryAmountDiffExecution>();
        for (int i = 0; i < matchPromotionItems.size(); ++i) {
            PromotionOrderEntry entry = matchPromotionItems.get(i);
            int times = 0;
            BigDecimal base = entry.getQtyOrAmount(this.judgestand);
            if (CompareORCalculateUtil.compareWithJudgeValue(base, this.conditionQty, this.comparison)) {
                times = base.divideToIntegralValue(this.conditionQty).intValue();
            }
            BigDecimal fullfreeQty = this.getFreeQty(times);
            BigDecimal freeAmount = entry.getPrice().multiply(fullfreeQty);
            if (freeAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            EntryAmountDiffExecution execution = new EntryAmountDiffExecution(entry.getEntryid(), freeAmount.negate());
            list.add(execution);
            orderItems.remove(entry);
        }
        return list;
    }

    private List<EntryAmountDiffExecution> executePromotionOnSingleItemByActOnWholeEntry(List<PromotionOrderEntry> orderItems, List<PromotionOrderEntry> matchPromotionItems) {
        ArrayList<EntryAmountDiffExecution> list = new ArrayList<EntryAmountDiffExecution>();
        BigDecimal lowestPrice = null;
        BigDecimal promotionBase = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal maximumAmount = BigDecimal.ZERO;
        Object maximumEntryId = null;
        for (int i = 0; i < matchPromotionItems.size(); ++i) {
            PromotionOrderEntry entry = matchPromotionItems.get(i);
            if (lowestPrice == null || entry.getPrice().compareTo(lowestPrice) < 0) {
                lowestPrice = entry.getPrice();
            }
            if (entry.getAmount().compareTo(maximumAmount) >= 0) {
                maximumAmount = entry.getAmount();
                maximumEntryId = entry.getEntryid();
            }
            promotionBase = promotionBase.add(entry.getQtyOrAmount(this.judgestand));
            totalAmount = totalAmount.add(entry.getAmount());
        }
        int times = 0;
        if (CompareORCalculateUtil.compareWithJudgeValue(promotionBase, this.conditionQty, this.comparison)) {
            times = promotionBase.divideToIntegralValue(this.conditionQty).intValue();
        }
        BigDecimal fullfreeQty = this.getFreeQty(times);
        if (lowestPrice == null) {
            lowestPrice = BigDecimal.ZERO;
        }
        BigDecimal totalFreeAmount = lowestPrice.multiply(fullfreeQty);
        if (promotionBase.compareTo(this.conditionQty) >= 0) {
            for (int i = 0; i < matchPromotionItems.size(); ++i) {
                PromotionOrderEntry entry = matchPromotionItems.get(i);
                Object entryId = entry.getEntryid();
                if (entryId == null || entryId.equals(maximumEntryId)) continue;
                BigDecimal qtyRate = entry.getAmount().divide(totalAmount, 10, 1);
                BigDecimal freeAmount = fullfreeQty.multiply(lowestPrice).multiply(qtyRate).setScale(this.amtprecision, 1);
                totalFreeAmount = totalFreeAmount.subtract(freeAmount);
                list.add(new EntryAmountDiffExecution(entryId, freeAmount.negate()));
            }
            list.add(new EntryAmountDiffExecution(maximumEntryId, totalFreeAmount.negate()));
            orderItems.removeAll(matchPromotionItems);
        }
        return list;
    }

    private List<EntryAmountDiffExecution> executePromotionOnItemRangeWithoutSplit(List<PromotionOrderEntry> matchPromotionItems) {
        return null;
    }

    private BigDecimal getFreeQty(int times) {
        DynamicObject resultInfo = this.getResultModel();
        BigDecimal resultFreeQty = resultInfo.getBigDecimal("batchfullfreeqty");
        BigDecimal limitQty = resultInfo.getBigDecimal("maxfullfreeqty");
        BigDecimal fullfreeQty = resultFreeQty.multiply(new BigDecimal(times));
        if (limitQty.compareTo(BigDecimal.ZERO) != 0 && fullfreeQty.compareTo(limitQty) > 0) {
            fullfreeQty = limitQty;
        }
        return fullfreeQty;
    }
}

