/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;

public class GoodsInfoUtil {
    public static QFilter getBarCodeIdFilter(long branchId, long currencyId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        List<Long> lstBarCodeId = GoodsInfoUtil.getGoodsInfoList(branchId, currencyId, Boolean.FALSE);
        qFilter.and("id", "in", (Object)lstBarCodeId.stream().distinct().toArray());
        return qFilter;
    }

    public static QFilter getBarCodeIdGoodsCur(long goodsId, long currencyId) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("item.Id", "=", (Object)goodsId);
        qFilter.and("currency.Id", "=", (Object)currencyId);
        return qFilter;
    }

    public static QFilter getBarCodeIdFilter(long branchId, long goodsId, long currencyId) {
        QFilter qFilter = GoodsInfoUtil.getBarCodeIdFilter(branchId, currencyId);
        qFilter.and("item.Id", "=", (Object)goodsId);
        return qFilter;
    }

    public static QFilter getGoodsIdFilter(long branchId, long currencyId) {
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        List<Long> lstGoodsId = GoodsInfoUtil.getGoodsInfoList(branchId, currencyId, Boolean.TRUE);
        qFilter.and("id", "in", (Object)lstGoodsId.stream().distinct().toArray());
        return qFilter;
    }

    private static List<Long> getGoodsInfoList(long branchId, long currencyId, boolean type) {
        List<Map<String, Long>> data = GoodsInfoUtil.getSaleItemContent(branchId, currencyId);
        if (data.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList result = new ArrayList();
        if (type) {
            result.clear();
            data.forEach(p -> result.add(p.get("goodsid")));
        } else {
            result.clear();
            data.forEach(p -> result.add(p.get("barcode")));
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private static List<Map<String, Long>> getSaleItemContent(long branchId, long currencyId) {
        QFilter filter = F7Utils.getEnableFilter();
        filter.and("customer.Id", "=", (Object)branchId);
        filter.and("retailprice", "!=", (Object)BigDecimal.ZERO);
        filter.and("currency.Id", "=", (Object)currencyId);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)"Id,barcode.Id,item.Id", (QFilter[])filter.toArray());
        if (data == null || data.isEmpty()) {
            return new ArrayList<Map<String, Long>>();
        }
        ArrayList<Map<String, Long>> result = new ArrayList<Map<String, Long>>();
        for (DynamicObject item : data) {
            HashMap<String, Long> map = new HashMap<String, Long>(2);
            map.put("goodsid", item.getLong("item.Id"));
            map.put("barcode", item.getLong("barcode.Id"));
            result.add(map);
        }
        return result;
    }
}

