/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.opplugin.promotionlimit.validator.PromotionLimitValidator;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class PromotionLimitSavePlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("qtylimititems");
        fieldKeys.add("isactonpolicy");
        fieldKeys.add("policy");
        fieldKeys.add("starttime");
        fieldKeys.add("endtime");
        fieldKeys.add("customerrangeid");
        fieldKeys.add("usedbaseqty");
        fieldKeys.add("promotionpolicy");
        fieldKeys.add("item");
        fieldKeys.add("attr");
        fieldKeys.add("owner");
        fieldKeys.add("enable");
        fieldKeys.add("item");
        fieldKeys.add("unit");
        fieldKeys.add("limitqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PromotionLimitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] promotionLimitObjs = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("audit".equals(operationKey)) {
            for (DynamicObject promotionLimitObj : promotionLimitObjs) {
                DynamicObjectCollection promotionPolicyEntry = promotionLimitObj.getDynamicObjectCollection("policy");
                ArrayList<DynamicObject> limitContentObjs = new ArrayList<DynamicObject>();
                for (DynamicObject promotionPolicyEntryObj : promotionPolicyEntry) {
                    DynamicObject limitContentObj;
                    DynamicObject promotionPolicyObj = promotionPolicyEntryObj.getDynamicObject("promotionpolicy");
                    Object limitContentId = DynamicObjectUtils.getPkId((DynamicObject)promotionPolicyObj, (String)"limitcontent");
                    if (limitContentId == null || !(limitContentObj = BusinessDataServiceHelper.loadSingle((Object)limitContentId, (String)"dpm_limit_content", (String)"islimit,entryentity,entryentity.item,entryentity.unit,entryentity.limitqty,entryentity.attr")).getBoolean("islimit")) continue;
                    DynamicObjectCollection itemEntry = limitContentObj.getDynamicObjectCollection("entryentity");
                    DynamicObjectCollection limitItemEntry = promotionLimitObj.getDynamicObjectCollection("qtylimititems");
                    for (DynamicObject itemLimitObj : limitItemEntry) {
                        Object itemId = DynamicObjectUtils.getPkId((DynamicObject)itemLimitObj, (String)"item");
                        Object unitId = DynamicObjectUtils.getPkId((DynamicObject)itemLimitObj, (String)"unit");
                        BigDecimal limitQty = itemLimitObj.getBigDecimal("limitqty");
                        Object attrId = DynamicObjectUtils.getPkId((DynamicObject)itemLimitObj, (String)"attr");
                        Optional<DynamicObject> itemEntryOptional = itemEntry.stream().filter(obj -> DynamicObjectUtils.getPkId((DynamicObject)obj, (String)"item") == itemId && DynamicObjectUtils.getPkId((DynamicObject)obj, (String)"unit") == unitId && DynamicObjectUtils.getPkId((DynamicObject)obj, (String)"attr") == attrId).findFirst();
                        if (!itemEntryOptional.isPresent()) continue;
                        itemEntryOptional.get().set("limitqty", (Object)limitQty);
                    }
                    limitContentObjs.add(limitContentObj);
                }
                SaveServiceHelper.save((DynamicObject[])limitContentObjs.toArray(new DynamicObject[limitContentObjs.size()]));
            }
        }
    }
}

