/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.drp.dpm.opplugin.PromotionPolicyOPPlugin;

public class PromotionPolicyEnablePlugin
extends PromotionPolicyOPPlugin {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("starttime");
        e.getFieldKeys().add("scheduletype");
        e.getFieldKeys().add("schedulevalues");
    }

    @Override
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Calendar c = Calendar.getInstance();
        Integer dayofmonth = c.get(5);
        Integer dayofweek = c.get(7);
        c.set(10, 23);
        c.set(12, 59);
        c.set(13, 59);
        DynamicObject[] objs = e.getDataEntities();
        ArrayList policydayslist = new ArrayList();
        for (DynamicObject policy : objs) {
            if (policy.getDate("starttime").after(c.getTime())) continue;
            String type = policy.getString("scheduletype");
            if (type == null || type.trim().isEmpty() || "day".equals(type)) {
                this.putIntoList(policydayslist, policy);
                continue;
            }
            String values = policy.getString("schedulevalues");
            if ("week".equals(type) && this.isInValues(values, dayofweek)) {
                this.putIntoList(policydayslist, policy);
            }
            if (!"month".equals(type) || !this.isInValues(values, dayofmonth)) continue;
            this.putIntoList(policydayslist, policy);
        }
        DynamicObject[] arr = policydayslist.toArray(new DynamicObject[policydayslist.size()]);
        SaveServiceHelper.save((DynamicObject[])objs);
        SaveServiceHelper.save((DynamicObject[])arr);
    }

    private void putIntoList(List list, DynamicObject policy) {
        String datestr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        DynamicObject policyvalidday = BusinessDataServiceHelper.newDynamicObject((String)"dpm_policyvaliddays");
        policyvalidday.set("policy", policy.get("id"));
        policyvalidday.set("date", (Object)datestr);
        list.add(policyvalidday);
    }

    private boolean isInValues(String values, int value) {
        boolean flag = false;
        if (!StringUtils.isEmpty((String)values)) {
            String[] arr = values.split(",");
            for (int i = 0; i < arr.length; ++i) {
                if (value != Integer.parseInt(arr[i])) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

