/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class PromotionPolicyOPPlugin
extends MdrBaseOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("policystatus");
        e.getFieldKeys().add("limitcontent");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] op = e.getOperationKey();
        String status = null;
        switch (op) {
            case "save": {
                status = "A";
                break;
            }
            case "submit": {
                status = "B";
                break;
            }
            case "unsubmit": {
                status = "A";
                break;
            }
            case "audit": {
                status = "C";
                break;
            }
            case "unaudit": {
                status = "A";
                break;
            }
            case "enable": {
                status = "D";
                break;
            }
            case "disable": {
                status = "E";
            }
        }
        for (DynamicObject policy : e.getDataEntities()) {
            policy.set("policystatus", (Object)status);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] datas = e.getDataEntities();
        switch (key) {
            case "audit": {
                HashSet<Object> promotionids = new HashSet<Object>(datas.length);
                for (DynamicObject object : datas) {
                    if (object.getDynamicObject("limitcontent") == null) continue;
                    promotionids.add(object.getPkValue());
                }
                if (promotionids.size() <= 0) break;
                Set idSet = (Set)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dpm", (String)"PromotionService", (String)"getPromotionByLimit", (Object[])new Object[]{promotionids.toArray()});
                promotionids.removeAll(idSet);
                Set operateErrorInfos = (Set)DispatchServiceHelper.invokeBizService((String)"drp", (String)"dpm", (String)"PromotionService", (String)"CreateLimitBill", (Object[])new Object[]{promotionids.toArray()});
                if (operateErrorInfos == null) break;
                this.operationResult.setAllErrorInfo(new ArrayList(operateErrorInfos));
                break;
            }
        }
    }
}

