/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.opplugin.MdrBaseOperationServicePlugIn;

public class PromotionValidDaysRefreshPlugin
extends MdrBaseOperationServicePlugIn {
    private String datestr = new SimpleDateFormat("yyyy-MM-dd").format(new Date());

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Integer dayofmonth = Calendar.getInstance().get(5);
        Integer dayofweek = Calendar.getInstance().get(7);
        DeleteServiceHelper.delete((String)"dpm_policyvaliddays", null);
        QFilter filter = new QFilter("policystatus", "=", (Object)"D");
        filter.and(new QFilter("starttime", "<=", (Object)(this.datestr + " 23:59:59")));
        DynamicObjectCollection policycol = QueryServiceHelper.query((String)"dpm_policy", (String)"id,scheduletype,schedulevalues", (QFilter[])new QFilter[]{filter});
        ArrayList policydayslist = new ArrayList();
        for (DynamicObject policy : policycol) {
            String type = policy.getString("scheduletype");
            if (type == null || type.trim().isEmpty() || "day".equals(type)) {
                this.putIntoList(policydayslist, policy);
                continue;
            }
            String values = policy.getString("schedulevalues");
            if ("week".equals(type) && this.isInValues(values, dayofweek)) {
                this.putIntoList(policydayslist, policy);
            }
            if (!"month".equals(type) || !this.isInValues(values, dayofmonth)) continue;
            this.putIntoList(policydayslist, policy);
        }
        DeleteServiceHelper.delete((String)"dpm_policyvaliddays", null);
        DynamicObject[] arr = policydayslist.toArray(new DynamicObject[policydayslist.size()]);
        SaveServiceHelper.save((DynamicObject[])arr);
    }

    private void putIntoList(List list, DynamicObject policy) {
        DynamicObject policyvalidday = BusinessDataServiceHelper.newDynamicObject((String)"dpm_policyvaliddays");
        policyvalidday.set("policy", policy.get("id"));
        policyvalidday.set("date", (Object)this.datestr);
        list.add(policyvalidday);
    }

    private boolean isInValues(String values, int value) {
        String[] arr = values.split(",");
        boolean flag = false;
        for (int i = 0; i < arr.length; ++i) {
            if (value != Integer.parseInt(arr[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

