/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin.promotionlimit.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.config.client.util.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.model.CheckResult;
import kd.drp.mdr.validator.BatchFastValidator;

public class PromotionLimitValidator
extends BatchFastValidator {
    public void otherOP(String opKey, ExtendedDataEntity[] datas) {
        CheckResult result = null;
        if (opKey.compareTo("enable") == 0) {
            HashSet<Object> limitIds = new HashSet<Object>();
            for (ExtendedDataEntity data : datas) {
                DynamicObject limitData = data.getDataEntity();
                result = this.check(limitData, limitIds, opKey);
                if (!result.isSuccess()) {
                    this.addFatalErrorMessage(data, result.getMsg());
                    continue;
                }
                limitIds.add(limitData.getPkValue());
            }
        }
    }

    public void save(ExtendedDataEntity[] datas) {
        super.save(datas);
    }

    public void submit(ExtendedDataEntity[] datas) {
        super.submit(datas);
        CheckResult result = null;
        HashSet<Object> limitIds = new HashSet<Object>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject limitData = data.getDataEntity();
            if (!limitData.getBoolean("enable")) continue;
            result = this.check(limitData, limitIds, "submit");
            if (!result.isSuccess()) {
                this.addFatalErrorMessage(data, result.getMsg());
                continue;
            }
            limitIds.add(limitData.getPkValue());
        }
    }

    public void audit(ExtendedDataEntity[] datas) {
        super.audit(datas);
    }

    public void unaudit(ExtendedDataEntity[] datas) {
        super.unaudit(datas);
        block0: for (ExtendedDataEntity data : datas) {
            DynamicObject dynamicObject = data.getDataEntity();
            DynamicObjectCollection qtylimititems = dynamicObject.getDynamicObjectCollection("qtylimititems");
            if (qtylimititems == null || qtylimititems.size() == 0) continue;
            for (DynamicObject qtylimititem : qtylimititems) {
                if (qtylimititem.getBigDecimal("usedbaseqty").compareTo(BigDecimal.ZERO) <= 0) continue;
                this.addFatalErrorMessage(data, "\u5df2\u6709\u5546\u54c1\u4f7f\u7528\u4e86\u9650\u91cf\u89c4\u5219\uff0c\u4e0d\u53ef\u53cd\u5ba1\u6838!");
                continue block0;
            }
        }
    }

    private CheckResult check(DynamicObject data, Set<Object> limitIds, String opKey) {
        CheckResult result = this.checkPolicyDuplication(data, limitIds, opKey);
        if (!result.isSuccess()) {
            return result;
        }
        result = this.checkDateDuplication(data, limitIds, opKey);
        if (!result.isSuccess()) {
            return result;
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkPolicyDuplication(DynamicObject data, Set<Object> limitIds, String opKey) {
        Boolean isactonpolicy = data.getBoolean("isactonpolicy");
        StringBuilder errorInfo = new StringBuilder();
        if (isactonpolicy.booleanValue()) {
            DynamicObjectCollection policys = data.getDynamicObjectCollection("policy");
            if (policys == null || policys.size() == 0) {
                errorInfo.append("\u542f\u7528\u5bf9\u4fc3\u9500\u653f\u7b56\u9650\u91cf\uff0c\u9650\u91cf\u4fc3\u9500\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                ArrayList<Long> policyIds = new ArrayList<Long>();
                long policyId = 0L;
                for (DynamicObject policy : policys) {
                    policyId = (Long)policy.getDynamicObject("promotionpolicy").getPkValue();
                    if (policyIds.contains(policy)) {
                        errorInfo.append("\u9650\u91cf\u4fc3\u9500\u653f\u7b56,\u5b58\u5728\u91cd\u590d\u4fc3\u9500\u653f\u7b56");
                        continue;
                    }
                    policyIds.add(policyId);
                }
                if (policyIds.size() > 0) {
                    HashSet<String> status = new HashSet<String>();
                    QFilter f = new QFilter("policy.promotionpolicy", "in", policyIds);
                    if (opKey.compareTo("enable") == 0) {
                        f.and("status", "in", (Object)new char[]{'B', 'C'});
                        status.add("1");
                    } else {
                        f.and("enable", "=", (Object)"1");
                        status.add("B");
                        status.add("C");
                    }
                    DynamicObject[] limits = BusinessDataServiceHelper.load((String)data.getDynamicObjectType().getName(), (String)"number,status,starttime,endtime,enable,name,policy.promotionpolicy", (QFilter[])f.toArray());
                    if (limits != null && limits.length > 0) {
                        StringBuilder policyinfos = null;
                        Object id = null;
                        Date start = data.getDate("starttime");
                        Date end = data.getDate("endtime");
                        for (DynamicObject limit : limits) {
                            id = limit.getPkValue();
                            if (data.getPkValue().equals(id) || (opKey.compareTo("enable") != 0 ? !limitIds.contains(id) && !status.contains(limit.getString("status")) : !limitIds.contains(id) && !status.contains(limit.getString("enable")))) continue;
                            if (!this.chenckTime(start, end, limit)) continue;
                            policys = limit.getDynamicObjectCollection("policy");
                            policyinfos = new StringBuilder();
                            if (policys != null) {
                                int i = 0;
                                for (DynamicObject policy : policys) {
                                    if (i != 0) {
                                        policyinfos.append('\u3001');
                                    }
                                    ++i;
                                    DynamicObject promotionpolicy = policy.getDynamicObject("promotionpolicy");
                                    policyinfos.append(String.format("%s.%s", promotionpolicy.get("number"), promotionpolicy.get("name")));
                                }
                            }
                            if (policyinfos == null || policyinfos.length() <= 0) continue;
                            if (opKey.compareTo("enable") == 0) {
                                errorInfo.append(String.format("%s\u5df2\u5173\u8054\u9650\u91cf\u89c4\u5219%s.%s\uff0c\u65e0\u6cd5\u542f\u7528\u3002", policyinfos, limit.get("number"), limit.get("name")));
                                continue;
                            }
                            errorInfo.append(String.format("%s\u5df2\u5173\u8054\u9650\u91cf\u89c4\u5219%s.%s\uff0c\u8bf7\u52ff\u91cd\u590d\u3002", policyinfos, limit.get("number"), limit.get("name")));
                        }
                    }
                }
            }
        }
        if (errorInfo.length() > 0) {
            return CheckResult.returnFalse((String)errorInfo.toString());
        }
        return CheckResult.returnTrue();
    }

    private CheckResult checkDateDuplication(DynamicObject data, Set<Object> limitIds, String opKey) {
        StringBuilder errorInfo = new StringBuilder();
        if (data.getDate("starttime").after(data.getDate("endtime"))) {
            errorInfo.append("\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4 \n");
        }
        DynamicObjectCollection qtylimititems = data.getDynamicObjectCollection("qtylimititems");
        long id = 0L;
        if (qtylimititems == null || qtylimititems.size() == 0) {
            errorInfo.append("\u9650\u91cf\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a \n");
        } else {
            ArrayList<String> iteminfos = new ArrayList<String>();
            DynamicObject item = null;
            DynamicObject attr = null;
            for (DynamicObject qtylimititem : qtylimititems) {
                String iteminfo = "";
                item = qtylimititem.getDynamicObject("item");
                if (item == null) continue;
                id = (Long)item.getPkValue();
                iteminfo = String.valueOf(id);
                attr = qtylimititem.getDynamicObject("attr");
                if (attr != null) {
                    id = (Long)attr.getPkValue();
                    iteminfo = String.format("%s,%s", iteminfo, id);
                }
                if (StringUtils.isEmpty((String)iteminfo)) continue;
                if (iteminfos.contains(iteminfo)) {
                    if (iteminfo.contains(",")) {
                        errorInfo.append(String.format("\u9650\u91cf\u5185\u5bb9\u5546\u54c1%s\u8f85\u52a9\u5c5e\u6027%s\u51fa\u73b0\u91cd\u590d \n", item.get("name"), qtylimititem.getDynamicObject("attr").get("name")));
                        continue;
                    }
                    errorInfo.append(String.format("\u9650\u91cf\u5185\u5bb9\u5546\u54c1%s\u51fa\u73b0\u91cd\u590d \n", item.get("name")));
                    continue;
                }
                iteminfos.add(iteminfo);
            }
        }
        if (errorInfo.length() > 0) {
            return CheckResult.returnFalse((String)errorInfo.toString());
        }
        return CheckResult.returnTrue();
    }

    private boolean chenckTime(Date start, Date end, DynamicObject limit) {
        Date starttime = limit.getDate("starttime");
        Date endtime = limit.getDate("endtime");
        if (starttime.getTime() <= start.getTime() && endtime.getTime() >= start.getTime()) {
            return true;
        }
        return starttime.getTime() >= start.getTime() && starttime.getTime() <= end.getTime();
    }
}

