/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.opplugin.retailprice.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.util.PriceTypeUtil;

public class RetailPriceSaveValidator
extends AbstractValidator {
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String SELECTED_ROW = "id, pricedetailentity.id, pricedetailentity.retailprice, pricedetailentity.rpadjustnum, pricedetailentity.uniqueprice, pricedetailentity.upadjustnum, pricedetailentity.factoryprice, pricedetailentity.fpadjustnum, pricedetailentity.memberprice, pricedetailentity.mpadjustnum, pricedetailentity.specialprice, pricedetailentity.spadjustnum, pricedetailentity.price1, pricedetailentity.price2, pricedetailentity.price3, pricedetailentity.price4, pricedetailentity.price5, pricedetailentity.p1adjustnum, pricedetailentity.p2adjustnum, pricedetailentity.p3adjustnum, pricedetailentity.p4adjustnum, pricedetailentity.p5adjustnum";

    public void validate() {
        String key;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length <= 0) {
            return;
        }
        switch (key = this.getOperateKey()) {
            case "save": 
            case "submit": {
                this.checkUseRange(dataEntities);
                this.checkItemPirce(dataEntities);
                break;
            }
        }
    }

    private void checkUseRange(ExtendedDataEntity[] dataEntities) {
        DynamicObject obj = null;
        DynamicObjectCollection useRanges = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            obj = dataEntity.getDataEntity();
            if (!"920045548189278208".equals(obj.getDynamicObject("billtype").getPkValue().toString()) || (useRanges = obj.getDynamicObjectCollection("userangeentity")).size() != 0) continue;
            this.addErrorMessage(dataEntity, "\u8bf7\u9009\u62e9\u9002\u7528\u95e8\u5e97\u8303\u56f4");
            return;
        }
    }

    private void checkItemPirce(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject currenctObj = dataEntity.getDataEntity();
            Boolean isdistributed = currenctObj.getBoolean("isdistributed");
            if (!isdistributed.booleanValue() && currenctObj.getDynamicObjectCollection("pricedetailentity").size() == 0) {
                this.addErrorMessage(dataEntity, "\u4ef7\u683c\u660e\u7ec6\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199");
                return;
            }
            this.checkItemPirceEntity(dataEntity);
        }
    }

    private void checkItemPirceEntity(ExtendedDataEntity dataEntity) {
        DynamicObject currentObj = dataEntity.getDataEntity();
        boolean isDistributed = currentObj.getBoolean("isdistributed");
        if (!isDistributed) {
            DynamicObject retailPrice = dataEntity.getDataEntity();
            Date effectDate = retailPrice.getDate("effectdate");
            Date invalidDate = retailPrice.getDate("invaliddate");
            if (effectDate != null && invalidDate != null && invalidDate.compareTo(effectDate) <= 0) {
                this.addErrorMessage(dataEntity, "\u5931\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002");
                return;
            }
            DynamicObjectCollection itemPirceList = retailPrice.getDynamicObjectCollection("pricedetailentity");
            DynamicObject itemPrice = null;
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            StringBuilder sb = null;
            for (int i = 0; i < itemPirceList.size(); ++i) {
                itemPrice = (DynamicObject)itemPirceList.get(i);
                int seq = itemPrice.getInt("seq");
                sb = new StringBuilder();
                sb.append(itemPrice.getDynamicObject("item").getPkValue());
                sb.append(itemPrice.getDynamicObject("barcode").getPkValue());
                sb.append(itemPrice.getDynamicObject("priceunit") == null ? Integer.valueOf(0) : itemPrice.getDynamicObject("priceunit").getPkValue());
                if (map.containsKey(sb.toString())) {
                    this.addErrorMessage(dataEntity, "\u4ef7\u683c\u660e\u7ec6" + map.get(sb.toString()) + ", " + seq + "\u4e24\u884c\u6570\u636e\u5546\u54c1\u7f16\u7801\uff0c\u6761\u5f62\u7801\uff0c\u8ba1\u4ef7\u5355\u4f4d\u76f8\u540c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                } else {
                    map.put(sb.toString(), seq);
                }
                Date priceInvalidDate = itemPrice.getDate("priceinvaliddate");
                Date priceEffectDate = itemPrice.getDate("priceeffectdate");
                if (priceInvalidDate != null && priceEffectDate != null && priceInvalidDate.compareTo(priceEffectDate) <= 0) {
                    this.addErrorMessage(dataEntity, String.format("\u4ef7\u683c\u660e\u7ec6\u7b2c%d\u884c\u5931\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq));
                    return;
                }
                if (effectDate != null && priceEffectDate != null && priceEffectDate.compareTo(effectDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format("\u4ef7\u683c\u660e\u7ec6\u7b2c%d\u884c\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u4ef7\u76ee\u8868\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq));
                    return;
                }
                if (invalidDate != null && priceInvalidDate != null && invalidDate.compareTo(priceInvalidDate) < 0) {
                    this.addErrorMessage(dataEntity, String.format("\u4ef7\u683c\u660e\u7ec6\u7b2c%d\u884c\u5931\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u4ef7\u76ee\u8868\u5931\u6548\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq));
                    return;
                }
                if (itemPrice.getBigDecimal("lowprice").compareTo(itemPrice.getBigDecimal("highprice")) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format("\u4ef7\u683c\u660e\u7ec6\u7b2c%d\u884c\u6700\u4f4e\u4ef7\u9ad8\u4e8e\u6700\u9ad8\u4ef7\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u3002", seq));
                return;
            }
        }
        this.checkPriceChangedCounts(dataEntity);
    }

    private void checkPriceChangedCounts(ExtendedDataEntity data) {
        DynamicObject dataEntity = data.getDataEntity();
        List currentPriceTypes = PriceTypeUtil.getCurrentPriceType((DynamicObject)dataEntity);
        DynamicObject baseDatas = null;
        DynamicObject billtype = (DynamicObject)dataEntity.get("billtype");
        if (!"920289759207803904".equals(billtype.getPkValue().toString())) {
            return;
        }
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("pricedetailentity");
        if (col.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("id", "=", dataEntity.getPkValue());
        DynamicObjectCollection priceDetails = this.queryPriceDetails(filter);
        HashMap<Object, DynamicObject> detailMap = new HashMap<Object, DynamicObject>(16);
        Map priceMap = PriceTypeUtil.getPriceMap();
        if (priceDetails != null && priceDetails.size() > 0) {
            for (DynamicObject detail : priceDetails) {
                if (detail.getLong("pricedetailentity.id") == 0L) continue;
                detailMap.put(detail.get("pricedetailentity.id"), detail);
            }
            for (int i = 0; i < col.size(); ++i) {
                baseDatas = (DynamicObject)detailMap.get(((DynamicObject)col.get(i)).getPkValue());
                if (baseDatas != null) {
                    for (String priceType : currentPriceTypes) {
                        this.checkPriceChanged(priceType, (DynamicObject)priceMap.get(priceType), i, (DynamicObject)col.get(i), baseDatas, data);
                    }
                    continue;
                }
                for (String priceType : currentPriceTypes) {
                    this.checkPriceBeforeSave((DynamicObject)col.get(i), i, data, priceType, (DynamicObject)priceMap.get(priceType));
                }
            }
        }
    }

    private DynamicObjectCollection queryPriceDetails(QFilter qFilter) {
        return QueryServiceHelper.query((String)"dpm_retailpricelist", (String)SELECTED_ROW, (QFilter[])new QFilter[]{qFilter});
    }

    private void checkPriceChanged(String priceType, DynamicObject priceTypeObj, int i, DynamicObject viewData, DynamicObject databaseData, ExtendedDataEntity data) {
        BigDecimal basedataPrice;
        BigDecimal viewPrice = viewData.getBigDecimal(priceType);
        if (viewPrice.compareTo(basedataPrice = databaseData.getBigDecimal("pricedetailentity." + priceType)) == 0) {
            return;
        }
        if (!priceTypeObj.getBoolean("isallowadjust")) {
            this.addErrorMessage(data, "\u7b2c" + (i + 1) + "\u884c" + PriceTypeUtil.getNameByPriceType((String)priceType) + "\u4e0d\u5141\u8bb8\u8c03\u6574");
            return;
        }
        int allowJustNum = priceTypeObj.getInt("allowadjustnum");
        int justedNum = databaseData.getInt("pricedetailentity." + PriceTypeUtil.getAdjustNumByPriceType((String)priceType));
        if (justedNum >= allowJustNum) {
            this.addErrorMessage(data, "\u7b2c" + (i + 1) + "\u884c" + PriceTypeUtil.getNameByPriceType((String)priceType) + "\u5df2\u8fbe\u5230\u6700\u5927\u8c03\u6574\u6b21\u6570\uff0c\u4e0d\u5141\u8bb8\u8c03\u6574");
            return;
        }
    }

    private void checkPriceBeforeSave(DynamicObject viewData, int i, ExtendedDataEntity data, String priceType, DynamicObject priceTypeObj) {
        DynamicObject barcode = null;
        BigDecimal barcodePrice = null;
        BigDecimal viewPrice = null;
        DynamicObject parent = (DynamicObject)viewData.getParent();
        if (!"retailprice".equals(priceType) && !"memberprice".equals(priceType)) {
            return;
        }
        boolean isDistributed = parent.getBoolean("isdistributed");
        if (isDistributed) {
            return;
        }
        barcode = viewData.getDynamicObject("barcode");
        if (barcode == null) {
            return;
        }
        barcodePrice = barcode.getBigDecimal(priceType);
        if (barcodePrice.compareTo(viewPrice = viewData.getBigDecimal(priceType)) == 0) {
            return;
        }
        if (!priceTypeObj.getBoolean("isallowadjust")) {
            this.addErrorMessage(data, "\u7b2c" + (i + 1) + "\u884c" + PriceTypeUtil.getNameByPriceType((String)priceType) + "\u4e0d\u5141\u8bb8\u8c03\u6574");
            return;
        }
    }
}

