/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.business.retailprice;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.common.retailprice.vo.DistributeOpResult;
import kd.drp.dpm.common.util.CommonUtil;

public class RetailItemPriceHelper {
    private static String[] PRICE_TYPES = new String[]{"rpcheckbox", "fpcheckbox", "upcheckbox", "mpcheckbox", "spcheckbox", "p1checkbox", "p2checkbox", "p3checkbox", "p4checkbox", "p5checkbox"};
    private static final String KEY_MDR_CUSTOMER = "mdr_customer";
    private static final String NAME = "name";
    private static final String OP_SAVE = "save";
    private static Log logger = LogFactory.getLog(RetailItemPriceHelper.class);

    public static List<DistributeOpResult> distributeItemPriceToBranches(Object pkValue, List<Object> branchList) {
        ArrayList<DistributeOpResult> resultList = new ArrayList<DistributeOpResult>(16);
        if (branchList == null || branchList.size() == 0) {
            resultList.add(new DistributeOpResult(false, "\u5206\u914d\u6e20\u9053\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u9009\u62e9\u4e86\u5206\u914d\u6e20\u9053\u3002"));
            return resultList;
        }
        DynamicObject distributeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pkValue, (String)"dpm_retailpricelist");
        if (distributeObj == null) {
            resultList.add(new DistributeOpResult(false, "\u4ef7\u76ee\u8868\u6570\u636e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u88ab\u5220\u9664\u3002"));
            return resultList;
        }
        if (resultList.size() > 0) {
            return resultList;
        }
        int seq = 1;
        ArrayList<Object> successBranches = new ArrayList<Object>(branchList.size());
        DynamicObject mdrCustomer = null;
        DistributeOpResult result = null;
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)KEY_MDR_CUSTOMER).getDataEntityType();
        DynamicObject[] mdrCustomers = (DynamicObject[])BusinessDataServiceHelper.load((Object[])branchList.toArray(), (IDataEntityType)dataEntityType);
        for (int i = 0; i < mdrCustomers.length; ++i) {
            result = new DistributeOpResult();
            mdrCustomer = mdrCustomers[i];
            if (!mdrCustomer.getDynamicObject("currency").getPkValue().equals(distributeObj.getDynamicObject("currency").getPkValue())) {
                result.setStatus(false);
                result.setOpMessage(mdrCustomer.getString(NAME) + "\u6e20\u9053\u7ed3\u7b97\u5e01\u522b\u4e0e\u603b\u90e8\u5e01\u522b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5206\u914d\u3002");
            } else {
                DynamicObjectCollection mdrItems = RetailItemPriceHelper.getSaleContent(mdrCustomer);
                if (mdrItems.size() == 0) {
                    result.setStatus(false);
                    result.setOpMessage("\u95e8\u5e97" + mdrCustomer.get(NAME) + "\u7ecf\u8425\u76ee\u5f55\u4e0b\u65e0\u5546\u54c1\uff0c\u5206\u914d\u5931\u8d25");
                } else {
                    Set<Object> retain = RetailItemPriceHelper.getRetain(mdrItems, distributeObj);
                    if (retain.size() == 0) {
                        result.setStatus(false);
                        result.setOpMessage("\u5f53\u524d\u95e8\u5e97" + mdrCustomer.get(NAME) + "\u7ecf\u8425\u76ee\u5f55\u4e2d\u7684\u5546\u54c1\u5747\u4e0d\u5728\u603b\u90e8\u4ef7\u76ee\u8868\u4e2d\uff0c\u5206\u914d\u5931\u8d25");
                    } else {
                        try {
                            DynamicObject newRetailPrice = RetailItemPriceHelper.buildNewRetailPrice(distributeObj, mdrCustomer, seq);
                            OperationResult saveOperation = OperationServiceHelper.executeOperate((String)OP_SAVE, (String)"dpm_retailpricelist", (DynamicObject[])new DynamicObject[]{newRetailPrice}, (OperateOption)OperateOption.create());
                            if (saveOperation != null && !saveOperation.isSuccess()) {
                                result.setStatus(false);
                                result.setOpMessage(saveOperation.getMessage());
                            } else {
                                successBranches.add(mdrCustomer.getPkValue());
                                result.setStatus(true);
                                result.setOpMessage(mdrCustomer.get(NAME) + " \u6e20\u9053\u4ef7\u76ee\u8868\u5206\u914d\u6210\u529f");
                            }
                        }
                        catch (KDBizException exception) {
                            logger.error("\u95e8\u5e97\u4ef7\u76ee\u8868\u4fdd\u5b58\u5931\u8d25", (Throwable)exception);
                            result = new DistributeOpResult(false, exception.getMessage());
                        }
                    }
                }
            }
            ++seq;
            resultList.add(result);
        }
        RetailItemPriceHelper.updateHasdistributedToSourceBill(distributeObj, successBranches, true);
        return resultList;
    }

    private static void updateHasdistributedToSourceBill(DynamicObject retailPrice, List<Object> branches, boolean hasdistributed) {
        if (retailPrice == null || CommonUtil.listIsEmpty(branches)) {
            return;
        }
        DynamicObjectCollection useRangeEntity = retailPrice.getDynamicObjectCollection("userangeentity");
        for (DynamicObject useRange : useRangeEntity) {
            DynamicObject branch = useRange.getDynamicObject("pricebranch");
            if (branch == null || !branches.contains(branch.getPkValue())) continue;
            useRange.set("hasdistributed", (Object)hasdistributed);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{retailPrice});
    }

    private static DynamicObject buildNewRetailPrice(DynamicObject dtRetailPrice, DynamicObject customer, int index) throws KDBizException {
        if (customer == null) {
            throw new KDBizException(ResManager.loadKDString((String)String.format("\u7b2c%d\u884c\u6e20\u9053\u627e\u4e0d\u5230\u5bf9\u5e94\u6e20\u9053\u4fe1\u606f\uff0c\u5206\u914d\u4ef7\u76ee\u8868\u5931\u8d25\u3002", index), (String)"RetailPriceDistributePlugin_0", (String)"drp-dpm-opplugin", (Object[])new Object[0]));
        }
        logger.info("\u6e20\u9053" + customer.getString(NAME) + "\u6784\u5efa\u4ef7\u76ee\u8868\u5f00\u59cb" + new Date());
        DynamicObject bizGroup = customer.getDynamicObject("bizgroup");
        if (bizGroup == null) {
            throw new KDBizException(ResManager.loadKDString((String)String.format("\u7b2c%d\u884c\u6e20\u9053\u5bf9\u5e94\u7ec4\u7ec7\u6709\u8bef\uff0c\u5206\u914d\u4ef7\u76ee\u8868\u5931\u8d25\u3002", index), (String)"RetailPriceDistributePlugin_1", (String)"drp-dpm-opplugin", (Object[])new Object[0]));
        }
        DynamicObject newRetailPrice = BusinessDataServiceHelper.newDynamicObject((String)"dpm_retailpricelist");
        newRetailPrice.set("sourcebillno", (Object)dtRetailPrice.getString("billno"));
        newRetailPrice.set("sourcebillid", dtRetailPrice.getPkValue());
        newRetailPrice.set("department", (Object)dtRetailPrice.getDynamicObject("department"));
        newRetailPrice.set("org", (Object)bizGroup);
        newRetailPrice.set("channel", (Object)customer);
        newRetailPrice.set("effectdate", (Object)dtRetailPrice.getDate("effectdate"));
        newRetailPrice.set("invaliddate", (Object)dtRetailPrice.getDate("invaliddate"));
        newRetailPrice.set("currency", (Object)dtRetailPrice.getDynamicObject("currency"));
        newRetailPrice.set("istax", (Object)dtRetailPrice.getBoolean("istax"));
        newRetailPrice.set("useterminal", (Object)dtRetailPrice.getString("useterminal"));
        newRetailPrice.set("enable", (Object)dtRetailPrice.getString("enable"));
        newRetailPrice.set("billstatus", (Object)"B");
        newRetailPrice.set("comment", (Object)dtRetailPrice.getString("comment"));
        newRetailPrice.set("isdistributed", (Object)Boolean.TRUE);
        newRetailPrice.set("candistribute", (Object)Boolean.FALSE);
        newRetailPrice.set("billtype", (Object)RetailItemPriceHelper.getBranchBillType());
        newRetailPrice.set("creator", (Object)dtRetailPrice.getDynamicObject("creator"));
        newRetailPrice.set("createtime", (Object)TimeServiceHelper.now());
        newRetailPrice.set("controltype", (Object)"B");
        DynamicObjectCollection useRangeList = new DynamicObjectCollection();
        DynamicObjectCollection rangeList = dtRetailPrice.getDynamicObjectCollection("userangeentity");
        DynamicObject useRange = new DynamicObject(rangeList.getDynamicObjectType());
        useRange.set("priceorg", (Object)bizGroup);
        useRange.set("pricebranch", (Object)customer);
        useRange.set("priceenable", (Object)Boolean.TRUE);
        useRange.set("hasdistributed", (Object)Boolean.TRUE);
        useRange.set("seq", (Object)1);
        useRangeList.add((Object)useRange);
        newRetailPrice.set("userangeentity", (Object)useRangeList);
        for (String priceType : PRICE_TYPES) {
            newRetailPrice.set(priceType, dtRetailPrice.get(priceType));
        }
        logger.info("\u6e20\u9053" + customer.getString(NAME) + "\u6784\u5efa\u4ef7\u76ee\u8868\u7ed3\u675f\u2014\u2014\u2014\u2014>" + new Date());
        return newRetailPrice;
    }

    public static DynamicObject getAllBranchList(Object pkValue) {
        return BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"dpm_retailpricelist");
    }

    public static List<DynamicObject> getDistributedBranchList(Object pkValue) {
        DynamicObject retailPrice = RetailItemPriceHelper.getAllBranchList(pkValue);
        if (retailPrice == null) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObjectCollection list = retailPrice.getDynamicObjectCollection("userangeentity");
        return list.stream().filter(s -> s.getBoolean("priceenable") && s.getBoolean("hasdistributed")).collect(Collectors.toList());
    }

    public static List<DynamicObject> getNotDistributedBranchList(Object pkValue) {
        DynamicObject retailPrice = RetailItemPriceHelper.getAllBranchList(pkValue);
        if (retailPrice == null) {
            return new ArrayList<DynamicObject>();
        }
        DynamicObjectCollection list = retailPrice.getDynamicObjectCollection("userangeentity");
        return list.stream().filter(s -> s.getBoolean("priceenable") && !s.getBoolean("hasdistributed")).collect(Collectors.toList());
    }

    public static List<DistributeOpResult> cancelDistribute(List<Object> branches, Object sourceBillId) {
        if (branches == null || branches.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u914d\u95e8\u5e97\u5217\u8868\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u518d\u64cd\u4f5c", (String)"RetailPriceDistributePlugin_0", (String)"drp-dpm-business", (Object[])new Object[0]));
        }
        DynamicObject distributeObj = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"dpm_retailpricelist");
        ArrayList<DistributeOpResult> unassignResults = new ArrayList<DistributeOpResult>(branches.size());
        QFilter filter = null;
        filter = new QFilter("channel", "in", branches);
        filter.and("sourcebillid", "=", sourceBillId);
        StringBuilder selectedProperties = new StringBuilder("id");
        selectedProperties.append(',').append("channel");
        selectedProperties.append(',').append("billstatus");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"dpm_retailpricelist", (String)selectedProperties.toString(), (QFilter[])new QFilter[]{filter});
        String status = "C";
        String billStatus = null;
        ArrayList<Object> unAuditIds = new ArrayList<Object>(branches.size());
        DistributeOpResult result = new DistributeOpResult();
        DynamicObject branch = null;
        ArrayList<Object> assignBranches = new ArrayList<Object>(branches.size());
        for (DynamicObject dynamicObj : dynamicObjects) {
            branch = dynamicObj.getDynamicObject("channel");
            String branchName = branch.getString(NAME);
            billStatus = dynamicObj.getString("billstatus");
            result.setBranch(branch);
            if (status.equals(billStatus)) {
                result.setOpMessage(branchName + "\u4ef7\u76ee\u8868\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u5206\u914d\uff0c\u53ef\u5148\u8fdb\u884c\u53cd\u5ba1\u6838\uff0c\u518d\u53d6\u6d88\u5206\u914d\u3002");
            } else {
                result.setOpMessage(branchName + "\u4ef7\u76ee\u8868\u53d6\u6d88\u5206\u914d\u6210\u529f\u3002");
                unAuditIds.add(dynamicObj.getPkValue());
                assignBranches.add(branch.getPkValue());
            }
            unassignResults.add(result);
            result = new DistributeOpResult();
        }
        if (unAuditIds.size() > 0) {
            filter = new QFilter("id", "in", unAuditIds);
            DeleteServiceHelper.delete((String)"dpm_retailpricelist", (QFilter[])new QFilter[]{filter});
            RetailItemPriceHelper.updateHasdistributedToSourceBill(distributeObj, assignBranches, false);
        }
        return unassignResults;
    }

    public static DynamicObject getBranchBillType() {
        return BusinessDataServiceHelper.loadSingle((Object)"920289759207803904", (String)"bos_billtype");
    }

    public static Set<Object> getRetain(DynamicObjectCollection mdrItems, DynamicObject distributeObj) {
        HashSet<Object> mdrItemIds = new HashSet<Object>(mdrItems.size());
        HashSet priceDetailItemIds = new HashSet(mdrItems.size());
        mdrItems.stream().forEach(e -> mdrItemIds.add(e.get("barcode.Id")));
        DynamicObjectCollection priceDetails = distributeObj.getDynamicObjectCollection("pricedetailentity");
        priceDetails.stream().forEach(e -> priceDetailItemIds.add(e.getDynamicObject("barcode").getPkValue()));
        mdrItemIds.retainAll(priceDetailItemIds);
        return mdrItemIds;
    }

    public static DynamicObjectCollection getSaleContent(DynamicObject mdrCustomer) {
        QFilter filter = new QFilter("customerid.id", "=", mdrCustomer.getPkValue());
        DynamicObjectCollection mdrItems = QueryServiceHelper.query((String)"dbd_itemsale_content", (String)"barcode.Id", (QFilter[])new QFilter[]{filter});
        return mdrItems;
    }
}

