/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.formplugin.MdrBillPlugin;

public abstract class AbstractPromotionOrderEditPlugin
extends MdrBillPlugin {
    public static final String DATE = "orderdate";
    public static final String ORDER_ID = "orderid";
    public static final String ORDER_LIST_ENTRY = "orderlist";
    public static final String ENTRY_ORDER_ID = "orderentryid";
    public static final String ENTRY_ORDER_ITEM = "orderitem";
    public static final String ENTRY_ORDER_UNIT = "orderunit";
    public static final String ENTRY_ORDER_ATTR = "orderattr";
    public static final String ENTRY_ORDER_QTY = "orderqty";
    public static final String ENTRY_ORDER_PRICE = "orderprice";
    public static final String ENTRY_ORDER_AMOUNT = "orderamount";
    public static final String ENTRY_ORDER_TYPE = "ordertype";
    public static final String ENTRY_ORDER_IS_PRESENT = "orderispresent";
    public static final String ENTRY_ORDER_IS_COMBINATION = "orderiscombination";
    public static final String ENTRY_ORDER_COMBINATION_ID = "ordercombinationid";
    public static final String ENTRY_ORDER_COMBINATION_MARK = "ordercombinationmark";
    public static final String PROMOTION_POLICY_LIST_ENTRY = "promotionpolicylist";
    public static final String ENTRY_PROMOTION = "promotion";
    public static final String BUTTON_PROMOTION_POLICY_FIND = "promotionpolicyfind";
    public static final String PROMOTION_RESULT_LIST_ENTRY = "resultlist";
    public static final String ENTRY_PROMOTION_RESULT_PRIORITY = "resultpriority";
    public static final String ENTRY_PROMOTION_RESULT_POLICY = "resultpolicy";
    public static final String ENTRY_PROMOTION_RESULT_RESULT_ID = "resultresultid";
    public static final String ENTRY_PROMOTION_RESULT_IS_USED = "resultisused";
    public static final String ENTRY_PROMOTION_RESULT_GROUP = "resultgroup";
    public static final String ENTRY_PROMOTION_RESULT_TYPE = "resulttype";
    public static final String ENTRY_PROMOTION_RESULT_ITEM = "resultitem";
    public static final String ENTRY_PROMOTION_RESULT_COMBINATION = "resultcombination";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_COMBINATION = "resultitem_combination";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_UNIT = "resultitemunit";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_ATTR = "resultitemattr";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_QTY = "resultitemqty";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_PRICE_DIFF = "resultitempricediff";
    public static final String ENTRY_PROMOTION_RESULT_ITEM_AMOUNT_DIFF = "resultitemamountdiff";
    public static final String BUTTON_PROMOTION_RESULT_SWITCH = "promotionresultswitch";
    public static final String RESULT_ORDER_LIST_ENTRY = "resultorderlist";
    public static final String ENTRY_RESULT_ORDER_ID = "resultorderentryid";
    public static final String ENTRY_RESULT_ORDER_ITEM = "resultorderitem";
    public static final String ENTRY_RESULT_ORDER_UNIT = "resultorderunit";
    public static final String ENTRY_RESULT_ORDER_ATTR = "resultorderattr";
    public static final String ENTRY_RESULT_ORDER_QTY = "resultorderqty";
    public static final String ENTRY_RESULT_ORDER_PRICE = "resultorderprice";
    public static final String ENTRY_RESULT_ORDER_AMOUNT = "resultorderamount";
    public static final String ENTRY_RESULT_ORDER_TYPE = "resultordertype";
    public static final String ENTRY_RESULT_ORDER_IS_PRESENT = "resultorderispresent";
    public static final String ENTRY_RESULT_ORDER_IS_COMBINATION = "resultorderiscombination";
    public static final String ENTRY_RESULT_ORDER_COMBINATION_ID = "resultordercombinationid";
    public static final String ENTRY_RESULT_ORDER_COMBINATION_MARK = "resultordercombmark";
    public static final String TOTAL_AMOUNT = "totalamount";
    public static final String FULL_FREE_TOTAL_AMOUNT = "freetotalamount";
    public static final String PROMOTION_TOTAL_AMOUNT = "promotionamount";
    private static final String PRO_SPM = "PRO_SPM";

    public void preOpenForm(PreOpenFormEventArgs e) {
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)PRO_SPM);
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u8d2d\u4e70\u4fc3\u9500\u7ba1\u7406\u7279\u6027\u5206\u7ec4", (String)"AbstractPromotionOrderEditPlugin_5", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean isInArray(int[] array, int obj) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != obj) continue;
            return true;
        }
        return false;
    }

    public List<String> sortSet(Set<String> set) {
        ArrayList<String> list = new ArrayList<String>(set);
        Collections.sort(list);
        return list;
    }

    public long convertCombinationF7IdToItemId(long id) {
        DynamicObject object = this.getItemByCombinationF7Id(id);
        return object != null ? object.getLong("id") : 0L;
    }

    public DynamicObject getItemByCombinationF7Id(long id) {
        DynamicObject combinationF7;
        if (id != 0L && (combinationF7 = QueryServiceHelper.queryOne((String)"dpm_itemcombination_f7", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)id).toArray())) != null) {
            DynamicObject item = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"id", (QFilter[])new QFilter("number", "=", (Object)combinationF7.getString("number")).toArray());
            return item;
        }
        return null;
    }

    public long convertCombinationF7IdToCombinationId(long id) {
        DynamicObject object = this.getCombinationByCombinationF7Id(id);
        return object != null ? object.getLong("id") : 0L;
    }

    public DynamicObject getCombinationByCombinationF7Id(long id) {
        DynamicObject combinationF7;
        if (id != 0L && (combinationF7 = QueryServiceHelper.queryOne((String)"dpm_itemcombination_f7", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)id).toArray())) != null) {
            DynamicObject combination = QueryServiceHelper.queryOne((String)"dpm_item_combination", (String)"id", (QFilter[])new QFilter("number", "=", (Object)combinationF7.getString("number")).toArray());
            return combination;
        }
        return null;
    }

    public DynamicObjectCollection getOrderList() {
        return this.getModel().getEntryEntity(ORDER_LIST_ENTRY);
    }

    public DynamicObjectCollection getPromotionResultList() {
        return this.getModel().getEntryEntity(PROMOTION_RESULT_LIST_ENTRY);
    }

    protected int getCombinationIndexByCombinationMark(String combinationMark, String entryName) {
        DynamicObjectCollection orderList = this.getModel().getEntryEntity(entryName);
        for (int i = 0; i < orderList.size(); ++i) {
            DynamicObject entry = (DynamicObject)orderList.get(i);
            String mark = entry.getString(ENTRY_ORDER_COMBINATION_MARK);
            if (!combinationMark.equals(mark) || !entry.getBoolean(ENTRY_ORDER_IS_COMBINATION)) continue;
            return i;
        }
        return -1;
    }

    protected PromotionOrder createPromotionOrder() {
        return this.createPromotionOrder(true);
    }

    protected PromotionOrder createPromotionOrder(boolean isCreateNewId) {
        Object orderId = null;
        if (isCreateNewId) {
            orderId = DBServiceHelper.genGlobalLongId();
            this.setValue(ORDER_ID, orderId);
        } else {
            orderId = this.getValue(ORDER_ID);
            if (orderId == null || "".equals(orderId.toString().trim())) {
                orderId = DBServiceHelper.genGlobalLongId();
                this.setValue(ORDER_ID, orderId);
            }
        }
        DynamicObject order = this.getModel().getDataEntity();
        PromotionOrder porder = new PromotionOrder();
        DynamicObject customer = order.getDynamicObject("customer");
        porder.setCustomerid(customer != null ? customer.getPkValue() : null);
        DynamicObject owner = order.getDynamicObject("owner");
        porder.setOwnerid(owner != null ? owner.getPkValue() : null);
        porder.setCreatetime(new Date());
        DynamicObjectCollection orderList = this.getModel().getEntryEntity(ORDER_LIST_ENTRY);
        if (orderList.size() != 0) {
            for (DynamicObject entry : orderList) {
                DynamicObject item = entry.getDynamicObject(ENTRY_ORDER_ITEM);
                DynamicObject unit = entry.getDynamicObject(ENTRY_ORDER_UNIT);
                DynamicObject attr = entry.getDynamicObject(ENTRY_ORDER_ATTR);
                this.validateOrderEntry(item, unit, attr, entry.get("seq"));
                PromotionOrderEntry pentry = new PromotionOrderEntry();
                pentry.setEntryid(entry.get(ENTRY_ORDER_ID));
                pentry.setItemid(item.getPkValue());
                pentry.setUnitid(unit.getPkValue());
                pentry.setAttrid(attr != null ? attr.getPkValue() : Long.valueOf(0L));
                pentry.setPrice(entry.getBigDecimal(ENTRY_ORDER_PRICE));
                pentry.setQty(entry.getBigDecimal(ENTRY_ORDER_QTY));
                pentry.setAmount(entry.getBigDecimal(ENTRY_ORDER_AMOUNT));
                pentry.setIspresent(entry.getBoolean(ENTRY_ORDER_IS_PRESENT));
                pentry.setIscombination(entry.getBoolean(ENTRY_ORDER_IS_COMBINATION));
                pentry.setType(SaleOrderEntryType.getByFlag((String)entry.getString(ENTRY_ORDER_TYPE)));
                pentry.setSourceentryid((Object)entry.getString(ENTRY_ORDER_COMBINATION_MARK));
                porder.addEntry(pentry);
            }
        }
        return porder;
    }

    protected PromotionOrder createPromotionOrderFromResult() {
        Object orderId = this.getValue(ORDER_ID);
        if (orderId == null || "".equals(orderId.toString().trim())) {
            orderId = DBServiceHelper.genGlobalLongId();
            this.setValue(ORDER_ID, orderId);
        }
        DynamicObject order = this.getModel().getDataEntity();
        PromotionOrder porder = new PromotionOrder();
        DynamicObject customer = order.getDynamicObject("customer");
        porder.setCustomerid(customer != null ? customer.getPkValue() : null);
        DynamicObject owner = order.getDynamicObject("owner");
        porder.setOwnerid(owner != null ? owner.getPkValue() : null);
        porder.setCreatetime(new Date());
        DynamicObjectCollection orderList = this.getModel().getEntryEntity(RESULT_ORDER_LIST_ENTRY);
        if (orderList.size() != 0) {
            for (DynamicObject entry : orderList) {
                DynamicObject item = entry.getDynamicObject(ENTRY_RESULT_ORDER_ITEM);
                DynamicObject unit = entry.getDynamicObject(ENTRY_RESULT_ORDER_UNIT);
                DynamicObject attr = entry.getDynamicObject(ENTRY_RESULT_ORDER_ATTR);
                this.validateOrderEntry(item, unit, attr, entry.get("seq"));
                PromotionOrderEntry pentry = new PromotionOrderEntry();
                pentry.setEntryid(entry.get(ENTRY_RESULT_ORDER_ID));
                pentry.setItemid(item.getPkValue());
                pentry.setUnitid(unit.getPkValue());
                pentry.setAttrid(attr != null ? attr.getPkValue() : Long.valueOf(0L));
                pentry.setPrice(entry.getBigDecimal(ENTRY_RESULT_ORDER_PRICE));
                pentry.setQty(entry.getBigDecimal(ENTRY_RESULT_ORDER_QTY));
                pentry.setAmount(entry.getBigDecimal(ENTRY_RESULT_ORDER_AMOUNT));
                pentry.setIspresent(entry.getBoolean(ENTRY_RESULT_ORDER_IS_PRESENT));
                pentry.setIscombination(entry.getBoolean(ENTRY_RESULT_ORDER_IS_COMBINATION));
                pentry.setType(SaleOrderEntryType.getByFlag((String)entry.getString(ENTRY_RESULT_ORDER_TYPE)));
                pentry.setSourceentryid((Object)entry.getString(ENTRY_RESULT_ORDER_COMBINATION_MARK));
                porder.addEntry(pentry);
            }
        }
        return porder;
    }

    private void validateOrderEntry(DynamicObject item, DynamicObject unit, DynamicObject attr, Object seq) {
        if (item == null || unit == null) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c \u672a\u8f93\u5165\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d", (String)"AbstractPromotionOrderEditPlugin_6", (String)"drp-dpm-formplugin", (Object[])new Object[0]), seq));
        }
        if (ItemAttrUtil.hasAssistAttr((Object)item.getPkValue()) && attr == null) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c \u5546\u54c1\u5177\u6709\u8f85\u52a9\u5c5e\u6027\uff0c\u8bf7\u8f93\u5165\u8f85\u52a9\u5c5e\u6027", (String)"AbstractPromotionOrderEditPlugin_7", (String)"drp-dpm-formplugin", (Object[])new Object[0]), seq));
        }
    }
}

