/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public class CustomerRangeEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_DELETE = "btn_delete";
    public static final String ENTRY_LIST = "entryentity";
    public static final String OWNER = "owner";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";
    public static final String AREA = "area";
    public static final String CUSTOMER = "customer";
    public static final String CUSTOMERGROUP = "customergroup";
    public static final String CUSTOMERGRADE = "customergrade";
    public static final String ISREMOVED = "isremoved";
    public static final String SALEORGID = "saleorgid";
    public static final String ENTRY_DETAIL = "entrydetail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_SAVE, BTN_DELETE});
        this.addF7Listener(this, new String[]{PROVINCE, CITY, AREA, CUSTOMER, CUSTOMERGRADE, SALEORGID});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object id = this.getView().getFormShowParameter().getCustomParam("id");
        if (id != null) {
            DynamicObject range = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"dpm_customerrange"));
            if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null && Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                DynamicObject fromrange = BusinessDataServiceHelper.newDynamicObject((String)"dpm_customerrange");
                HashSet<String> ignoreKeys = new HashSet<String>(1);
                ignoreKeys.add(ENTRY_LIST);
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromrange, (DynamicObject)range, ignoreKeys);
                DynamicObjectCollection entrys = fromrange.getDynamicObjectCollection(ENTRY_LIST);
                DynamicObjectType entryType = entrys.getDynamicObjectType();
                DynamicObject entry = null;
                for (DynamicObject fromentry : range.getDynamicObjectCollection(ENTRY_LIST)) {
                    entry = new DynamicObject(entryType);
                    DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)entry, (DynamicObject)fromentry);
                    entrys.add((Object)entry);
                }
                e.setDataEntity((Object)fromrange);
                return;
            }
            e.setDataEntity((Object)range);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object ownerid = this.getView().getFormShowParameter().getCustomParam("ownerid");
        if (ownerid != null) {
            this.getModel().setValue(OWNER, ownerid);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        super.propertyChanged(e, key);
        int index = super.getRowIndex(e);
        ChangeData[] changeset = e.getChangeSet();
        Object newValue = changeset[0].getNewValue();
        switch (key) {
            case "customer": {
                if (newValue == null) break;
                this.setValue(SALEORGID, null, index);
                this.setValue(CUSTOMERGROUP, null, index);
                this.setValue(CUSTOMERGRADE, null, index);
                this.setValue(PROVINCE, null, index);
                this.setValue(CITY, null, index);
                this.setValue(AREA, null, index);
                break;
            }
            case "customergroup": {
                if (newValue == null) break;
                this.setValue(CUSTOMER, null, index);
                this.setValue(CUSTOMERGRADE, null, index);
                break;
            }
            case "customergrade": {
                if (newValue == null) break;
                this.setValue(CUSTOMER, null, index);
                this.setValue(CUSTOMERGROUP, null, index);
                break;
            }
            case "province": {
                if (newValue != null) {
                    this.setValue(CUSTOMER, null, index);
                }
                this.setValue(AREA, null, index);
                this.setValue(CITY, null, index);
                break;
            }
            case "city": {
                this.setValue(AREA, null, index);
                break;
            }
            case "saleorgid": {
                if (newValue == null) break;
                this.setValue(CUSTOMER, null, index);
                break;
            }
        }
    }

    private void checkIsOwnerEmpty() {
        Object owner = this.getModel().getDataEntity().get(OWNER);
        if (owner == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f9b\u8d27\u6e20\u9053", (String)"CustomerRangeEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int rowIndex = e.getRow();
        List<QFilter> fitlers = null;
        switch (key) {
            case "province": {
                this.checkIsOwnerEmpty();
                break;
            }
            case "city": {
                this.checkIsOwnerEmpty();
                fitlers = this.getAddressFilters(e, PROVINCE, rowIndex);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fitlers);
                break;
            }
            case "area": {
                this.checkIsOwnerEmpty();
                fitlers = this.getAddressFilters(e, CITY, rowIndex);
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, fitlers);
                break;
            }
            case "customer": {
                this.checkIsOwnerEmpty();
                Object ownerid = this.getModel().getDataEntity().getDynamicObject(OWNER).getPkValue();
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)CustomerUtil.getAllAuthSubsIdsQFilter((Object)ownerid));
                break;
            }
            case "customergrade": {
                this.checkIsOwnerEmpty();
                break;
            }
            case "saleorgid": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)F7Utils.getSaleOrgFitler());
                break;
            }
        }
    }

    private List<QFilter> getAddressFilters(BeforeF7SelectEvent e, String fieldName, int rowindex) {
        ArrayList<QFilter> fitlers = new ArrayList<QFilter>();
        DynamicObject customer = this.getRowInfo(ENTRY_LIST, rowindex);
        DynamicObject address = customer.getDynamicObject(fieldName);
        if (address == null) {
            if (fieldName.compareTo(CITY) == 0) {
                e.setCancel(true);
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7701/\u5e02", (String)"CustomerRangeEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            }
            e.setCancel(true);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7701", (String)"CustomerRangeEditPlugin_3", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
        QFilter orgIdsFilter = new QFilter("parent", "=", address.getPkValue());
        fitlers.add(orgIdsFilter);
        return fitlers;
    }
}

