/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.formplugin.MdrBasePlugin;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class ItemRangeEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String ITEM_CLASS = "itemclass";
    public static final String ITEM_BRAND = "itembrand";
    public static final String ISREMOVED = "isremvoed";
    public static final String ITEM = "item";
    public static final String UNIT = "unit";
    public static final String ATTR = "attr";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{ITEM_CLASS, ITEM_BRAND, ITEM, UNIT, ATTR});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object rangeid = this.getView().getFormShowParameter().getCustomParam("id");
        if (rangeid != null) {
            DynamicObject itemrange = BusinessDataServiceHelper.loadSingle((Object)rangeid, (String)"dpm_itemrange");
            if (Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                DynamicObject toitemrange = BusinessDataServiceHelper.newDynamicObject((String)"dpm_itemrange");
                HashSet<String> ignoreKeys = new HashSet<String>(1);
                ignoreKeys.add("entryentity");
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)toitemrange, (DynamicObject)itemrange, ignoreKeys);
                DynamicObjectCollection toentrys = toitemrange.getDynamicObjectCollection("entryentity");
                DynamicObjectType entryType = toentrys.getDynamicObjectType();
                DynamicObject toentry = null;
                for (DynamicObject fromentry : itemrange.getDynamicObjectCollection("entryentity")) {
                    toentry = new DynamicObject(entryType);
                    DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)toentry, (DynamicObject)fromentry);
                    toentrys.add((Object)toentry);
                }
                e.setDataEntity((Object)toitemrange);
                return;
            }
            e.setDataEntity((Object)itemrange);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        switch (key) {
            case "item": {
                DynamicObject owner = this.getModel().getDataEntity().getDynamicObject("owner");
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "unit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM, (int)index);
                break;
            }
            case "attr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM, (int)index);
                break;
            }
            case "itemclass": {
                DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
                long standardId = itemClassStandard.getLong("classstandardid_id");
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                listShowParameter.setCustomParam("groupStandard", (Object)standardId);
                listShowParameter.setMultiSelect(false);
                QFilter standardFilter = new QFilter("standard", "=", (Object)standardId);
                listShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"rangeentry"});
        }
        Object ownerid = this.getView().getFormShowParameter().getCustomParam("ownerid");
        this.setValue("owner", ownerid);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObjectCollection entrycol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        this.getView().setEnable(Boolean.FALSE, entrycol.size() - 1, new String[]{UNIT, ATTR});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        Boolean triggerChangeEventLocal = (Boolean)MdrFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            MdrFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        switch (key) {
            case "item": {
                PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)ITEM, (String)UNIT, (String)ATTR, (int)index);
                this.setValue(ITEM_BRAND, null, index);
                this.setValue(ITEM_CLASS, null, index);
                break;
            }
            case "itemclass": {
                this.setValue(UNIT, null, index);
                this.setValue(ATTR, null, index);
                this.setValue(ITEM, null, index);
                this.setValue(ITEM_BRAND, null, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{UNIT, ATTR});
                break;
            }
            case "itembrand": {
                this.setValue(UNIT, null, index);
                this.setValue(ATTR, null, index);
                this.setValue(ITEM, null, index);
                this.setValue(ITEM_CLASS, null, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{UNIT, ATTR});
            }
        }
    }

    public void setValue(String key, Object value, int i) {
        this.setValue(key, value, i, false);
    }
}

