/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.formplugin.PromotionBaseEdit;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.OperationUtil;

public class PromotionConditionEditPlugin
extends PromotionBaseEdit
implements BeforeF7SelectListener {
    public static final String PAGE_ITEMRANGE = "page_itemrange";
    public static final String CONDITIONTYPE = "conditiontype";
    public static final String ITEM = "item";
    public static final String UNIT = "unit";
    public static final String ATTR = "attr";
    public static final String ITEMRANGEFLEX = "itemrangeflex";
    public static final String ITEMRANGE = "itemrange";
    public static final String JUDGESTANDARD = "judgestandard";
    public static final String COMPARISON = "comparison";
    public static final String JUDGEVALUE = "judgevalue";
    public static final String ISRANGESPLIT = "israngesplit";
    public static final String PARENTCONDITION = "parentcondition";
    public static final String PARENTJUDGEVALUE = "parentjudgevalue";
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String BTN_CONFIRM = "btn_confirm";
    protected volatile boolean triggerChangeEvent = false;

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object id = this.getIdInShowParam();
        if (id != null) {
            DynamicObject condition = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dpm_condition");
            if (Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                DynamicObject fromCondition = BusinessDataServiceHelper.newDynamicObject((String)"dpm_condition");
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromCondition, (DynamicObject)condition);
                e.setDataEntity((Object)fromCondition);
                return;
            }
            e.setDataEntity((Object)condition);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject condition;
        DynamicObject itemrange;
        super.afterCreateNewData(e);
        if (this.getIdInShowParam() == null) {
            Object ownerid = this.getView().getFormShowParameter().getCustomParam("ownerid");
            this.setValue("owner", ownerid);
        }
        if ((itemrange = (condition = this.getModel().getDataEntity(true)).getDynamicObject(ITEMRANGE)) == null) {
            this.showItemrangePanel(null);
        } else {
            this.showItemrangePanel(itemrange.getPkValue());
            if (Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                this.setValue(ITEMRANGE, null);
            }
        }
        if (0L != condition.getLong(PARENTCONDITION)) {
            this.setUnEnable(new String[]{CONDITIONTYPE, ITEM, UNIT, ATTR, ITEMRANGEFLEX, COMPARISON, ISRANGESPLIT, JUDGESTANDARD});
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"content_flex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_flex"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.triggerChangeEvent && !key.equals(UNIT) && !key.equals(ISRANGESPLIT)) {
            return;
        }
        this.triggerChangeEvent = true;
        switch (key) {
            case "conditiontype": {
                this.conditiontypechanged();
                break;
            }
            case "item": {
                this.itemChanged();
                break;
            }
            case "unit": {
                this.unitChanged();
                break;
            }
            case "attr": {
                this.attrChanged();
                break;
            }
            case "judgestandard": {
                this.judgestandardChanged();
                break;
            }
            case "israngesplit": {
                this.israngesplitChanged();
                break;
            }
            case "owner": {
                this.ownerChanged();
            }
        }
        this.triggerChangeEvent = false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PromotionUiUtil.standardChanged((IFormView)this.getView(), (String)UNIT, null, (String)JUDGESTANDARD, (String)JUDGEVALUE);
    }

    protected void conditiontypechanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject conditiontype = model.getDynamicObject(CONDITIONTYPE);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue("batchtype", (Object)conditiontype);
        this.getView().sendFormAction(view);
        pageid = this.getView().getParentView().getPageCache().get("page_fullfreeinfo");
        view = this.getView().getView(pageid);
        view.getModel().setValue("batchtype", (Object)conditiontype);
        this.getView().sendFormAction(view);
        if (conditiontype == null) {
            return;
        }
        String number = conditiontype.getString("number");
        if (number.compareTo("singleitem") != 0) {
            this.setValue(ITEM, null, false);
            this.setValue(UNIT, null, false);
            this.setValue(ATTR, null, false);
        } else if (number.compareTo(ITEMRANGE) != 0 && (pageid = this.getPageCache().get(PAGE_ITEMRANGE)) != null) {
            IDataModel childmodel = this.getView().getView(pageid).getModel();
            childmodel.deleteEntryData("entryentity");
            childmodel.createNewEntryRow("entryentity");
            this.getView().sendFormAction(this.getView().getView(pageid));
        }
        Boolean isrange = conditiontype.getBoolean("isrange");
        if (!isrange.booleanValue()) {
            this.setValue(ISRANGESPLIT, Boolean.FALSE);
        }
    }

    protected void itemChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject item = model.getDynamicObject(ITEM);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue("batchitem", (Object)item);
        this.getView().sendFormAction(view);
        pageid = this.getView().getParentView().getPageCache().get("page_fullfreeinfo");
        view = this.getView().getView(pageid);
        view.getModel().setValue("batchitem", (Object)item);
        this.getView().sendFormAction(view);
        PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)ITEM, (String)UNIT, (String)ATTR);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl(ATTR);
        if (item != null && PromotionUiUtil.hasAssistAttr((Object)item.getPkValue())) {
            edit.setMustInput(true);
        } else {
            edit.setMustInput(false);
        }
    }

    protected void unitChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject unit = model.getDynamicObject(UNIT);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue("batchunit", (Object)unit);
        this.getView().sendFormAction(view);
        pageid = this.getView().getParentView().getPageCache().get("page_fullfreeinfo");
        view = this.getView().getView(pageid);
        view.getModel().setValue("batchunit", (Object)unit);
        this.getView().sendFormAction(view);
        PromotionUiUtil.unitChangedWithStandard((IFormView)this.getView(), (String)UNIT, (String)JUDGEVALUE, (String)JUDGESTANDARD);
    }

    protected void attrChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject attr = model.getDynamicObject(ATTR);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue("batchattr", (Object)attr);
        this.getView().sendFormAction(view);
        pageid = this.getView().getParentView().getPageCache().get("page_fullfreeinfo");
        view = this.getView().getView(pageid);
        view.getModel().setValue("batchattr", (Object)attr);
        this.getView().sendFormAction(view);
    }

    protected void judgestandardChanged() {
        PromotionUiUtil.standardChanged((IFormView)this.getView(), (String)UNIT, null, (String)JUDGESTANDARD, (String)JUDGEVALUE);
        DynamicObject model = this.getModel().getDataEntity();
        String judgestandard = model.getString(JUDGESTANDARD);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue("batchstandard", (Object)judgestandard);
        this.getView().sendFormAction(view);
        pageid = this.getView().getParentView().getPageCache().get("page_fullfreeinfo");
        view = this.getView().getView(pageid);
        view.getModel().setValue("batchstandard", (Object)judgestandard);
        this.getView().sendFormAction(view);
    }

    protected void israngesplitChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        boolean israngesplit = model.getBoolean(ISRANGESPLIT);
        String pageid = this.getView().getParentView().getPageCache().get("page_presentinfo");
        IFormView view = this.getView().getView(pageid);
        view.getModel().setValue(ISRANGESPLIT, (Object)israngesplit);
        this.getView().sendFormAction(view);
    }

    protected void ownerChanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject conditiontype = model.getDynamicObject(CONDITIONTYPE);
        if (conditiontype == null) {
            return;
        }
        String nuber = conditiontype.getString("number");
        if (nuber.compareTo("singleitem") == 0) {
            this.setValue(ITEM, null);
            this.setValue(UNIT, null);
            this.setValue(ATTR, null);
        }
        String pageid = this.getPageCache().get(PAGE_ITEMRANGE);
        IDataModel childmodel = this.getView().getView(pageid).getModel();
        childmodel.setValue("owner", this.getF7PKValue("owner"));
        childmodel.deleteEntryData("entryentity");
        childmodel.createNewEntryRow("entryentity");
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{BTN_CANCEL, BTN_CONFIRM});
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{CONDITIONTYPE, ITEM, UNIT, ATTR});
    }

    private void showItemrangePanel(Object rangeid) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        parameter.setFormId("dpm_itemrange");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(ITEMRANGEFLEX);
        parameter.setCustomParam("id", rangeid);
        parameter.setCustomParam("iscopy", this.getView().getFormShowParameter().getCustomParam("iscopy"));
        parameter.setCustomParam("ownerid", this.getF7PKValue("owner"));
        this.getView().showForm((FormShowParameter)parameter);
        String pageid = parameter.getPageId();
        this.getView().sendFormAction(this.getView().getView(pageid));
        this.getPageCache().put(PAGE_ITEMRANGE, pageid);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7name;
        switch (f7name = e.getProperty().getName()) {
            case "conditiontype": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("enable", "=", (Object)Character.valueOf('1')));
                break;
            }
            case "item": {
                DynamicObject owner = this.getF7Value("owner");
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "unit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM);
                break;
            }
            case "attr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.btnConfirmClick();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void click(EventObject e) {
        String btnname;
        super.click(e);
        Button btn = (Button)e.getSource();
        switch (btnname = btn.getKey()) {
            case "btn_confirm": {
                this.btnConfirmClick();
            }
        }
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private void btnConfirmClick() {
        OperationResult opresult;
        DynamicObject condition = this.getModel().getDataEntity(true);
        Long parentconditionid = condition.getLong(PARENTCONDITION);
        if (parentconditionid != null && !parentconditionid.equals(0L) && condition.getBigDecimal(JUDGEVALUE).compareTo(condition.getBigDecimal(PARENTJUDGEVALUE)) <= 0) {
            throw new KDBizException("\u4fc3\u9500\u6761\u4ef6\u5f53\u524d\u6761\u4ef6\u5355\u5143\u7684\u6bd4\u8f83\u503c\u5fc5\u987b\u5927\u4e8e\u4e0a\u7ea7\u6bd4\u8f83\u503c");
        }
        DynamicObject conditiontype = condition.getDynamicObject(CONDITIONTYPE);
        if (conditiontype == null) {
            throw new KDBizException("\u8bf7\u9009\u62e9\u4fc3\u9500\u6761\u4ef6\u5339\u914d\u8303\u56f4\u3002");
        }
        String number = conditiontype.getString("number");
        if (number.equals(ITEMRANGE)) {
            StringBuilder errorinfo = new StringBuilder();
            String pageid = this.getPageCache().get(PAGE_ITEMRANGE);
            DynamicObject itemrange = this.getView().getView(pageid).getModel().getDataEntity(true);
            DynamicObjectCollection entrys = itemrange.getDynamicObjectCollection("entryentity");
            if (entrys == null) {
                errorinfo.append("\u8bf7\u7ef4\u62a4\u4fc3\u9500\u6761\u4ef6\u6709\u6548\u7684\u5546\u54c1\u8303\u56f4\u3002");
            } else {
                StringBuilder strkeys = null;
                String key = "";
                ArrayList<String> keys = new ArrayList<String>(entrys.size());
                ArrayList<String> repeatSeq = new ArrayList<String>(entrys.size());
                ArrayList<String> emptySeq = new ArrayList<String>(entrys.size());
                ArrayList<String> attremptySeq = new ArrayList<String>(entrys.size());
                DynamicObject iteminfo = null;
                DynamicObject attr = null;
                for (DynamicObject entry : entrys) {
                    strkeys = new StringBuilder();
                    this.setKeys(strkeys, entry.getDynamicObject("itemclass"));
                    this.setKeys(strkeys, entry.getDynamicObject("itembrand"));
                    iteminfo = entry.getDynamicObject(ITEM);
                    this.setKeys(strkeys, iteminfo);
                    this.setKeys(strkeys, entry.getDynamicObject(UNIT));
                    attr = entry.getDynamicObject(ATTR);
                    this.setKeys(strkeys, attr);
                    key = strkeys.toString();
                    if (key.isEmpty()) {
                        emptySeq.add(entry.getString("Seq"));
                        continue;
                    }
                    if (keys.contains(key)) {
                        repeatSeq.add(entry.getString("Seq"));
                    } else {
                        keys.add(key);
                    }
                    if (attr != null || iteminfo == null || !PromotionUiUtil.hasAssistAttr((Object)iteminfo.getPkValue())) continue;
                    attremptySeq.add(entry.getString("Seq"));
                }
                if (repeatSeq.size() > 0) {
                    errorinfo.append(String.format("\u5206\u5f55%s\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", repeatSeq)));
                }
                if (emptySeq.size() > 0) {
                    errorinfo.append(String.format("\u5206\u5f55%s\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", emptySeq)));
                }
                if (attremptySeq.size() > 0) {
                    errorinfo.append(String.format("\u5206\u5f55%s\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", attremptySeq)));
                }
            }
            if (errorinfo.length() > 0) {
                throw new KDBizException(String.format("\u4fc3\u9500\u6761\u4ef6\uff1a%s", errorinfo));
            }
            opresult = OperationUtil.invokeOperation((DynamicObject)itemrange, (String)"save");
            if (!opresult.isSuccess()) {
                this.getView().showOperationResult(opresult);
                return;
            }
            condition.set(ITEMRANGE, (Object)itemrange);
        } else if (number.equals("singleitem")) {
            DynamicObject item = condition.getDynamicObject(ITEM);
            if (item == null) {
                throw new KDBizException("\u8bf7\u7ef4\u62a4\u4fc3\u9500\u6761\u4ef6\u6709\u6548\u7684\u5546\u54c1\u4fe1\u606f\u3002");
            }
            if (condition.getDynamicObject(ATTR) == null && PromotionUiUtil.hasAssistAttr((Object)item.getPkValue())) {
                throw new KDBizException("\u8bf7\u7ef4\u62a4\u4fc3\u9500\u6761\u4ef6\u6709\u6548\u7684\u5546\u54c1\u8f85\u52a9\u5c5e\u6027\u4fe1\u606f\u3002");
            }
        }
        condition.set("name", (Object)this.generatorName());
        opresult = OperationUtil.invokeOperation((DynamicObject)condition, (String)"save");
        if (!opresult.isSuccess()) {
            this.getView().showOperationResult(opresult);
            return;
        }
        this.getView().returnDataToParent(opresult.getSuccessPkIds().get(0));
    }

    private void setKeys(StringBuilder strkeys, DynamicObject object) {
        if (object != null) {
            strkeys.append(object.getPkValue());
            strkeys.append('_');
        }
    }

    private String generatorName() {
        StringBuilder namebuilder = new StringBuilder();
        DynamicObject condition = this.getModel().getDataEntity();
        String type = condition.getDynamicObject(CONDITIONTYPE).getString("name");
        String judgevalue = condition.getBigDecimal(JUDGEVALUE).stripTrailingZeros().toPlainString();
        String judgestandard = "qty".equals(condition.getString(JUDGESTANDARD)) ? ResManager.loadKDString((String)"\u6570\u91cf", (String)"PromotionConditionEditPlugin_3", (String)"drp-dpm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91d1\u989d", (String)"PromotionConditionEditPlugin_4", (String)"drp-dpm-formplugin", (Object[])new Object[0]);
        String comparison = "0".equals(condition.get(COMPARISON)) ? ">" : ">=";
        namebuilder.append(type);
        if (condition.getBoolean(ISRANGESPLIT)) {
            namebuilder.append(ResManager.loadKDString((String)"(\u62c6\u5206)", (String)"PromotionConditionEditPlugin_5", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
        namebuilder.append(judgestandard);
        namebuilder.append(comparison);
        namebuilder.append(judgevalue);
        return namebuilder.toString();
    }

    private Object getIdInShowParam() {
        return this.getView().getFormShowParameter().getCustomParam("id");
    }
}

