/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.formplugin.PromotionBaseEdit;
import kd.drp.mdr.common.StringUtils;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.UserUtil;

public class PromotionLimitEditPlugin
extends PromotionBaseEdit
implements BeforeF7SelectListener {
    public static final String CUSTOMERRANGE = "customerrange";
    public static final String PAGE_CUSTOMERRANGE = "page_customerrange";
    public static final String TOOLBAR = "tbmain";
    public static final String BAR_SAVE = "bar_save";

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (key.equals("owner")) {
            F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)UserUtil.getAuthorizedOwnerIDs()));
            return;
        }
        DynamicObject owner = this.getF7Value("owner");
        if (owner == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165 \u9500\u552e\u6e20\u9053", (String)"PromotionLimitEditPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        int index = e.getRow();
        switch (key) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getAuthorizedCommonUserOwnersFilter());
                break;
            }
            case "promotionpolicy": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getPromotionPolicyFiler(index));
                break;
            }
            case "item": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)owner.getPkValue());
                break;
            }
            case "unit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"item");
                break;
            }
            case "attr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"item");
                break;
            }
        }
    }

    private QFilter getPromotionPolicyFiler(int index) {
        DynamicObject currentPolicy = (DynamicObject)this.getValue("promotionpolicy");
        Object currentPolicyPkValue = currentPolicy != null ? currentPolicy.getPkValue() : Long.valueOf(0L);
        DynamicObject owner = this.getF7Value("owner");
        QFilter filter = new QFilter("owner", "=", owner.getPkValue());
        filter.and(new QFilter("policystatus", "=", (Object)"D"));
        Date date = new Date();
        filter.and("endtime", ">=", (Object)date);
        filter.and("starttime", "<=", (Object)date);
        HashSet<Object> alreadySelectPromotionPolicys = new HashSet<Object>();
        DynamicObjectCollection policyEntries = this.getModel().getEntryEntity("policy");
        for (DynamicObject policyEntry : policyEntries) {
            DynamicObject policy = policyEntry.getDynamicObject("promotionpolicy");
            if (policy == null || policy.getPkValue() == currentPolicyPkValue) continue;
            alreadySelectPromotionPolicys.add(policy.get("id"));
        }
        filter.and("id", "not in", alreadySelectPromotionPolicys);
        return filter;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDefaultOwner();
    }

    private void initDefaultOwner() {
        Object userId = UserUtil.getUserID();
        List owners = UserUtil.getOwners((Object)userId);
        Object id = null;
        if (owners.size() > 0) {
            id = ((DynamicObject)owners.get(0)).getPkValue();
            this.setValue("owner", id);
        }
    }

    public void afterBindData(EventObject e) {
        this.checkIsActOnPolicy();
        this.checkLimitType();
        super.afterBindData(e);
        DynamicObject customerrange = (DynamicObject)this.getValue("customerrangeid");
        if (this.isAddNew()) {
            this.setOwnerFromCache("owner");
            this.showCustomerRangePanel(customerrange == null ? null : customerrange.getPkValue(), OperationStatus.ADDNEW);
            this.getModel().deleteEntryData("policy");
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            this.showCustomerRangePanel(customerrange == null ? null : customerrange.getPkValue(), status);
            String billstatus = this.getValue("status").toString().trim();
            if ("B".equals(billstatus) || "C".equals(billstatus)) {
                this.setDisVisible(new String[]{"promotionpolicytoolbar", "promotionpolicytoolbar1", "limitruletoolbar"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.triggerChangeEvent) {
            return;
        }
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "owner": {
                this.refreshChildPageOwner();
                this.clearEntry("policy");
                this.clearEntry("qtylimititems");
                break;
            }
            case "isactonpolicy": {
                boolean newIsactonpolicy = (Boolean)e.getChangeSet()[0].getNewValue();
                this.isactonpolicyChanged(newIsactonpolicy);
                break;
            }
            case "limitqty": {
                this.limitQtyChanged(index);
                break;
            }
            case "unit": {
                if (this.getValue("unit", index) == null) break;
                this.limitQtyChanged(index);
                break;
            }
            case "limittype": {
                String limitType = (String)this.getValue("limittype");
                if ("amt".equals(limitType) && !this.getBooleanValue("isactonpolicy")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9650\u91cf\u7c7b\u578b\u4e3a \u91d1\u989d \u65f6\uff0c\u9700\u8981\u5f00\u542f \u5bf9\u4fc3\u9500\u653f\u7b56\u9650\u91cf", (String)"PromotionLimitEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                    Object oldValue = e.getChangeSet()[0].getOldValue();
                    this.triggerChangeEvent = false;
                    this.setValue("limittype", oldValue);
                    this.triggerChangeEvent = true;
                }
                String newLimitType = (String)e.getChangeSet()[0].getNewValue();
                this.checkLimitType();
                this.changeLimitType(newLimitType);
                break;
            }
            case "item": {
                this.itemChanged(index);
            }
        }
    }

    protected void clearEntry(String entryName) {
        this.getModel().deleteEntryData(entryName);
        this.getModel().createNewEntryRow(entryName);
    }

    private void checkLimitType() {
        String limitType = (String)this.getValue("limittype");
        if (limitType == null) {
            this.setDisVisible(new String[]{"limitcontextflex"});
            this.setDisVisible(new String[]{"limitforpresent"});
        } else if ("amt".equals(limitType)) {
            this.setVisible(new String[]{"limitcontextflex"});
            this.setVisible(new String[]{"amountflex"});
            this.setDisVisible(new String[]{"qtylimitflex"});
            this.setDisVisible(new String[]{"limitforpresent"});
        } else if ("qty".equals(limitType)) {
            this.setVisible(new String[]{"limitcontextflex"});
            this.setDisVisible(new String[]{"amountflex"});
            this.setVisible(new String[]{"qtylimitflex"});
            this.setVisible(new String[]{"limitforpresent"});
        }
    }

    private void changeLimitType(String newLimitType) {
        this.getModel().deleteEntryData("qtylimititems");
        if ("qty".equals(newLimitType)) {
            this.getModel().createNewEntryRow("qtylimititems");
        }
    }

    private void checkIsActOnPolicy() {
        if (this.getBooleanValue("isactonpolicy")) {
            this.setVisible(new String[]{"promotionpolicyflex"});
        } else {
            this.setDisVisible(new String[]{"promotionpolicyflex"});
        }
    }

    private void changeActOnPolicy(Boolean newValue) {
        this.getModel().deleteEntryData("policy");
        if (newValue.booleanValue()) {
            this.getModel().createNewEntryRow("policy");
        }
    }

    private void refreshChildPageOwner() {
        String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
        IDataModel childmodel = this.getView().getView(pageid).getModel();
        childmodel.setValue("owner", this.getModel().getValue("owner"));
        childmodel.deleteEntryData("entryentity");
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void isactonpolicyChanged(boolean newIsactonpolicy) {
        DynamicObjectCollection policys;
        if (!newIsactonpolicy && (policys = this.getModel().getEntryEntity("policy")) != null && policys.size() > 0 && ((DynamicObject)policys.get(0)).getDynamicObject("promotionpolicy") != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("isactonpolicyCallBack", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5173\u95ed\u540e\uff0c\u5df2\u9009\u7684\u4fc3\u9500\u653f\u7b56\u5c06\u88ab\u6e05\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5173\u95ed\u3002", (String)"PromotionLimitEditPlugin_9", (String)"drp-dpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            return;
        }
        this.checkIsActOnPolicy();
        this.changeActOnPolicy(newIsactonpolicy);
    }

    private void limitQtyChanged(int index) {
        this.triggerChangeEvent = false;
        BigDecimal limitQty = (BigDecimal)this.getValue("limitqty", index);
        DynamicObject unit = (DynamicObject)this.getValue("unit", index);
        DynamicObject item = (DynamicObject)this.getValue("item", index);
        if (item == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u8ddf\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"PromotionLimitEditPlugin_10", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean iscombination = item.getBoolean("iscombination");
        if (!iscombination && unit == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u8ddf\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"PromotionLimitEditPlugin_10", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal limitBaseQty = limitQty;
        if (!iscombination) {
            limitBaseQty = this.getUnitFormHandler().getBaseQty(item.get("id"), limitQty, unit.get("id"));
        }
        this.setValue("leftlimitqty", limitQty, index);
        this.setValue("limitbaseqty", limitBaseQty, index);
        this.setValue("leftlimitbaseqty", limitBaseQty, index);
        this.triggerChangeEvent = true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "isactonpolicyCallBack": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.checkIsActOnPolicy();
                    this.changeActOnPolicy(this.getBooleanValue("isactonpolicy"));
                    break;
                }
                this.triggerChangeEvent = false;
                this.setValue("isactonpolicy", Boolean.TRUE);
                this.triggerChangeEvent = true;
                break;
            }
        }
    }

    private void itemChanged(int index) {
        this.triggerChangeEvent = false;
        IDataModel model = this.getView().getModel();
        DynamicObject item = (DynamicObject)model.getValue("item", index);
        if (item == null) {
            return;
        }
        PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)"item", (String)"baseunit", (String)"unit", (String)"attr", (int)index);
        this.triggerChangeEvent = true;
    }

    protected void setOwnerFromCache(String fieldname) {
        FormShowParameter fsp;
        Object ownerid4cache;
        if (StringUtils.isEmpty((String)fieldname)) {
            fieldname = "owner";
        }
        if ((ownerid4cache = (fsp = this.getView().getFormShowParameter()).getCustomParam("ownerid4cache")) != null) {
            this.getModel().setValue(fieldname, ownerid4cache);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addItemClickListeners(new String[]{TOOLBAR});
        this.addF7Listener(this, new String[]{"item", "unit", "attr", "promotionpolicy", "owner"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": 
            case "save": {
                if (this.validateSave()) {
                    this.beforeExcuteSave();
                } else {
                    args.setCancel(true);
                }
                this.getModel().getDataEntity().get("starttime");
                break;
            }
        }
    }

    private boolean validateSave() {
        String limitType;
        DynamicObjectCollection policys;
        Boolean isactonpolicy = this.getBooleanValue("isactonpolicy");
        if (isactonpolicy.booleanValue() && ((policys = this.getModel().getEntryEntity("policy")) == null || policys.size() == 0 || policys.size() == 1 && ((DynamicObject)policys.get(0)).getDynamicObject("promotionpolicy") == null)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9650\u91cf\u4fc3\u9500\u653f\u7b56 \u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionLimitEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        switch (limitType = (String)this.getValue("limittype")) {
            case "qty": {
                DynamicObjectCollection qtylimititems = this.getModel().getEntryEntity("qtylimititems");
                if (qtylimititems == null || qtylimititems.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9650\u91cf\u5185\u5bb9   \u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionLimitEditPlugin_3", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                ArrayList<String> erroRows = new ArrayList<String>();
                DynamicObject presentitem = null;
                DynamicObject presentattr = null;
                boolean iscombination = false;
                for (DynamicObject entry : qtylimititems) {
                    presentitem = entry.getDynamicObject("item");
                    if (presentitem == null) {
                        erroRows.add(entry.getString("Seq"));
                        continue;
                    }
                    iscombination = presentitem.getBoolean("iscombination");
                    if (iscombination) continue;
                    if (entry.getDynamicObject("unit") == null) {
                        erroRows.add(entry.getString("Seq"));
                        continue;
                    }
                    presentattr = entry.getDynamicObject("attr");
                    if (presentattr != null || !PromotionUiUtil.hasAssistAttr((Object)presentitem.getPkValue())) continue;
                    erroRows.add(entry.getString("Seq"));
                }
                if (erroRows.size() == 0) break;
                this.getView().showErrorNotification(MessageFormat.format("\u9650\u91cf\u5185\u5bb9\u4e2d,\u7b2c{0}\u884c\u6570\u636e\u7f3a\u5c11\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u3001\u8f85\u52a9\u5c5e\u6027\u3002", String.join((CharSequence)",", erroRows)));
                return false;
            }
        }
        return true;
    }

    private void beforeExcuteSave() {
        this.handleCustomerRangeSave();
    }

    private void handleCustomerRangeSave() {
        DynamicObject customerRange = this.saveOrUpdateCustomerrange();
        this.setValue("customerrangeid", customerRange);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                OperationResult result = args.getOperationResult();
                if (result.isSuccess()) break;
                DynamicObject customerRange = (DynamicObject)this.getValue("customerrangeid");
                DeleteServiceHelper.delete((IDataEntityType)customerRange.getDataEntityType(), (Object[])new Object[]{customerRange.getPkValue()});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": 
            case "audit": {
                String billstatus = this.getValue("status").toString().trim();
                String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
                if ("B".equals(billstatus) || "C".equals(billstatus)) {
                    this.setDisVisible(new String[]{"promotionpolicytoolbar", "promotionpolicytoolbar1", "limitruletoolbar"});
                    this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
                    this.getView().getView(pageid).setEnable(Boolean.FALSE, new String[]{"entryentity"});
                } else {
                    this.setVisible(new String[]{"promotionpolicytoolbar", "promotionpolicytoolbar1", "limitruletoolbar"});
                    this.getView().getView(pageid).setVisible(Boolean.TRUE, new String[]{"advcontoolbarap"});
                    this.getView().getView(pageid).setEnable(Boolean.TRUE, new String[]{"entryentity"});
                }
                this.getView().sendFormAction(this.getView().getView(pageid));
                break;
            }
        }
    }

    private void showCustomerRangePanel(Object rangeid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_CUSTOMERRANGE, pageid);
        parameter.setFormId("dpm_customerrange");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CUSTOMERRANGE);
        parameter.setStatus(status);
        DynamicObject owner = (DynamicObject)this.getModel().getValue("owner");
        if (owner != null) {
            parameter.setCustomParam("ownerid", owner.getPkValue());
        }
        if (rangeid != null) {
            parameter.setCustomParam("id", rangeid);
        }
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{"owner"});
        this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{"entrydetail"});
        String billstatus = this.getValue("status").toString().trim();
        if ("B".equals(billstatus) || "C".equals(billstatus)) {
            this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{"advcontoolbarap"});
            this.getView().getView(pageid).setEnable(Boolean.FALSE, new String[]{"entryentity"});
        }
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private DynamicObject saveOrUpdateCustomerrange() {
        String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
        DynamicObject range = this.getView().getView(pageid).getModel().getDataEntity(true);
        DynamicObjectCollection entryEntitys = range.getDynamicObjectCollection("entryentity");
        StringBuilder errorinfo = new StringBuilder();
        if (entryEntitys == null) {
            errorinfo.append("\u8bf7\u7ef4\u62a4\u6709\u6548\u7684\u6e20\u9053\u8303\u56f4\u3002");
        } else {
            StringBuilder strkeys = null;
            String key = "";
            ArrayList<String> keys = new ArrayList<String>(entryEntitys.size());
            ArrayList<String> repeatSeq = new ArrayList<String>(entryEntitys.size());
            ArrayList<String> emptySeq = new ArrayList<String>(entryEntitys.size());
            for (DynamicObject entry : entryEntitys) {
                strkeys = new StringBuilder();
                this.setKeys(strkeys, entry.getDynamicObject("province"));
                this.setKeys(strkeys, entry.getDynamicObject("city"));
                this.setKeys(strkeys, entry.getDynamicObject("area"));
                this.setKeys(strkeys, entry.getDynamicObject("saleorgid"));
                this.setKeys(strkeys, entry.getDynamicObject("customergroup"));
                this.setKeys(strkeys, entry.getDynamicObject("customergrade"));
                this.setKeys(strkeys, entry.getDynamicObject("customer"));
                key = strkeys.toString();
                if (key.isEmpty()) {
                    emptySeq.add(entry.getString("Seq"));
                    continue;
                }
                if (keys.contains(key)) {
                    repeatSeq.add(entry.getString("Seq"));
                    continue;
                }
                keys.add(key);
            }
            if (repeatSeq.size() > 0) {
                errorinfo.append(String.format("\u5206\u5f55%s\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", repeatSeq)));
            }
            if (emptySeq.size() > 0) {
                errorinfo.append(String.format("\u5206\u5f55%s\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", emptySeq)));
            }
        }
        if (errorinfo.length() > 0) {
            throw new KDBizException(String.format("\u6e20\u9053\u8303\u56f4\uff1a%s", errorinfo));
        }
        if (range.getPkValue().equals(0L)) {
            range.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        range.getDataEntityType().getProperties();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{range});
        return range;
    }

    private void setKeys(StringBuilder strkeys, DynamicObject object) {
        if (object != null) {
            strkeys.append(object.getPkValue());
            strkeys.append('_');
        }
    }
}

