/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.formplugin.AbstractPromotionOrderEditPlugin;
import kd.drp.mdr.common.constants.SaleOrderEntryType;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.status.EnumUtil;
import kd.drp.mdr.common.util.CustomerUtil;
import kd.drp.mdr.common.util.UserUtil;

public class PromotionOrderEditPlugin
extends AbstractPromotionOrderEditPlugin
implements BeforeF7SelectListener {
    private static final String CACHE_COMBINATION_SIZE = "cacheCombinationSize";
    private static final String CACHE_COMBINATION_PREFIX = "cacheCombination-";
    private static final String BUTTON_ORDER_DELETE_ENTRY = "deleteorderentry";

    public void afterCreateNewData(EventObject e) {
        this.initDefaultOwner();
    }

    private void initDefaultOwner() {
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "deleteorderentry": {
                BigDecimal all = this.sumAllAmount();
                this.setValue("totalamount", all);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"owner", "customer", "orderunit", "orderattr"});
        this.addClickListeners(new String[]{BUTTON_ORDER_DELETE_ENTRY});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7name = e.getProperty().getName();
        int rowIndex = e.getRow();
        DynamicObject owner = this.getF7Value("owner");
        switch (f7name) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getOwnerFilter());
                break;
            }
            case "customer": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getCustomerFilter());
                break;
            }
            case "orderitem": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "orderunit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"orderitem", (int)rowIndex);
                break;
            }
            case "orderattr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"orderitem", (int)rowIndex);
            }
        }
    }

    private QFilter getOwnerFilter() {
        List ownerids = UserUtil.getOwnerIDs();
        return new QFilter("id", "in", (Object)ownerids);
    }

    private QFilter getCustomerFilter() {
        Object ownerId = this.getOwnerF7PKValue();
        if (ownerId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9500\u552e\u6e20\u9053", (String)"PromotionOrderEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
        return CustomerUtil.getAuthSubsIdsQFilter((Object)ownerId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "orderitem": {
                this.handleOldValue(index);
                if (this.isCombination((DynamicObject)e.getChangeSet()[0].getNewValue())) {
                    this.handleCombiantion(index);
                    break;
                }
                this.setValue("orderentryid", DBServiceHelper.genGlobalLongId(), index);
                this.handleItem(index);
                PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)"orderitem", (String)"orderunit", (String)"orderattr", (int)index);
                break;
            }
            case "orderqty": {
                if (this.isCombination(index)) {
                    this.changeCombinationItemQty(index);
                }
                this.sumAmount(index);
                break;
            }
            case "orderprice": {
                this.sumAmount(index);
            }
        }
    }

    public void setValue(String key, Object value, int i) {
        this.setValue(key, value, i, false);
    }

    private void handleOldValue(int index) {
        this.deleteEntry(this.getCombItemSonEntrys(index));
    }

    private void changeCombinationItemQty(int index) {
        DynamicObject orderEntry = (DynamicObject)this.getOrderList().get(index);
        if (orderEntry.getBoolean("orderiscombination")) {
            DynamicObject combination = orderEntry.getDynamicObject("orderitem");
            String mark = orderEntry.getString("ordercombinationmark");
            ArrayList<Integer> combinationEntryList = new ArrayList<Integer>();
            for (DynamicObject entry : this.getOrderList()) {
                if (!mark.equals(entry.getString("ordercombinationmark")) || !entry.getString("ordercombinationid").equals(combination.get("number"))) continue;
                int deleteEntrySeq = entry.getInt("seq");
                combinationEntryList.add(deleteEntrySeq - 1);
            }
            BigDecimal combinationQty = orderEntry.getBigDecimal("orderqty");
            DynamicObjectCollection combinationItems = this.getCombinationInfo(combination.getString("number"));
            for (DynamicObject combinationItem : combinationItems) {
                Long item = combinationItem.getLong("itemdetail.item");
                for (Integer itemIndex : combinationEntryList) {
                    DynamicObject combinationEntry = (DynamicObject)this.getOrderList().get(itemIndex.intValue());
                    if (!item.equals(this.convertCombinationF7IdToItemId(combinationEntry.getDynamicObject("orderitem").getLong("id")))) continue;
                    BigDecimal newItemQty = combinationItem.getBigDecimal("itemdetail.qty").multiply(combinationQty);
                    this.setValue("orderqty", newItemQty, combinationEntry.getInt("seq") - 1);
                }
            }
        }
    }

    private void handleCombiantion(int index) {
        Long entryId = DBServiceHelper.genGlobalLongId();
        this.setUnEnable(index, new String[]{"orderattr", "orderunit"});
        DynamicObject entry = this.getModel().getEntryRowEntity("orderlist", index);
        DynamicObject combinationInfo = entry.getDynamicObject("orderitem");
        DynamicObjectCollection items = QueryServiceHelper.query((String)"dpm_item_combination", (String)"id,totalamount,itemdetail.item,itemdetail.unit,itemdetail.attr,itemdetail.qty,itemdetail.price", (QFilter[])new QFilter("number", "=", (Object)combinationInfo.getString("number")).toArray());
        this.setValue("orderentryid", entryId, index);
        this.setValue("orderprice", ((DynamicObject)items.get(0)).getBigDecimal("totalamount"), index);
        this.setValue("ordercombinationmark", entryId, index);
        for (DynamicObject singleItem : items) {
            int newIndex = this.getModel().insertEntryRow("orderlist", index + 1);
            this.getView().sendFormAction(this.getView());
            Long itemID = singleItem.getLong("itemdetail.item");
            Long unitID = singleItem.getLong("itemdetail.unit");
            Long attrID = singleItem.getLong("itemdetail.attr");
            this.getModel().setValue("orderitem", (Object)this.convertItemIdToCombinationId(itemID), newIndex);
            this.getModel().setValue("orderunit", (Object)unitID, newIndex);
            this.getModel().setValue("orderattr", (Object)attrID, newIndex);
            this.getModel().setValue("orderprice", (Object)singleItem.getBigDecimal("itemdetail.price"), newIndex);
            this.getModel().setValue("ordertype", (Object)SaleOrderEntryType.COMBINATION_SON.getFlagStr(), newIndex);
            this.getModel().setValue("ordercombinationid", (Object)combinationInfo.getString("number"), newIndex);
            this.getModel().setValue("ordercombinationmark", (Object)entryId, newIndex);
        }
        for (int i = 1; i < items.size() + 1; ++i) {
            this.setUnEnable(index + i, new String[]{"orderqty", "orderattr", "orderitem", "orderunit", "orderprice"});
        }
        this.setValue("ordertype", SaleOrderEntryType.COMBINATION.getFlagStr(), index);
        this.setValue("orderiscombination", Boolean.TRUE, index);
    }

    private void handleItem(int index) {
        this.setEnable(index, new String[]{"orderattr", "orderunit"});
        this.setValue("ordertype", SaleOrderEntryType.COMMON.getFlagStr(), index);
        this.setValue("orderiscombination", Boolean.FALSE, index);
        this.setValue("orderunit", 0L, index);
        this.setValue("orderattr", 0L, index);
        this.setValue("ordercombinationid", "", index);
        this.setValue("orderprice", BigDecimal.ZERO, index);
    }

    private DynamicObjectCollection getCombinationInfo(String number) {
        DynamicObjectCollection items = QueryServiceHelper.query((String)"dpm_item_combination", (String)"id,itemdetail.item,itemdetail.unit,itemdetail.qty,itemdetail.price", (QFilter[])new QFilter("number", "=", (Object)number).toArray());
        return items;
    }

    private long convertItemIdToCombinationId(long id) {
        if (id == 0L) {
            return id;
        }
        DynamicObject obj = QueryServiceHelper.queryOne((String)"mdr_item_info", (String)"id,number", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (obj == null) {
            return 0L;
        }
        DynamicObject combination = QueryServiceHelper.queryOne((String)"dpm_itemcombination_f7", (String)"id", (QFilter[])new QFilter("number", "=", (Object)obj.getString("number")).toArray());
        return combination.getLong("id");
    }

    private BigDecimal sumAmount(int index) {
        DynamicObjectCollection orderList = this.getOrderList();
        if (index >= orderList.size()) {
            return BigDecimal.ZERO;
        }
        DynamicObject orderEntry = (DynamicObject)orderList.get(index);
        BigDecimal price = orderEntry.getBigDecimal("orderprice");
        BigDecimal qty = orderEntry.getBigDecimal("orderqty");
        BigDecimal amount = price.multiply(qty);
        this.setValue("orderamount", amount, index);
        BigDecimal all = this.sumAllAmount();
        this.setValue("totalamount", all);
        return amount;
    }

    private BigDecimal sumAllAmount() {
        int rowCount = this.getModel().getEntryRowCount("orderlist");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("orderlist", i);
            if (entry.getBoolean("orderamount") || entry.getString("ordercombinationid") == null || !entry.getString("ordercombinationid").trim().equals("")) continue;
            BigDecimal entryAmount = entry.getBigDecimal("orderamount");
            totalAmount = totalAmount.add(entryAmount);
        }
        return totalAmount;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "deleteentry": {
                String entryKey;
                DeleteEntry entry = (DeleteEntry)e.getSource();
                switch (entryKey = (String)entry.getParameter().get("entryId")) {
                    case "orderlist": {
                        this.checkDeleteCombinationEntry(e);
                        this.deleteEntry(e);
                    }
                }
            }
        }
    }

    private void checkDeleteCombinationEntry(BeforeDoOperationEventArgs e) {
        DeleteEntry entry = (DeleteEntry)e.getSource();
        String entryKey = (String)entry.getParameter().get("entryId");
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selectedRow = proxy.getEntryState(entryKey).getSelectedRows();
        if (selectedRow.length != 0) {
            for (int index = selectedRow.length; index > 0; --index) {
                int deleteRowIndex = selectedRow[index - 1];
                if (!this.isCombinationItem(deleteRowIndex)) continue;
                DynamicObject orderListEntry = (DynamicObject)this.getModel().getEntryEntity(entryKey).get(deleteRowIndex);
                String combinationMark = orderListEntry.getString("ordercombinationmark");
                int combinationIndex = -1;
                combinationIndex = this.getCombinationIndexByCombinationMark(combinationMark, entryKey);
                if (combinationIndex != -1 && this.isInArray(selectedRow, combinationIndex)) continue;
                e.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5355\u72ec\u5220\u9664\u7ec4\u5408\u54c1\u7684\u5546\u54c1\u5206\u5f55", (String)"PromotionOrderEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                return;
            }
        } else {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"PromotionOrderEditPlugin_3", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isCombination(int index) {
        DynamicObjectCollection list = this.getOrderList();
        if (index >= list.size()) {
            return false;
        }
        DynamicObject orderListEntry = (DynamicObject)this.getOrderList().get(index);
        DynamicObject item = orderListEntry.getDynamicObject("orderitem");
        return this.isCombination(item);
    }

    private boolean isCombination(DynamicObject item) {
        return item == null ? false : item.getBoolean("iscombination");
    }

    private boolean isCombinationItem(int index) {
        DynamicObjectCollection list = this.getOrderList();
        if (index >= list.size()) {
            return false;
        }
        DynamicObject orderListEntry = (DynamicObject)list.get(index);
        String combinationId = orderListEntry.getString("ordercombinationid");
        return combinationId != null && !combinationId.trim().equals("");
    }

    protected void deleteEntry(BeforeDoOperationEventArgs e) {
        EntryGrid itemEntry = (EntryGrid)this.getControl("orderlist");
        int[] selectRows = itemEntry.getSelectRows();
        HashSet<Integer> rows = new HashSet<Integer>();
        for (int i : selectRows) {
            String entrytype = (String)this.getValue("ordertype", i);
            if (SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entrytype)) continue;
            rows.add(i);
            rows.addAll(this.getCombItemSonEntrys(i));
        }
        if (rows != null && rows.size() > 0) {
            this.deleteEntry(rows);
        }
        e.setCancel(true);
    }

    protected SaleOrderEntryType getEntryType(int i) {
        String entrytype = (String)this.getValue("ordertype", i);
        return EnumUtil.toSaleOrderEntryType((String)entrytype);
    }

    protected Set<Integer> getCombItemSonEntrys(int i) {
        HashSet<Integer> rows = new HashSet<Integer>();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("orderlist", i);
        String parentId = entryRowEntity.getString("ordercombinationmark");
        String entrytype = (String)this.getValue("ordertype", i);
        if (!SaleOrderEntryType.COMBINATION.getFlagStr().equals(entrytype)) {
            return rows;
        }
        for (int j = 0; j < this.getModel().getEntryRowCount("orderlist"); ++j) {
            String parententryid;
            if (i == j) continue;
            entrytype = (String)this.getValue("ordertype", j);
            if (!SaleOrderEntryType.COMBINATION_SON.getFlagStr().equals(entrytype) || !parentId.equals(parententryid = (String)this.getValue("ordercombinationmark", j))) continue;
            rows.add(j);
        }
        return rows;
    }

    private void deleteEntry(Set<Integer> rows) {
        int j = 0;
        int[] rowindex = new int[rows.size()];
        for (Integer rowIndex : rows) {
            rowindex[j++] = rowIndex;
        }
        this.getModel().deleteEntryRows("orderlist", rowindex);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("closeCallBack", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5185\u5bb9\u6709\u4fee\u6539\uff0c\u662f\u5426\u786e\u5b9a\u9000\u51fa?", (String)"PromotionOrderEditPlugin_4", (String)"drp-dpm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBacks);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("closeCallBack".equals(messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().setDataChanged(false);
                this.getView().close();
            } else {
                return;
            }
        }
    }
}

