/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.model.Promotion;
import kd.drp.dpm.common.model.execution.PromotionExecutionUnit;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.dpm.formplugin.AbstractPromotionOrderEditPlugin;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class PromotionOrderPolicyEditPlugin
extends AbstractPromotionOrderEditPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"promotionpolicyfind", "promotionresultswitch"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "promotionpolicyfind": {
                this.loadPromotionPolicy();
                break;
            }
            case "promotionresultswitch": {
                this.switchUsed();
                break;
            }
        }
    }

    private void loadPromotionPolicy() {
        PromotionOrder order = this.createPromotionOrder();
        PromotionExecuteContext context = PromotionUtil.matchAndExecute((String)this.getView().getPageId(), (PromotionOrder)order);
        this.fillPromotionPolicyList(context.getPromotions());
        this.fillPromotionResultList(context);
        this.showPromotionOrderInResultView(context.getOrder());
    }

    private void fillPromotionPolicyList(Set<Promotion> promotionset) {
        this.getModel().deleteEntryData("promotionpolicylist");
        if (promotionset.isEmpty()) {
            return;
        }
        int[] index = this.getModel().batchCreateNewEntryRow("promotionpolicylist", promotionset.size());
        int i = 0;
        for (Promotion promotion : promotionset) {
            this.setValue("promotion", promotion.getId(), index[i]);
            ++i;
        }
    }

    private void fillPromotionResultList(PromotionExecuteContext ctx) {
        this.getModel().deleteEntryData("resultlist");
        for (Promotion promotion : ctx.getPromotions()) {
            ReplaceablePromotionExecution execution = ctx.get(promotion);
            this.showResultOnList(String.valueOf(promotion.getPriority()), execution, ctx.getOrder());
        }
    }

    private void switchUsed() {
        int selectedIndex;
        DynamicObject selectedEntry;
        Boolean isUsed;
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] selectedRow = proxy.getEntryState("resultlist").getSelectedRows();
        DynamicObjectCollection results = this.getModel().getEntryEntity("resultlist");
        if (selectedRow.length == 1 && !(isUsed = Boolean.valueOf((selectedEntry = (DynamicObject)results.get(selectedIndex = selectedRow[0])).getBoolean("resultisused"))).booleanValue()) {
            Object selectedPromotionId = selectedEntry.getDynamicObject("resultpolicy").getPkValue();
            String selectedGroup = selectedEntry.getString("resultgroup");
            Integer selectedPriority = selectedEntry.getInt("resultpriority");
            this.executeNewPromotionResult(selectedPromotionId, selectedGroup, selectedPriority);
        }
    }

    private void executeNewPromotionResult(Object selectedPromotionId, String selectedGroup, Integer selectedPriority) {
        this.getModel().deleteEntryData("resultlist");
        PromotionExecuteContext context = PromotionUtil.switchExecutions((String)this.getView().getPageId(), (PromotionOrder)this.createPromotionOrder(false), (Object)selectedPromotionId, (char)selectedGroup.charAt(0));
        this.getModel().deleteEntryData("resultorderlist");
        this.fillPromotionResultList(context);
        this.showPromotionOrderInResultView(context.getOrder());
    }

    private void showResultOnList(String priorityKey, ReplaceablePromotionExecution promotionsExecution, PromotionOrder order) {
        char[] charset;
        if (promotionsExecution == null) {
            return;
        }
        LinkedList<DynamicObject> list = new LinkedList<DynamicObject>();
        int lines = 0;
        Object promotionId = promotionsExecution.getPromotionid();
        for (char c : charset = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'}) {
            PromotionExecutionUnit unit = promotionsExecution.get(Character.valueOf(c));
            if (unit == null) continue;
            DynamicObject object = unit.createExecution(promotionId);
            DynamicObjectCollection entries = object.getDynamicObjectCollection("entryentity");
            if (entries != null) {
                lines += entries.size();
            }
            list.add(object);
        }
        if (lines == 0) {
            return;
        }
        int[] rowIndexes = this.getModel().batchCreateNewEntryRow("resultlist", lines);
        this.getView().sendFormAction(this.getView());
        int initIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject obj = (DynamicObject)list.get(i);
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            if (entries.size() <= 0 || entries.get(0) == null) continue;
            for (DynamicObject dynamicObject : entries) {
                int index = rowIndexes[initIndex];
                this.setValue("resultpriority", priorityKey, index);
                this.setValue("resultpolicy", promotionId, index);
                this.setValue("resultisused", obj.get("isused"), index);
                this.setValue("resultgroup", obj.get("groupnumber"), index);
                this.setValue("resulttype", dynamicObject.get("type"), index);
                this.setValue("resultresultid", dynamicObject.get("resultid"), index);
                DynamicObject item = dynamicObject.getDynamicObject("item");
                DynamicObject combination = dynamicObject.getDynamicObject("combination");
                if (item != null) {
                    DynamicObject attr;
                    this.setValue("resultitem_combination", item.getPkValue(), index);
                    DynamicObject unit = dynamicObject.getDynamicObject("unit");
                    if (unit != null) {
                        this.setValue("resultitemunit", unit.getPkValue(), index);
                    }
                    if ((attr = dynamicObject.getDynamicObject("attr")) != null) {
                        this.setValue("resultitemattr", attr.getPkValue(), index);
                    }
                } else if (combination != null) {
                    this.setValue("resultcombination", combination.getPkValue(), index);
                }
                this.setValue("resultitemqty", dynamicObject.get("qty"), index);
                this.setValue("resultitempricediff", dynamicObject.get("pricediff"), index);
                this.setValue("resultitemamountdiff", dynamicObject.get("amountdiff"), index);
                ++initIndex;
            }
        }
    }

    private void showPromotionOrderInResultView(PromotionOrder order) {
        PromotionOrder sourceOrder = this.createPromotionOrder();
        List entries = order.getEntries();
        int size = order.getEntries().size();
        if (size == 0) {
            return;
        }
        this.getModel().deleteEntryData("resultorderlist");
        int[] indexes = this.getModel().batchCreateNewEntryRow("resultorderlist", size);
        for (int i = 0; i < indexes.length; ++i) {
            PromotionOrderEntry sourceEntry;
            int index = indexes[i];
            PromotionOrderEntry entry = (PromotionOrderEntry)entries.get(i);
            this.setValue("resultorderentryid", entry.getEntryid(), index);
            this.setValue("resultorderitem", entry.getItemid(), index);
            this.setValue("resultorderunit", entry.getUnitid(), index);
            this.setValue("resultorderattr", entry.getAttrid(), index);
            this.setValue("promotionprice", entry.getPrice(), index);
            this.setValue("resultorderqty", entry.getQty(), index);
            this.setValue("orderpromotonamount", entry.getAmount(), index);
            this.setValue("resultordertype", entry.getType(), index);
            this.setValue("resultorderispresent", entry.isIspresent(), index);
            this.setValue("resultorderiscombination", entry.isIscombination(), index);
            this.setValue("resultordercombmark", entry.getSourceentryid(), index);
            if (entry.getEntryid() == null || (sourceEntry = sourceOrder.getEntryById(entry.getEntryid())) == null) continue;
            this.setValue("resultorderamount", sourceEntry.getAmount(), index);
            this.setValue("freeamount", entry.getAmount().subtract(sourceEntry.getAmount()), index);
            this.setValue("resultorderprice", sourceEntry.getPrice(), index);
            this.setValue("freeprice", entry.getPrice().subtract(sourceEntry.getPrice()), index);
        }
        this.setValue("totalamount1", sourceOrder.getTotalamount());
        this.setValue("freetotalamount", sourceOrder.getTotalamount().subtract(order.getTotalamount()));
        this.setValue("promotionamount", order.getTotalamount());
    }
}

