/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.drp.dpm.common.cache.DPMAppCache;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.limit.PromotionLimitUtil;
import kd.drp.dpm.formplugin.AbstractPromotionOrderEditPlugin;
import kd.drp.mdr.common.model.dpm.LimitResult;
import kd.drp.mdr.common.model.dpm.LimitResultEntry;
import kd.drp.mdr.common.model.dpm.PromotionOrder;
import kd.drp.mdr.common.model.dpm.PromotionOrderEntry;

public class PromotionOrderResultEditPlugin
extends AbstractPromotionOrderEditPlugin {
    private static final String BUTTON_MATCH_LIMIT = "matchlimit";
    private static final String BUTTON_ORDER = "order";

    public void afterBindData(EventObject e) {
        this.setValue("matchlimitmode", "1,2,3,4");
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "matchlimit": {
                this.executeLimitPolicy();
            }
        }
    }

    private void executeLimitPolicy() {
        DynamicObject owner = (DynamicObject)this.getValue("owner");
        DynamicObject customer = (DynamicObject)this.getValue("customer");
        if (owner != null && customer != null) {
            PromotionExecuteContext context = DPMAppCache.getContextFromCache((String)this.getView().getPageId());
            if (context == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fc3\u9500\u653f\u7b56", (String)"PromotionOrderResultEditPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            }
            if (context.getOrder() == null) {
                PromotionOrder order = this.createPromotionOrderFromResult();
                context.setOrder(order);
                LimitResult res = PromotionLimitUtil.validateLimitRule((String)context.getCachekey(), (PromotionOrder)order, (boolean)true);
                this.showResultInLimitFlex(res);
                this.showResultInOrder(context.getOrder());
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u6e20\u9053 \u6216 \u8ba2\u8d27\u6e20\u9053 \u4e0d\u80fd\u4e3a\u7a7a", (String)"PromotionOrderResultEditPlugin_5", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showResultInOrder(PromotionOrder order) {
        this.getModel().deleteEntryData("present");
        for (PromotionOrderEntry entry : order.getEntries()) {
            if (!entry.isIspresent()) continue;
            int index = this.getModel().createNewEntryRow("present");
            this.setValue("presentitem", entry.getItemid(), index);
            this.setValue("presentunit", entry.getUnitid(), index);
            this.setValue("presentattr", entry.getAttrid(), index);
            this.setValue("presentqty", entry.getQty(), index);
        }
    }

    private void showResultInLimitFlex(LimitResult res) {
        this.getModel().deleteEntryData("limitflex");
        if (res == null) {
            return;
        }
        this.showMatchLimitRule(res);
        if (res.isSuccessExecuteLimit()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9650\u91cf\u9a8c\u8bc1\u7ed3\u679c\u6210\u529f", (String)"PromotionOrderResultEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9650\u91cf\u9a8c\u8bc1\u7ed3\u679c\u5931\u8d25\uff0c\u5f53\u524d\u8ba2\u5355\u4e2d\u7684\u90e8\u5206\u5546\u54c1\u8d85\u51fa\u4e86\u9650\u91cf", (String)"PromotionOrderResultEditPlugin_3", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showMatchLimitRule(LimitResult res) {
        Map contextEntries = res.getLimitResultEntries();
        Set idset = contextEntries.keySet();
        if (idset.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u7684\u9650\u91cf\u89c4\u5219", (String)"PromotionOrderResultEditPlugin_4", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().batchCreateNewEntryRow("limitflex", contextEntries.size());
        int index = 0;
        for (Map.Entry detail : contextEntries.entrySet()) {
            LimitResultEntry entry = (LimitResultEntry)detail.getValue();
            this.setValue("limitrule", entry.getRuleId(), index);
            this.setValue("limititem", entry.getItemId(), index);
            this.setValue("limitunit", entry.getUnitId(), index);
            this.setValue("limitattr", entry.getAttrId(), index);
            this.setValue("leftlimitqty", entry.getLeftLimitQty(), index);
            this.setValue("minuslimitqty", entry.getMinusQty(), index);
            this.setValue("executeresult", entry.getExecuteResult(), index);
            ++index;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_ORDER, BUTTON_MATCH_LIMIT});
    }
}

