/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.common.PromotionDataServiceHelper;
import kd.drp.dpm.formplugin.PromotionBaseEdit;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.UserUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class PromotionPolicyEditPlugin
extends PromotionBaseEdit
implements BeforeF7SelectListener {
    public static final String TOOLBAR = "toolbarap";
    public static final String BAR_SAVE = "bar_save";
    public static final String BAR_SUBMIT = "bar_submit";
    public static final String BAR_UNSUBMIT = "bar_unsubmit";
    public static final String BAR_AUDIT = "bar_audit";
    public static final String BAR_UNAUDIT = "bar_unaudit";
    public static final String BAR_ENABLE = "bar_enable";
    public static final String BAR_DISABLE = "bar_disable";
    public static final String OWNER = "owner";
    public static final String CUSTOMERRANGE_FLEX = "customerrange_flex";
    public static final String SALESCONDITIONS_FLEX = "salesconditions_flex";
    public static final String LIMITCONTENT_FLEX = "limitcontent_flex";
    public static final String PRESENTINFO_FLEX = "presentinfo_flex";
    public static final String FULLFREEINFO_FLEX = "fullfreeinfo_flex";
    public static final String REDUCTIONSINFO_FLEX = "reductionsinfo_flex";
    public static final String REBATEINFO_FLEX = "rebateinfo_flex";
    public static final String CUSTOMER = "customer";
    public static final String REGION = "region";
    public static final String CUSTOMERGROUP = "customergroup";
    public static final String CUSTOMERGRADE = "customergrade";
    public static final String ISREMOVED = "isremoved";
    public static final String ENTRYENTITY = "entryentity";
    public static final String SCHEDULETYPE = "scheduletype";
    public static final String WEEKPANEL = "weektype";
    public static final String MONTHPANEL = "monthtype";
    public static final String WEEK_PREFIX = "week";
    public static final String DAY_PREFIX = "day";
    public static final String START_HOUR = "starthour";
    public static final String START_MIN = "startmin";
    public static final String END_HOUR = "endhour";
    public static final String END_MIN = "endmin";
    public static final String PAGE_CUSTOMERRANGE = "page_customerrange";
    public static final String PAGE_SALESCONDITIONS = "page_salesconditions";
    public static final String PAGE_LIMITCONTENT = "page_limitcontent";
    public static final String PAGE_PRESENTINFO = "page_presentinfo";
    public static final String PAGE_FULLFREEINFO = "page_fullfreeinfo";
    public static final String PAGE_REDUCTIONSINFO = "page_reductionsinfo";
    public static final String PAGE_REBATEINFO = "page_rebateinfo";
    public static final String ITEMRANGE_KEY = "itemrange_key";
    public static final String CONDITIONEXP = "conditionexp";
    public static final String RESULTEXP = "resultexp";
    protected volatile boolean isCopy = false;

    @Override
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object owner = this.getOwnerF7PKValue();
        if (this.isAddNew() && !this.isCopy) {
            this.showCustomerRangePanel(null, owner, OperationStatus.ADDNEW);
            this.showSalesConditionsPanel(null, owner, OperationStatus.ADDNEW);
            this.showLimitContentPanel(null, owner, OperationStatus.ADDNEW);
            this.showPresentInfoPanel(null, owner, OperationStatus.ADDNEW);
            this.showReductionsInfoPanel(null, owner, OperationStatus.ADDNEW);
            this.showFullfreeInfoPanel(null, owner, OperationStatus.ADDNEW);
            this.showRebateInfoPanel(null, owner, OperationStatus.ADDNEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{WEEKPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{MONTHPANEL});
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            DynamicObject policy = this.getPolicyObject();
            DynamicObject customerrange = policy.getDynamicObject("customerrange");
            this.showCustomerRangePanel(customerrange == null ? null : customerrange.getPkValue(), owner, status);
            DynamicObject limitcontent = policy.getDynamicObject("limitcontent");
            this.showLimitContentPanel(limitcontent == null ? null : limitcontent.getPkValue(), owner, status);
            String conditionid = null;
            Long presentid = null;
            Long reductionsid = null;
            Long fullfreeid = null;
            Long rebateid = null;
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col != null && col.size() == 1) {
                String resultexp;
                DynamicObject entry = (DynamicObject)col.get(0);
                String conditionexp = entry.getString(CONDITIONEXP);
                if (!conditionexp.isEmpty()) {
                    conditionid = conditionexp.split("AND|OR")[0];
                }
                if (!(resultexp = entry.getString(RESULTEXP)).isEmpty()) {
                    String[] resultexps = resultexp.split("AND|OR");
                    HashSet<Long> ids = new HashSet<Long>(resultexps.length);
                    for (String object : resultexps) {
                        ids.add(Long.valueOf(object));
                    }
                    DynamicObjectCollection resultrelations = QueryServiceHelper.query((String)"dpm_result_relation", (String)"id,resulttype.metadata.number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    Long id = null;
                    String resultentity = "";
                    for (DynamicObject resultrelation : resultrelations) {
                        id = resultrelation.getLong("id");
                        switch (resultentity = resultrelation.getString("resulttype.metadata.number")) {
                            case "dpm_result_present": {
                                presentid = id;
                                break;
                            }
                            case "dpm_result_fullfree": {
                                fullfreeid = id;
                                break;
                            }
                            case "dpm_result_rebate": {
                                rebateid = id;
                                break;
                            }
                            case "dpm_result_reductions": {
                                reductionsid = id;
                                break;
                            }
                        }
                    }
                }
            }
            this.showSalesConditionsPanel(conditionid, owner, status);
            this.showPresentInfoPanel(presentid, owner, status);
            this.showReductionsInfoPanel(reductionsid, owner, status);
            this.showFullfreeInfoPanel(fullfreeid, owner, status);
            this.showRebateInfoPanel(rebateid, owner, status);
            if (this.isCopy) {
                this.getView().getModel().deleteEntryData(ENTRYENTITY);
                this.setValue("limitcontent", null);
                this.setValue("customerrange", null);
            }
            this.loadSchedule(policy);
            this.lockOwner();
        }
        this.getModel().setDataChanged(false);
        this.initializeIsEditable();
        this.setBarEnable();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.SetOwnerFromCache(OWNER);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.isCopy = true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBAR});
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{OWNER});
    }

    public void propertyChanged(PropertyChangedArgs e, String key) {
        Boolean triggerChangeEventLocal = (Boolean)MdrFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            MdrFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        switch (key) {
            case "scheduletype": {
                this.showScheduleTypePanel();
                break;
            }
            case "owner": {
                ChangeData data = e.getChangeSet()[0];
                this.ownerChange(data.getNewValue(), data.getOldValue());
            }
        }
    }

    private void showScheduleTypePanel() {
        IFormView view = this.getView();
        String type = super.getModel().getValue(SCHEDULETYPE).toString();
        if (WEEK_PREFIX.equals(type)) {
            view.setVisible(Boolean.TRUE, new String[]{WEEKPANEL});
            view.setVisible(Boolean.FALSE, new String[]{MONTHPANEL});
        } else if ("month".equals(type)) {
            view.setVisible(Boolean.FALSE, new String[]{WEEKPANEL});
            view.setVisible(Boolean.TRUE, new String[]{MONTHPANEL});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{WEEKPANEL});
            view.setVisible(Boolean.FALSE, new String[]{MONTHPANEL});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7name;
        switch (f7name = e.getProperty().getName()) {
            case "owner": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)UserUtil.getAuthorizedCommonUserOwnersFilter());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "ownerChange": {
                if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.refreshChildPageOwner();
                    break;
                }
                String operateKey = messageBoxClosedEvent.getCustomVaule();
                this.setValue(OWNER, operateKey, false);
                break;
            }
        }
    }

    private void showCustomerRangePanel(Object rangeid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_CUSTOMERRANGE, pageid);
        parameter.setFormId("dpm_customerrange");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(CUSTOMERRANGE_FLEX);
        parameter.setStatus(status);
        if (rangeid != null) {
            parameter.setCustomParam("id", rangeid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{OWNER});
        this.getView().getView(pageid).setVisible(Boolean.FALSE, new String[]{"entrydetail"});
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showSalesConditionsPanel(Object conditionid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_SALESCONDITIONS, pageid);
        parameter.setFormId("dpm_condition");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(SALESCONDITIONS_FLEX);
        parameter.setStatus(status);
        if (conditionid != null) {
            parameter.setCustomParam("id", conditionid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showLimitContentPanel(Object limitcontentid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_LIMITCONTENT, pageid);
        parameter.setFormId("dpm_limit_content");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(LIMITCONTENT_FLEX);
        parameter.setStatus(status);
        if (limitcontentid != null) {
            parameter.setCustomParam("id", limitcontentid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showFullfreeInfoPanel(Object conditionid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_FULLFREEINFO, pageid);
        parameter.setFormId("dpm_result_fullfree");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(FULLFREEINFO_FLEX);
        parameter.setStatus(status);
        if (conditionid != null) {
            parameter.setCustomParam("id", conditionid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showReductionsInfoPanel(Object conditionid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_REDUCTIONSINFO, pageid);
        parameter.setFormId("dpm_result_reductions");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(REDUCTIONSINFO_FLEX);
        parameter.setStatus(status);
        if (conditionid != null) {
            parameter.setCustomParam("id", conditionid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showRebateInfoPanel(Object conditionid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_REBATEINFO, pageid);
        parameter.setFormId("dpm_result_rebate");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(REBATEINFO_FLEX);
        parameter.setStatus(status);
        if (conditionid != null) {
            parameter.setCustomParam("id", conditionid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void showPresentInfoPanel(Object conditionid, Object ownerid, OperationStatus status) {
        BaseShowParameter parameter = new BaseShowParameter();
        String pageid = parameter.getPageId();
        this.getPageCache().put(PAGE_PRESENTINFO, pageid);
        parameter.setFormId("dpm_result_present");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(PRESENTINFO_FLEX);
        parameter.setStatus(status);
        if (conditionid != null) {
            parameter.setCustomParam("id", conditionid);
        }
        if (ownerid != null) {
            parameter.setCustomParam("ownerid", ownerid);
        }
        parameter.setCustomParam("iscopy", (Object)this.isCopy);
        this.getView().showForm((FormShowParameter)parameter);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private void saveOrUpdateCustomerrange(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
        DynamicObject range = this.getView().getView(pageid).getModel().getDataEntity(true);
        DynamicObjectCollection entryEntitys = range.getDynamicObjectCollection(ENTRYENTITY);
        StringBuilder errorinfo = new StringBuilder();
        if (entryEntitys == null) {
            errorinfo.append(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6709\u6548\u7684\u6e20\u9053\u8303\u56f4", (String)"PromotionPolicyEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        } else {
            StringBuilder strkeys = null;
            String key = "";
            ArrayList<String> keys = new ArrayList<String>(entryEntitys.size());
            ArrayList<String> repeatSeq = new ArrayList<String>(entryEntitys.size());
            ArrayList<String> emptySeq = new ArrayList<String>(entryEntitys.size());
            for (DynamicObject entry : entryEntitys) {
                strkeys = new StringBuilder();
                this.setKeys(strkeys, entry.getDynamicObject("province"));
                this.setKeys(strkeys, entry.getDynamicObject("city"));
                this.setKeys(strkeys, entry.getDynamicObject("area"));
                this.setKeys(strkeys, entry.getDynamicObject("saleorgid"));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMERGROUP));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMERGRADE));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMER));
                key = strkeys.toString();
                if (key.isEmpty()) {
                    emptySeq.add(entry.getString("Seq"));
                    continue;
                }
                if (keys.contains(key)) {
                    repeatSeq.add(entry.getString("Seq"));
                    continue;
                }
                keys.add(key);
            }
            if (repeatSeq.size() > 0) {
                errorinfo.append(String.format("\u5206\u5f55%s\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", repeatSeq)));
            }
            if (emptySeq.size() > 0) {
                errorinfo.append(String.format("\u5206\u5f55%s\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", emptySeq)));
            }
        }
        if (errorinfo.length() > 0) {
            throw new KDBizException(String.format("\u6e20\u9053\u8303\u56f4\uff1a%s", errorinfo));
        }
        if (range.getPkValue().equals(0L)) {
            range.set("id", (Object)DBServiceHelper.genGlobalLongId());
        }
        policy.set("customerrange", (Object)range);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{range});
    }

    private void setKeys(StringBuilder strkeys, DynamicObject object) {
        if (object != null) {
            strkeys.append(object.getPkValue());
            strkeys.append('_');
        }
    }

    private void saveOrUpdatePresentInfo(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_PRESENTINFO);
        IFormView view = this.getView().getView(pageid);
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        if (dynamicObject == null || !dynamicObject.getBoolean("ispresent")) {
            return;
        }
        OperationResult opresult = view.invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col == null || col.size() == 0) {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.setValue(RESULTEXP, okIds.get(0), 0);
            } else {
                DynamicObject entry = (DynamicObject)col.get(0);
                String resultexp = entry.getString(RESULTEXP);
                if (resultexp.isEmpty()) {
                    this.setValue(RESULTEXP, okIds.get(0), 0);
                } else {
                    this.setValue(RESULTEXP, String.format("%sAND%s", resultexp, okIds.get(0)), 0);
                }
            }
        }
    }

    private void saveOrUpdateFullfreeInfo(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_FULLFREEINFO);
        IFormView view = this.getView().getView(pageid);
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        if (dynamicObject == null || !dynamicObject.getBoolean("isfullfree")) {
            return;
        }
        OperationResult opresult = view.invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col == null || col.size() == 0) {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.setValue(RESULTEXP, okIds.get(0), 0);
            } else {
                DynamicObject entry = (DynamicObject)col.get(0);
                String resultexp = entry.getString(RESULTEXP);
                if (resultexp.isEmpty()) {
                    this.setValue(RESULTEXP, okIds.get(0), 0);
                } else {
                    this.setValue(RESULTEXP, String.format("%sAND%s", resultexp, okIds.get(0)), 0);
                }
            }
        }
    }

    private void saveOrUpdateReductionsInfo(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_REDUCTIONSINFO);
        IFormView view = this.getView().getView(pageid);
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        if (dynamicObject == null || !dynamicObject.getBoolean("isreductions")) {
            return;
        }
        OperationResult opresult = view.invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col == null || col.size() == 0) {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.setValue(RESULTEXP, okIds.get(0), 0);
            } else {
                DynamicObject entry = (DynamicObject)col.get(0);
                String resultexp = entry.getString(RESULTEXP);
                if (resultexp.isEmpty()) {
                    this.setValue(RESULTEXP, okIds.get(0), 0);
                } else {
                    this.setValue(RESULTEXP, String.format("%sAND%s", resultexp, okIds.get(0)), 0);
                }
            }
        }
    }

    private void saveOrUpdateRebateInfo(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_REBATEINFO);
        IFormView view = this.getView().getView(pageid);
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        if (dynamicObject == null || !dynamicObject.getBoolean("isrebate")) {
            return;
        }
        OperationResult opresult = view.invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col == null || col.size() == 0) {
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.setValue(RESULTEXP, okIds.get(0), 0);
            } else {
                DynamicObject entry = (DynamicObject)col.get(0);
                String resultexp = entry.getString(RESULTEXP);
                if (resultexp.isEmpty()) {
                    this.setValue(RESULTEXP, okIds.get(0), 0);
                } else {
                    this.setValue(RESULTEXP, String.format("%sAND%s", resultexp, okIds.get(0)), 0);
                }
            }
        }
    }

    private void saveOrUpdateSalesCondition(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_SALESCONDITIONS);
        OperationResult opresult = this.getView().getView(pageid).invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            DynamicObjectCollection col = policy.getDynamicObjectCollection(ENTRYENTITY);
            if (col == null || col.size() == 0) {
                this.getModel().createNewEntryRow(ENTRYENTITY);
            }
            this.setValue(CONDITIONEXP, okIds.get(0), 0);
        }
    }

    private void saveOrUpdateLimitContent(DynamicObject policy) {
        String pageid = this.getPageCache().get(PAGE_LIMITCONTENT);
        IFormView view = this.getView().getView(pageid);
        DynamicObject dynamicObject = view.getModel().getDataEntity(true);
        if (dynamicObject == null || !dynamicObject.getBoolean("islimit")) {
            this.setValue("limitcontent", null);
            return;
        }
        OperationResult opresult = this.getView().getView(pageid).invokeOperation("confirm");
        if (!opresult.isSuccess()) {
            this.getView().getView(pageid).showOperationResult(opresult);
            return;
        }
        List okIds = opresult.getSuccessPkIds();
        if (okIds != null && okIds.size() == 1) {
            this.setValue("limitcontent", okIds.get(0));
        }
    }

    private void loadSchedule(DynamicObject policy) {
        int i;
        String scheduletype = policy.getString(SCHEDULETYPE);
        this.setValue(SCHEDULETYPE, scheduletype);
        if (scheduletype == null || scheduletype.trim().equals("") || scheduletype.equals(DAY_PREFIX)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{WEEKPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{MONTHPANEL});
            return;
        }
        String schedulevalues = policy.getString("schedulevalues");
        String[] values = schedulevalues.split(",");
        String value = "";
        if (scheduletype.equals("month")) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                if (value.isEmpty()) continue;
                this.setValue(DAY_PREFIX + values[i], Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{WEEKPANEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{MONTHPANEL});
        }
        if (scheduletype.equals(WEEK_PREFIX)) {
            for (i = 0; i < values.length; ++i) {
                value = values[i];
                if (value.isEmpty()) continue;
                this.setValue(WEEK_PREFIX + values[i], Boolean.TRUE);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{WEEKPANEL});
            this.getView().setVisible(Boolean.FALSE, new String[]{MONTHPANEL});
        }
    }

    private void ownerChange(Object newValue, Object oldValue) {
        if (newValue == null) {
            this.setValue(OWNER, oldValue, false);
        } else if (oldValue == null) {
            this.refreshChildPageOwner();
        } else {
            String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
            IDataModel childmodel = this.getView().getView(pageid).getModel();
            DynamicObject customerrange = childmodel.getDataEntity(true);
            DynamicObjectCollection entrys = customerrange.getDynamicObjectCollection(ENTRYENTITY);
            boolean isask = false;
            if (entrys != null && entrys.size() > 0) {
                StringBuilder strkeys = new StringBuilder();
                DynamicObject entry = (DynamicObject)entrys.get(0);
                this.setKeys(strkeys, entry.getDynamicObject("province"));
                this.setKeys(strkeys, entry.getDynamicObject("city"));
                this.setKeys(strkeys, entry.getDynamicObject("area"));
                this.setKeys(strkeys, entry.getDynamicObject("saleorgid"));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMERGROUP));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMERGRADE));
                this.setKeys(strkeys, entry.getDynamicObject(CUSTOMER));
                if (!strkeys.toString().isEmpty()) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_SALESCONDITIONS);
                if (this.getView().getView(pageid).getModel().getDataEntity().getDynamicObject("conditiontype") != null) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_LIMITCONTENT);
                if (this.getView().getView(pageid).getModel().getDataEntity().getBoolean("islimit")) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_PRESENTINFO);
                if (this.getView().getView(pageid).getModel().getDataEntity().getBoolean("ispresent")) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_FULLFREEINFO);
                if (this.getView().getView(pageid).getModel().getDataEntity().getBoolean("isfullfree")) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_REDUCTIONSINFO);
                if (this.getView().getView(pageid).getModel().getDataEntity().getBoolean("isreductions")) {
                    isask = true;
                }
            }
            if (!isask) {
                pageid = this.getPageCache().get(PAGE_REBATEINFO);
                if (this.getView().getView(pageid).getModel().getDataEntity().getBoolean("isrebate")) {
                    isask = true;
                }
            }
            if (isask) {
                ConfirmCallBackListener callBack = new ConfirmCallBackListener("ownerChange", (IFormPlugin)this);
                String oldid = ((DynamicObject)oldValue).getString("id");
                this.getView().showConfirm("\u5207\u6362\u9500\u552e\u6e20\u9053\u5c06\u6e05\u7a7a\u6e20\u9053\u8303\u56f4\u3001\u4fc3\u9500\u6761\u4ef6\u548c\u4fc3\u9500\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4\u3002", "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, oldid);
            } else {
                this.refreshChildPageOwner();
            }
        }
    }

    private void refreshChildPageOwner() {
        Object ownervalue = this.getModel().getValue(OWNER);
        String pageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
        IDataModel childmodel = this.getView().getView(pageid).getModel();
        childmodel.setValue(OWNER, ownervalue);
        childmodel.deleteEntryData(ENTRYENTITY);
        childmodel.createNewEntryRow(ENTRYENTITY);
        this.getView().sendFormAction(this.getView().getView(pageid));
        this.refreshChildPageOwner(PAGE_SALESCONDITIONS, ownervalue);
        this.refreshChildPageOwner(PAGE_LIMITCONTENT, ownervalue);
        this.refreshChildPageOwner(PAGE_PRESENTINFO, ownervalue);
        this.refreshChildPageOwner(PAGE_FULLFREEINFO, ownervalue);
        this.refreshChildPageOwner(PAGE_REDUCTIONSINFO, ownervalue);
        this.refreshChildPageOwner(PAGE_REBATEINFO, ownervalue);
    }

    private void refreshChildPageOwner(String pagekey, Object ownervalue) {
        String pageid = this.getPageCache().get(pagekey);
        IDataModel childmodel = this.getView().getView(pageid).getModel();
        childmodel.setValue(OWNER, ownervalue);
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    private DynamicObject getPolicyObject() {
        return this.getModel().getDataEntity(true);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (Long.valueOf(0L).equals(this.getPolicyObject().getPkValue())) {
            DynamicObjectCollection unitcol = this.getPolicyObject().getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject unit : unitcol) {
                PromotionDataServiceHelper.deleteUnitContent((String)unit.getString(CONDITIONEXP), (String)unit.getString(RESULTEXP));
            }
        }
    }

    private void initializeIsEditable() {
        String status = this.getPolicyObject().getString("policystatus");
        boolean isEditable = "A".equals(status);
        this.refreshCustomerRangeView(isEditable);
        this.refreshSalesConditionView(isEditable);
        this.refreshLimitContentView(isEditable);
        this.refreshPresentView(isEditable);
        this.refreshFullfreeView(isEditable);
        this.refreshReductionsView(isEditable);
        this.refreshRebateView(isEditable);
    }

    private void refreshIsEditable() {
        DynamicObject policy = this.getPolicyObject();
        boolean isEditable = "A".equals(policy.getString("policystatus"));
        this.refreshCustomerRangeView(isEditable);
        this.refreshSalesConditionView(isEditable);
        this.refreshLimitContentView(isEditable);
        this.refreshPresentView(isEditable);
        this.refreshFullfreeView(isEditable);
        this.refreshReductionsView(isEditable);
        this.refreshRebateView(isEditable);
    }

    private void refreshCustomerRangeView(boolean iseditable) {
        String customerrangepageid = this.getPageCache().get(PAGE_CUSTOMERRANGE);
        IFormView customerrangeview = this.getView().getView(customerrangepageid);
        customerrangeview.setEnable(Boolean.valueOf(iseditable), new String[]{ENTRYENTITY});
        customerrangeview.setVisible(Boolean.valueOf(iseditable), new String[]{"addentry", "deleteentry"});
        this.getView().sendFormAction(customerrangeview);
    }

    private void refreshPresentView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_PRESENTINFO);
        IFormView presentView = this.getView().getView(pageid);
        presentView.setEnable(Boolean.valueOf(iseditable), new String[]{"present"});
        this.getView().sendFormAction(presentView);
    }

    private void refreshFullfreeView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_FULLFREEINFO);
        IFormView fullfreeview = this.getView().getView(pageid);
        fullfreeview.setEnable(Boolean.valueOf(iseditable), new String[]{"fullfree"});
        this.getView().sendFormAction(fullfreeview);
    }

    private void refreshReductionsView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_REDUCTIONSINFO);
        IFormView reductionsview = this.getView().getView(pageid);
        reductionsview.setEnable(Boolean.valueOf(iseditable), new String[]{"reductions"});
        this.getView().sendFormAction(reductionsview);
    }

    private void refreshRebateView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_REBATEINFO);
        IFormView rebateview = this.getView().getView(pageid);
        rebateview.setEnable(Boolean.valueOf(iseditable), new String[]{"rebate"});
        this.getView().sendFormAction(rebateview);
    }

    private void refreshSalesConditionView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_SALESCONDITIONS);
        IFormView conditionview = this.getView().getView(pageid);
        conditionview.setEnable(Boolean.valueOf(iseditable), new String[]{"condition"});
        this.getView().sendFormAction(conditionview);
    }

    private void refreshLimitContentView(boolean iseditable) {
        String pageid = this.getPageCache().get(PAGE_LIMITCONTENT);
        IFormView limitContentview = this.getView().getView(pageid);
        limitContentview.setEnable(Boolean.valueOf(iseditable), new String[]{"contentflex"});
        this.getView().sendFormAction(limitContentview);
    }

    private void lockOwner() {
        this.getView().setEnable(Boolean.FALSE, new String[]{OWNER});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                DynamicObject dynamicObject = this.getPolicyObject();
                this.saveOrUpdateCustomerrange(dynamicObject);
                this.getView().getModel().deleteEntryData(ENTRYENTITY);
                this.saveOrUpdateSalesCondition(dynamicObject);
                this.saveOrUpdateLimitContent(dynamicObject);
                this.saveOrUpdatePresentInfo(dynamicObject);
                this.saveOrUpdateFullfreeInfo(dynamicObject);
                this.saveOrUpdateReductionsInfo(dynamicObject);
                this.saveOrUpdateRebateInfo(dynamicObject);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        this.setBarEnable();
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                if (!this.getOperationResult(e)) break;
                this.refreshIsEditable();
                break;
            }
            case "unsubmit": 
            case "audit": {
                this.refreshIsEditable();
                break;
            }
            case "unaudit": {
                this.refreshIsEditable();
                this.setUnEnableLimitQty();
            }
        }
    }

    private void setUnEnableLimitQty() {
        String pageid = this.getPageCache().get(PAGE_LIMITCONTENT);
        IFormView limitContentview = this.getView().getView(pageid);
        DynamicObjectCollection itemEntrys = limitContentview.getModel().getEntryEntity(ENTRYENTITY);
        if (itemEntrys != null && itemEntrys.size() > 0) {
            limitContentview.setEnable(Boolean.valueOf(false), new String[]{"addentry", "deleteentry", "islimit"});
            for (int index = 0; index < itemEntrys.size(); ++index) {
                limitContentview.setEnable(Boolean.valueOf(false), index, new String[]{"limitqty", "item", "unit", "attr"});
            }
        }
        this.getView().sendFormAction(limitContentview);
    }

    private void setBarEnable() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        IFormView view = this.getView();
        String policystatus = dataEntity.getString("policystatus");
        if ("D".equals(policystatus)) {
            view.setEnable(Boolean.FALSE, new String[]{BAR_ENABLE});
            view.setEnable(Boolean.TRUE, new String[]{BAR_DISABLE});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{BAR_ENABLE});
            view.setEnable(Boolean.FALSE, new String[]{BAR_DISABLE});
        }
    }
}

