/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class PromotionResultTypeSelectPlugin
extends MdrFormPlugin {
    public static final String SELECTEDKEYTAG = "selectedkeytag";
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String BTN_NEXT = "btn_next";
    public static final String CONTENT = "content";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{BTN_CANCEL, BTN_NEXT});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Container c = (Container)this.getView().getControl(CONTENT);
        DynamicObjectCollection resulttypes = QueryServiceHelper.query((String)"dpm_resulttype", (String)"name,metadata.number", null);
        FlexPanelAp flexap = this.buildFlexAp();
        for (DynamicObject resulttype : resulttypes) {
            flexap.getItems().add(this.buildLabelAp(resulttype));
        }
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexap.createControl());
        c.insertControls(-1, list);
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (key.equals(CONTENT) || key.equals("btnflex") || key.equals(BTN_CANCEL) || key.equals(BTN_NEXT)) {
            return;
        }
        Label label = new Label();
        label.setKey(key);
        label.setView(this.getView());
        label.addClickListener((ClickListener)this);
        e.setControl((Control)label);
    }

    public void click(EventObject e) {
        super.click(e);
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if (control instanceof Label) {
            ArrayList<Object> list = new ArrayList<Object>();
            HashMap<String, String> dataMap = new HashMap<String, String>();
            list.add(key);
            list.add(dataMap);
            dataMap.put("bc", "#F4984E");
            dataMap.put("fc", "#fff");
            String oldkey = this.getPageCache().get(SELECTEDKEYTAG);
            if (oldkey != null && key.compareTo(oldkey) != 0) {
                HashMap<String, String> olddataMap = new HashMap<String, String>();
                list.add(oldkey);
                list.add(olddataMap);
                olddataMap.put("bc", "#fff");
                olddataMap.put("fc", "#333");
            }
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.addAction("updateControlMetadata", list);
            this.getPageCache().put(SELECTEDKEYTAG, key);
        }
        if (control instanceof Button) {
            if (key.equals(BTN_NEXT)) {
                String resulttype = this.getPageCache().get(SELECTEDKEYTAG);
                if (resulttype == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u4e00\u7ed3\u679c\u7c7b\u578b", (String)"PromotionResultTypeSelectPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                }
                this.getView().returnDataToParent((Object)resulttype);
                this.getView().close();
            }
            if (key.equals(BTN_CANCEL)) {
                this.getView().close();
            }
        }
    }

    private FlexPanelAp buildFlexAp() {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey("contentpanel");
        flexAp.setDirection("row");
        flexAp.setAlignItems("center");
        flexAp.setGrow(1);
        flexAp.setJustifyContent("flex-start");
        flexAp.setAlignItems("flex-start");
        flexAp.setShrink(1);
        flexAp.setOverflow("");
        flexAp.setWidth(new LocaleString("100%"));
        flexAp.setHeight(new LocaleString("100%"));
        return flexAp;
    }

    private LabelAp buildLabelAp(DynamicObject result) {
        LabelAp title = new LabelAp();
        title.setKey(result.getString("metadata.number"));
        title.setName(new LocaleString(result.getString("name")));
        title.setWidth(new LocaleString("120px"));
        title.setHeight(new LocaleString("32px"));
        title.setTextAlign("center");
        title.setRadius("2px");
        title.setFontSize(12);
        title.setForeColor("#666666");
        title.setClickable(true);
        Style labelstype = new Style();
        Border border = new Border();
        border.setBottom("1px solid #BBBBBB");
        border.setLeft("1px solid #BBBBBB");
        border.setRight("1px solid #BBBBBB");
        border.setTop("1px solid #BBBBBB");
        labelstype.setBorder(border);
        Padding padding = new Padding();
        padding.setTop("6px");
        labelstype.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("25px");
        margin.setLeft("70px");
        labelstype.setMargin(margin);
        title.setStyle(labelstype);
        return title;
    }
}

