/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.mobile;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUtil;
import kd.drp.dpm.common.execute.PromotionExecuteContext;
import kd.drp.dpm.common.model.execution.ReplaceablePromotionExecution;
import kd.drp.mdr.formplugin.MdrFormMobPlugin;

public class PromotionExecutionSelect
extends MdrFormMobPlugin
implements RowClickEventListener {
    public static final String EXECUTION_LIST = "executrionlist";
    public static final String UNUSE_ICON = "unuseicon";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addRowClickListener(this, new String[]{EXECUTION_LIST});
        this.addClickListeners(new String[]{UNUSE_ICON});
    }

    public void afterCreateNewData(EventObject e) {
        Object promotionKey = this.getParameter("promotioncachekey");
        if (promotionKey == null) {
            return;
        }
        this.setValue("promotioncachekey", promotionKey);
        this.initPromotionExecution(promotionKey.toString());
    }

    protected void initPromotionExecution(String promotionKey) {
        PromotionExecuteContext ctx = PromotionUtil.loadPromotionContextFromCache((String)promotionKey);
        if (ctx == null || ctx.getExecutions().isEmpty()) {
            return;
        }
        LinkedList<ExecutionLine> executionLines = new LinkedList<ExecutionLine>();
        LinkedList<Object> resultIds = new LinkedList<Object>();
        HashSet<String> showResult = new HashSet<String>();
        for (ReplaceablePromotionExecution rpe : ctx.getExecutions()) {
            if (rpe == null) continue;
            Object policyid = rpe.getPromotionid();
            executionLines.add(new ExecutionLine(policyid));
            List list = rpe.createExecution();
            for (DynamicObject execution : list) {
                Object executionid = execution.getPkValue();
                Boolean isUsed = execution.getBoolean("isused");
                String groupnumber = execution.getString("groupnumber");
                for (DynamicObject entry : execution.getDynamicObjectCollection("entryentity")) {
                    Object resultId = entry.get("resultid");
                    StringBuilder keyStr = new StringBuilder();
                    keyStr.append(resultId).append('-').append(policyid);
                    String key = keyStr.toString();
                    if (showResult.contains(key)) continue;
                    showResult.add(key);
                    executionLines.add(new ExecutionLine(executionid, isUsed, groupnumber, entry, policyid));
                    resultIds.add(resultId);
                }
            }
        }
        Map relations = BusinessDataServiceHelper.loadFromCache((Object[])resultIds.toArray(new Object[]{resultIds.size()}), (String)"dpm_result_relation");
        int size = executionLines.size();
        this.getModel().deleteEntryData(EXECUTION_LIST);
        this.getModel().batchCreateNewEntryRow(EXECUTION_LIST, size);
        ExecutionLine executionLine = null;
        for (int i = 0; i < size; ++i) {
            executionLine = (ExecutionLine)executionLines.get(i);
            this.setValue("promotionpolicy", executionLine.getPromotionId(), i);
            if (executionLine.isHeader()) {
                this.setValue("isheader", Boolean.TRUE, i);
                continue;
            }
            Object executionid = executionLine.getExecutionid();
            Boolean isUsed = executionLine.isUsed();
            String groupnumber = executionLine.getGroupnumber();
            DynamicObject entry = executionLine.getExecutionEntry();
            Object resultname = entry.get("resultname");
            Object resultid = entry.get("resultid");
            String type = entry.getString("type");
            DynamicObject item = entry.getDynamicObject("item");
            DynamicObject combination = entry.getDynamicObject("combination");
            DynamicObject unit = entry.getDynamicObject("unit");
            DynamicObject attr = entry.getDynamicObject("attr");
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal amountdiff = entry.getBigDecimal("amountdiff");
            BigDecimal pricediff = entry.getBigDecimal("pricediff");
            DynamicObject relation = (DynamicObject)relations.get(resultid);
            if (relation != null) {
                this.setValue("resulttype", relation.get("resulttype"), i);
            }
            this.setValue("resultname", resultname, i);
            if (isUsed.booleanValue()) {
                // empty if block
            }
            this.setValue("isused", isUsed, i);
            this.setValue("executionid", executionid, i);
            this.setValue("groupnumber", groupnumber, i);
            if (combination != null) {
                this.setValue("combinationitem", combination.getPkValue(), i);
            }
            if (item != null) {
                this.setValue("item", item.getPkValue(), i);
                if (unit != null) {
                    this.setValue("unit", unit.getPkValue(), i);
                }
                if (attr != null) {
                    this.setValue("assistattr", attr.getPkValue(), i);
                }
            }
            this.setValue("amountdiff", amountdiff, i);
            this.setValue("pricediff", pricediff, i);
            this.setValue("qty", qty, i);
            this.setValue("type", type, i);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = this.getKeyFromEvent(evt)) {
            case "unuseicon": {
                int rowIndex = this.getCurrentRowIndex(EXECUTION_LIST);
                this.executionListRowClick(rowIndex);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = this.getKeyFromEvent((EventObject)evt);
        int rowIndex = evt.getRow();
        switch (key) {
            case "executrionlist": {
                this.executionListRowClick(rowIndex);
                break;
            }
        }
    }

    protected void executionListRowClick(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject row = model.getEntryRowEntity(EXECUTION_LIST, rowIndex);
        if (!row.getBoolean("isheader")) {
            if (row.getBoolean("isused")) {
                return;
            }
            this.setValue("isused", Boolean.TRUE, rowIndex);
            DynamicObject promotionpolicy = row.getDynamicObject("promotionpolicy");
            String groupnumber = row.getString("groupnumber");
            this.chooseExecutionResult(promotionpolicy, groupnumber);
            this.getView().returnDataToParent(row.get("executionid"));
            this.getView().close();
        }
    }

    private void chooseExecutionResult(Object promotionpolicy, String groupnumber) {
        DynamicObjectCollection executionlist = this.getModel().getEntryEntity(EXECUTION_LIST);
        DynamicObject execution = null;
        for (int i = 0; i < executionlist.size(); ++i) {
            execution = (DynamicObject)executionlist.get(i);
            Object currentPromotionpolicy = execution.get("promotionpolicy");
            if (!promotionpolicy.equals(currentPromotionpolicy)) continue;
            String currentGroupNumber = execution.getString("groupnumber");
            if (currentGroupNumber.equals(groupnumber)) {
                this.setValue("isused", Boolean.TRUE, i);
                continue;
            }
            this.setValue("isused", Boolean.FALSE, i);
        }
    }

    static class ExecutionLine {
        private boolean header = false;
        private Object policyid;
        private Object executionid = null;
        private boolean used = false;
        private String groupnumber = null;
        private DynamicObject executionEntry;

        public ExecutionLine(Object policyid) {
            this.header = true;
            this.policyid = policyid;
        }

        public ExecutionLine(Object executionid, boolean used, String groupnumber, DynamicObject executionEntry, Object policyid) {
            this.header = false;
            this.executionid = executionid;
            this.used = used;
            this.groupnumber = groupnumber;
            this.executionEntry = executionEntry;
            this.policyid = policyid;
        }

        public boolean isHeader() {
            return this.header;
        }

        public Object getPromotionId() {
            return this.policyid;
        }

        public DynamicObject getExecutionEntry() {
            return this.executionEntry;
        }

        public Object getPolicyid() {
            return this.policyid;
        }

        public Object getExecutionid() {
            return this.executionid;
        }

        public boolean isUsed() {
            return this.used;
        }

        public String getGroupnumber() {
            return this.groupnumber;
        }

        public String toString() {
            String s = "";
            s = this.header ? "header:" + this.policyid : "body:" + this.executionEntry;
            return s;
        }
    }
}

