/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.result;

import java.util.EventObject;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.OperationUtil;
import kd.drp.mdr.formplugin.MdrBasePlugin;

public abstract class AbstractPromotionResultEditPlugin
extends MdrBasePlugin
implements BeforeF7SelectListener {
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String BTN_CONFIRM = "btn_confirm";
    public static final String BTN_PREVIOUS = "btn_previous";
    public static final String CONFIRM = "confirm";
    public static final String FLEX_BTN = "btn_flex";
    public static final String CONTENTFLEX = "contentflex";
    public static final String PAGE_ITEMRANGE = "page_itemrange";
    public static final String FLEX_ITEMRANGE = "flex_itemrange";
    public static final String ITEMRANGE = "itemrange";
    public static final String CONDITION = "condition";
    public static final String OWNER = "owner";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object id = this.getIdInShowParam();
        if (id != null) {
            DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getModelName());
            if (Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                e.setDataEntity((Object)this.CopyResultData(result));
                return;
            }
            e.setDataEntity((Object)result);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getIdInShowParam() == null) {
            Object ownerid = this.getView().getFormShowParameter().getCustomParam("ownerid");
            this.setValue(OWNER, ownerid);
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTENTFLEX});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{CONTENTFLEX});
        }
        DynamicObject itemrange = this.getModel().getDataEntity(true).getDynamicObject(ITEMRANGE);
        if (itemrange == null) {
            this.openItemrangePanel(null);
        } else {
            this.openItemrangePanel(itemrange.getPkValue());
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{CONTENTFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_BTN});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addClickListeners(new String[]{BTN_CANCEL, BTN_CONFIRM, BTN_PREVIOUS});
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{CONDITION});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (CONDITION.equals(key)) {
            String conditionexp = this.getConditionExp();
            if (conditionexp == null || conditionexp.trim().isEmpty()) {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "=", (Object)0));
            } else {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)conditionexp.split("AND|OR")));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.btnConfirmClick();
                break;
            }
        }
    }

    public void click(EventObject e) {
        String btnname;
        super.click(e);
        Button btn = (Button)e.getSource();
        switch (btnname = btn.getKey()) {
            case "btn_confirm": {
                this.btnConfirmClick();
                this.closeView();
                break;
            }
            case "btn_cancel": {
                this.closeView();
                break;
            }
            case "btn_previous": {
                this.getView().returnDataToParent((Object)"opentypeselect");
                this.closeView();
            }
        }
    }

    protected boolean isAssociatedCondition() {
        return this.getModel().getValue(CONDITION) != null;
    }

    protected DynamicObject getAssociatedConditonObj() {
        DynamicObject condition = (DynamicObject)this.getModel().getValue(CONDITION);
        return BusinessDataServiceHelper.loadSingle((Object)condition.getPkValue(), (String)"dpm_condition");
    }

    private void closeView() {
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    protected final void openItemrangePanel(Object rangeid) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("dpm_itemrange");
        parameter.getOpenStyle().setShowType(ShowType.InContainer);
        parameter.getOpenStyle().setTargetKey(FLEX_ITEMRANGE);
        parameter.setCustomParam("id", rangeid);
        parameter.setCustomParam("ownerid", this.getF7PKValue(OWNER));
        parameter.setCustomParam("iscopy", this.getView().getFormShowParameter().getCustomParam("iscopy"));
        parameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm((FormShowParameter)parameter);
        this.getPageCache().put(PAGE_ITEMRANGE, parameter.getPageId());
    }

    protected final void closeItemrangePanel() {
        String pageid = this.getPageCache().get(PAGE_ITEMRANGE);
        this.getView().getView(pageid).close();
    }

    protected final void hideItemrangePanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_ITEMRANGE});
    }

    protected final void showItemrangePanel() {
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_ITEMRANGE});
    }

    protected final DynamicObject getItemRange() {
        String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
        return this.getView().getView(pageid).getModel().getDataEntity(true);
    }

    protected String getConditionExp() {
        return (String)this.getView().getFormShowParameter().getCustomParam("conditionexp");
    }

    private void btnConfirmClick() {
        DynamicObject itemrange;
        DynamicObject result = this.getModel().getDataEntity(true);
        this.beforeConfirmResult(result);
        Object itemrangeid = null;
        DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
        if (batchType != null && ITEMRANGE.equals(batchType.getString("number")) && (itemrange = this.getItemRange()) != null) {
            itemrangeid = itemrange.get(ITEMRANGE);
        }
        result.set(ITEMRANGE, itemrangeid);
        OperationResult opresult = OperationUtil.invokeOperation((DynamicObject)result, (String)"save");
        if (!opresult.isSuccess()) {
            this.getView().showOperationResult(opresult);
            return;
        }
        Object resultid = opresult.getSuccessPkIds().get(0);
        if (!QueryServiceHelper.exists((String)"dpm_result_relation", resultid)) {
            DynamicObject relation = BusinessDataServiceHelper.newDynamicObject((String)"dpm_result_relation");
            DynamicObject resulttype = BusinessDataServiceHelper.loadSingle((String)"dpm_resulttype", (String)"id", (QFilter[])new QFilter[]{new QFilter("metadata.number", "=", (Object)result.getDataEntityType().getName())});
            relation.set("id", resultid);
            relation.set("resulttype", (Object)resulttype);
            SaveServiceHelper.save((IDataEntityType)relation.getDataEntityType(), (Object[])new DynamicObject[]{relation});
        }
        this.getView().returnDataToParent(resultid);
    }

    protected void setItemrange(DynamicObject itemrange) {
        String pageid = this.getPageCache().get(PAGE_ITEMRANGE);
        IFormView itemrangeview = this.getView().getView(pageid);
        IDataModel model = itemrangeview.getModel();
        model.beginInit();
        model.setValue(OWNER, itemrange.get(OWNER));
        model.deleteEntryData("entryentity");
        DynamicObjectCollection entrys = itemrange.getDynamicObjectCollection("entryentity");
        model.batchCreateNewEntryRow("entryentity", entrys.size());
        for (int i = 0; i < entrys.size(); ++i) {
            model.setValue("item", ((DynamicObject)entrys.get(i)).get("item"), i);
            model.setValue("itemclass", ((DynamicObject)entrys.get(i)).get("itemclass"), i);
            model.setValue("itembrand", ((DynamicObject)entrys.get(i)).get("itembrand"), i);
            model.setValue("unit", ((DynamicObject)entrys.get(i)).get("unit"), i);
            model.setValue("attr", ((DynamicObject)entrys.get(i)).get("attr"), i);
            model.setValue("isremoved", ((DynamicObject)entrys.get(i)).get("isremoved"), i);
        }
        model.endInit();
        itemrangeview.updateView();
        this.getView().sendFormAction(this.getView().getView(pageid));
    }

    protected Object getOwnerID() {
        return this.getF7PKValue(OWNER);
    }

    private Object getIdInShowParam() {
        return this.getView().getFormShowParameter().getCustomParam("id");
    }

    protected void setItemRangeVisiable(boolean isvisiable) {
        this.getView().setVisible(Boolean.valueOf(isvisiable), new String[]{FLEX_ITEMRANGE});
    }

    public abstract void beforeConfirmResult(DynamicObject var1) throws KDBizException;

    public abstract DynamicObject CopyResultData(DynamicObject var1) throws KDBizException;
}

