/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.result;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.formplugin.PromotionBaseEdit;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.common.util.OperationUtil;

public class LimitContentEditPlugin
extends PromotionBaseEdit
implements BeforeF7SelectListener {
    public static final String ITEM = "item";
    public static final String UNIT = "unit";
    public static final String ATTR = "attr";
    public static final String ISLIMIT = "islimit";
    public static final String CONTENTFLEX = "advconap";
    public static final String ENTRYENTITY = "entryentity";

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        Object id = this.getIdInShowParam();
        if (id != null) {
            DynamicObject limitcontent = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dpm_limit_content");
            if (this.getView().getFormShowParameter().getCustomParam("iscopy") != null && Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("iscopy").toString())) {
                DynamicObject fromlimitcontent = BusinessDataServiceHelper.newDynamicObject((String)"dpm_limit_content");
                HashSet<String> ignoreKeys = new HashSet<String>(1);
                ignoreKeys.add(ENTRYENTITY);
                ignoreKeys.add("limit");
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromlimitcontent, (DynamicObject)limitcontent, ignoreKeys);
                DynamicObjectCollection entrys = fromlimitcontent.getDynamicObjectCollection(ENTRYENTITY);
                DynamicObjectType entryType = entrys.getDynamicObjectType();
                DynamicObject entry = null;
                for (DynamicObject fromentry : limitcontent.getDynamicObjectCollection(ENTRYENTITY)) {
                    entry = new DynamicObject(entryType);
                    DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)entry, (DynamicObject)fromentry);
                    entrys.add((Object)entry);
                }
                e.setDataEntity((Object)fromlimitcontent);
                return;
            }
            e.setDataEntity((Object)limitcontent);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getIdInShowParam() == null) {
            Object ownerid = this.getParamValue("ownerid");
            this.setValue("owner", ownerid);
            this.setDisVisible(new String[]{CONTENTFLEX});
        } else {
            this.initEntryView();
        }
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.setUnEnable(new String[]{ISLIMIT, CONTENTFLEX});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{ITEM, UNIT, ATTR});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String f7name = e.getProperty().getName();
        int index = e.getRow();
        switch (f7name) {
            case "item": {
                DynamicObject owner = this.getF7Value("owner");
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "unit": {
                this.addUnitFilter(e, index);
                break;
            }
            case "attr": {
                this.addAttrFilter(e, index);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        int index = this.getRowIndex(e);
        switch (key = e.getProperty().getName()) {
            case "owner": {
                this.ownerChanged();
                break;
            }
            case "islimit": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (((Boolean)newValue).booleanValue()) {
                    this.isLimitChange();
                    this.setVisible(new String[]{CONTENTFLEX});
                    break;
                }
                this.setDisVisible(new String[]{CONTENTFLEX});
                break;
            }
            case "item": {
                this.itemChanged(index);
                break;
            }
            case "limitqty": {
                this.setValue("leftlimitqty", e.getChangeSet()[0].getNewValue(), index);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.btnConfirmClick();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    private Object getIdInShowParam() {
        return this.getParamValue("id");
    }

    private void isLimitChange() {
        if (this.getPageCache().get("is") == null) {
            DynamicObject item;
            this.getPageCache().put("is", "1");
            if (this.getView().getParentView() == null) {
                return;
            }
            String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
            if (StringUtil.isEmpty((CharSequence)pageid)) {
                return;
            }
            IFormView view = this.getView().getView(pageid);
            DynamicObject condition = view.getModel().getDataEntity(true);
            DynamicObject conditiontype = condition.getDynamicObject("conditiontype");
            if (conditiontype == null) {
                return;
            }
            String number = conditiontype.getString("number");
            if (number.compareTo("singleitem") == 0 && (item = condition.getDynamicObject(ITEM)) != null) {
                this.setValue(ITEM, item, 0);
            }
        }
    }

    protected void ownerChanged() {
        IDataModel model = this.getView().getModel();
        model.deleteEntryData(ENTRYENTITY);
        model.createNewEntryRow(ENTRYENTITY);
    }

    public void addAttrFilter(BeforeF7SelectEvent e, int index) {
        Object item = this.getEntryF7PKValue(ENTRYENTITY, ITEM, index);
        if (item == null) {
            throw new KDBizException("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)ItemAttrUtil.getAttrFilter((Object)item));
    }

    public void addUnitFilter(BeforeF7SelectEvent e, int index) {
        Object item = this.getEntryF7PKValue(ENTRYENTITY, ITEM, index);
        if (item == null) {
            throw new KDBizException("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
        }
        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", (Object)this.getUnitFormHandler().getUnitIdList(item)));
    }

    public void itemChanged(int index) {
        IDataModel model = this.getView().getModel();
        DynamicObject item = (DynamicObject)model.getValue(ITEM, index);
        if (item == null) {
            return;
        }
        PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)ITEM, (String)"baseunit", (String)UNIT, (String)ATTR, (int)index);
    }

    private void initEntryView() {
        DynamicObjectCollection limitEntry;
        DynamicObjectCollection itemEntrys = this.getModel().getEntryEntity(ENTRYENTITY);
        if (itemEntrys == null || itemEntrys.size() == 0) {
            return;
        }
        HashMap<String, BigDecimal> qtyinfos = new HashMap<String, BigDecimal>();
        DynamicObject limit = (DynamicObject)this.getValue("limit");
        String key = "";
        DynamicObject unit = null;
        DynamicObject attr = null;
        if (limit != null && (limitEntry = (limit = BusinessDataServiceHelper.loadSingle((Object)limit.getPkValue(), (DynamicObjectType)limit.getDynamicObjectType())).getDynamicObjectCollection("qtylimititems")) != null && limitEntry.size() > 0) {
            this.setUnEnable(new String[]{ISLIMIT, "addentry", "deleteentry"});
            for (DynamicObject dynamicObject : limitEntry) {
                attr = dynamicObject.getDynamicObject(ATTR);
                unit = dynamicObject.getDynamicObject(UNIT);
                key = String.format("%S_%S_%S", dynamicObject.getDynamicObject(ITEM).getPkValue(), unit == null ? Integer.valueOf(0) : unit.getPkValue(), attr == null ? Integer.valueOf(0) : attr.getPkValue());
                qtyinfos.put(key, dynamicObject.getBigDecimal("leftlimitqty"));
            }
        }
        for (int index = 0; index < itemEntrys.size(); ++index) {
            DynamicObject itemEntry = (DynamicObject)itemEntrys.get(index);
            DynamicObject item = itemEntry.getDynamicObject(ITEM);
            if (item == null) continue;
            if (limit != null) {
                this.setUnEnable(index, new String[]{"limitqty"});
                this.setUnEnable(index, new String[]{ITEM});
                this.setUnEnable(index, new String[]{UNIT});
                this.setUnEnable(index, new String[]{ATTR});
            }
            if (item.getBoolean("iscombination")) {
                this.setUnEnable(index, new String[]{UNIT, ATTR});
                key = String.format("%s_0_0", item.getPkValue());
            } else {
                QFilter fs = new QFilter("id", "=", item.getPkValue());
                boolean hasattr = false;
                DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
                if (iteminfo != null) {
                    hasattr = iteminfo.getBoolean("hasattr");
                }
                unit = itemEntry.getDynamicObject(UNIT);
                attr = itemEntry.getDynamicObject(ATTR);
                key = String.format("%S_%S_%S", item.getPkValue(), unit == null ? Integer.valueOf(0) : unit.getPkValue(), attr == null ? Integer.valueOf(0) : attr.getPkValue());
            }
            BigDecimal leftlimitqty = (BigDecimal)qtyinfos.get(key);
            itemEntry.set("leftlimitqty", (Object)(leftlimitqty == null ? itemEntry.getBigDecimal("limitqty") : leftlimitqty));
        }
    }

    private void btnConfirmClick() {
        DynamicObjectCollection qtylimititems = this.getModel().getEntryEntity(ENTRYENTITY);
        if (qtylimititems == null || qtylimititems.size() == 0) {
            throw new KDBizException("\u9650\u91cf\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a \u3002");
        }
        ArrayList<String> erroRows = new ArrayList<String>();
        ArrayList<String> zeroRows = new ArrayList<String>();
        ArrayList<String> iteminfos = new ArrayList<String>();
        DynamicObject item = null;
        DynamicObject attr = null;
        StringBuilder errorInfo = new StringBuilder();
        boolean iscombination = false;
        for (DynamicObject entry : qtylimititems) {
            String iteminfo;
            item = entry.getDynamicObject(ITEM);
            if (item == null) {
                erroRows.add(entry.getString("Seq"));
                continue;
            }
            iscombination = item.getBoolean("iscombination");
            if (!iscombination) {
                Object attrid;
                if (entry.getDynamicObject(UNIT) == null) {
                    erroRows.add(entry.getString("Seq"));
                    continue;
                }
                attr = entry.getDynamicObject(ATTR);
                Object object = attrid = attr == null ? Integer.valueOf(0) : attr.getPkValue();
                if (attrid.equals(0) && PromotionUiUtil.hasAssistAttr((Object)item.getPkValue())) {
                    erroRows.add(entry.getString("Seq"));
                    continue;
                }
                iteminfo = String.format("%s_%s", item.getPkValue(), attrid);
            } else {
                iteminfo = String.format("%s_%s", item.getPkValue(), 0);
            }
            if (iteminfos.contains(iteminfo)) {
                if (iteminfo.contains("_0")) {
                    errorInfo.append(String.format("\u5546\u54c1%s\u51fa\u73b0\u91cd\u590d \n", item.get("name")));
                } else {
                    errorInfo.append(String.format("\u9650\u91cf\u5185\u5bb9\u5546\u54c1%s\u8f85\u52a9\u5c5e\u6027%s\u51fa\u73b0\u91cd\u590d \n", item.get("name"), attr == null ? "" : attr.get("name")));
                }
            } else {
                iteminfos.add(iteminfo);
            }
            if (entry.getBigDecimal("limitqty").compareTo(BigDecimal.ZERO) != 0) continue;
            zeroRows.add(entry.getString("Seq"));
        }
        if (erroRows.size() != 0) {
            errorInfo.append(MessageFormat.format("\u7b2c{0}\u884c\u6570\u636e\u7f3a\u5c11\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u3001\u8f85\u52a9\u5c5e\u6027\u3002", String.join((CharSequence)",", erroRows)));
        }
        if (zeroRows.size() != 0) {
            errorInfo.append(MessageFormat.format("\u7b2c{0}\u884c\u9650\u91cf\u6570\u8981\u586b>0\u7684\u6570\u636e\u3002", String.join((CharSequence)",", zeroRows)));
        }
        if (errorInfo.length() > 0) {
            throw new KDBizException(String.format("\u9650\u91cf\u5185\u5bb9\uff1a%s", errorInfo));
        }
        DynamicObject condition = this.getModel().getDataEntity(true);
        OperationResult opresult = OperationUtil.invokeOperation((DynamicObject)condition, (String)"save");
        if (!opresult.isSuccess()) {
            this.getView().showOperationResult(opresult);
            return;
        }
        this.getView().returnDataToParent(opresult.getSuccessPkIds().get(0));
    }
}

