/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.result;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.formplugin.result.AbstractPromotionResultEditPlugin;
import kd.drp.mdr.common.util.DynamicObjectUtils;

public class PromotionResultFullFreeEditPlugin
extends AbstractPromotionResultEditPlugin
implements BeforeF7SelectListener {
    public static final String ISFULLFREE = "isfullfree";

    @Override
    public DynamicObject CopyResultData(DynamicObject resultobj) throws KDBizException {
        DynamicObject fromresult = BusinessDataServiceHelper.newDynamicObject((String)this.getModelName());
        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromresult, (DynamicObject)resultobj);
        return fromresult;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{"batchitem", "batchunit", "batchattr", "batchtype"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.changeBatchType();
        super.afterCreateNewData(e);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        DynamicObject owner = this.getF7Value("owner");
        switch (key) {
            case "batchitem": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "batchunit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"batchitem", (int)index);
                break;
            }
            case "batchattr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"batchitem", (int)index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "batchtype": {
                this.changeBatchType();
                break;
            }
            case "batchitem": {
                if (this.getModel().getValue("batchitem") == null) break;
                PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)"batchitem", (String)"batchunit", (String)"batchattr");
                break;
            }
            case "batchfullfreeqty": {
                BigDecimal batchQty = (BigDecimal)this.getValue("batchqty");
                BigDecimal freeQty = (BigDecimal)this.getValue("batchfullfreeqty");
                if (batchQty.compareTo(BigDecimal.ZERO) == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ee1\u514d\uff1a\u6ee1\u514d\u5339\u914d\u503c\u4e0d\u80fd\u4e3a 0\u3002", (String)"PromotionResultFullFreeEditPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                }
                if (batchQty.compareTo(freeQty) > 0) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ee1\u514d\uff1a\u6ee1\u514d\u6570\u91cf\u5fc5\u987b<\u6ee1\u514d\u5339\u914d\u503c\u3002", (String)"PromotionResultFullFreeEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "isfullfree": {
                if (((Boolean)newValue).booleanValue()) {
                    this.setVisible(new String[]{"contentflex"});
                    this.isfullfreeChanged();
                    break;
                }
                this.setDisVisible(new String[]{"contentflex"});
                break;
            }
        }
    }

    private void isfullfreeChanged() {
        DynamicObject model = this.getModel().getDataEntity(true);
        boolean isfullfree = model.getBoolean(ISFULLFREE);
        if (!isfullfree) {
            return;
        }
        DynamicObject batchtype = model.getDynamicObject("batchtype");
        if (batchtype != null) {
            return;
        }
        String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
        IFormView view = this.getView().getView(pageid);
        DynamicObject salescondition = view.getModel().getDataEntity(true);
        DynamicObject conditiontype = salescondition.getDynamicObject("conditiontype");
        if (conditiontype == null) {
            return;
        }
        this.setValue("batchtype", conditiontype);
        switch (conditiontype.getString("number")) {
            case "singleitem": {
                this.setValue("batchitem", salescondition.getDynamicObject("item"));
                this.setValue("batchunit", salescondition.getDynamicObject("unit"));
                this.setValue("batchattr", salescondition.getDynamicObject("attr"));
                break;
            }
        }
    }

    private void checkBatchFullFreeQty() {
        BigDecimal batchQty = (BigDecimal)this.getValue("batchqty");
        BigDecimal freeQty = (BigDecimal)this.getValue("batchfullfreeqty");
        if (batchQty.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ee1\u514d\uff1a\u6ee1\u514d\u5339\u914d\u503c\u4e0d\u80fd\u4e3a 0\u3002", (String)"PromotionResultFullFreeEditPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
        if (batchQty.compareTo(freeQty) <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ee1\u514d\uff1a\u6ee1\u514d\u6570\u91cf\u5fc5\u987b<\u6ee1\u514d\u5339\u914d\u503c\u3002", (String)"PromotionResultFullFreeEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkBatchType() {
        DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
        if (batchType == null) {
            throw new KDBizException("\u6ee1\u514d\uff1a\u8bf7\u5148\u9009\u62e9\u6279\u57fa\u8303\u56f4\u3002");
        }
        switch (batchType.getString("number")) {
            case "singleitem": {
                if ((DynamicObject)this.getValue("batchitem") != null) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u6ee1\u514d\uff1a\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u5355\u4e00\u5546\u54c1\u65f6\uff0c\u6279\u57fa\u5546\u54c1\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PromotionResultFullFreeEditPlugin_2", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            }
            case "itemrange": {
                String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
                pageid = this.getView().getView(pageid).getPageCache().get("page_itemrange");
                IFormView itemrangeview = this.getView().getView(pageid);
                IDataModel model = itemrangeview.getModel();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                if (entryentity != null && entryentity.size() != 0 && (((DynamicObject)entryentity.get(0)).get("item") != null || ((DynamicObject)entryentity.get(0)).get("itemclass") != null || ((DynamicObject)entryentity.get(0)).get("itembrand") != null)) break;
                throw new KDBizException("\u6ee1\u514d\uff1a\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u8303\u56f4\u5546\u54c1\u65f6\uff0c\u6279\u57fa\u8303\u56f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002");
            }
        }
    }

    private void changeBatchType() {
        DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
        if (batchType == null) {
            this.setItemRangeFlexVisible(false);
            this.setSingleItemFlexVisible(false);
            return;
        }
        switch (batchType.getString("number")) {
            case "itemrange": {
                this.setItemRangeFlexVisible(true);
                this.setSingleItemFlexVisible(false);
                break;
            }
            case "singleitem": {
                this.setItemRangeFlexVisible(false);
                this.setSingleItemFlexVisible(true);
            }
        }
    }

    private void setSingleItemFlexVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"batchitem", "batchunit", "batchattr"});
        if (!visible) {
            this.setValue("batchitem", null);
            this.setValue("batchunit", null);
            this.setValue("batchattr", null);
        }
    }

    private void setItemRangeFlexVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"israngesplit", "flex_itemrange1"});
        if (visible) {
            this.showItemrangePanel();
        } else {
            this.hideItemrangePanel();
        }
    }

    @Override
    public void click(EventObject e) {
        String btnname;
        Button btn = (Button)e.getSource();
        switch (btnname = btn.getKey()) {
            case "btn_confirm": {
                this.checkBatchFullFreeQty();
                this.checkBatchType();
            }
        }
        super.click(e);
    }

    @Override
    public void beforeConfirmResult(DynamicObject resultobj) throws KDBizException {
        this.checkBatchFullFreeQty();
        this.checkBatchType();
    }
}

