/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.common.model.PromotionResult;
import kd.drp.dpm.formplugin.result.AbstractPromotionResultEditPlugin;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.common.util.ItemAttrUtil;
import kd.drp.mdr.common.util.ItemUtil;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class PromotionResultPresentEditPlugin
extends AbstractPromotionResultEditPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String BATCHTYPE = "batchtype";
    public static final String BATCHQTY = "batchqty";
    public static final String ISBEYONDPART = "isbeyondpart";
    public static final String ISPRESENTSELF = "ispresentself";
    public static final String ISPRESENTBAG = "ispresentbag";
    public static final String BATCHITEM = "batchitem";
    public static final String BATCHUNIT = "batchunit";
    public static final String BATCHATTR = "batchattr";
    public static final String BATCHSTANDARD = "batchstandard";
    public static final String BATCHITEMRANGE = "itemrange";
    public static final String ISPRESENT = "ispresent";
    public static final String ISLADDER = "isladder";
    public static final String ISMULTISTAGE = "ismultistage";
    public static final String ISCUMULATIVE = "iscumulative";
    public static final String ISRANGESPLIT = "israngesplit";
    public static final String CONDITION = "condition";
    public static final String PRESENTENTITY = "presententity";
    public static final String PRESENTBAGENTITY = "presentbagentity";
    public static final String SUBENTRYENTITY = "subentryentity";
    public static final String PRESENTITEM = "presentitem";
    public static final String PRESENTUNIT = "presentunit";
    public static final String PRESENTATTR = "presentattr";
    public static final String PRESENTQTY = "presentqty";
    public static final String STARTLADDERQTY = "startladderqty";
    public static final String ENDLADDERQTY = "endladderqty";
    public static final String MATCHQTY = "matchqty";
    public static final String PRESENTBAG = "presentbag";
    public static final String SUBPRESENTBAG = "subpresentbag";
    public static final String ITEM = "item";
    public static final String UNIT = "unit";
    public static final String ATTR = "attr";
    public static final String PRESENTTYPE = "presenttype";
    public static final String ADDROW = "addrow";
    public static final String DELETEROW = "deleterow";

    public void initialize() {
        super.initialize();
    }

    @Override
    public DynamicObject CopyResultData(DynamicObject resultobj) throws KDBizException {
        DynamicObject fromresult = BusinessDataServiceHelper.newDynamicObject((String)this.getModelName());
        HashSet<String> ignoreKeys = new HashSet<String>(3);
        ignoreKeys.add(PRESENTENTITY);
        ignoreKeys.add(PRESENTBAGENTITY);
        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromresult, (DynamicObject)resultobj, ignoreKeys);
        ignoreKeys.remove("id");
        for (String entryKey : ignoreKeys) {
            this.copyEntryRow(fromresult, resultobj, entryKey);
        }
        if (this.getPageCache().get("is") == null) {
            this.getPageCache().put("is", "1");
        }
        return fromresult;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isLadderChanged(false);
        this.isMultistageChanged(false);
        this.isRangeSplitChanged(false);
        this.ispresentselfchanged(false);
        this.isPresentBagChanged(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{BATCHITEM, PRESENTITEM, BATCHUNIT, PRESENTUNIT, BATCHATTR, PRESENTATTR, ITEM, UNIT, ATTR});
        EntryGrid ce = (EntryGrid)this.getControl(PRESENTBAGENTITY);
        ce.addRowClickListener((RowClickEventListener)this);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntitys;
        EntryProp prop = e.getEntryProp();
        if (SUBENTRYENTITY.equals(prop.getName()) && (rowDataEntitys = e.getRowDataEntities()) != null && rowDataEntitys.length > 0) {
            int parentIndex = rowDataEntitys[0].getParentRowIndex();
            DynamicObject parentrow = this.getModel().getEntryRowEntity(PRESENTBAGENTITY, parentIndex);
            if (parentrow == null) {
                return;
            }
            String presentbag = parentrow.getString(PRESENTBAG);
            DynamicObjectCollection presententity = parentrow.getDynamicObjectCollection(SUBENTRYENTITY);
            this.setValue("subpresentqty", presententity.size(), parentIndex);
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                this.setValue(SUBPRESENTBAG, presentbag, rowDataEntity.getRowIndex());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        EntryProp prop = e.getEntryProp();
        if (SUBENTRYENTITY.equals(prop.getName())) {
            int[] indexs = e.getRowIndexs();
            DynamicObject subentryentity = this.getModel().getEntryRowEntity(SUBENTRYENTITY, indexs[0]);
            DynamicObject parentInfo = (DynamicObject)subentryentity.getParent();
            this.setValue("subpresentqty", parentInfo.getInt("subpresentqty") - indexs.length, parentInfo.getInt("seq") - 1);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.compareTo(PRESENTBAGENTITY) == 0) {
            DynamicObject presentbagentity = this.getModel().getEntryRowEntity(PRESENTBAGENTITY, evt.getRow());
            DynamicObjectCollection subentryentitys = presentbagentity.getDynamicObjectCollection(SUBENTRYENTITY);
            for (int i = 0; i < subentryentitys.size(); ++i) {
                DynamicObject subentryentity = (DynamicObject)subentryentitys.get(i);
                DynamicObject item = subentryentity.getDynamicObject(ITEM);
                if (item == null) continue;
                this.getView().setEnable(Boolean.valueOf(subentryentity.getBoolean("hasattr")), i, new String[]{ATTR});
                this.getView().setEnable(Boolean.valueOf(!item.getBoolean("iscombination")), i, new String[]{UNIT});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)MdrFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            MdrFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        String key = e.getProperty().getName();
        int index = this.getRowIndex(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "isbeyondpart": {
                this.isbeyondpartchanged();
                break;
            }
            case "batchtype": {
                this.batchtypechanged();
                break;
            }
            case "batchitem": {
                PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)BATCHITEM, (String)BATCHUNIT, (String)BATCHATTR);
                break;
            }
            case "presentitem": {
                if (this.getBooleanValue(ISPRESENTSELF)) {
                    boolean isupdate = false;
                    IDataModel model = this.getView().getModel();
                    DynamicObject presentitem = (DynamicObject)model.getValue(PRESENTITEM, index);
                    if (presentitem == null) {
                        return;
                    }
                    String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
                    pageid = this.getView().getView(pageid).getPageCache().get("page_itemrange");
                    IFormView itemrangeview = this.getView().getView(pageid);
                    model = itemrangeview.getModel();
                    DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                    if (entryentity != null && entryentity.size() > 0) {
                        for (DynamicObject dynamicObject : entryentity) {
                            DynamicObject item = dynamicObject.getDynamicObject(ITEM);
                            if (item == null || item.getPkValue() != presentitem.getPkValue()) continue;
                            this.setValue(PRESENTUNIT, dynamicObject.getDynamicObject(UNIT), index);
                            this.setValue(PRESENTATTR, dynamicObject.getDynamicObject(ATTR), index);
                            isupdate = true;
                            break;
                        }
                    }
                    if (isupdate) break;
                    PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)PRESENTITEM, (String)PRESENTUNIT, (String)PRESENTATTR, (int)index);
                    break;
                }
                PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)PRESENTITEM, (String)PRESENTUNIT, (String)PRESENTATTR, (int)index);
                break;
            }
            case "item": {
                this.itemChanged(index);
                break;
            }
            case "ispresentself": {
                this.ispresentselfchanged(true);
                break;
            }
            case "condition": {
                break;
            }
            case "presentqty": {
                if (newValue == null) break;
                this.setValue("presentrules", null, index, false);
                break;
            }
            case "presentrules": {
                if (newValue == null) break;
                this.setValue(PRESENTQTY, null, index, false);
                break;
            }
            case "ispresent": {
                if (((Boolean)newValue).booleanValue()) {
                    this.setVisible(new String[]{"contentflex"});
                    this.ispresentChanged();
                    break;
                }
                this.setDisVisible(new String[]{"contentflex"});
                break;
            }
            case "isladder": {
                this.isLadderChanged(true);
                break;
            }
            case "ismultistage": {
                this.isMultistageChanged(true);
                break;
            }
            case "israngesplit": {
                this.isRangeSplitChanged(true);
                break;
            }
            case "owner": {
                this.getModel().deleteEntryData(PRESENTENTITY);
                break;
            }
            case "ispresentbag": {
                this.isPresentBagChanged(true);
                break;
            }
            case "presentbag": {
                this.presentBagChanged(index, newValue);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                this.beforeConfirmResult(this.getModel().getDataEntity(true));
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    private void isbeyondpartchanged() {
        boolean isbeyondpart = Boolean.parseBoolean(this.getValue(ISBEYONDPART).toString());
        if (isbeyondpart) {
            this.openbeyondpart();
        } else {
            this.closebeyondpart();
        }
    }

    private void ispresentChanged() {
        String number;
        DynamicObject model = this.getModel().getDataEntity(true);
        boolean ispresent = model.getBoolean(ISPRESENT);
        if (!ispresent) {
            return;
        }
        DynamicObject batchtype = model.getDynamicObject(BATCHTYPE);
        if (batchtype != null) {
            return;
        }
        String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
        IFormView view = this.getView().getView(pageid);
        DynamicObject salescondition = view.getModel().getDataEntity(true);
        DynamicObject conditiontype = salescondition.getDynamicObject("conditiontype");
        if (conditiontype == null) {
            return;
        }
        this.setValue(BATCHTYPE, conditiontype);
        switch (number = conditiontype.getString("number")) {
            case "singleitem": {
                this.setValue(BATCHITEM, salescondition.getDynamicObject(ITEM));
                this.setValue(BATCHUNIT, salescondition.getDynamicObject(UNIT));
                this.setValue(BATCHATTR, salescondition.getDynamicObject(ATTR));
                break;
            }
        }
    }

    private void isLadderChanged(boolean isEmpty) {
        boolean isLadder = Boolean.parseBoolean(this.getValue(ISLADDER).toString());
        if (isLadder) {
            this.setVisible(new String[]{STARTLADDERQTY, ENDLADDERQTY});
            this.setDisVisible(new String[]{ISMULTISTAGE, ISCUMULATIVE, BATCHQTY, ISPRESENTBAG});
            if (isEmpty) {
                this.setValue(ISCUMULATIVE, Boolean.FALSE, false);
                this.setValue(ISPRESENTBAG, Boolean.FALSE, false);
                this.setValue(BATCHQTY, BigDecimal.ZERO, false);
            }
        } else {
            DynamicObjectCollection presententity;
            if (isEmpty && (presententity = this.getView().getModel().getEntryEntity(PRESENTENTITY)) != null && presententity.size() > 0) {
                for (int i = 0; i < presententity.size(); ++i) {
                    this.setValue(ENDLADDERQTY, BigDecimal.ZERO, i);
                    this.setValue(STARTLADDERQTY, BigDecimal.ZERO, i);
                }
            }
            this.setDisVisible(new String[]{STARTLADDERQTY, ENDLADDERQTY});
            this.setVisible(new String[]{ISMULTISTAGE, ISCUMULATIVE, BATCHQTY, ISPRESENTBAG});
        }
        this.ispresentselfchanged(isEmpty);
    }

    private void isMultistageChanged(boolean isEmpty) {
        boolean isMultistage = Boolean.parseBoolean(this.getValue(ISMULTISTAGE).toString());
        if (isMultistage) {
            this.setVisible(new String[]{MATCHQTY});
            this.setDisVisible(new String[]{ISLADDER, ISCUMULATIVE, BATCHQTY, ISPRESENTBAG});
            if (isEmpty) {
                this.setValue(ISCUMULATIVE, Boolean.FALSE, false);
                this.setValue(ISPRESENTBAG, Boolean.FALSE, false);
                this.setValue(BATCHQTY, BigDecimal.ZERO, false);
            }
        } else {
            DynamicObjectCollection presententity;
            if (isEmpty && (presententity = this.getView().getModel().getEntryEntity(PRESENTENTITY)) != null && presententity.size() > 0) {
                for (int i = 0; i < presententity.size(); ++i) {
                    this.setValue(MATCHQTY, BigDecimal.ZERO, i);
                }
            }
            this.setDisVisible(new String[]{MATCHQTY});
            this.setVisible(new String[]{ISLADDER, ISCUMULATIVE, BATCHQTY, ISPRESENTBAG});
        }
        this.ispresentselfchanged(isEmpty);
    }

    private void isRangeSplitChanged(boolean isEmpty) {
        boolean israngesplit = Boolean.parseBoolean(this.getValue(ISRANGESPLIT).toString());
        if (israngesplit) {
            this.setVisible(new String[]{ISPRESENTSELF});
        } else {
            if (isEmpty) {
                this.setValue(ISPRESENTSELF, Boolean.FALSE);
            }
            this.setDisVisible(new String[]{ISPRESENTSELF});
        }
    }

    private void copyBatchTypeInfos() {
        DynamicObject condition = this.getAssociatedConditonObj();
        this.setValue(BATCHITEM, condition.get(ITEM));
        this.setValue(BATCHSTANDARD, condition.get("judgestandard"));
        this.setValue(ISRANGESPLIT, condition.get(ISRANGESPLIT));
        this.setValue(BATCHUNIT, condition.get(UNIT));
        this.setValue(BATCHATTR, condition.get(ATTR));
        DynamicObject itemrange = condition.getDynamicObject(BATCHITEMRANGE);
        if (itemrange != null) {
            this.setItemrange(itemrange);
        }
        this.setValue(BATCHTYPE, condition.get("conditiontype"));
    }

    private void ispresentselfchanged(boolean isEmpty) {
        boolean ispresentself = Boolean.parseBoolean(this.getValue(ISPRESENTSELF).toString());
        if (ispresentself) {
            this.openpresentself(isEmpty);
        } else {
            this.closepresentself(isEmpty);
        }
    }

    private void isPresentBagChanged(boolean isEmpty) {
        boolean ispresentbag = Boolean.parseBoolean(this.getValue(ISPRESENTBAG).toString());
        if (ispresentbag) {
            this.setVisible(new String[]{"presentbagflex"});
            this.setVisible(new String[]{"presentbagdetailflex"});
            this.setDisVisible(new String[]{"presentflex"});
            this.setValue(ISMULTISTAGE, Boolean.FALSE);
            this.setValue(ISLADDER, Boolean.FALSE);
            this.setDisVisible(new String[]{ISMULTISTAGE});
            this.setDisVisible(new String[]{ISLADDER});
            if (isEmpty) {
                this.getModel().deleteEntryData(PRESENTENTITY);
            }
        } else {
            this.setDisVisible(new String[]{"presentbagflex"});
            this.setDisVisible(new String[]{"presentbagdetailflex"});
            this.setVisible(new String[]{ISMULTISTAGE});
            this.setVisible(new String[]{ISLADDER});
            this.setVisible(new String[]{"presentflex"});
            if (isEmpty) {
                this.getModel().deleteEntryData(PRESENTBAGENTITY);
                this.getModel().deleteEntryData(SUBENTRYENTITY);
            }
        }
    }

    private void presentBagChanged(int index, Object value) {
        DynamicObject parentrow = this.getModel().getEntryRowEntity(PRESENTBAGENTITY, index);
        if (parentrow == null) {
            return;
        }
        DynamicObjectCollection presententity = parentrow.getDynamicObjectCollection(SUBENTRYENTITY);
        if (presententity == null || presententity.size() == 0) {
            return;
        }
        for (DynamicObject entity : presententity) {
            entity.set(SUBPRESENTBAG, value);
        }
        this.getView().updateView(SUBENTRYENTITY);
    }

    private void openbeyondpart() {
        if (!this.isAssociatedCondition()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5173\u8054\u6761\u4ef6\u624d\u80fd\u786e\u5b9a\u8d85\u51fa\u90e8\u5206", (String)"PromotionResultPresentEditPlugin_0", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
            this.setValue(ISBEYONDPART, Boolean.FALSE);
            return;
        }
        this.copyBatchTypeInfos();
        this.getView().setVisible(Boolean.FALSE, new String[]{BATCHTYPE, BATCHITEM, ISRANGESPLIT, BATCHUNIT, BATCHATTR, BATCHSTANDARD, BATCHITEMRANGE, "flex_itemrange"});
    }

    private void closebeyondpart() {
        this.getView().setVisible(Boolean.TRUE, new String[]{BATCHTYPE, BATCHITEM, ISRANGESPLIT, BATCHUNIT, BATCHATTR, BATCHSTANDARD, BATCHITEMRANGE, "flex_itemrange"});
    }

    private void openpresentself(boolean isEmpty) {
        DynamicObject condition;
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject batchtype = model.getDynamicObject(BATCHTYPE);
        if (batchtype != null && BATCHITEMRANGE.equals(batchtype.getString("number")) && model.getBoolean(ISRANGESPLIT)) {
            this.emptyAndLockPresents(isEmpty);
            return;
        }
        if (this.isAssociatedCondition() && BATCHITEMRANGE.equals((condition = this.getAssociatedConditonObj()).getDynamicObject("conditiontype").getString("number")) && condition.getBoolean(ISRANGESPLIT)) {
            this.emptyAndLockPresents(isEmpty);
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u57fa\u8303\u56f4\u662f\u5546\u54c1\u8303\u56f4\u62c6\u5206\u65f6 \u6216 \u5173\u8054\u6761\u4ef6\u62c6\u5206\u65f6 \u6709\u6548", (String)"PromotionResultPresentEditPlugin_1", (String)"drp-dpm-formplugin", (Object[])new Object[0]));
        this.setValue(ISPRESENTSELF, Boolean.FALSE);
    }

    private void closepresentself(boolean isEmpty) {
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean ismultistage = this.getBooleanValue(ISMULTISTAGE);
        if (isladder || ismultistage) {
            this.setVisible(new String[]{"presentflex"});
        } else {
            this.setDisVisible(new String[]{"presentselfqty"});
            this.setVisible(new String[]{"presentflex"});
            if (isEmpty) {
                this.setValue("presentselfqty", BigDecimal.ZERO);
            }
        }
    }

    private void emptyAndLockPresents(boolean isEmpty) {
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean ismultistage = this.getBooleanValue(ISMULTISTAGE);
        if (isladder || ismultistage) {
            this.setDisVisible(new String[]{"presentselfqty"});
            this.setVisible(new String[]{"presentflex"});
            if (isEmpty) {
                this.setValue("presentselfqty", BigDecimal.ZERO);
                DynamicObjectCollection presententity = this.getView().getModel().getEntryEntity(PRESENTENTITY);
                if (presententity != null && presententity.size() > 0) {
                    for (int i = 0; i < presententity.size(); ++i) {
                        this.setValue(PRESENTITEM, null, i);
                        this.setValue(PRESENTUNIT, null, i);
                        this.setValue(PRESENTATTR, null, i);
                    }
                }
            }
        } else {
            this.setVisible(new String[]{"presentselfqty"});
            this.setDisVisible(new String[]{"presentflex"});
            if (isEmpty) {
                this.getModel().deleteEntryData(PRESENTENTITY);
            }
        }
    }

    protected void batchtypechanged() {
        DynamicObject model = this.getModel().getDataEntity();
        DynamicObject batchtype = model.getDynamicObject(BATCHTYPE);
        if (batchtype == null) {
            return;
        }
        String typenumber = batchtype.getString("number");
        if (BATCHITEMRANGE.equals(typenumber)) {
            this.showItemrangePanel();
            this.setVisible(new String[]{ISRANGESPLIT});
            this.setDisVisible(new String[]{BATCHITEM, BATCHUNIT, BATCHATTR});
            return;
        }
        if ("wholeorder".equals(typenumber)) {
            this.setDisVisible(new String[]{BATCHITEM, BATCHUNIT, BATCHATTR, ISRANGESPLIT});
            this.hideItemrangePanel();
            return;
        }
        if ("singleitem".equals(typenumber)) {
            this.hideItemrangePanel();
            this.setDisVisible(new String[]{ISRANGESPLIT});
            this.setVisible(new String[]{BATCHITEM, BATCHUNIT, BATCHATTR});
            return;
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        String key = e.getProperty().getName();
        int index = this.getCurrentRowIndex(PRESENTENTITY);
        DynamicObject owner = this.getF7Value("owner");
        switch (key) {
            case "batchitem": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "batchunit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)BATCHITEM);
                break;
            }
            case "batchattr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)BATCHITEM);
                break;
            }
            case "presentitem": {
                if (this.getBooleanValue(ISPRESENTSELF)) {
                    String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
                    pageid = this.getView().getView(pageid).getPageCache().get("page_itemrange");
                    IFormView itemrangeview = this.getView().getView(pageid);
                    IDataModel model = itemrangeview.getModel();
                    DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                    QFilter qFilter = null;
                    if (entryentity != null && entryentity.size() > 0) {
                        HashSet<Long> itemids = new HashSet<Long>(entryentity.size());
                        HashSet<Long> itembrandids = new HashSet<Long>(entryentity.size());
                        DynamicObjectCollection entryresult = null;
                        for (DynamicObject dynamicObject : entryentity) {
                            DynamicObject item = dynamicObject.getDynamicObject(ITEM);
                            if (item != null) {
                                itemids.add(item.getLong("id"));
                            }
                            if ((item = dynamicObject.getDynamicObject("itembrand")) != null) {
                                itembrandids.add(item.getLong("id"));
                            }
                            if ((item = dynamicObject.getDynamicObject("itemclass")) == null) continue;
                            if (qFilter == null) {
                                qFilter = new QFilter("itemclassentity.goodsclasssid.longnumber", "like", (Object)(item.getString("longnumber") + "%"));
                                continue;
                            }
                            qFilter.or(new QFilter("itemclassentity.goodsclasssid.longnumber", "like", (Object)(item.getString("longnumber") + "%")));
                        }
                        if (qFilter != null) {
                            entryresult = QueryServiceHelper.query((String)"mdr_item_info", (String)"id,material.id", (QFilter[])qFilter.toArray());
                            for (DynamicObject o : entryresult) {
                                itemids.add(o.getLong("id"));
                            }
                        }
                        if (itembrandids.size() > 0) {
                            qFilter = new QFilter("itembrands.fbasedataid", "in", itembrandids);
                            entryresult = QueryServiceHelper.query((String)"mdr_item_info", (String)"id", (QFilter[])qFilter.toArray());
                            for (DynamicObject o : entryresult) {
                                itemids.add(o.getLong("id"));
                            }
                        }
                        qFilter = null;
                        if (itemids.size() > 0) {
                            qFilter = new QFilter("id", "in", itemids);
                        }
                    }
                    if (qFilter == null) {
                        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", new HashSet()));
                        break;
                    }
                    F7Utils.addF7Filter((BeforeF7SelectEvent)e, qFilter);
                    break;
                }
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "item": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)(owner == null ? null : owner.getPkValue()));
                break;
            }
            case "presentunit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)PRESENTITEM, (int)index);
                break;
            }
            case "unit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM, (int)index);
                break;
            }
            case "attr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)ITEM, (int)index);
                break;
            }
            case "presentattr": {
                if (this.getBooleanValue(ISPRESENTSELF)) {
                    IDataModel model = this.getView().getModel();
                    DynamicObject presentitem = (DynamicObject)model.getValue(PRESENTITEM, index);
                    if (presentitem == null) {
                        throw new KDBizException("\u8bf7\u5148\u9009\u62e9\u5546\u54c1\u3002");
                    }
                    String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
                    pageid = this.getView().getView(pageid).getPageCache().get("page_itemrange");
                    IFormView itemrangeview = this.getView().getView(pageid);
                    model = itemrangeview.getModel();
                    DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                    if (entryentity == null || entryentity.size() <= 0) break;
                    HashSet<Long> attrids = new HashSet<Long>(entryentity.size());
                    for (DynamicObject dynamicObject : entryentity) {
                        DynamicObject attr;
                        DynamicObject item = dynamicObject.getDynamicObject(ITEM);
                        if (item == null || item.getPkValue() != presentitem.getPkValue() || (attr = dynamicObject.getDynamicObject(ATTR)) == null) continue;
                        attrids.add(attr.getLong("id"));
                    }
                    if (attrids.size() > 0) {
                        F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)new QFilter("id", "in", attrids));
                        break;
                    }
                    PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)PRESENTITEM, (int)index);
                    break;
                }
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)PRESENTITEM, (int)index);
            }
        }
    }

    @Override
    public void beforeConfirmResult(DynamicObject resultobj) throws KDBizException {
        DynamicObject batchType = (DynamicObject)this.getValue(BATCHTYPE);
        if (batchType == null) {
            throw new KDBizException("\u4e70\u8d60\uff1a\u8bf7\u5148\u9009\u62e9\u6279\u57fa\u8303\u56f4");
        }
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean ismultistage = this.getBooleanValue(ISMULTISTAGE);
        if (!isladder && !ismultistage && resultobj.getBigDecimal(BATCHQTY).compareTo(BigDecimal.ZERO) <= 0) {
            throw new KDBizException("\u4e70\u8d60\uff1a\u8d60\u9001\u5339\u914d\u503c\u5e94\u5927\u4e8e0");
        }
        boolean ispresentself = (Boolean)this.getValue(ISPRESENTSELF);
        switch (batchType.getString("number")) {
            case "singleitem": {
                if ((DynamicObject)this.getValue(BATCHITEM) == null) {
                    throw new KDBizException("\u4e70\u8d60\uff1a\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u5355\u4e00\u5546\u54c1\u65f6\uff0c\u5546\u54c1\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                this.checkPresententity();
                break;
            }
            case "itemrange": {
                if (!ispresentself) {
                    this.checkPresententity();
                } else {
                    this.checkPresentSelfentity();
                }
                String pageid = this.getView().getParentView().getPageCache().get("page_salesconditions");
                pageid = this.getView().getView(pageid).getPageCache().get("page_itemrange");
                IFormView itemrangeview = this.getView().getView(pageid);
                IDataModel model = itemrangeview.getModel();
                DynamicObjectCollection entryentity = model.getEntryEntity("entryentity");
                if (entryentity != null && entryentity.size() != 0 && (((DynamicObject)entryentity.get(0)).get(ITEM) != null || ((DynamicObject)entryentity.get(0)).get("itemclass") != null || ((DynamicObject)entryentity.get(0)).get("itembrand") != null)) break;
                throw new KDBizException("\u4e70\u8d60\uff1a\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u8303\u56f4\u5546\u54c1\u65f6\uff0c\u8bf7\u5148\u7ef4\u62a4\u597d\u6279\u57fa\u8303\u56f4\u4fe1\u606f\uff01");
            }
            case "wholeorder": {
                if (ispresentself) break;
                this.checkPresententity();
                break;
            }
        }
    }

    private void checkPresentSelfentity() {
        IDataModel dataModel = this.getView().getModel();
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean ismultistage = this.getBooleanValue(ISMULTISTAGE);
        if (!isladder && !ismultistage) {
            if (dataModel.getDataEntity().getBigDecimal("presentselfqty").compareTo(BigDecimal.ZERO) == 0) {
                throw new KDBizException("\u4e70\u8d60\uff1a\u8d60\u672c\u54c1\u52fe\u9009\uff0c\u8d60\u672c\u54c1\u6570\u636e\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002");
            }
            return;
        }
        DynamicObjectCollection presententity = dataModel.getEntryEntity(PRESENTENTITY);
        if (presententity == null || presententity.size() == 0) {
            throw new KDBizException("\u4e70\u8d60\uff1a\u8bf7\u5148\u7ef4\u62a4\u597d\u8d60\u54c1\u4fe1\u606f\u3002");
        }
        int size = presententity.size();
        HashMap<String, ArrayList<PromotionResult>> presentinfo = new HashMap<String, ArrayList<PromotionResult>>(size);
        HashMap repeatseq = new HashMap();
        ArrayList<String> attremptySeq = new ArrayList<String>(size);
        ArrayList<PromotionResult> promotionresults = null;
        ArrayList<String> seq = null;
        PromotionResult promotionresult = null;
        DynamicObject presentitem = null;
        DynamicObject presentunit = null;
        DynamicObject presentattr = null;
        StringBuilder emptyseq = new StringBuilder();
        StringBuilder zeroseq = new StringBuilder();
        StringBuilder sizeerrorseq = new StringBuilder();
        StringBuilder errorinfo = new StringBuilder();
        String key = "";
        String repeatkey = "";
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        BigDecimal matchqty = BigDecimal.ZERO;
        BigDecimal presentqty = BigDecimal.ZERO;
        HashMap<Long, String> mapItems = new HashMap<Long, String>(size);
        HashSet<String> itemkeys = new HashSet<String>(size);
        long itemid = 0L;
        boolean iscombination = false;
        for (DynamicObject dynamicObject : presententity) {
            presentitem = dynamicObject.getDynamicObject(PRESENTITEM);
            presentunit = dynamicObject.getDynamicObject(PRESENTUNIT);
            if (presentitem == null) {
                emptyseq.append(dynamicObject.getString("Seq"));
                emptyseq.append(',');
                continue;
            }
            iscombination = presentitem.getBoolean("iscombination");
            if (!iscombination && presentunit == null) {
                emptyseq.append(dynamicObject.getString("Seq"));
                emptyseq.append(',');
                continue;
            }
            itemid = presentitem.getLong("id");
            presentqty = dynamicObject.getBigDecimal(PRESENTQTY);
            presentattr = dynamicObject.getDynamicObject(PRESENTATTR);
            if (!iscombination && presentattr == null && PromotionUiUtil.hasAssistAttr((Object)presentitem.getPkValue())) {
                attremptySeq.add(dynamicObject.getString("Seq"));
                continue;
            }
            key = String.format("%s_%s_%s", itemid, presentunit == null ? Integer.valueOf(0) : presentunit.getPkValue(), presentattr == null ? Integer.valueOf(0) : presentattr.getPkValue());
            repeatkey = (String)mapItems.get(itemid);
            if (repeatkey == null) {
                mapItems.put(itemid, key);
            } else if (repeatkey.compareTo(key) != 0 && !itemkeys.contains(presentitem.getString("Name"))) {
                itemkeys.add(presentitem.getString("Name"));
            }
            promotionresults = (ArrayList<PromotionResult>)presentinfo.get(key);
            if (promotionresults == null) {
                promotionresults = new ArrayList<PromotionResult>(size);
            }
            promotionresult = new PromotionResult();
            promotionresult.setSeq(dynamicObject.getInt("Seq"));
            if (ismultistage) {
                matchqty = dynamicObject.getBigDecimal(MATCHQTY);
                if (presentqty.compareTo(BigDecimal.ZERO) == 0 || matchqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                promotionresult.setMatchQty(matchqty);
            } else {
                startladderqty = dynamicObject.getBigDecimal(STARTLADDERQTY);
                endladderqty = dynamicObject.getBigDecimal(ENDLADDERQTY);
                if (presentqty.compareTo(BigDecimal.ZERO) == 0 || startladderqty.compareTo(BigDecimal.ZERO) == 0 || endladderqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                if (startladderqty.compareTo(endladderqty) >= 0) {
                    sizeerrorseq.append(dynamicObject.getString("Seq"));
                    sizeerrorseq.append(',');
                    continue;
                }
                promotionresult.setStartLadderQty(startladderqty);
                promotionresult.setEndLadderQty(endladderqty);
            }
            String repeatSeq = this.checkRepeat(promotionresult, promotionresults, ismultistage);
            if (!repeatSeq.isEmpty()) {
                repeatkey = String.format("%s,%s", presentitem.getPkValue(), presentitem.getString("Name"));
                seq = (ArrayList<String>)repeatseq.get(repeatkey);
                if (seq == null) {
                    seq = new ArrayList<String>(size);
                }
                if (!seq.contains(repeatSeq)) {
                    seq.add(repeatSeq);
                }
                seq.add(dynamicObject.getString("Seq"));
                repeatseq.put(repeatkey, seq);
            }
            promotionresults.add(promotionresult);
            presentinfo.put(key, promotionresults);
        }
        int length = emptyseq.length();
        if (length > 0) {
            emptyseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a", emptyseq));
        }
        if (attremptySeq.size() > 0) {
            errorinfo.append(String.format("\u5206\u5f55%s\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", attremptySeq)));
        }
        if ((length = zeroseq.length()) > 0) {
            zeroseq.delete(length - 1, length);
            if (isladder) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u3001\u9636\u68af\u7ed3\u675f\u91cf\u8ddf\u8d60\u9001\u6570\u91cf\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            } else if (ismultistage) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u5339\u914d\u6570\u91cf\u8ddf\u8d60\u9001\u6570\u91cf\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            }
        }
        if ((length = sizeerrorseq.length()) > 0) {
            sizeerrorseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u5fc5\u987b<\u9636\u68af\u7ed3\u675f\u91cf", sizeerrorseq));
        }
        if (repeatseq.size() > 0) {
            for (Map.Entry entry : repeatseq.entrySet()) {
                if (isladder) {
                    errorinfo.append(String.format("%s\uff0c\u5206\u5f55%s\u884c\uff0c\u9636\u68af\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", ((String)entry.getKey()).split(",")[1], String.join((CharSequence)",", (Iterable)entry.getValue())));
                    continue;
                }
                errorinfo.append(String.format("%s\uff0c\u5206\u5f55%s\u884c\uff0c\u5339\u914d\u6570\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", ((String)entry.getKey()).split(",")[1], String.join((CharSequence)",", (Iterable)entry.getValue())));
            }
        }
        if (itemkeys.size() > 0) {
            errorinfo.append(String.format("\u589e\u672c\u54c1\uff0c\u540c\u4e00\u8d60\u54c1\u7684\u8ba1\u91cf\u5355\u4f4d\u8ddf\u8f85\u52a9\u5c5e\u6027\u8981\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u5546\u54c1\uff1a%s \u7684\u5546\u54c1\u5c5e\u6027\u3002", String.join((CharSequence)",", itemkeys)));
        }
        if (errorinfo.length() > 0) {
            throw new KDBizException(String.format("\u4e70\u8d60\uff1a%s", errorinfo));
        }
    }

    private void checkPresententity() {
        if (this.getBooleanValue(ISPRESENTBAG)) {
            this.checkPresentBagEntity();
            return;
        }
        IDataModel dataModel = this.getView().getModel();
        DynamicObjectCollection presententity = dataModel.getEntryEntity(PRESENTENTITY);
        if (presententity == null || presententity.size() == 0) {
            throw new KDBizException("\u4e70\u8d60\uff1a\u8bf7\u5148\u7ef4\u62a4\u597d\u8d60\u54c1\u4fe1\u606f\uff01");
        }
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean ismultistage = this.getBooleanValue(ISMULTISTAGE);
        int size = presententity.size();
        HashMap<String, ArrayList<PromotionResult>> presentinfo = new HashMap<String, ArrayList<PromotionResult>>(size);
        HashMap repeatseq = new HashMap();
        ArrayList<String> attremptySeq = new ArrayList<String>(size);
        ArrayList<PromotionResult> promotionresults = null;
        ArrayList<String> seq = null;
        PromotionResult promotionresult = null;
        DynamicObject presentitem = null;
        DynamicObject presentunit = null;
        DynamicObject presentattr = null;
        StringBuilder emptyseq = new StringBuilder();
        StringBuilder zeroseq = new StringBuilder();
        StringBuilder sizeerrorseq = new StringBuilder();
        StringBuilder errorinfo = new StringBuilder();
        String key = "";
        String repeatkey = "";
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        BigDecimal matchqty = BigDecimal.ZERO;
        BigDecimal presentqty = BigDecimal.ZERO;
        HashMap<Long, String> mapItems = new HashMap<Long, String>(size);
        long itemid = 0L;
        HashSet<String> itemkeys = new HashSet<String>(size);
        boolean iscombination = false;
        for (DynamicObject dynamicObject : presententity) {
            presentitem = dynamicObject.getDynamicObject(PRESENTITEM);
            presentunit = dynamicObject.getDynamicObject(PRESENTUNIT);
            if (presentitem == null) {
                emptyseq.append(dynamicObject.getString("Seq"));
                emptyseq.append(',');
                continue;
            }
            iscombination = presentitem.getBoolean("iscombination");
            if (!iscombination && presentunit == null) {
                emptyseq.append(dynamicObject.getString("Seq"));
                emptyseq.append(',');
                continue;
            }
            presentattr = dynamicObject.getDynamicObject(PRESENTATTR);
            if (!iscombination && presentattr == null && PromotionUiUtil.hasAssistAttr((Object)presentitem.getPkValue())) {
                attremptySeq.add(dynamicObject.getString("Seq"));
                continue;
            }
            itemid = presentitem.getLong("id");
            presentqty = dynamicObject.getBigDecimal(PRESENTQTY);
            key = String.format("%s_%s_%s", itemid, presentunit == null ? Integer.valueOf(0) : presentunit.getPkValue(), presentattr == null ? Integer.valueOf(0) : presentattr.getPkValue());
            if (!ismultistage && !isladder) {
                if (presentqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                }
                if ((repeatkey = (String)mapItems.get(itemid)) == null) {
                    mapItems.put(itemid, key);
                    continue;
                }
                if (repeatkey.compareTo(key) != 0 || itemkeys.contains(presentitem.getString("Name"))) continue;
                itemkeys.add(presentitem.getString("Name"));
                continue;
            }
            promotionresults = (ArrayList<PromotionResult>)presentinfo.get(key);
            if (promotionresults == null) {
                promotionresults = new ArrayList<PromotionResult>(size);
            }
            promotionresult = new PromotionResult();
            promotionresult.setSeq(dynamicObject.getInt("Seq"));
            if (ismultistage) {
                matchqty = dynamicObject.getBigDecimal(MATCHQTY);
                if (presentqty.compareTo(BigDecimal.ZERO) == 0 || matchqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                promotionresult.setMatchQty(matchqty);
            } else {
                startladderqty = dynamicObject.getBigDecimal(STARTLADDERQTY);
                endladderqty = dynamicObject.getBigDecimal(ENDLADDERQTY);
                if (presentqty.compareTo(BigDecimal.ZERO) == 0 || startladderqty.compareTo(BigDecimal.ZERO) == 0 || endladderqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                if (startladderqty.compareTo(endladderqty) >= 0) {
                    sizeerrorseq.append(dynamicObject.getString("Seq"));
                    sizeerrorseq.append(',');
                    continue;
                }
                promotionresult.setStartLadderQty(startladderqty);
                promotionresult.setEndLadderQty(endladderqty);
            }
            String repeatSeq = this.checkRepeat(promotionresult, promotionresults, ismultistage);
            if (!repeatSeq.isEmpty()) {
                repeatkey = String.format("%s,%s", presentitem.getPkValue(), presentitem.getString("Name"));
                seq = (ArrayList<String>)repeatseq.get(repeatkey);
                if (seq == null) {
                    seq = new ArrayList<String>(size);
                }
                if (!seq.contains(repeatSeq)) {
                    seq.add(repeatSeq);
                }
                seq.add(dynamicObject.getString("Seq"));
                repeatseq.put(repeatkey, seq);
            }
            promotionresults.add(promotionresult);
            presentinfo.put(key, promotionresults);
        }
        int length = emptyseq.length();
        if (length > 0) {
            emptyseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\u3002", emptyseq));
        }
        if (attremptySeq.size() > 0) {
            errorinfo.append(String.format("\u5206\u5f55%s\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", attremptySeq)));
        }
        if ((length = zeroseq.length()) > 0) {
            zeroseq.delete(length - 1, length);
            if (isladder) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u3001\u9636\u68af\u7ed3\u675f\u91cf\u8ddf\u8d60\u9001\u6570\u91cf\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            } else if (ismultistage) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u5339\u914d\u6570\u91cf\u8ddf\u8d60\u9001\u6570\u91cf\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            } else {
                errorinfo.append(String.format("\u5206\u5f55%s,\u8d60\u9001\u6570\u91cf\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            }
        }
        if ((length = sizeerrorseq.length()) > 0) {
            sizeerrorseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u4e0d\u80fd\u5927\u4e8e\u9636\u68af\u7ed3\u675f\u91cf", sizeerrorseq));
        }
        if (repeatseq.size() > 0) {
            for (Map.Entry entry : repeatseq.entrySet()) {
                if (isladder) {
                    errorinfo.append(String.format("%s\uff0c\u5206\u5f55%s\u884c\uff0c\u9636\u68af\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", ((String)entry.getKey()).split(",")[1], String.join((CharSequence)",", (Iterable)entry.getValue())));
                    continue;
                }
                errorinfo.append(String.format("%s\uff0c\u5206\u5f55%s\u884c\uff0c\u5339\u914d\u6570\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", ((String)entry.getKey()).split(",")[1], String.join((CharSequence)",", (Iterable)entry.getValue())));
            }
        }
        if (itemkeys.size() > 0) {
            errorinfo.append(String.format("%s\u7684\u5546\u54c1\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u8d60\u54c1\u4fe1\u606f\u3002", String.join((CharSequence)",", itemkeys)));
        }
        if (errorinfo.length() > 0) {
            throw new KDBizException(String.format("\u4e70\u8d60\uff1a%s", errorinfo));
        }
    }

    private void checkPresentBagEntity() {
        IDataModel dataModel = this.getView().getModel();
        DynamicObjectCollection presentbagentitys = dataModel.getEntryEntity(PRESENTBAGENTITY);
        if (presentbagentitys == null || presentbagentitys.size() == 0) {
            throw new KDBizException("\u4e70\u8d60\uff1a\u8bf7\u5148\u7ef4\u62a4\u597d\u8d60\u54c1\u5305\u4fe1\u606f\uff01");
        }
        StringBuilder errorinfo = new StringBuilder();
        StringBuilder emptyseq = new StringBuilder();
        StringBuilder repeatseq = new StringBuilder();
        HashSet<String> itemkeys = new HashSet<String>(presentbagentitys.size());
        String presentbag = "";
        for (DynamicObject presentbagentity : presentbagentitys) {
            presentbag = presentbagentity.getString(PRESENTBAG);
            if (presentbag.isEmpty() || presentbagentity.getBigDecimal("presentsumqty").compareTo(BigDecimal.ZERO) == 0) {
                emptyseq.append(presentbagentity.getString("Seq"));
                emptyseq.append(',');
                continue;
            }
            if (itemkeys.contains(presentbag)) {
                repeatseq.append(presentbag);
                repeatseq.append(',');
                continue;
            }
            itemkeys.add(presentbag);
            this.checkPresentBagSubEntity(presentbagentity, errorinfo);
        }
        StringBuilder strerror = new StringBuilder();
        int length = emptyseq.length();
        if (length > 0) {
            emptyseq.delete(length - 1, length);
            strerror.append(String.format("\u8d60\u54c1\u5305\u5206\u5f55%S,\u8d60\u54c1\u5305\u6216\u8d60\u54c1\u603b\u6570\u6ca1\u6709\u7ef4\u62a4\u3002", emptyseq));
        }
        if ((length = repeatseq.length()) > 0) {
            repeatseq.delete(length - 1, length);
            strerror.append(String.format("\u8d60\u54c1\u5305%S\u5b58\u5728\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", repeatseq));
        }
        if (errorinfo.length() > 0) {
            strerror.append((CharSequence)errorinfo);
        }
        if (strerror.length() > 0) {
            throw new KDBizException(String.format("\u4e70\u8d60\uff1a%s", strerror));
        }
    }

    private void checkPresentBagSubEntity(DynamicObject presentbagentity, StringBuilder errorinfo) {
        DynamicObjectCollection subentryentitys = presentbagentity.getDynamicObjectCollection(SUBENTRYENTITY);
        Object presentbag = presentbagentity.get(PRESENTBAG);
        if (subentryentitys == null || subentryentitys.size() == 0) {
            errorinfo.append(String.format("\u8d60\u54c1\u5305%S\u6ca1\u6709\u7ef4\u62a4\u5bf9\u5e94\u7684\u8d60\u54c1\u5305\u660e\u7ec6\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", presentbag));
        } else {
            StringBuilder emptyseq = new StringBuilder();
            StringBuilder attremptySeq = new StringBuilder();
            DynamicObject item = null;
            DynamicObject unit = null;
            DynamicObject attr = null;
            boolean iscombination = false;
            int size = subentryentitys.size();
            HashMap<Long, String> mapItems = new HashMap<Long, String>(size);
            HashSet<String> itemkeys = new HashSet<String>(size);
            String key = "";
            String repeatkey = "";
            long itemid = 0L;
            for (DynamicObject subentryentity : subentryentitys) {
                item = subentryentity.getDynamicObject(ITEM);
                unit = subentryentity.getDynamicObject(UNIT);
                if (item == null) {
                    emptyseq.append(subentryentity.getString("Seq"));
                    emptyseq.append(',');
                    continue;
                }
                iscombination = item.getBoolean("iscombination");
                if (!iscombination && unit == null) {
                    emptyseq.append(subentryentity.getString("Seq"));
                    emptyseq.append(',');
                    continue;
                }
                attr = subentryentity.getDynamicObject(ATTR);
                if (!iscombination && attr == null && PromotionUiUtil.hasAssistAttr((Object)item.getPkValue())) {
                    attremptySeq.append(subentryentity.getString("Seq"));
                    emptyseq.append(',');
                    continue;
                }
                itemid = item.getLong("id");
                key = String.format("%s_%s", itemid, attr == null ? Integer.valueOf(0) : attr.getPkValue());
                repeatkey = (String)mapItems.get(itemid);
                if (repeatkey == null) {
                    mapItems.put(itemid, key);
                    continue;
                }
                if (repeatkey.compareTo(key) != 0 || itemkeys.contains(item.getString("Name"))) continue;
                itemkeys.add(item.getString("Name"));
            }
            int length = emptyseq.length();
            if (length > 0) {
                emptyseq.delete(length - 1, length);
                errorinfo.append(String.format("\u8d60\u54c1\u5305%S\u7684\u8d60\u54c1\u5305\u660e\u7ec6\u5206\u5f55%s,\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a", presentbag, emptyseq));
            }
            if ((length = attremptySeq.length()) > 0) {
                attremptySeq.delete(length - 1, length);
                errorinfo.append(String.format("\u8d60\u54c1\u5305%S\u7684\u8d60\u54c1\u5305\u660e\u7ec6\u5206\u5f55%s\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", presentbag, attremptySeq));
            }
            if (itemkeys.size() > 0) {
                errorinfo.append(String.format("\u8d60\u54c1\u5305%S\u7684\u8d60\u54c1\u5305\u660e\u7ec6%S\u7684\u5546\u54c1\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", presentbag, String.join((CharSequence)",", itemkeys)));
            }
        }
    }

    private String checkRepeat(PromotionResult promotionresult, List<PromotionResult> promotionresults, boolean ismultistage) {
        String repeatSeq = "";
        if (promotionresults.size() == 0) {
            return repeatSeq;
        }
        for (PromotionResult result : promotionresults) {
            if (ismultistage) {
                if (result.getMatchQty().compareTo(promotionresult.getMatchQty()) != 0) continue;
                repeatSeq = String.valueOf(result.getSeq());
                break;
            }
            if (result.getStartLadderQty().compareTo(promotionresult.getEndLadderQty()) > 0 || promotionresult.getStartLadderQty().compareTo(result.getEndLadderQty()) > 0) continue;
            repeatSeq = String.valueOf(result.getSeq());
            break;
        }
        return repeatSeq;
    }

    public void itemChanged(int index) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject item = (DynamicObject)model.getValue(ITEM, index);
        if (item == null) {
            return;
        }
        if (item.getBoolean("iscombination")) {
            model.setValue(UNIT, null, index);
            model.setValue(ATTR, null, index);
            view.setEnable(Boolean.FALSE, index, new String[]{UNIT, ATTR});
        } else {
            QFilter fs = new QFilter("id", "=", item.getPkValue());
            boolean hasattr = false;
            DynamicObject iteminfo = ItemUtil.getInfoByQFilter((QFilter)fs, (String)"saleunit,hasattr");
            if (iteminfo != null) {
                Object unit = iteminfo.get("saleunit");
                if (unit != null) {
                    model.setValue(UNIT, unit, index);
                }
                hasattr = iteminfo.getBoolean("hasattr");
            }
            view.setEnable(Boolean.TRUE, index, new String[]{UNIT});
            model.setValue("hasattr", (Object)hasattr, index);
            if (hasattr) {
                model.setValue(ATTR, ItemAttrUtil.getDefaultAttrId((Object)item.getPkValue()), index);
                view.setEnable(Boolean.TRUE, index, new String[]{ATTR});
            } else {
                view.setEnable(Boolean.FALSE, index, new String[]{ATTR});
            }
        }
    }

    private void copyEntryRow(DynamicObject fromresult, DynamicObject resultobj, String entryKey) {
        DynamicObjectCollection entrys = resultobj.getDynamicObjectCollection(entryKey);
        if (entrys.size() == 0) {
            return;
        }
        DynamicObjectCollection toentrys = fromresult.getDynamicObjectCollection(entryKey);
        DynamicObjectType entryType = toentrys.getDynamicObjectType();
        DynamicObject toentry = null;
        for (DynamicObject entry : entrys) {
            toentry = new DynamicObject(entryType);
            if (entryKey.compareTo(PRESENTBAGENTITY) == 0) {
                HashSet<String> ignoreKeys = new HashSet<String>(2);
                ignoreKeys.add(SUBENTRYENTITY);
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)toentry, (DynamicObject)entry, ignoreKeys);
                this.copyEntryRow(toentry, entry, SUBENTRYENTITY);
            } else {
                DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)toentry, (DynamicObject)entry);
            }
            toentrys.add((Object)toentry);
        }
    }
}

