/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.drp.dpm.common.PromotionUiUtil;
import kd.drp.dpm.common.model.PromotionResult;
import kd.drp.dpm.formplugin.result.AbstractPromotionResultEditPlugin;
import kd.drp.mdr.common.f7.F7Utils;
import kd.drp.mdr.common.util.DynamicObjectUtils;
import kd.drp.mdr.formplugin.MdrFormPlugin;

public class PromotionResultReductionsEditPlugin
extends AbstractPromotionResultEditPlugin
implements BeforeF7SelectListener {
    public static final String ISREDUCTIONS = "isreductions";
    public static final String ISLADDER = "isladder";
    public static final String ISFULLREDUCTION = "isfullreduction";
    public static final String STARTLADDERQTY = "startladderqty";
    public static final String ENDLADDERQTY = "endladderqty";

    @Override
    public DynamicObject CopyResultData(DynamicObject resultobj) throws KDBizException {
        DynamicObject fromresult = BusinessDataServiceHelper.newDynamicObject((String)this.getModelName());
        HashSet<String> ignoreKeys = new HashSet<String>(1);
        ignoreKeys.add("entryentity");
        DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)fromresult, (DynamicObject)resultobj, ignoreKeys);
        DynamicObjectCollection entrys = fromresult.getDynamicObjectCollection("entryentity");
        DynamicObjectType entryType = entrys.getDynamicObjectType();
        DynamicObject entry = null;
        for (DynamicObject fromentry : resultobj.getDynamicObjectCollection("entryentity")) {
            entry = new DynamicObject(entryType);
            DynamicObjectUtils.copyPropertiesWithOutId((DynamicObject)entry, (DynamicObject)fromentry);
            entrys.add((Object)entry);
        }
        return fromresult;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.hideItemrangePanel();
        this.changeBatchType(false);
        this.isLadderChanged(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.changIsFullReduction(false);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.addF7Listener((BeforeF7SelectListener)this, new String[]{"itemclass", "itembrand", "item", "unit", "attr"});
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = e.getRow();
        switch (key) {
            case "item": {
                PromotionUiUtil.addItemFilter((BeforeF7SelectEvent)e, (Object)this.getOwnerID());
                break;
            }
            case "unit": {
                PromotionUiUtil.addUnitFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"item", (int)index);
                break;
            }
            case "attr": {
                PromotionUiUtil.addAttrFilter((BeforeF7SelectEvent)e, (IFormView)this.getView(), (String)"item", (int)index);
                break;
            }
            case "itemclass": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getItemClassFilter());
                DynamicObject itemClassStandard = BusinessDataServiceHelper.loadSingle((Object)7L, (String)"mdr_classstandardapply");
                long standardId = itemClassStandard.getLong("classstandardid_id");
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                listShowParameter.setCustomParam("groupStandard", (Object)standardId);
                listShowParameter.setMultiSelect(false);
                QFilter standardFilter = new QFilter("standard", "=", (Object)standardId);
                listShowParameter.getListFilterParameter().getQFilters().add(standardFilter);
                break;
            }
            case "itembrand": {
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)this.getItemBrandFilter());
            }
        }
    }

    private QFilter getItemClassFilter() {
        DynamicObjectCollection rules = this.getModel().getEntryEntity("entryentity");
        HashSet<Object> idSet = new HashSet<Object>();
        for (DynamicObject rule : rules) {
            DynamicObject itemClass = rule.getDynamicObject("itemclass");
            if (itemClass == null) continue;
            idSet.add(itemClass.getPkValue());
        }
        return new QFilter("id", "not in", idSet);
    }

    private QFilter getItemBrandFilter() {
        DynamicObjectCollection rules = this.getModel().getEntryEntity("entryentity");
        HashSet<Object> idSet = new HashSet<Object>();
        for (DynamicObject rule : rules) {
            DynamicObject itemBrand = rule.getDynamicObject("itembrand");
            if (itemBrand == null) continue;
            idSet.add(itemBrand.getPkValue());
        }
        return new QFilter("id", "not in", idSet);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Boolean triggerChangeEventLocal = (Boolean)MdrFormPlugin.triggerChangeEventLocal.get();
        if (triggerChangeEventLocal != null && !triggerChangeEventLocal.booleanValue()) {
            MdrFormPlugin.triggerChangeEventLocal.remove();
            return;
        }
        int index = this.getRowIndex(e);
        String key = e.getProperty().getName();
        if (!this.triggerChangeEvent) {
            return;
        }
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "itembrand": 
            case "itemclass": 
            case "item": {
                this.clearContextWithOutKey(key, index);
                this.triggerChangeEvent = true;
                break;
            }
            case "batchtype": {
                this.changeBatchType(true);
                this.changIsFullReduction(true);
                break;
            }
            case "reductiontype": {
                this.setVisible(new String[]{"batchtype"});
                this.changeBatchType(true);
                this.changIsFullReduction(true);
                break;
            }
            case "isfullreduction": {
                this.changIsFullReduction(true);
                break;
            }
            case "startorderqty": {
                boolean isfullreduction = (Boolean)this.getValue(ISFULLREDUCTION);
                if (!isfullreduction || ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) <= 0) break;
                this.setValue("startorderamount", null, index, false);
                break;
            }
            case "startorderamount": {
                boolean isfullreduction = (Boolean)this.getValue(ISFULLREDUCTION);
                if (!isfullreduction || ((BigDecimal)newValue).compareTo(BigDecimal.ZERO) <= 0) break;
                this.setValue("startorderqty", null, index, false);
                break;
            }
            case "isreductions": {
                if (((Boolean)newValue).booleanValue()) {
                    this.setVisible(new String[]{"contentflex"});
                    break;
                }
                this.setDisVisible(new String[]{"contentflex"});
                break;
            }
            case "isladder": {
                this.isLadderChanged(true);
                this.changeBatchType(true);
                break;
            }
            case "owner": {
                this.getModel().deleteEntryData("entryentity");
            }
        }
    }

    private void isLadderChanged(boolean isEmpty) {
        boolean isLadder = Boolean.parseBoolean(this.getValue(ISLADDER).toString());
        if (isLadder) {
            this.setVisible(new String[]{STARTLADDERQTY, ENDLADDERQTY});
            this.setUnEnable(new String[]{ISFULLREDUCTION});
        } else {
            DynamicObjectCollection presententity;
            if (isEmpty && (presententity = this.getView().getModel().getEntryEntity("entryentity")) != null && presententity.size() > 0) {
                for (int i = 0; i < presententity.size(); ++i) {
                    this.setValue(ENDLADDERQTY, BigDecimal.ZERO, i);
                    this.setValue(STARTLADDERQTY, BigDecimal.ZERO, i);
                }
            }
            this.setDisVisible(new String[]{STARTLADDERQTY, ENDLADDERQTY});
            this.setEnable(new String[]{ISFULLREDUCTION});
        }
    }

    private void changIsFullReduction(boolean isEmpty) {
        block14: {
            block13: {
                DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
                String type = (String)this.getValue("reductiontype");
                if (batchType == null || type == null || type.compareTo("reduceamount") != 0) break block13;
                boolean isfullreduction = this.getBooleanValue(ISFULLREDUCTION);
                if (isfullreduction) {
                    this.setUnEnable(new String[]{ISLADDER});
                } else {
                    this.setEnable(new String[]{ISLADDER});
                }
                switch (batchType.getString("number")) {
                    case "itemrange": {
                        this.setVisible(new String[]{ISFULLREDUCTION});
                        this.setDisVisible(new String[]{"fullimpairment", "fullreductiontype"});
                        if (!isEmpty) break;
                        this.setValue("fullreductiontype", "amount");
                        this.setValue("fullimpairment", BigDecimal.ZERO);
                        if (!isfullreduction) break;
                        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                        for (int i = 0; i < entryentity.size(); ++i) {
                            this.setValue("startorderqty", BigDecimal.ZERO, i);
                            this.setValue("startorderamount", BigDecimal.ZERO, i);
                        }
                        break block14;
                    }
                    case "wholeorder": {
                        this.setVisible(new String[]{ISFULLREDUCTION});
                        if (isfullreduction) {
                            this.setVisible(new String[]{"fullimpairment", "fullreductiontype"});
                            break;
                        }
                        this.setDisVisible(new String[]{"fullimpairment", "fullreductiontype"});
                        if (!isEmpty) break;
                        this.setValue("fullreductiontype", "amount");
                        this.setValue("fullimpairment", BigDecimal.ZERO);
                    }
                }
                break block14;
            }
            this.setDisVisible(new String[]{ISFULLREDUCTION, "fullimpairment", "fullreductiontype"});
            if (isEmpty) {
                this.setValue(ISFULLREDUCTION, Boolean.FALSE);
                this.setValue("fullreductiontype", "amount");
                this.setValue("fullimpairment", BigDecimal.ZERO);
            }
        }
    }

    private void clearContextWithOutKey(String key, int index) {
        this.triggerChangeEvent = false;
        this.setValue("unit", null, index);
        this.setValue("attr", null, index);
        if (!"itemclass".equals(key)) {
            this.setValue("itemclass", null, index);
        }
        if (!"itembrand".equals(key)) {
            this.setValue("itembrand", null, index);
        }
        if (!"item".equals(key)) {
            this.setValue("item", null, index);
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"unit", "attr"});
        } else {
            PromotionUiUtil.itemChanged((IFormView)this.getView(), (String)"item", (String)"unit", (String)"attr", (int)index);
        }
    }

    private void changeBatchType(boolean isdelete) {
        DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
        if (batchType == null || this.getValue("reductiontype") == null) {
            this.setItemRangeFlexVisible(false, isdelete);
            this.setWholeOrderFlexVisible(false);
            return;
        }
        switch (batchType.getString("number")) {
            case "itemrange": {
                this.setItemRangeFlexVisible(true, isdelete);
                this.setWholeOrderFlexVisible(false);
                break;
            }
            case "wholeorder": {
                this.setItemRangeFlexVisible(false, isdelete);
                this.setWholeOrderFlexVisible(true);
            }
        }
    }

    private void setItemRangeFlexVisible(boolean b, boolean isdelete) {
        String type = (String)this.getValue("reductiontype");
        if (type == null) {
            this.setDisVisible(new String[]{"reductionprice", "reductionamount"});
        } else {
            switch (type) {
                case "reduceamount": {
                    this.setDisVisible(new String[]{"reductionprice"});
                    this.setVisible(new String[]{"reductionamount"});
                    break;
                }
                case "reduceprice": {
                    this.setVisible(new String[]{"reductionprice"});
                    this.setDisVisible(new String[]{"reductionamount"});
                }
            }
        }
        boolean isladder = this.getBooleanValue(ISLADDER);
        if (!b && isdelete) {
            this.getModel().deleteEntryData("entryentity");
        }
        if (!b && isladder) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"reduction_flex"});
            this.setDisVisible(new String[]{"itemclass", "itembrand", "item", "unit", "attr", "iscombination", "modelnum", "baseunit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(b), new String[]{"reduction_flex"});
            this.setVisible(new String[]{"itemclass", "itembrand", "item", "unit", "attr", "iscombination", "modelnum", "baseunit", "startorderamount", "startorderqty"});
        }
        if (isladder) {
            this.setDisVisible(new String[]{"startorderamount", "startorderqty"});
        }
        this.getView().setVisible(Boolean.valueOf(b), new String[]{"isactonsingleentry"});
    }

    private void setWholeOrderFlexVisible(boolean b) {
        boolean isladder = this.getBooleanValue(ISLADDER);
        if (b) {
            String type;
            switch (type = (String)this.getValue("reductiontype")) {
                case "reduceamount": {
                    if (isladder) {
                        this.setDisVisible(new String[]{"wholereductionamount"});
                    } else {
                        this.setVisible(new String[]{"wholereductionamount"});
                    }
                    this.setDisVisible(new String[]{"wholereductionprice"});
                    this.setValue("wholereductionprice", BigDecimal.ZERO);
                    break;
                }
                case "reduceprice": {
                    this.setDisVisible(new String[]{"wholereductionamount"});
                    if (isladder) {
                        this.setDisVisible(new String[]{"wholereductionprice"});
                    } else {
                        this.setVisible(new String[]{"wholereductionprice"});
                    }
                    this.setValue("wholereductionamount", BigDecimal.ZERO);
                }
            }
        } else {
            this.setValue("wholereductionamount", BigDecimal.ZERO);
            this.setValue("wholereductionprice", BigDecimal.ZERO);
            this.getView().setVisible(Boolean.valueOf(b), new String[]{"wholereductionamount"});
            this.getView().setVisible(Boolean.valueOf(b), new String[]{"wholereductionprice"});
        }
    }

    @Override
    public void beforeConfirmResult(DynamicObject resultobj) throws KDBizException {
        this.checkBatchType();
    }

    private void checkBatchType() {
        int length;
        DynamicObject batchType = (DynamicObject)this.getValue("batchtype");
        if (batchType == null) {
            throw new KDBizException("\u76f4\u51cf\uff1a\u8bf7\u5148\u9009\u62e9\u76f4\u51cf\u8303\u56f4\u3002");
        }
        String type = (String)this.getValue("reductiontype");
        if (type == null) {
            throw new KDBizException("\u76f4\u51cf\uff1a\u8bf7\u5148\u9009\u62e9\u76f4\u51cf\u7c7b\u578b\u3002");
        }
        boolean isladder = this.getBooleanValue(ISLADDER);
        boolean isfullreduction = (Boolean)this.getValue(ISFULLREDUCTION);
        StringBuilder emptyseq = new StringBuilder();
        StringBuilder zeroseq = new StringBuilder();
        StringBuilder sizeerrorseq = new StringBuilder();
        StringBuilder errorinfo = new StringBuilder();
        HashMap repeatseq = new HashMap();
        ArrayList<String> attremptySeq = new ArrayList<String>();
        ArrayList<String> seq = null;
        BigDecimal startladderqty = BigDecimal.ZERO;
        BigDecimal endladderqty = BigDecimal.ZERO;
        HashMap<String, ArrayList<PromotionResult>> presentinfo = null;
        ArrayList<PromotionResult> promotionresults = null;
        PromotionResult promotionresult = null;
        String key = "";
        String repeatkey = "";
        String number = batchType.getString("number");
        DynamicObject item = null;
        DynamicObject unit = null;
        DynamicObject attr = null;
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        int size = entryentity.size();
        HashMap<Long, String> mapItems = new HashMap<Long, String>(size);
        HashSet<String> itemkeys = new HashSet<String>(size);
        long itemid = 0L;
        boolean iscombination = false;
        if (isladder) {
            if (size == 0) {
                throw new KDBizException("\u76f4\u51cf\uff1a\u8bf7\u5148\u7ef4\u62a4\u597d\u5bf9\u5e94\u76f4\u51cf\u89c4\u5219\u3002");
            }
            presentinfo = new HashMap<String, ArrayList<PromotionResult>>(size);
            for (DynamicObject dynamicObject : entryentity) {
                item = dynamicObject.getDynamicObject("item");
                unit = dynamicObject.getDynamicObject("unit");
                if (number.compareTo("itemrange") == 0) {
                    if (item == null) {
                        emptyseq.append(dynamicObject.getString("Seq"));
                        emptyseq.append(',');
                        continue;
                    }
                    iscombination = item.getBoolean("iscombination");
                    if (!iscombination && unit == null) {
                        emptyseq.append(dynamicObject.getString("Seq"));
                        emptyseq.append(',');
                        continue;
                    }
                    attr = dynamicObject.getDynamicObject("attr");
                    if (!iscombination && attr == null && PromotionUiUtil.hasAssistAttr((Object)item.getPkValue())) {
                        attremptySeq.add(dynamicObject.getString("Seq"));
                        continue;
                    }
                }
                if ((promotionresults = (ArrayList<PromotionResult>)presentinfo.get(key = String.format("%s_%s_%s", item == null ? Integer.valueOf(0) : item.getPkValue(), unit == null ? Integer.valueOf(0) : unit.getPkValue(), attr == null ? Integer.valueOf(0) : attr.getPkValue()))) == null) {
                    promotionresults = new ArrayList<PromotionResult>(size);
                }
                promotionresult = new PromotionResult();
                promotionresult.setSeq(dynamicObject.getInt("Seq"));
                startladderqty = dynamicObject.getBigDecimal(STARTLADDERQTY);
                endladderqty = dynamicObject.getBigDecimal(ENDLADDERQTY);
                if (startladderqty.compareTo(BigDecimal.ZERO) == 0 || endladderqty.compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                if (startladderqty.compareTo(endladderqty) >= 0) {
                    sizeerrorseq.append(dynamicObject.getString("Seq"));
                    sizeerrorseq.append(',');
                    continue;
                }
                if (type.compareTo("reduceamount") == 0) {
                    if (dynamicObject.getBigDecimal("reductionamount").compareTo(BigDecimal.ZERO) == 0) {
                        zeroseq.append(dynamicObject.getString("Seq"));
                        zeroseq.append(',');
                    }
                } else if (dynamicObject.getBigDecimal("reductionprice").compareTo(BigDecimal.ZERO) == 0) {
                    zeroseq.append(dynamicObject.getString("Seq"));
                    zeroseq.append(',');
                }
                promotionresult.setStartLadderQty(startladderqty);
                promotionresult.setEndLadderQty(endladderqty);
                String repeatSeq = this.checkRepeat(promotionresult, promotionresults);
                if (!repeatSeq.isEmpty()) {
                    repeatkey = String.format("%s,%s", item == null ? Integer.valueOf(0) : item.getPkValue(), item == null ? Integer.valueOf(0) : item.getString("Name"));
                    seq = (ArrayList<String>)repeatseq.get(repeatkey);
                    if (seq == null) {
                        seq = new ArrayList<String>(size);
                    }
                    if (!seq.contains(repeatSeq)) {
                        seq.add(repeatSeq);
                    }
                    seq.add(dynamicObject.getString("Seq"));
                    repeatseq.put(repeatkey, seq);
                }
                promotionresults.add(promotionresult);
                presentinfo.put(key, promotionresults);
            }
        } else if (number.compareTo("itemrange") == 0) {
            if (size == 0) {
                throw new KDBizException("\u76f4\u51cf\uff1a\u8bf7\u5148\u7ef4\u62a4\u597d\u5bf9\u5e94\u76f4\u51cf\u89c4\u5219\u3002");
            }
            for (DynamicObject entry : entryentity) {
                item = entry.getDynamicObject("item");
                unit = entry.getDynamicObject("unit");
                if (item == null) {
                    emptyseq.append(entry.getString("Seq"));
                    emptyseq.append(',');
                    continue;
                }
                iscombination = item.getBoolean("iscombination");
                if (!iscombination && unit == null) {
                    emptyseq.append(entry.getString("Seq"));
                    emptyseq.append(',');
                    continue;
                }
                itemid = item.getLong("id");
                attr = entry.getDynamicObject("attr");
                if (!iscombination && attr == null && PromotionUiUtil.hasAssistAttr((Object)itemid)) {
                    attremptySeq.add(entry.getString("Seq"));
                    continue;
                }
                key = String.format("%s_%s_%s", itemid, unit == null ? Integer.valueOf(0) : unit.getPkValue(), attr == null ? Integer.valueOf(0) : attr.getPkValue());
                repeatkey = (String)mapItems.get(itemid);
                if (repeatkey == null) {
                    mapItems.put(itemid, key);
                } else if (repeatkey.compareTo(key) == 0 && !itemkeys.contains(item.getString("Name"))) {
                    itemkeys.add(item.getString("Name"));
                }
                if (isfullreduction && entry.getBigDecimal("startorderqty").compareTo(BigDecimal.ZERO) == 0 && entry.getBigDecimal("startorderamount").compareTo(BigDecimal.ZERO) == 0) {
                    sizeerrorseq.append(entry.getString("Seq"));
                    sizeerrorseq.append(',');
                }
                if (type.compareTo("reduceamount") == 0) {
                    if (entry.getBigDecimal("reductionamount").compareTo(BigDecimal.ZERO) != 0) continue;
                    zeroseq.append(entry.getString("Seq"));
                    zeroseq.append(',');
                    continue;
                }
                if (entry.getBigDecimal("reductionprice").compareTo(BigDecimal.ZERO) != 0) continue;
                zeroseq.append(entry.getString("Seq"));
                zeroseq.append(',');
            }
        } else if (type.compareTo("reduceamount") == 0) {
            if (((BigDecimal)this.getValue("wholereductionamount")).compareTo(BigDecimal.ZERO) == 0) {
                errorinfo.append("\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u6574\u5355\u65f6\uff0c\u6574\u5355\u76f4\u51cf\u91d1\u989d\u4e0d\u5141\u8bb8\u4e3a0\u3002");
            }
            if (isfullreduction && ((BigDecimal)this.getValue("fullimpairment")).compareTo(BigDecimal.ZERO) == 0) {
                errorinfo.append("\u6ee1\u51cf\u503c\u4e0d\u5141\u8bb8\u4e3a0\u3002");
            }
        } else if (((BigDecimal)this.getValue("wholereductionprice")).compareTo(BigDecimal.ZERO) == 0) {
            errorinfo.append("\u6279\u57fa\u8303\u56f4\u9009\u62e9\u4e3a\u6574\u5355\u65f6\uff0c\u6574\u5355\u76f4\u51cf\u5355\u4ef7\u4e0d\u5141\u8bb8\u4e3a0\u3002");
        }
        if ((length = emptyseq.length()) > 0) {
            emptyseq.delete(length - 1, length);
            errorinfo.append(String.format("\u5206\u5f55%s,\u5546\u54c1\u6216\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\u3002", emptyseq));
        }
        if (attremptySeq.size() > 0) {
            errorinfo.append(String.format("\u5206\u5f55%s\u8f85\u52a9\u5c5e\u6027\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", String.join((CharSequence)",", attremptySeq)));
        }
        if ((length = zeroseq.length()) > 0) {
            zeroseq.delete(length - 1, length);
            if (type.compareTo("reduceamount") == 0) {
                if (isladder) {
                    errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u3001\u9636\u68af\u7ed3\u675f\u91cf\u8ddf\u76f4\u51cf\u91d1\u989d\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
                } else {
                    errorinfo.append(String.format("\u5206\u5f55%s,\u76f4\u51cf\u91d1\u989d\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
                }
            } else if (isladder) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u3001\u9636\u68af\u7ed3\u675f\u91cf\u8ddf\u76f4\u51cf\u4ef7\u683c\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            } else {
                errorinfo.append(String.format("\u5206\u5f55%s,\u76f4\u51cf\u4ef7\u683c\u8981\u586b\u5927\u4e8e0\u7684\u6570\u636e\u3002", zeroseq));
            }
        }
        if ((length = sizeerrorseq.length()) > 0) {
            sizeerrorseq.delete(length - 1, length);
            if (isladder) {
                errorinfo.append(String.format("\u5206\u5f55%s,\u9636\u68af\u8d77\u59cb\u91cf\u5fc5\u987b<\u9636\u68af\u7ed3\u675f\u91cf\u3002", sizeerrorseq));
            } else {
                errorinfo.append(String.format("\u5206\u5f55%s,\u8d77\u8ba2\u91d1\u989d\u8ddf\u8d77\u8ba2\u6570\u91cf\u4e0d\u80fd\u90fd\u4e3a0\u3002", sizeerrorseq));
            }
        }
        if (repeatseq.size() > 0) {
            for (Map.Entry entry : repeatseq.entrySet()) {
                if (number.compareTo("itemrange") == 0) {
                    errorinfo.append(String.format("%s\uff0c\u5206\u5f55%s\u884c\uff0c\u9636\u68af\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", ((String)entry.getKey()).split(",")[1], String.join((CharSequence)",", (Iterable)entry.getValue())));
                    continue;
                }
                errorinfo.append(String.format("\u5206\u5f55%s\u884c\uff0c\u9636\u68af\u91cf\u6709\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u3002", String.join((CharSequence)",", (Iterable)entry.getValue())));
            }
        }
        if (itemkeys.size() > 0) {
            errorinfo.append(String.format("%s\u7684\u5546\u54c1\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u76f4\u51cf\u89c4\u5219\u3002", String.join((CharSequence)",", itemkeys)));
        }
        if (errorinfo.length() > 0) {
            throw new KDBizException(String.format("\u76f4\u51cf\uff1a%s", errorinfo));
        }
    }

    private String checkRepeat(PromotionResult promotionresult, List<PromotionResult> promotionresults) {
        String repeatSeq = "";
        if (promotionresults.size() == 0) {
            return repeatSeq;
        }
        for (PromotionResult result : promotionresults) {
            if (result.getStartLadderQty().compareTo(promotionresult.getEndLadderQty()) > 0 || promotionresult.getStartLadderQty().compareTo(result.getEndLadderQty()) > 0) continue;
            repeatSeq = String.valueOf(result.getSeq());
            break;
        }
        return repeatSeq;
    }
}

