/*
 * Decompiled with CFR 0.152.
 */
package kd.drp.dpm.formplugin.retailprice;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.drp.dpm.business.retailprice.RetailItemPriceHelper;
import kd.drp.dpm.common.util.CommonUtil;
import kd.drp.dpm.common.util.PriceTypeUtil;
import kd.drp.dpm.formplugin.retailprice.RetailPriceBasePlugin;

public class PriceDetailFormPlugin
extends RetailPriceBasePlugin
implements RowClickEventListener {
    private static final String DETAILDISABLE = "detaildisable";
    private static final String DETAILENABLE = "detailenable";
    private static final Set<String> CHANGED_FILEDS = new HashSet<String>(Arrays.asList("retailvalue", "factoryvalue", "uniquevalue", "membervalue", "specialvalue", "value1", "value2", "value3", "value4", "value5"));

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("pricedetail");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        IFormView view = this.getView();
        EntryGrid detailGrid = (EntryGrid)view.getControl("pricedetail");
        int[] selectRows = detailGrid.getSelectRows();
        if (selectRows.length > 0) {
            EntryGrid entryGrid = (EntryGrid)view.getControl("pricedetailentity");
            entryGrid.selectRows(selectRows, selectRows[selectRows.length - 1]);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        IFormView view = this.getView();
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)view.getControl("pricedetail");
        switch (itemKey) {
            case "detaildisable": {
                int[] disableRow = entryGrid.getSelectRows();
                if (disableRow.length == 0) {
                    view.showTipNotification("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4ef7\u683c\u660e\u7ec6\u3002");
                    return;
                }
                this.updateEntryInvalidProperties(disableRow);
                break;
            }
            case "detailenable": {
                int[] enableRow = entryGrid.getSelectRows();
                if (enableRow.length == 0) {
                    view.showTipNotification("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4ef7\u683c\u660e\u7ec6\u3002");
                    return;
                }
                this.clearEntryInvalidProperties(enableRow);
                break;
            }
        }
    }

    private void updateEntryInvalidProperties(int[] disableRow) {
        int i;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        model.beginInit();
        Boolean priceIsInvalid = null;
        DynamicObjectCollection entryEntity = model.getEntryEntity("pricedetail");
        for (i = 0; i < disableRow.length; ++i) {
            priceIsInvalid = ((DynamicObject)entryEntity.get(disableRow[i])).getBoolean("isenable");
            if (priceIsInvalid.booleanValue()) continue;
            ((DynamicObject)entryEntity.get(disableRow[i])).set("disoper", (Object)CommonUtil.getLoginUser());
            ((DynamicObject)entryEntity.get(disableRow[i])).set("disopdate", (Object)TimeServiceHelper.now());
            ((DynamicObject)entryEntity.get(disableRow[i])).set("isenable", (Object)Boolean.TRUE);
            if (CommonUtil.isInPriceDetailList((DynamicObject)((DynamicObject)entryEntity.get(disableRow[i])), (DynamicObjectCollection)model.getEntryEntity("pricedetailentity"), (Boolean)Boolean.TRUE) == -1) {
                this.addNewDetail((DynamicObject)entryEntity.get(disableRow[i]));
                continue;
            }
            this.setDetailEntry(disableRow[i], "disopdate");
            this.setDetailEntry(disableRow[i], "disoper");
            this.setDetailEntry(disableRow[i], "isenable");
        }
        i = 0;
        for (DynamicObject entry : entryEntity) {
            if (!entry.getBoolean("isenable")) continue;
            ++i;
        }
        if (i == entryEntity.size()) {
            model.setValue("enable", (Object)"B");
            model.setValue("disabler", (Object)CommonUtil.getLoginUser());
            model.setValue("disabletime", (Object)TimeServiceHelper.now());
        }
        SaveServiceHelper.update((DynamicObject)model.getDataEntity());
        model.setDataChanged(false);
        view.updateView();
        model.endInit();
    }

    private void clearEntryInvalidProperties(int[] enableRow) {
        int i;
        IDataModel model = this.getView().getModel();
        IFormView view = this.getView();
        model.beginInit();
        Boolean priceIsInvalid = null;
        DynamicObjectCollection entryEntity = model.getEntryEntity("pricedetail");
        for (i = 0; i < enableRow.length; ++i) {
            priceIsInvalid = ((DynamicObject)entryEntity.get(enableRow[i])).getBoolean("isenable");
            if (!priceIsInvalid.booleanValue()) continue;
            ((DynamicObject)entryEntity.get(enableRow[i])).set("disoper", null);
            ((DynamicObject)entryEntity.get(enableRow[i])).set("disopdate", null);
            ((DynamicObject)entryEntity.get(enableRow[i])).set("isenable", (Object)Boolean.FALSE);
            if (CommonUtil.isInPriceDetailList((DynamicObject)((DynamicObject)entryEntity.get(enableRow[i])), (DynamicObjectCollection)model.getEntryEntity("pricedetailentity"), (Boolean)Boolean.TRUE) == -1) {
                this.addNewDetail((DynamicObject)entryEntity.get(enableRow[i]));
                continue;
            }
            this.setDetailEntry(enableRow[i], "disopdate");
            this.setDetailEntry(enableRow[i], "disoper");
            this.setDetailEntry(enableRow[i], "isenable");
        }
        i = 0;
        for (DynamicObject entry : entryEntity) {
            if (entry.getBoolean("isenable")) continue;
            ++i;
            break;
        }
        if (i != 0) {
            model.setValue("enable", (Object)"A");
            model.setValue("disabler", null);
            model.setValue("disabletime", null);
        }
        SaveServiceHelper.update((DynamicObject)model.getDataEntity());
        model.setDataChanged(false);
        view.updateView();
        model.endInit();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String isdistributed = model.getValue("isdistributed").toString();
        String property = e.getProperty().getName();
        if (Boolean.parseBoolean(isdistributed) && CHANGED_FILEDS.contains(property)) {
            ChangeData[] changeSet = e.getChangeSet();
            int rowIndex = changeSet[0].getRowIndex();
            DynamicObject entryRowEntity = model.getEntryRowEntity("pricedetail", rowIndex);
            int target = CommonUtil.isInPriceDetailList((DynamicObject)entryRowEntity, (DynamicObjectCollection)model.getEntryEntity("pricedetailentity"), (Boolean)Boolean.TRUE);
            if (target == -1) {
                this.addNewDetail(entryRowEntity);
            } else {
                this.setDetailEntry(target, property);
            }
        }
    }

    private void addNewDetail(DynamicObject object) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject itemPrice = model.getDataEntity(true).getDynamicObjectCollection("pricedetailentity").addNew();
        itemPrice.set("item", (Object)object.getDynamicObject("itempk"));
        itemPrice.set("barcode", (Object)object.getDynamicObject("barcodepk"));
        itemPrice.set("priceunit", (Object)object.getDynamicObject("unit"));
        itemPrice.set("stocktype", (Object)object.getDynamicObject("stocktypepk"));
        itemPrice.set("pricenum", (Object)object.getInt("priceqty"));
        itemPrice.set("retailprice", (Object)object.getBigDecimal("retailvalue"));
        itemPrice.set("rpadjustnum", (Object)object.getInt("rvadjustnum"));
        itemPrice.set("factoryprice", (Object)object.getBigDecimal("factoryvalue"));
        itemPrice.set("fpadjustnum", (Object)object.getInt("fvadjustnum"));
        itemPrice.set("memberprice", (Object)object.getBigDecimal("membervalue"));
        itemPrice.set("mpadjustnum", (Object)object.getInt("membervalue"));
        itemPrice.set("uniqueprice", (Object)object.getBigDecimal("uniquevalue"));
        itemPrice.set("upadjustnum", (Object)object.getInt("uvadjustnum"));
        itemPrice.set("specialprice", (Object)object.getBigDecimal("specialvalue"));
        itemPrice.set("spadjustnum", (Object)object.getInt("svadjustnum"));
        itemPrice.set("highprice", (Object)object.getBigDecimal("highvalue"));
        itemPrice.set("hpadjustnum", (Object)object.getInt("hvadjustnum"));
        itemPrice.set("lowprice", (Object)object.getBigDecimal("lowvalue"));
        itemPrice.set("lpadjustnum", (Object)object.getInt("lvadjustnum"));
        itemPrice.set("price1", (Object)object.getBigDecimal("value1"));
        itemPrice.set("p1adjustnum", (Object)object.getInt("v1adjustnum"));
        itemPrice.set("price2", (Object)object.getBigDecimal("value2"));
        itemPrice.set("p2adjustnum", (Object)object.getInt("v2adjustnum"));
        itemPrice.set("price3", (Object)object.getBigDecimal("value3"));
        itemPrice.set("p3adjustnum", (Object)object.getInt("v3adjustnum"));
        itemPrice.set("price4", (Object)object.getBigDecimal("value4"));
        itemPrice.set("p4adjustnum", (Object)object.getInt("v4adjustnum"));
        itemPrice.set("price5", (Object)object.getBigDecimal("value5"));
        itemPrice.set("p5adjustnum", (Object)object.getInt("v5adjustnum"));
        itemPrice.set("priceeffectdate", (Object)object.getDate("efdate"));
        itemPrice.set("priceinvaliddate", (Object)object.getDate("inefdate"));
        itemPrice.set("priceisinvalid", (Object)object.getBoolean("isenable"));
        itemPrice.set("disabloper", (Object)object.getDynamicObject("disoper"));
        itemPrice.set("disableopdate", (Object)object.getDate("disopdate"));
        itemPrice.set("pricecomment", (Object)object.getString("entrycomment"));
        view.updateView("pricedetailentity");
    }

    private void setDetailEntry(int index, String property) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        model.beginInit();
        model.setValue(PriceTypeUtil.getPriceTypeByProp((String)property), model.getValue(property, index), index);
        model.endInit();
        view.updateView("pricedetailentity", index);
    }

    public void afterLoadData(EventObject e) {
        Boolean isDistributed = (Boolean)this.getView().getModel().getValue("isdistributed");
        if (isDistributed.booleanValue()) {
            IDataModel model = this.getView().getModel();
            Object sourcebillId = model.getValue("sourcebillid");
            DynamicObject sourceObj = BusinessDataServiceHelper.loadSingle((Object)sourcebillId, (String)"dpm_retailpricelist");
            DynamicObjectCollection sourceCol = sourceObj.getDynamicObjectCollection("pricedetailentity");
            DynamicObject branch = (DynamicObject)this.getView().getModel().getValue("channel");
            DynamicObjectCollection mdrItems = RetailItemPriceHelper.getSaleContent((DynamicObject)branch);
            Set mdrItemIds = RetailItemPriceHelper.getRetain((DynamicObjectCollection)mdrItems, (DynamicObject)sourceObj);
            DynamicObjectCollection branchCol = model.getEntryEntity("pricedetailentity");
            for (DynamicObject obj : branchCol) {
                this.setPriceDetailEntry(obj);
            }
            HashSet branchBarcode = new HashSet(branchCol.size());
            branchCol.stream().forEach(p -> branchBarcode.add(p.getDynamicObject("barcode").getPkValue()));
            Object barcodePKValue = null;
            for (DynamicObject obj : sourceCol) {
                barcodePKValue = obj.getDynamicObject("barcode").getPkValue();
                if (!mdrItemIds.contains(barcodePKValue) || branchBarcode.contains(barcodePKValue)) continue;
                this.setPriceDetailEntry(obj);
            }
        }
    }

    private void setPriceDetailEntry(DynamicObject priceDetailItem) {
        DynamicObject item = null;
        DynamicObject parentObj = null;
        item = this.getModel().getDataEntity(true).getDynamicObjectCollection("pricedetail").addNew();
        parentObj = (DynamicObject)item.getParent();
        item.set("pkid", parentObj.getPkValue());
        item.set("entryid", priceDetailItem.getPkValue());
        item.set("ischanged", (Object)Boolean.FALSE);
        item.set("itempk", priceDetailItem.get("item"));
        item.set("barcodepk", priceDetailItem.get("barcode"));
        item.set("unit", priceDetailItem.get("priceunit"));
        item.set("priceqty", priceDetailItem.get("pricenum"));
        item.set("stocktypepk", priceDetailItem.get("stocktype"));
        item.set("disoper", priceDetailItem.get("disabloper"));
        item.set("disopdate", priceDetailItem.get("disableopdate"));
        item.set("retailvalue", priceDetailItem.get("retailprice"));
        item.set("oldretail", priceDetailItem.get("retailprice"));
        item.set("rvadjustnum", priceDetailItem.get("rpadjustnum"));
        item.set("uniquevalue", priceDetailItem.get("uniqueprice"));
        item.set("oldunique", priceDetailItem.get("uniqueprice"));
        item.set("uvadjustnum", priceDetailItem.get("upadjustnum"));
        item.set("factoryvalue", priceDetailItem.get("factoryprice"));
        item.set("oldfactory", priceDetailItem.get("factoryprice"));
        item.set("fvadjustnum", priceDetailItem.get("fpadjustnum"));
        item.set("membervalue", priceDetailItem.get("memberprice"));
        item.set("oldmember", priceDetailItem.get("memberprice"));
        item.set("mvadjustnum", priceDetailItem.get("mpadjustnum"));
        item.set("specialvalue", priceDetailItem.get("specialprice"));
        item.set("oldspecial", priceDetailItem.get("specialprice"));
        item.set("svadjustnum", priceDetailItem.get("spadjustnum"));
        item.set("highvalue", priceDetailItem.get("highprice"));
        item.set("oldhigh", priceDetailItem.get("highprice"));
        item.set("hvadjustnum", priceDetailItem.get("hpadjustnum"));
        item.set("lowvalue", priceDetailItem.get("lowprice"));
        item.set("oldlow", priceDetailItem.get("lowprice"));
        item.set("lvadjustnum", priceDetailItem.get("lpadjustnum"));
        item.set("value1", priceDetailItem.get("price1"));
        item.set("oldvalue1", priceDetailItem.get("price1"));
        item.set("v1adjustnum", priceDetailItem.get("p1adjustnum"));
        item.set("value2", priceDetailItem.get("price2"));
        item.set("oldvalue2", priceDetailItem.get("price2"));
        item.set("v2adjustnum", priceDetailItem.get("p2adjustnum"));
        item.set("value3", priceDetailItem.get("price3"));
        item.set("oldvalue3", priceDetailItem.get("price3"));
        item.set("v3adjustnum", priceDetailItem.get("p3adjustnum"));
        item.set("value4", priceDetailItem.get("price4"));
        item.set("oldvalue4", priceDetailItem.get("price4"));
        item.set("v4adjustnum", priceDetailItem.get("p4adjustnum"));
        item.set("value5", priceDetailItem.get("price5"));
        item.set("oldvalue5", priceDetailItem.get("price5"));
        item.set("v5adjustnum", priceDetailItem.get("p5adjustnum"));
        item.set("efdate", priceDetailItem.get("priceeffectdate"));
        item.set("inefdate", priceDetailItem.get("priceinvaliddate"));
        item.set("isenable", priceDetailItem.get("priceisinvalid"));
        item.set("disopdate", priceDetailItem.get("disableopdate"));
        item.set("disoper", priceDetailItem.get("disabloper"));
        item.set("entrycomment", priceDetailItem.get("pricecomment"));
        this.getView().getModel().setDataChanged(false);
    }
}

